/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.mime.datasource;

import com.openexchange.config.ConfigurationService;
import com.openexchange.config.Reloadable;
import com.openexchange.configuration.ServerConfig;
import com.openexchange.exception.OXException;
import com.openexchange.java.Charsets;
import com.openexchange.java.Streams;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.api.MailConfig;
import com.openexchange.mail.config.MailReloadable;
import com.openexchange.mail.mime.ContentType;
import com.openexchange.mail.mime.MimeMailException;
import com.openexchange.mail.mime.datasource.CleanUp;
import com.openexchange.mail.utils.MessageUtility;
import com.openexchange.session.Session;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import javax.activation.DataSource;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimePart;
import org.apache.james.mime4j.MimeException;
import org.apache.james.mime4j.dom.BinaryBody;
import org.apache.james.mime4j.dom.Body;
import org.apache.james.mime4j.dom.Entity;
import org.apache.james.mime4j.dom.Header;
import org.apache.james.mime4j.dom.Message;
import org.apache.james.mime4j.dom.Multipart;
import org.apache.james.mime4j.dom.TextBody;
import org.apache.james.mime4j.dom.address.Address;
import org.apache.james.mime4j.dom.address.AddressList;
import org.apache.james.mime4j.dom.address.Mailbox;
import org.apache.james.mime4j.dom.address.MailboxList;
import org.apache.james.mime4j.message.AbstractEntity;
import org.apache.james.mime4j.message.BodyPart;
import org.apache.james.mime4j.message.DefaultMessageWriter;
import org.apache.james.mime4j.message.HeaderImpl;
import org.apache.james.mime4j.message.MessageImpl;
import org.apache.james.mime4j.message.MultipartImpl;
import org.apache.james.mime4j.storage.StorageBodyFactory;
import org.apache.james.mime4j.storage.StorageProvider;
import org.apache.james.mime4j.storage.TempFileStorageProvider;
import org.apache.james.mime4j.storage.ThresholdStorageProvider;
import org.apache.james.mime4j.stream.RawFieldParser;
import org.apache.james.mime4j.util.ByteArrayBuffer;
import org.apache.james.mime4j.util.ByteSequence;

public final class MimeMessageDataSource
implements DataSource,
CleanUp {
    private static final String SUFFIX = ".tmp";
    private static final String PREFIX = "open-xchange-";
    private static volatile File directory;
    private static volatile Field filesToDelete;
    private final MessageImpl message = new MessageImpl();
    private final StorageProvider tempStore;
    private static final DefaultMessageWriter DEFAULT_MESSAGE_WRITER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static File directory() {
        File tmp = directory;
        if (null != tmp) return tmp;
        Class<MimeMessageDataSource> clazz = MimeMessageDataSource.class;
        synchronized (MimeMessageDataSource.class) {
            tmp = directory;
            if (null != tmp) return tmp;
            String property = ServerConfig.getProperty(ServerConfig.Property.UploadDirectory);
            directory = tmp = new File(null == property ? "/tmp" : property);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return tmp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Field filesToDelete() {
        Field tmp = filesToDelete;
        if (null != tmp) return tmp;
        Class<MimeMessageDataSource> clazz = MimeMessageDataSource.class;
        synchronized (MimeMessageDataSource.class) {
            tmp = filesToDelete;
            if (null != tmp) return tmp;
            Class<?> innerClass = null;
            Class<?>[] classes = TempFileStorageProvider.class.getDeclaredClasses();
            for (int i = 0; null == innerClass && i < classes.length; ++i) {
                Class<?> clazz2 = classes[i];
                if (!clazz2.getName().endsWith("TempFileStorage")) continue;
                innerClass = clazz2;
            }
            if (null == innerClass) return tmp;
            try {
                tmp = innerClass.getDeclaredField("filesToDelete");
                tmp.setAccessible(true);
                filesToDelete = tmp;
            }
            catch (Exception e) {
                // empty catch block
            }
            return tmp;
        }
    }

    public MimeMessageDataSource(MimeMessage mimeMessage) throws OXException {
        this(mimeMessage, null, null);
    }

    public MimeMessageDataSource(MimeMessage mimeMessage, MailConfig optConfig, Session optSession) throws OXException {
        TempFileStorageProvider tempStore = new TempFileStorageProvider(PREFIX, SUFFIX, MimeMessageDataSource.directory());
        ThresholdStorageProvider provider = new ThresholdStorageProvider((StorageProvider)tempStore, 8192);
        StorageBodyFactory bodyFactory = new StorageBodyFactory((StorageProvider)provider, null);
        MimeMessageDataSource.mime4jOf((MimePart)mimeMessage, (AbstractEntity)this.message, bodyFactory, optConfig, optSession);
        this.tempStore = tempStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanUp() {
        StorageProvider tempStore;
        MessageImpl message = this.message;
        if (null != message) {
            message.dispose();
        }
        if (null != (tempStore = this.tempStore)) {
            try {
                Set filesToDelete;
                Set set = filesToDelete = (Set)MimeMessageDataSource.filesToDelete().get(null);
                synchronized (set) {
                    Iterator iterator = filesToDelete.iterator();
                    while (iterator.hasNext()) {
                        File file = (File)iterator.next();
                        if (!file.delete()) continue;
                        iterator.remove();
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String getContentType() {
        return this.message.getMimeType();
    }

    public InputStream getInputStream() throws IOException {
        DefaultMessageWriter messageWriter = DEFAULT_MESSAGE_WRITER;
        ByteArrayOutputStream out = Streams.newByteArrayOutputStream((int)8192);
        messageWriter.writeMessage((Message)this.message, (OutputStream)out);
        return Streams.asInputStream((ByteArrayOutputStream)out);
    }

    public String getName() {
        return this.message.getFilename();
    }

    public OutputStream getOutputStream() throws IOException {
        throw new IOException(this.getClass().getName() + ".getOutputStream() is not implemented");
    }

    public void writeTo(OutputStream os) throws IOException {
        MimeMessageDataSource.writeTo((Message)this.message, os);
    }

    public static void writeTo(Message message, OutputStream os) throws IOException {
        if (null == message || null == os) {
            return;
        }
        DEFAULT_MESSAGE_WRITER.writeMessage(message, os);
    }

    public static Message mime4jOf(MimeMessage mimeMessage, MailConfig optConfig, Session optSession) throws OXException {
        MessageImpl message = new MessageImpl();
        TempFileStorageProvider tempStore = new TempFileStorageProvider(PREFIX, SUFFIX, MimeMessageDataSource.directory());
        ThresholdStorageProvider provider = new ThresholdStorageProvider((StorageProvider)tempStore, 8192);
        StorageBodyFactory bodyFactory = new StorageBodyFactory((StorageProvider)provider, null);
        MimeMessageDataSource.mime4jOf((MimePart)mimeMessage, (AbstractEntity)message, bodyFactory, optConfig, optSession);
        return new CleanUpMessageImpl(message, (StorageProvider)tempStore);
    }

    private static void mime4jOf(MimePart mimePart, AbstractEntity entity, StorageBodyFactory bodyFactory, MailConfig mailConfig, Session session) throws OXException {
        try {
            javax.mail.Multipart m;
            ContentType contentType = new ContentType(mimePart.getHeader("Content-Type", null));
            String name = contentType.getNameParameter();
            if (contentType.startsWith("multipart/")) {
                m = (javax.mail.Multipart)mimePart.getContent();
                String subType = MimeMessageDataSource.parseSubType(m.getContentType());
                MultipartImpl mime4jMultipart = new MultipartImpl(null == subType ? "mixed" : MimeMessageDataSource.toLowerCase(subType));
                mime4jMultipart.setPreamble("This is a multi-part message in MIME format.");
                int count = m.getCount();
                for (int i = 0; i < count; ++i) {
                    MimeBodyPart bodyPart = (MimeBodyPart)m.getBodyPart(i);
                    AbstractEntity mime4jBodyPart = MimeMessageDataSource.getEntityByContentType(bodyPart.getHeader("Content-Type", null));
                    MimeMessageDataSource.mime4jOf((MimePart)bodyPart, mime4jBodyPart, bodyFactory, mailConfig, session);
                    mime4jMultipart.addBodyPart((Entity)mime4jBodyPart);
                }
                entity.setMultipart((Multipart)mime4jMultipart);
            } else if (contentType.startsWith("message/rfc822") || name != null && name.endsWith(".eml")) {
                m = (MimeMessage)mimePart.getContent();
                MessageImpl mime4jMessage = new MessageImpl();
                MimeMessageDataSource.mime4jOf((MimePart)m, (AbstractEntity)mime4jMessage, bodyFactory, mailConfig, session);
                entity.setMessage((Message)mime4jMessage);
            } else if (contentType.startsWith("text/")) {
                String text = MimeMessageDataSource.tryGetStringContent(mimePart);
                if (null == text) {
                    text = MessageUtility.readMimePart((Part)mimePart, contentType);
                }
                TextBody textBody = bodyFactory.textBody(text, contentType.getCharsetParameter());
                entity.setBody((Body)textBody, contentType.getBaseType());
            } else {
                BinaryBody binaryBody = bodyFactory.binaryBody(mimePart.getInputStream());
                entity.setBody((Body)binaryBody, contentType.getBaseType());
            }
            RawFieldParser fieldParser = RawFieldParser.DEFAULT;
            HeaderImpl mime4jHeader = new HeaderImpl();
            Enumeration enumeration = mimePart.getAllHeaderLines();
            while (enumeration.hasMoreElements()) {
                String headerLine = (String)enumeration.nextElement();
                byte[] bytes = headerLine.getBytes(Charsets.ISO_8859_1);
                mime4jHeader.addField((org.apache.james.mime4j.stream.Field)fieldParser.parseField((ByteSequence)new ByteArrayBuffer(bytes, bytes.length, true)));
            }
            entity.setHeader((Header)mime4jHeader);
        }
        catch (MessagingException e) {
            throw MimeMailException.handleMessagingException(e, mailConfig, session);
        }
        catch (IOException e) {
            throw MailExceptionCode.IO_ERROR.create(e, e.getMessage());
        }
        catch (MimeException e) {
            throw MailExceptionCode.MESSAGING_ERROR.create(e, e.getMessage());
        }
        catch (RuntimeException e) {
            throw MailExceptionCode.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
    }

    private static AbstractEntity getEntityByContentType(String sContentType) {
        if (null == sContentType) {
            return null;
        }
        if (MimeMessageDataSource.toLowerCase(sContentType).startsWith("message/rfc822")) {
            return new MessageImpl();
        }
        try {
            String name = new ContentType(sContentType).getNameParameter();
            if (name != null && name.endsWith(".eml")) {
                return new MessageImpl();
            }
        }
        catch (OXException oXException) {
            // empty catch block
        }
        return new BodyPart();
    }

    private static String parseSubType(String sContentType) {
        if (null == sContentType) {
            return null;
        }
        int start = sContentType.indexOf(47) + 1;
        if (start <= 0) {
            return null;
        }
        int pos = sContentType.indexOf(59, start);
        return pos < 0 ? sContentType.substring(start) : sContentType.substring(start, pos);
    }

    private static String tryGetStringContent(MimePart mimePart) {
        try {
            Object content = mimePart.getContent();
            if (content instanceof String) {
                return content.toString();
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static String toLowerCase(CharSequence chars) {
        if (null == chars) {
            return null;
        }
        int length = chars.length();
        StringBuilder builder = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            char c = chars.charAt(i);
            builder.append(c >= 'A' && c <= 'Z' ? (char)(c ^ 0x20) : c);
        }
        return builder.toString();
    }

    static {
        MailReloadable.getInstance().addReloadable(new Reloadable(){

            public void reloadConfiguration(ConfigurationService configService) {
                directory = null;
                filesToDelete = null;
            }

            public Map<String, String[]> getConfigFileNames() {
                return null;
            }
        });
        DEFAULT_MESSAGE_WRITER = new DefaultMessageWriter();
    }

    private static final class CleanUpMessageImpl
    extends MessageImpl
    implements CleanUp {
        private final MessageImpl message;
        private final StorageProvider tempStore;

        CleanUpMessageImpl(MessageImpl message, StorageProvider tempStore) {
            this.message = message;
            this.tempStore = tempStore;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cleanUp() {
            StorageProvider tempStore;
            MessageImpl message = this.message;
            if (null != message) {
                try {
                    message.dispose();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (null != (tempStore = this.tempStore)) {
                try {
                    Set filesToDelete;
                    Set set = filesToDelete = (Set)MimeMessageDataSource.filesToDelete().get(null);
                    synchronized (set) {
                        Iterator iterator = filesToDelete.iterator();
                        while (iterator.hasNext()) {
                            File file = (File)iterator.next();
                            if (!file.delete()) continue;
                            iterator.remove();
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public int hashCode() {
            return this.message.hashCode();
        }

        public String getMessageId() {
            return this.message.getMessageId();
        }

        public Entity getParent() {
            return this.message.getParent();
        }

        public void setParent(Entity parent) {
            this.message.setParent(parent);
        }

        public void createMessageId(String hostname) {
            this.message.createMessageId(hostname);
        }

        public Header getHeader() {
            return this.message.getHeader();
        }

        public void setHeader(Header header) {
            this.message.setHeader(header);
        }

        public Body getBody() {
            return this.message.getBody();
        }

        public String getSubject() {
            return this.message.getSubject();
        }

        public void setBody(Body body) {
            this.message.setBody(body);
        }

        public void setSubject(String subject) {
            this.message.setSubject(subject);
        }

        public boolean equals(Object obj) {
            return this.message.equals(obj);
        }

        public Body removeBody() {
            return this.message.removeBody();
        }

        public void setMessage(Message message) {
            ((AbstractEntity)message).setMessage(message);
        }

        public Date getDate() {
            return this.message.getDate();
        }

        public void setMultipart(Multipart multipart) {
            this.message.setMultipart(multipart);
        }

        public void setDate(Date date) {
            this.message.setDate(date);
        }

        public void setDate(Date date, TimeZone zone) {
            this.message.setDate(date, zone);
        }

        public void setMultipart(Multipart multipart, Map<String, String> parameters) {
            this.message.setMultipart(multipart, parameters);
        }

        public Mailbox getSender() {
            return this.message.getSender();
        }

        public void setText(TextBody textBody) {
            this.message.setText(textBody);
        }

        public void setSender(Mailbox sender) {
            this.message.setSender(sender);
        }

        public MailboxList getFrom() {
            return this.message.getFrom();
        }

        public void setText(TextBody textBody, String subtype) {
            this.message.setText(textBody, subtype);
        }

        public void setFrom(Mailbox from) {
            this.message.setFrom(from);
        }

        public void setFrom(Mailbox ... from) {
            this.message.setFrom(from);
        }

        public void setBody(Body body, String mimeType) {
            this.message.setBody(body, mimeType);
        }

        public void setFrom(Collection<Mailbox> from) {
            this.message.setFrom(from);
        }

        public AddressList getTo() {
            return this.message.getTo();
        }

        public void setBody(Body body, String mimeType, Map<String, String> parameters) {
            this.message.setBody(body, mimeType, parameters);
        }

        public void setTo(Address to) {
            this.message.setTo(to);
        }

        public void setTo(Address ... to) {
            this.message.setTo(to);
        }

        public String getMimeType() {
            return this.message.getMimeType();
        }

        public void setTo(Collection<? extends Address> to) {
            this.message.setTo(to);
        }

        public AddressList getCc() {
            return this.message.getCc();
        }

        public String getCharset() {
            return this.message.getCharset();
        }

        public String toString() {
            return this.message.toString();
        }

        public void setCc(Address cc) {
            this.message.setCc(cc);
        }

        public String getContentTransferEncoding() {
            return this.message.getContentTransferEncoding();
        }

        public void setCc(Address ... cc) {
            this.message.setCc(cc);
        }

        public void setContentTransferEncoding(String contentTransferEncoding) {
            this.message.setContentTransferEncoding(contentTransferEncoding);
        }

        public void setCc(Collection<? extends Address> cc) {
            this.message.setCc(cc);
        }

        public String getDispositionType() {
            return this.message.getDispositionType();
        }

        public AddressList getBcc() {
            return this.message.getBcc();
        }

        public void setBcc(Address bcc) {
            this.message.setBcc(bcc);
        }

        public void setContentDisposition(String dispositionType) {
            this.message.setContentDisposition(dispositionType);
        }

        public void setBcc(Address ... bcc) {
            this.message.setBcc(bcc);
        }

        public void setContentDisposition(String dispositionType, String filename) {
            this.message.setContentDisposition(dispositionType, filename);
        }

        public void setBcc(Collection<? extends Address> bcc) {
            this.message.setBcc(bcc);
        }

        public AddressList getReplyTo() {
            return this.message.getReplyTo();
        }

        public void setContentDisposition(String dispositionType, String filename, long size) {
            this.message.setContentDisposition(dispositionType, filename, size);
        }

        public void setReplyTo(Address replyTo) {
            this.message.setReplyTo(replyTo);
        }

        public void setReplyTo(Address ... replyTo) {
            this.message.setReplyTo(replyTo);
        }

        public void setReplyTo(Collection<? extends Address> replyTo) {
            this.message.setReplyTo(replyTo);
        }

        public void setContentDisposition(String dispositionType, String filename, long size, Date creationDate, Date modificationDate, Date readDate) {
            this.message.setContentDisposition(dispositionType, filename, size, creationDate, modificationDate, readDate);
        }

        public String getFilename() {
            return this.message.getFilename();
        }

        public void setFilename(String filename) {
            this.message.setFilename(filename);
        }

        public boolean isMimeType(String type) {
            return this.message.isMimeType(type);
        }

        public boolean isMultipart() {
            return this.message.isMultipart();
        }

        public void dispose() {
            this.message.dispose();
        }
    }
}

