/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.mime;

import com.openexchange.config.ConfigurationService;
import com.openexchange.exception.OXException;
import com.openexchange.java.Strings;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.mime.MimeType2ExtMap;
import com.openexchange.mail.mime.ParameterList;
import com.openexchange.mail.mime.ParameterizedHeader;
import com.openexchange.mail.mime.utils.MimeMessageUtility;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.Collections;
import java.util.Iterator;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentType
extends ParameterizedHeader {
    private static final long serialVersionUID = -9197784872892324694L;
    private static volatile Boolean contentTypeRegexFallback;
    public static final ContentType DEFAULT_CONTENT_TYPE;
    private static final Pattern PATTERN_CONTENT_TYPE;
    private static final Pattern PATTERN_TOKEN;
    private static final Pattern PATTERN_WHITESPACE;
    private static final String EMPTY = "";
    private static final char DELIMITER = '/';
    private static final String DEFAULT_PRIMTYPE = "APPLICATION";
    private static final String DEFAULT_SUBTYPE = "OCTET-STREAM";
    private static final String PARAM_CHARSET = "charset";
    private static final String PARAM_NAME = "name";
    private String primaryType;
    private String subType;
    private String baseType;
    private String lcBaseType;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean contentTypeRegexFallback() {
        Boolean b = contentTypeRegexFallback;
        if (null != b) return b;
        Class<ContentType> clazz = ContentType.class;
        synchronized (ContentType.class) {
            b = contentTypeRegexFallback;
            if (null != b) return b;
            ConfigurationService service = ServerServiceRegistry.getInstance().getService(ConfigurationService.class);
            contentTypeRegexFallback = b = Boolean.valueOf(null == service || service.getBoolProperty("com.openexchange.mail.mime.contentTypeRegexFallback", true));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return b;
        }
    }

    private static boolean isInvalidToken(String token) {
        if (null == token) {
            return true;
        }
        return !PATTERN_TOKEN.matcher(token).matches();
    }

    private static String clearWhitespaces(String str) {
        if (null == str) {
            return null;
        }
        return PATTERN_WHITESPACE.matcher(str).replaceAll(EMPTY);
    }

    public ContentType() {
        this.parameterList = new ParameterList();
    }

    public ContentType(String contentType) throws OXException {
        this.parseContentType(contentType);
    }

    public void reset() {
        this.parameterList = new ParameterList();
        this.primaryType = null;
        this.subType = null;
        this.baseType = null;
        this.lcBaseType = null;
    }

    @Override
    public int compareTo(ParameterizedHeader other) {
        int baseComp;
        if (this == other) {
            return 0;
        }
        if (ContentType.class.isInstance(other) && (baseComp = this.getBaseType().compareToIgnoreCase(((ContentType)other).getBaseType())) != 0) {
            return baseComp;
        }
        return super.compareTo(other);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.primaryType == null ? 0 : this.primaryType.toLowerCase(Locale.ENGLISH).hashCode());
        result = 31 * result + (this.subType == null ? 0 : this.subType.toLowerCase(Locale.ENGLISH).hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ContentType other = (ContentType)obj;
        if (this.primaryType == null ? other.primaryType != null : !this.primaryType.equalsIgnoreCase(other.primaryType)) {
            return false;
        }
        return !(this.subType == null ? other.subType != null : !this.subType.equalsIgnoreCase(other.subType));
    }

    private String getLowerCaseBaseType() {
        if (null == this.lcBaseType) {
            this.lcBaseType = ContentType.toLowerCase(this.getBaseType());
        }
        return this.lcBaseType;
    }

    private void parseContentType(String contentType) throws OXException {
        this.parseContentType(contentType, true);
    }

    private void parseContentType(String contentType, boolean paramList) throws OXException {
        Matcher ctMatcher;
        if (null == contentType || contentType.length() == 0) {
            this.setContentType(DEFAULT_CONTENT_TYPE);
            return;
        }
        String cts = ContentType.prepareParameterizedHeader(contentType);
        int semicolonPos = cts.indexOf(59);
        int commaPos = -1;
        String type = semicolonPos < 0 ? cts : cts.substring(0, semicolonPos);
        int slashPos = type.indexOf(47);
        if (slashPos >= 0) {
            try {
                char lc;
                int mlen;
                char fc;
                String pt;
                String string = pt = 0 == slashPos ? DEFAULT_PRIMTYPE : type.substring(0, slashPos).trim();
                if (pt.indexOf(37) >= 0) {
                    pt = ContentType.decodeUrl(pt);
                }
                while ((fc = pt.charAt(0)) == '\"' || fc == '\'') {
                    pt = pt.substring(1);
                }
                if (Strings.toLowerCase((CharSequence)pt).startsWith("content-type:") && ((fc = (pt = pt.substring(13)).charAt(0)) == '\"' || fc == '\'')) {
                    pt = pt.substring(1);
                }
                if (ContentType.isInvalidToken(pt)) {
                    throw MailExceptionCode.INVALID_CONTENT_TYPE.create(contentType);
                }
                this.primaryType = pt.length() <= 0 ? DEFAULT_PRIMTYPE : pt;
                String st = slashPos < type.length() ? type.substring(slashPos + 1).trim() : DEFAULT_SUBTYPE;
                commaPos = st.indexOf(44);
                String string2 = st = commaPos > 0 ? st.substring(0, commaPos) : st;
                if (st.indexOf(37) >= 0) {
                    st = ContentType.decodeUrl(st);
                }
                while ((mlen = st.length() - 1) > 0 && ((lc = st.charAt(mlen)) == '\"' || lc == '\'')) {
                    st = st.substring(0, mlen);
                }
                if (ContentType.isInvalidToken(st)) {
                    throw MailExceptionCode.INVALID_CONTENT_TYPE.create(contentType);
                }
                this.subType = st.trim().length() <= 0 ? ("multipart".equals(this.primaryType) ? "mixed" : ("text".equals(this.primaryType) ? "plain" : DEFAULT_SUBTYPE)) : st;
                this.baseType = new StringBuilder(16).append(this.primaryType).append('/').append(this.subType).toString();
                this.lcBaseType = ContentType.toLowerCase(this.baseType);
                if (paramList) {
                    if (semicolonPos < 0) {
                        if (commaPos < 0) {
                            this.parameterList = new ParameterList();
                        } else {
                            try {
                                commaPos = cts.indexOf(44);
                                this.parameterList = commaPos < cts.length() ? new ParameterList(cts.substring(commaPos + 1)) : new ParameterList();
                            }
                            catch (RuntimeException e) {
                                throw MailExceptionCode.INVALID_CONTENT_TYPE.create(e, contentType);
                            }
                        }
                    } else {
                        try {
                            this.parameterList = semicolonPos < cts.length() ? new ParameterList(cts.substring(semicolonPos + 1)) : new ParameterList();
                        }
                        catch (RuntimeException e) {
                            throw MailExceptionCode.INVALID_CONTENT_TYPE.create(e, contentType);
                        }
                    }
                }
                return;
            }
            catch (OXException e) {
                if (!ContentType.contentTypeRegexFallback()) {
                    throw e;
                }
                Logger logger = LoggerFactory.getLogger(ContentType.class);
                logger.debug(EMPTY, (Throwable)e);
            }
        }
        if ((ctMatcher = PATTERN_CONTENT_TYPE.matcher(type)).find()) {
            if (ctMatcher.start() != 0) {
                throw MailExceptionCode.INVALID_CONTENT_TYPE.create(contentType);
            }
            String alt = ctMatcher.group(3);
            if (null != alt) {
                this.primaryType = DEFAULT_PRIMTYPE;
                String decoded = ContentType.clearWhitespaces(MimeMessageUtility.decodeMultiEncodedHeader(alt));
                String string = this.subType = null == decoded ? alt : decoded;
                if (this.subType == null || this.subType.length() == 0) {
                    this.subType = DEFAULT_SUBTYPE;
                }
            } else {
                String pt = ctMatcher.group(1);
                String decoded = ContentType.clearWhitespaces(MimeMessageUtility.decodeMultiEncodedHeader(pt));
                String string = this.primaryType = null == decoded ? pt : decoded;
                if (this.primaryType == null || this.primaryType.length() == 0) {
                    this.primaryType = DEFAULT_PRIMTYPE;
                }
                if ((semicolonPos = this.primaryType.indexOf(47)) >= 0) {
                    this.subType = this.primaryType.substring(semicolonPos + 1);
                    this.primaryType = this.primaryType.substring(0, semicolonPos);
                } else {
                    String st = ctMatcher.group(2);
                    decoded = ContentType.clearWhitespaces(MimeMessageUtility.decodeMultiEncodedHeader(st));
                    String string3 = this.subType = null == decoded ? st : decoded;
                    if (this.subType == null || this.subType.length() == 0) {
                        this.subType = DEFAULT_SUBTYPE;
                    }
                }
                if (this.subType == null || this.subType.length() == 0) {
                    this.subType = DEFAULT_SUBTYPE;
                }
            }
            this.baseType = new StringBuilder(16).append(this.primaryType).append('/').append(this.subType).toString();
            this.lcBaseType = null;
            if (paramList) {
                this.parameterList = new ParameterList(cts.substring(ctMatcher.end()));
            }
        } else {
            this.primaryType = "text";
            this.subType = "plain";
            this.baseType = new StringBuilder(16).append(this.primaryType).append('/').append(this.subType).toString();
            this.lcBaseType = null;
            if (paramList) {
                String byName;
                this.parameterList = new ParameterList(semicolonPos < 0 ? cts : cts.substring(semicolonPos));
                String name = this.parameterList.getParameter(PARAM_NAME);
                if (null != name && null != (byName = MimeType2ExtMap.getContentType(name))) {
                    int slash = byName.indexOf(47);
                    this.primaryType = byName.substring(0, slash);
                    this.subType = byName.substring(slash + 1);
                    if (this.subType == null || this.subType.length() == 0) {
                        this.subType = DEFAULT_SUBTYPE;
                    }
                    this.baseType = new StringBuilder(16).append(this.primaryType).append('/').append(this.subType).toString();
                    this.lcBaseType = null;
                }
            }
        }
    }

    private void parseBaseType(String baseType) throws OXException {
        this.parseContentType(baseType, false);
        if (this.parameterList == null) {
            this.parameterList = new ParameterList();
        }
    }

    public void setContentType(ContentType contentType) {
        if (contentType == this) {
            return;
        }
        this.primaryType = contentType.getPrimaryType();
        this.subType = contentType.getSubType();
        this.parameterList = (ParameterList)contentType.parameterList.clone();
        this.baseType = new StringBuilder(16).append(this.primaryType).append('/').append(this.subType).toString();
        this.lcBaseType = null;
    }

    public String getPrimaryType() {
        return this.primaryType;
    }

    public ContentType setPrimaryType(String primaryType) {
        this.primaryType = primaryType;
        this.baseType = null;
        this.lcBaseType = null;
        return this;
    }

    public String getSubType() {
        return this.subType;
    }

    public ContentType setSubType(String subType) {
        this.subType = subType;
        this.baseType = null;
        this.lcBaseType = null;
        return this;
    }

    public boolean isBaseType(String primaryType, String subType) {
        if (null == this.primaryType ? null != primaryType : !this.primaryType.equalsIgnoreCase(primaryType)) {
            return false;
        }
        return !(null == this.subType ? null != subType : !this.subType.equalsIgnoreCase(subType));
    }

    public boolean matchesBaseType(String primaryType, String subTypeExpression) {
        if (null == this.primaryType ? null != primaryType : !this.primaryType.equalsIgnoreCase(primaryType)) {
            return false;
        }
        if (null == this.subType) {
            return "*".equals(subTypeExpression);
        }
        return Pattern.matches(ContentType.wildcardToRegex(subTypeExpression), this.subType);
    }

    public String getBaseType() {
        if (this.baseType != null) {
            return this.baseType;
        }
        this.baseType = new StringBuilder(16).append(this.primaryType).append('/').append(this.subType).toString();
        return this.baseType;
    }

    public ContentType setBaseType(String baseType) throws OXException {
        this.parseBaseType(baseType);
        return this;
    }

    public ContentType setCharsetParameter(String charset) {
        this.setParameter(PARAM_CHARSET, charset);
        return this;
    }

    public String getCharsetParameter() {
        return this.getParameter(PARAM_CHARSET);
    }

    public boolean containsCharsetParameter() {
        return this.containsParameter(PARAM_CHARSET);
    }

    public String removeCharsetParameter() {
        return this.removeParameter(PARAM_CHARSET);
    }

    public ContentType setNameParameter(String filename) {
        this.setParameter(PARAM_NAME, filename);
        return this;
    }

    public String getNameParameter() {
        return this.getParameter(PARAM_NAME);
    }

    public boolean containsNameParameter() {
        return this.containsParameter(PARAM_NAME);
    }

    public String removeNameParameter() {
        return this.removeParameter(PARAM_NAME);
    }

    public void setContentType(String contentType) throws OXException {
        this.parseContentType(contentType);
    }

    public boolean isMimeType(String pattern) {
        return Pattern.compile(ContentType.wildcardToRegex(pattern), 2).matcher(this.getBaseType()).matches();
    }

    public boolean startsWith(String prefix) {
        if (null == prefix) {
            throw new IllegalArgumentException("Prefix is null");
        }
        return this.getLowerCaseBaseType().startsWith(ContentType.toLowerCase(prefix), 0);
    }

    public boolean startsWithAny(String ... prefixes) {
        if (null == prefixes) {
            return false;
        }
        String lowerCase = this.getLowerCaseBaseType();
        for (String prefix : prefixes) {
            if (null == prefix || !lowerCase.startsWith(ContentType.toLowerCase(prefix), 0)) continue;
            return true;
        }
        return false;
    }

    public static String prepareContentTypeString(String contentType) throws OXException {
        return MimeMessageUtility.foldContentType(new ContentType(contentType).toString());
    }

    public static String prepareContentTypeString(String contentType, String name) throws OXException {
        ContentType ct = new ContentType(contentType);
        if (name != null && !ct.containsNameParameter()) {
            ct.setNameParameter(name);
        }
        return MimeMessageUtility.foldContentType(ct.toString());
    }

    public static boolean isMimeType(String mimeType, String pattern) throws OXException {
        return Pattern.compile(ContentType.wildcardToRegex(pattern), 2).matcher(ContentType.getBaseType(mimeType)).matches();
    }

    public static String getBaseType(String mimeType) throws OXException {
        Matcher m = PATTERN_CONTENT_TYPE.matcher(mimeType);
        if (m.find()) {
            String subType = m.group(2);
            if (subType == null || subType.length() == 0) {
                subType = DEFAULT_SUBTYPE;
            }
            return new StringBuilder(32).append(m.group(1)).append('/').append(subType).toString();
        }
        throw MailExceptionCode.INVALID_CONTENT_TYPE.create(mimeType);
    }

    private static String toLowerCase(String s) {
        int length = s.length();
        StringBuilder sb = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            sb.append(Character.toLowerCase(s.charAt(i)));
        }
        return sb.toString();
    }

    private static String wildcardToRegex(String wildcard) {
        if (null == wildcard) {
            return "^.*$";
        }
        if (wildcard.indexOf(42) < 0 && wildcard.indexOf(63) < 0) {
            return Pattern.quote(wildcard);
        }
        StringBuilder s = new StringBuilder(wildcard.length());
        s.append('^');
        int len = wildcard.length();
        for (int i = 0; i < len; ++i) {
            char c = wildcard.charAt(i);
            if (c == '*') {
                s.append(".*");
                continue;
            }
            if (c == '?') {
                s.append('.');
                continue;
            }
            if (c == '(' || c == ')' || c == '[' || c == ']' || c == '$' || c == '^' || c == '.' || c == '{' || c == '}' || c == '|' || c == '\\') {
                s.append('\\');
                s.append(c);
                continue;
            }
            s.append(c);
        }
        s.append('$');
        return s.toString();
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean skipEmptyParams) {
        StringBuilder sb = new StringBuilder(64);
        sb.append(this.primaryType).append('/').append(this.subType);
        if (null != this.parameterList) {
            this.parameterList.appendRFC2045String(sb, skipEmptyParams);
        }
        return sb.toString();
    }

    static {
        ContentType tmp = new ContentType();
        tmp.setPrimaryType("text");
        tmp.setSubType("plain");
        tmp.setCharsetParameter("us-ascii");
        DEFAULT_CONTENT_TYPE = new UnmodifiableContentType(tmp);
        PATTERN_CONTENT_TYPE = Pattern.compile("(?:\"?([\\p{L}_0-9-]+)(?:/([\\p{L}_0-9-]+))?\"?)|(?:/([\\p{L}_0-9-]+))");
        PATTERN_TOKEN = Pattern.compile("[\\p{L}_0-9-.+*]*");
        PATTERN_WHITESPACE = Pattern.compile("\\s+");
    }

    public static final class UnmodifiableContentType
    extends ContentType {
        private static final long serialVersionUID = 2473639344400699522L;
        private final ContentType contentType;

        public UnmodifiableContentType(ContentType contentType) {
            this.contentType = contentType;
        }

        @Override
        public void addParameter(String key, String value) {
            throw new UnsupportedOperationException("ContentType.UnmodifiableContentType.addParameter()");
        }

        @Override
        public int compareTo(ParameterizedHeader other) {
            return this.contentType.compareTo(other);
        }

        @Override
        public boolean containsCharsetParameter() {
            return this.contentType.containsCharsetParameter();
        }

        @Override
        public boolean containsNameParameter() {
            return this.contentType.containsNameParameter();
        }

        @Override
        public boolean containsParameter(String key) {
            return this.contentType.containsParameter(key);
        }

        @Override
        public boolean equals(Object obj) {
            return this.contentType.equals(obj);
        }

        @Override
        public String getBaseType() {
            return this.contentType.getBaseType();
        }

        @Override
        public String getCharsetParameter() {
            return this.contentType.getCharsetParameter();
        }

        @Override
        public String getNameParameter() {
            return this.contentType.getNameParameter();
        }

        @Override
        public String getParameter(String key) {
            return this.contentType.getParameter(key);
        }

        @Override
        public Iterator<String> getParameterNames() {
            return Collections.unmodifiableIterator(this.contentType.getParameterNames());
        }

        @Override
        public String getPrimaryType() {
            return this.contentType.getPrimaryType();
        }

        @Override
        public String getSubType() {
            return this.contentType.getSubType();
        }

        @Override
        public int hashCode() {
            return this.contentType.hashCode();
        }

        @Override
        public boolean isMimeType(String pattern) {
            return this.contentType.isMimeType(pattern);
        }

        @Override
        public String removeParameter(String key) {
            throw new UnsupportedOperationException("ContentType.UnmodifiableContentType.removeParameter()");
        }

        @Override
        public ContentType setBaseType(String baseType) throws OXException {
            throw new UnsupportedOperationException("ContentType.UnmodifiableContentType.setCharsetParameter()");
        }

        @Override
        public ContentType setCharsetParameter(String charset) {
            throw new UnsupportedOperationException("ContentType.UnmodifiableContentType.setCharsetParameter()");
        }

        @Override
        public void setContentType(ContentType contentType) {
            throw new UnsupportedOperationException("ContentType.UnmodifiableContentType.setContentType()");
        }

        @Override
        public void setContentType(String contentType) throws OXException {
            throw new UnsupportedOperationException("ContentType.UnmodifiableContentType.setContentType()");
        }

        @Override
        public ContentType setNameParameter(String filename) {
            throw new UnsupportedOperationException("ContentType.UnmodifiableContentType.setNameParameter()");
        }

        @Override
        public void setParameter(String key, String value) {
            throw new UnsupportedOperationException("ContentType.UnmodifiableContentType.setParameter()");
        }

        @Override
        public ContentType setPrimaryType(String primaryType) {
            throw new UnsupportedOperationException("ContentType.UnmodifiableContentType.setPrimaryType()");
        }

        @Override
        public ContentType setSubType(String subType) {
            throw new UnsupportedOperationException("ContentType.UnmodifiableContentType.setSubType()");
        }

        @Override
        public boolean startsWith(String prefix) {
            return this.contentType.startsWith(prefix);
        }

        @Override
        public String toString() {
            return this.contentType.toString();
        }

        @Override
        public String toString(boolean skipEmptyParams) {
            return this.contentType.toString(skipEmptyParams);
        }
    }
}

