/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.userconfiguration;

import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.java.Strings;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.procedure.TIntObjectProcedure;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public enum Permission {
    WEBMAIL(1, "WebMail"),
    CALENDAR(2, "Calendar"),
    CONTACTS(4, "Contacts"),
    TASKS(8, "Tasks"),
    INFOSTORE(16, "Infostore"),
    FORUM(64, "Forum"),
    PINBOARD_WRITE_ACCESS(128, "PinboardWriteAccess"),
    WEBDAV_XML(256, "WebDAVXML"),
    WEBDAV(512, "WebDAV"),
    ICAL(1024, "ICal"),
    VCARD(2048, "VCard"),
    RSS_BOOKMARKS(4096, "RSSBookmarks"),
    RSS_PORTAL(8192, "RSSPortal"),
    MOBILITY(16384, "SyncML"),
    EDIT_PUBLIC_FOLDERS(32768, "FullPublicFolderAccess"),
    READ_CREATE_SHARED_FOLDERS(65536, "FullSharedFolderAccess"),
    DELEGATE_TASKS(131072, "DelegateTasks"),
    EDIT_GROUP(262144, "EditGroup"),
    EDIT_RESOURCE(524288, "EditResource"),
    EDIT_PASSWORD(0x100000, "EditPassword"),
    COLLECT_EMAIL_ADDRESSES(0x200000, "CollectEMailAddresses"),
    MULTIPLE_MAIL_ACCOUNTS(0x400000, "MultipleMailAccounts"),
    SUBSCRIPTION(0x800000, "Subscription"),
    PUBLICATION(0x1000000, "Publication"),
    ACTIVE_SYNC(0x2000000, "ActiveSync"),
    USM(0x4000000, "USM"),
    OLOX20(0x8000000, "OLOX20"),
    DENIED_PORTAL(0x10000000, "DeniedPortal"),
    CALDAV(0x20000000, "CalDAV"),
    CARDDAV(0x40000000, "CardDAV");

    private static final TIntObjectMap<Permission> byBit;
    final int bit;
    final String tagName;

    private Permission(int bit, String name) {
        this.bit = bit;
        this.tagName = name;
    }

    public int getBit() {
        return this.bit;
    }

    public String getTagName() {
        return this.tagName;
    }

    public String getCapabilityName() {
        return Strings.toLowerCase((CharSequence)this.name());
    }

    public static Permission byBit(int bit) {
        return (Permission)((Object)byBit.get(bit));
    }

    public static List<Permission> byBits(int bits) {
        if (0 == bits) {
            return Collections.emptyList();
        }
        Permission[] pa = Permission.values();
        ArrayList<Permission> permissions = new ArrayList<Permission>(pa.length);
        for (Permission p : pa) {
            int bit = p.bit;
            if ((bits & bit) != bit) continue;
            permissions.add(p);
        }
        return permissions;
    }

    public static void addByBits(int bits, Set<String> set) {
        byBit.forEachEntry((TIntObjectProcedure)new AdderProcedure(bits, set));
    }

    public static int toBits(Collection<Permission> col) {
        if (null == col) {
            return 0;
        }
        Iterator<Permission> iterator = col.iterator();
        int bits = 0;
        int i = col.size();
        while (i-- > 0) {
            bits |= iterator.next().bit;
        }
        return bits;
    }

    public static Permission get(String name) {
        if (null == name) {
            return null;
        }
        String upperCase = Strings.toUpperCase((CharSequence)name);
        for (Permission p : Permission.values()) {
            if (!p.name().equals(upperCase)) continue;
            return p;
        }
        return null;
    }

    static {
        Permission[] permissions = Permission.values();
        TIntObjectHashMap m = new TIntObjectHashMap(permissions.length);
        for (Permission p : permissions) {
            m.put(p.bit, (Object)p);
        }
        byBit = m;
    }

    private static final class AdderProcedure
    implements TIntObjectProcedure<Permission> {
        private final Set<String> set;
        private final int bits;

        AdderProcedure(int bits, Set<String> set) {
            this.set = set;
            this.bits = bits;
        }

        public boolean execute(int bit, Permission p) {
            if (bit == (this.bits & bit)) {
                this.set.add(UserConfiguration.toLowerCase(p.name()));
            }
            return true;
        }
    }
}

