/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.userconfiguration;

import com.openexchange.cache.registry.CacheAvailabilityListener;
import com.openexchange.cache.registry.CacheAvailabilityRegistry;
import com.openexchange.caching.Cache;
import com.openexchange.caching.CacheKey;
import com.openexchange.caching.CacheService;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.groupware.userconfiguration.CapabilityUserConfigurationStorage;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.groupware.userconfiguration.UserConfigurationCodes;
import com.openexchange.groupware.userconfiguration.UserConfigurationStorage;
import com.openexchange.groupware.userconfiguration.UserPermissionBitsStorage;
import com.openexchange.server.services.ServerServiceRegistry;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.io.Serializable;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachingUserConfigurationStorage
extends UserConfigurationStorage {
    private static final Logger LOG = LoggerFactory.getLogger(CachingUserConfigurationStorage.class);
    private static final String CACHE_REGION_NAME = "UserConfiguration";
    private final CacheAvailabilityListener cacheAvailabilityListener;
    private final transient UserConfigurationStorage delegateStorage = new CapabilityUserConfigurationStorage();
    private volatile Cache cache;
    private volatile UserConfigurationStorage fallback;

    public CachingUserConfigurationStorage() throws OXException {
        this.cacheAvailabilityListener = new CacheAvailabilityListener(){

            @Override
            public void handleAbsence() throws OXException {
                CachingUserConfigurationStorage.this.releaseCache();
            }

            @Override
            public void handleAvailability() throws OXException {
                CachingUserConfigurationStorage.this.initCache();
            }
        };
        this.initCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UserConfigurationStorage getFallback() {
        UserConfigurationStorage fallback = this.fallback;
        if (null == fallback) {
            CachingUserConfigurationStorage cachingUserConfigurationStorage = this;
            synchronized (cachingUserConfigurationStorage) {
                fallback = this.fallback;
                if (null == fallback) {
                    this.fallback = fallback = new CapabilityUserConfigurationStorage();
                }
            }
        }
        return fallback;
    }

    @Override
    protected void startInternal() throws OXException {
        CacheAvailabilityRegistry reg = CacheAvailabilityRegistry.getInstance();
        if (null != reg && !reg.registerListener(this.cacheAvailabilityListener)) {
            LOG.error("Cache availability listener could not be registered", new Throwable());
        }
    }

    @Override
    protected void stopInternal() throws OXException {
        CacheAvailabilityRegistry reg = CacheAvailabilityRegistry.getInstance();
        if (null != reg) {
            reg.unregisterListener(this.cacheAvailabilityListener);
        }
        this.releaseCache();
    }

    private static final CacheKey getKey(int userId, Context ctx, Cache cache) {
        return cache.newCacheKey(ctx.getContextId(), userId);
    }

    private static final CacheKey getKey(Cache cache, Context ctx, int userId, boolean extendedPermissions) {
        return cache.newCacheKey(ctx.getContextId(), new String[]{String.valueOf(userId), String.valueOf(extendedPermissions)});
    }

    void initCache() throws OXException {
        Cache cache = this.cache;
        if (cache != null) {
            return;
        }
        try {
            this.cache = ServerServiceRegistry.getInstance().getService(CacheService.class).getCache(CACHE_REGION_NAME);
        }
        catch (RuntimeException e) {
            throw UserConfigurationCodes.CACHE_INITIALIZATION_FAILED.create(e, CACHE_REGION_NAME);
        }
    }

    void releaseCache() throws OXException {
        Cache cache = this.cache;
        if (cache == null) {
            return;
        }
        try {
            cache.clear();
            CacheService cacheService = ServerServiceRegistry.getInstance().getService(CacheService.class);
            if (null != cacheService) {
                cacheService.freeCache(CACHE_REGION_NAME);
            }
        }
        catch (RuntimeException e) {
            throw UserConfigurationCodes.CACHE_INITIALIZATION_FAILED.create(e, CACHE_REGION_NAME);
        }
        finally {
            this.cache = null;
        }
    }

    @Override
    public UserConfiguration getUserConfiguration(int userId, int[] groups, Context ctx) throws OXException {
        int[] grps = null != groups && 0 != groups.length ? groups : UserStorage.getInstance().getUser(userId, ctx).getGroups();
        Cache cache = this.cache;
        if (cache == null) {
            return this.getFallback().getUserConfiguration(userId, grps, ctx);
        }
        return this.getUserConfigurations(cache, ctx, new int[]{userId}, new int[][]{grps})[0];
    }

    @Override
    public UserConfiguration[] getUserConfiguration(Context ctx, User[] users) throws OXException {
        Cache cache = this.cache;
        if (cache == null) {
            return this.getFallback().getUserConfiguration(ctx, users);
        }
        int[] userIds = new int[users.length];
        for (int i = 0; i < users.length; ++i) {
            userIds[i] = users[i].getId();
        }
        TIntObjectMap<UserConfiguration> map = CachingUserConfigurationStorage.getCachedUserConfiguration(cache, ctx, userIds, true);
        TIntArrayList toLoad = new TIntArrayList(users.length - map.size());
        ArrayList<int[]> groupsToLoad = new ArrayList<int[]>(users.length - map.size());
        for (User user : users) {
            if (map.containsKey(user.getId())) continue;
            toLoad.add(user.getId());
            groupsToLoad.add(user.getGroups());
        }
        this.loadUserConfiguration(cache, map, ctx, toLoad.toArray(), (int[][])groupsToLoad.toArray((T[])new int[groupsToLoad.size()][]));
        return CachingUserConfigurationStorage.convert(map, userIds);
    }

    @Override
    public UserConfiguration[] getUserConfigurations(Context ctx, int[] userIds, int[][] groups) throws OXException {
        Cache cache = this.cache;
        if (cache == null) {
            return this.getFallback().getUserConfigurations(ctx, userIds, groups);
        }
        return this.getUserConfigurations(cache, ctx, userIds, groups);
    }

    private static TIntObjectMap<UserConfiguration> getCachedUserConfiguration(Cache cache, Context ctx, int[] userIds, boolean extendedPermissions) {
        TIntObjectHashMap map = new TIntObjectHashMap(userIds.length, 1.0f);
        for (int i = 0; i < userIds.length; ++i) {
            CacheKey key = extendedPermissions ? CachingUserConfigurationStorage.getKey(userIds[i], ctx, cache) : CachingUserConfigurationStorage.getKey(cache, ctx, userIds[i], false);
            UserConfiguration userConfig = (UserConfiguration)cache.get((Serializable)key);
            if (null == userConfig) continue;
            map.put(userIds[i], (Object)userConfig.clone());
        }
        return map;
    }

    private static UserConfiguration[] convert(TIntObjectMap<UserConfiguration> map, int[] userIds) {
        ArrayList<UserConfiguration> retval = new ArrayList<UserConfiguration>(map.size());
        for (int userId : userIds) {
            UserConfiguration userConfiguration = (UserConfiguration)map.get(userId);
            if (null == userConfiguration) continue;
            retval.add(userConfiguration.clone());
        }
        return retval.toArray(new UserConfiguration[map.size()]);
    }

    private UserConfiguration[] getUserConfigurations(Cache cache, Context ctx, int[] userIds, int[][] groups) throws OXException {
        TIntObjectMap<UserConfiguration> map = CachingUserConfigurationStorage.getCachedUserConfiguration(cache, ctx, userIds, false);
        TIntArrayList toLoad = new TIntArrayList(userIds.length - map.size());
        ArrayList<int[]> groupsToLoad = new ArrayList<int[]>(userIds.length - map.size());
        for (int i = 0; i < userIds.length; ++i) {
            if (map.containsKey(userIds[i])) continue;
            toLoad.add(userIds[i]);
            groupsToLoad.add(groups[i]);
        }
        this.loadUserConfiguration(cache, map, ctx, toLoad.toArray(), (int[][])groupsToLoad.toArray((T[])new int[groupsToLoad.size()][]));
        return CachingUserConfigurationStorage.convert(map, userIds);
    }

    private void loadUserConfiguration(Cache cache, TIntObjectMap<UserConfiguration> map, Context ctx, int[] userIds, int[][] groups) throws OXException {
        if (null == userIds || 0 == userIds.length) {
            return;
        }
        UserConfiguration[] loaded = this.delegateStorage.getUserConfigurations(ctx, userIds, groups);
        if (null == loaded) {
            return;
        }
        for (UserConfiguration userConfig : loaded) {
            int userId = userConfig.getUserId();
            CacheKey key = CachingUserConfigurationStorage.getKey(cache, ctx, userId, false);
            try {
                cache.put((Serializable)key, (Serializable)userConfig, false);
            }
            catch (RuntimeException e) {
                LOG.warn("Failed to add user configuration for context {} and user {} to cache.", new Object[]{ctx.getContextId(), userId, e});
            }
            map.put(userId, (Object)userConfig.clone());
        }
    }

    @Override
    public void clearStorage() throws OXException {
        Cache cache = this.cache;
        if (cache == null) {
            return;
        }
        try {
            cache.clear();
        }
        catch (RuntimeException rte) {
            LOG.warn("A runtime error occurred.", (Throwable)rte);
        }
    }

    @Override
    public void invalidateCache(int userId, Context ctx) throws OXException {
        Cache cache = this.cache;
        if (cache == null) {
            return;
        }
        CacheKey key = CachingUserConfigurationStorage.getKey(userId, ctx, cache);
        CacheKey keyWithoutExtended = CachingUserConfigurationStorage.getKey(cache, ctx, userId, false);
        try {
            cache.remove((Serializable)key);
            cache.remove((Serializable)keyWithoutExtended);
        }
        catch (RuntimeException e) {
            LOG.warn("Failed to remove user configuration for context {} and user {} to cache.", new Object[]{ctx.getContextId(), userId, e});
        }
        UserPermissionBitsStorage.getInstance().removeUserPermissionBits(userId, ctx);
    }
}

