/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tools;

import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.groupware.update.Schema;
import com.openexchange.groupware.update.SchemaStore;
import com.openexchange.groupware.update.SchemaUpdateState;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTask;
import com.openexchange.groupware.update.internal.DynamicList;
import com.openexchange.groupware.update.internal.SchemaExceptionCodes;
import com.openexchange.groupware.update.internal.UpdateExecutor;
import com.openexchange.groupware.update.internal.UpdateProcess;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UpdateTaskToolkit {
    private static final Logger LOG = LoggerFactory.getLogger(UpdateTaskToolkit.class);
    private static final Object LOCK = new Object();
    private static final String SQL_SELECT_SCHEMAS = "SELECT db_schema,cid FROM context_server2db_pool";
    private static final String SQL_UPDATE_VERSION = "UPDATE version SET version = ?";
    private static final String SQL_SELECT_LOCKED_FOR_UPDATE = "SELECT locked FROM version FOR UPDATE";

    private UpdateTaskToolkit() {
    }

    public static void forceUpdateTask(String className, String schemaName) throws OXException {
        UpdateTaskToolkit.forceUpdateTask(className, UpdateTaskToolkit.getContextIdBySchema(schemaName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void forceUpdateTask(String className, int contextId) throws OXException {
        Object object = LOCK;
        synchronized (object) {
            UpdateTaskToolkit.forceUpdateTask0(UpdateTaskToolkit.getUpdateTask(className), contextId);
        }
    }

    private static void forceUpdateTask0(UpdateTask task, int contextId) throws OXException {
        ArrayList<UpdateTask> taskList = new ArrayList<UpdateTask>(1);
        taskList.add(task);
        new UpdateExecutor(UpdateTaskToolkit.getSchema(contextId), contextId, taskList).execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void forceUpdateTaskOnAllSchemas(String className) throws OXException {
        Object object = LOCK;
        synchronized (object) {
            UpdateTask updateTask = UpdateTaskToolkit.getUpdateTask(className);
            Map<String, Set<Integer>> map = UpdateTaskToolkit.getSchemasAndContexts();
            for (Set<Integer> set : map.values()) {
                if (set.isEmpty()) continue;
                UpdateTaskToolkit.forceUpdateTask0(updateTask, set.iterator().next());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runUpdateOnAllSchemas() throws OXException {
        Object object = LOCK;
        synchronized (object) {
            Map<String, Set<Integer>> map = UpdateTaskToolkit.getSchemasAndContexts();
            for (Set<Integer> set : map.values()) {
                if (set.isEmpty()) continue;
                int contextId = set.iterator().next();
                new UpdateProcess(contextId).run();
            }
        }
    }

    public static Map<String, Schema> getSchemasAndVersions() throws OXException {
        Map<String, Set<Integer>> schemasAndContexts = UpdateTaskToolkit.getSchemasAndContexts();
        HashMap<String, Schema> schemas = new HashMap<String, Schema>(schemasAndContexts.size());
        for (Map.Entry<String, Set<Integer>> entry : schemasAndContexts.entrySet()) {
            SchemaUpdateState schema = UpdateTaskToolkit.getSchema(entry.getValue().iterator().next());
            schemas.put(entry.getKey(), schema);
        }
        return schemas;
    }

    private static Map<String, Set<Integer>> getSchemasAndContexts() throws OXException {
        HashMap<String, Set<Integer>> hashMap;
        Connection con = Database.get(false);
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.prepareStatement(SQL_SELECT_SCHEMAS);
            rs = stmt.executeQuery();
            HashMap<String, Set<Integer>> schemasAndContexts = new HashMap<String, Set<Integer>>();
            while (rs.next()) {
                String schemaName = rs.getString(1);
                int contextId = rs.getInt(2);
                HashSet<Integer> contextIds = (HashSet<Integer>)schemasAndContexts.get(schemaName);
                if (null == contextIds) {
                    contextIds = new HashSet<Integer>();
                    schemasAndContexts.put(schemaName, contextIds);
                }
                contextIds.add(contextId);
            }
            hashMap = schemasAndContexts;
        }
        catch (SQLException e) {
            try {
                throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(rs, stmt);
                Database.back(false, con);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(rs, stmt);
        Database.back(false, con);
        return hashMap;
    }

    public static int getContextIdBySchema(String schemaName) throws OXException {
        Map<String, Set<Integer>> map = UpdateTaskToolkit.getSchemasAndContexts();
        Set<Integer> set = map.get(schemaName);
        if (null == set) {
            throw UpdateExceptionCodes.UNKNOWN_SCHEMA.create(schemaName);
        }
        return set.iterator().next();
    }

    public static void resetVersion(int versionNumber, String schemaName) throws OXException {
        UpdateTaskToolkit.resetVersion(versionNumber, UpdateTaskToolkit.getContextIdBySchema(schemaName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetVersion(int versionNumber, int contextId) throws OXException {
        Object object = LOCK;
        synchronized (object) {
            SchemaUpdateState schema = UpdateTaskToolkit.getSchema(contextId);
            if (schema.getDBVersion() <= versionNumber) {
                throw UpdateExceptionCodes.ONLY_REDUCE.create(schema.getDBVersion(), versionNumber);
            }
            if (schema.getDBVersion() == 200) {
                throw UpdateExceptionCodes.RESET_FORBIDDEN.create(schema.getSchema());
            }
            UpdateTaskToolkit.lockSchema(schema, contextId);
            try {
                UpdateTaskToolkit.setVersionNumber(versionNumber, schema, contextId);
            }
            finally {
                UpdateTaskToolkit.unlockSchema(schema, contextId);
                try {
                    UpdateTaskToolkit.removeContexts(contextId);
                }
                catch (OXException e) {
                    LOG.error("", (Throwable)e);
                }
            }
        }
    }

    private static UpdateTask getUpdateTask(String className) throws OXException {
        List<UpdateTask> taskList = DynamicList.getInstance().getTaskList();
        for (UpdateTask task : taskList) {
            if (!task.getClass().getName().equals(className)) continue;
            return task;
        }
        throw UpdateExceptionCodes.UNKNOWN_TASK.create(className);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void setVersionNumber(int versionNumber, Schema schema, int contextId) throws OXException {
        Connection con = Database.get(contextId, true);
        PreparedStatement stmt = null;
        ResultSet result = null;
        try {
            con.setAutoCommit(false);
            stmt = con.prepareStatement(SQL_SELECT_LOCKED_FOR_UPDATE);
            result = stmt.executeQuery();
            if (!result.next()) {
                throw SchemaExceptionCodes.MISSING_VERSION_ENTRY.create(schema.getSchema());
            }
            if (!result.getBoolean(1)) {
                throw SchemaExceptionCodes.UPDATE_CONFLICT.create(schema.getSchema());
            }
        }
        finally {
            DBUtils.autocommit(con);
            Database.back(contextId, true, con);
        }
        DBUtils.closeSQLStuff(result, stmt);
        try {
            stmt = con.prepareStatement(SQL_UPDATE_VERSION);
            stmt.setInt(1, versionNumber);
            if (stmt.executeUpdate() == 0) {
                throw SchemaExceptionCodes.WRONG_ROW_COUNT.create(1, 0);
            }
            con.commit();
            return;
        }
        catch (SQLException e) {
            DBUtils.rollback(con);
            throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        catch (OXException e) {
            DBUtils.rollback(con);
            throw e;
        }
        catch (SQLException e) {
            try {
                DBUtils.rollback(con);
                throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
                catch (OXException e2) {
                    DBUtils.rollback(con);
                    throw e2;
                }
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(result, stmt);
                throw throwable;
            }
        }
        finally {
            DBUtils.closeSQLStuff(result, stmt);
        }
    }

    private static SchemaUpdateState getSchema(int contextId) throws OXException {
        return SchemaStore.getInstance().getSchema(contextId);
    }

    private static void lockSchema(Schema schema, int contextId) throws OXException {
        SchemaStore.getInstance().lockSchema(schema, contextId, false);
    }

    private static void unlockSchema(Schema schema, int contextId) throws OXException {
        SchemaStore.getInstance().unlockSchema(schema, contextId, false);
    }

    private static void removeContexts(int contextId) throws OXException, OXException {
        int[] contextIds = Database.getContextsInSameSchema(contextId);
        ContextStorage contextStorage = ContextStorage.getInstance();
        for (int cid : contextIds) {
            contextStorage.invalidateContext(cid);
        }
    }
}

