/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.Schema;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTask;
import com.openexchange.tools.sql.DBUtils;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CalendarExtendDNColumnTask
implements UpdateTask {
    private static final Logger LOG = LoggerFactory.getLogger(CalendarExtendDNColumnTask.class);
    private static final int DESIRED_SIZE = 320;
    private static final String SQL_MODIFY = "ALTER TABLE #TABLE# MODIFY dn varchar(320) collate utf8_unicode_ci default NULL";

    @Override
    public int addedWithVersion() {
        return 33;
    }

    @Override
    public int getPriority() {
        return UpdateTask.UpdateTaskPriority.HIGHEST.priority;
    }

    @Override
    public void perform(Schema schema, int contextId) throws OXException {
        LOG.info("Starting {}", (Object)CalendarExtendDNColumnTask.class.getSimpleName());
        this.modifyColumnInTable("prg_date_rights", contextId);
        this.modifyColumnInTable("del_date_rights", contextId);
        LOG.info("{} finished.", (Object)CalendarExtendDNColumnTask.class.getSimpleName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void modifyColumnInTable(String tableName, int contextId) throws OXException {
        block14: {
            CalendarExtendDNColumnTask.LOG.info("{}: Going to extend size of column `dn` in table `{}`.", (Object)CalendarExtendDNColumnTask.class.getSimpleName(), (Object)tableName);
            con = Database.getNoTimeout(contextId, true);
            rs = null;
            try {
                metadata = con.getMetaData();
                rs = metadata.getColumns(null, null, tableName, null);
                columnName = "dn";
lbl9:
                // 2 sources

                while (rs.next()) {
                    name = rs.getString("COLUMN_NAME");
                    if (!"dn".equals(name) || (size = rs.getInt("COLUMN_SIZE")) < 320) break block14;
                    CalendarExtendDNColumnTask.LOG.info("{}: Column {}.{} with size {} is already equal to/greater than {}", new Object[]{CalendarExtendDNColumnTask.class.getSimpleName(), tableName, name, size, 320});
                    break;
                }
            }
            finally {
                Database.backNoTimeout(contextId, true, con);
            }
            DBUtils.closeSQLStuff(rs);
            rs = null;
            return;
        }
        ** GOTO lbl9
        DBUtils.closeSQLStuff(rs);
        rs = null;
        stmt = null;
        try {
            stmt = con.prepareStatement("ALTER TABLE #TABLE# MODIFY dn varchar(320) collate utf8_unicode_ci default NULL".replaceFirst("#TABLE#", tableName));
            stmt.executeUpdate();
            ** GOTO lbl46
        }
        catch (SQLException e) {
            try {
                throw CalendarExtendDNColumnTask.wrapSQLException(e);
            }
            catch (Throwable var10_12) {
                DBUtils.closeSQLStuff(stmt);
                throw var10_12;
                catch (SQLException e) {
                    try {
                        throw CalendarExtendDNColumnTask.wrapSQLException(e);
                    }
                    catch (Throwable var9_11) {
                        DBUtils.closeSQLStuff(rs);
                        rs = null;
                        throw var9_11;
                    }
                }
lbl46:
                // 1 sources

                DBUtils.closeSQLStuff(stmt);
            }
        }
        CalendarExtendDNColumnTask.LOG.info("{}: Size of column `dn` in table `{}` successfully extended.", (Object)CalendarExtendDNColumnTask.class.getSimpleName(), (Object)tableName);
    }

    private static OXException wrapSQLException(SQLException e) {
        return UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
    }
}

