/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.Schema;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTask;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AppointmentExceptionRemoveDuplicateDatePosition
implements UpdateTask {
    private static final Logger LOG = LoggerFactory.getLogger(AppointmentExceptionRemoveDuplicateDatePosition.class);

    @Override
    public int addedWithVersion() {
        return 22;
    }

    @Override
    public int getPriority() {
        return UpdateTask.UpdateTaskPriority.NORMAL.priority;
    }

    @Override
    public void perform(Schema schema, int contextId) throws OXException {
        LOG.info("Performing update task to remove duplicate date recurrence position from appointment change exceptions on schema {}", (Object)schema.getSchema());
        Connection con = Database.get(contextId, true);
        Statement st = null;
        try {
            con.setAutoCommit(false);
            st = con.createStatement();
            st.executeUpdate("UPDATE prg_dates SET field08=SUBSTR(field08,1,LOCATE(',', field08)-1) WHERE intfield01!=intfield02 AND field08 LIKE '%,%';");
            con.commit();
        }
        catch (SQLException e) {
            DBUtils.rollback(con);
            throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        finally {
            DBUtils.autocommit(con);
            DBUtils.closeSQLStuff(null, st);
            if (con != null) {
                Database.back(contextId, true, con);
            }
        }
        LOG.info("Update task to remove duplicate date recurrence position from appointment change exceptions performed.");
    }
}

