/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.infostore.search;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.infostore.DocumentMetadata;
import com.openexchange.groupware.infostore.search.SearchTerm;
import com.openexchange.groupware.infostore.search.SearchTermVisitor;
import com.openexchange.groupware.infostore.utils.Metadata;
import java.util.Collection;

public final class CurrentVersionTerm
implements SearchTerm<Boolean> {
    private final boolean currentVersion;

    public CurrentVersionTerm(boolean currentVersion) {
        this.currentVersion = currentVersion;
    }

    @Override
    public Boolean getPattern() {
        return this.currentVersion;
    }

    @Override
    public void visit(SearchTermVisitor visitor) throws OXException {
        if (null != visitor) {
            visitor.visit(this);
        }
    }

    @Override
    public void addField(Collection<Metadata> col) {
        if (null != col) {
            col.add(Metadata.CURRENT_VERSION_LITERAL);
        }
    }

    @Override
    public boolean matches(DocumentMetadata file) throws OXException {
        return this.currentVersion ? -1 == file.getVersion() : -1 != file.getVersion();
    }
}

