/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.infostore.database.impl;

import com.openexchange.database.Databases;
import com.openexchange.database.provider.DBProvider;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.infostore.DocumentMetadata;
import com.openexchange.groupware.infostore.InfostoreExceptionCodes;
import com.openexchange.groupware.infostore.database.BatchFilenameReserver;
import com.openexchange.groupware.infostore.database.FilenameReservation;
import com.openexchange.groupware.infostore.database.impl.BatchFilenameReservation;
import com.openexchange.groupware.infostore.database.impl.Tools;
import com.openexchange.java.util.UUIDs;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchFilenameReserverImpl
implements BatchFilenameReserver {
    private static final Logger LOG = LoggerFactory.getLogger(BatchFilenameReserverImpl.class);
    private final Context context;
    private final DBProvider provider;
    private final List<BatchFilenameReservation> performedReservations;

    public BatchFilenameReserverImpl(Context context, DBProvider provider) {
        this.context = context;
        this.provider = provider;
        this.performedReservations = new ArrayList<BatchFilenameReservation>();
    }

    @Override
    public void cleanUp() {
        if (0 < this.performedReservations.size()) {
            this.destroySilently(this.performedReservations);
        }
    }

    @Override
    public Map<DocumentMetadata, FilenameReservation> reserve(List<DocumentMetadata> documents, boolean adjustAsNeeded) throws OXException {
        if (null == documents || 0 == documents.size()) {
            return Collections.emptyMap();
        }
        HashMap<DocumentMetadata, FilenameReservation> reservations = new HashMap<DocumentMetadata, FilenameReservation>(documents.size());
        Map<Long, List<DocumentMetadata>> documentsPerFolder = BatchFilenameReserverImpl.getDocumentsPerFolder(documents);
        boolean committed = false;
        Connection con = null;
        try {
            con = this.provider.getWriteConnection(this.context);
            Databases.startTransaction((Connection)con);
            for (Map.Entry<Long, List<DocumentMetadata>> entry : documentsPerFolder.entrySet()) {
                long folderID = entry.getKey();
                List<DocumentMetadata> documentsInFolder = entry.getValue();
                ArrayList<BatchFilenameReservation> reservationsInFolder = new ArrayList<BatchFilenameReservation>(documentsInFolder.size());
                BatchFilenameReserverImpl.lockFolder(con, this.context.getContextId(), folderID);
                Set<String> usedNames = BatchFilenameReserverImpl.getConflictingFilenames(con, this.context.getContextId(), folderID, BatchFilenameReserverImpl.getFileNames(documentsInFolder));
                for (DocumentMetadata document : documentsInFolder) {
                    String fileName = document.getFileName();
                    if (null == fileName) continue;
                    boolean adjusted = false;
                    if (usedNames.contains(fileName)) {
                        if (!adjustAsNeeded) {
                            throw InfostoreExceptionCodes.FILENAME_NOT_UNIQUE.create(fileName, document);
                        }
                        adjusted = true;
                        int count = 0;
                        while (usedNames.contains(fileName = Tools.enhance(fileName, ++count))) {
                        }
                    }
                    BatchFilenameReservation reservation = new BatchFilenameReservation(UUIDs.toByteArray((UUID)UUID.randomUUID()), fileName, adjusted);
                    reservations.put(document, reservation);
                    reservationsInFolder.add(reservation);
                    usedNames.add(fileName);
                }
                if (0 >= reservationsInFolder.size()) continue;
                BatchFilenameReserverImpl.insertReservations(con, this.context.getContextId(), folderID, reservationsInFolder);
                this.performedReservations.addAll(reservationsInFolder);
            }
            con.commit();
            committed = true;
        }
        catch (SQLException e) {
            throw InfostoreExceptionCodes.SQL_PROBLEM.create(e.getMessage(), e);
        }
        finally {
            if (!committed) {
                Databases.rollback((Connection)con);
            }
            Databases.autocommit((Connection)con);
            this.provider.releaseWriteConnection(this.context, con);
        }
        return reservations;
    }

    private int destroySilently(Collection<BatchFilenameReservation> reservations) {
        int updated = 0;
        try {
            updated = this.destroy(reservations);
        }
        catch (OXException e) {
            LOG.warn("", (Throwable)e);
        }
        catch (SQLException e) {
            LOG.warn("", (Throwable)e);
        }
        return updated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int destroy(Collection<BatchFilenameReservation> reservations) throws OXException, SQLException {
        if (null == reservations || 0 == reservations.size()) {
            return 0;
        }
        ArrayList<byte[]> reservationIDs = new ArrayList<byte[]>(reservations.size());
        for (BatchFilenameReservation reservation : reservations) {
            reservationIDs.add(reservation.getReservationID());
        }
        int updated = 0;
        boolean committed = false;
        Connection con = null;
        try {
            con = this.provider.getWriteConnection(this.context);
            Databases.startTransaction((Connection)con);
            updated = BatchFilenameReserverImpl.deleteReservations(con, this.context.getContextId(), reservationIDs);
            con.commit();
            committed = true;
        }
        finally {
            if (!committed) {
                Databases.rollback((Connection)con);
            }
            Databases.autocommit((Connection)con);
            this.provider.releaseWriteConnection(this.context, con);
        }
        return updated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int deleteReservations(Connection connection, int contextID, List<byte[]> reservationIDs) throws SQLException {
        int n;
        if (null == reservationIDs || 0 == reservationIDs.size()) {
            return 0;
        }
        StringBuilder StringBuilder2 = new StringBuilder();
        StringBuilder2.append("DELETE FROM infostoreReservedPaths WHERE cid=? AND uuid");
        if (1 == reservationIDs.size()) {
            StringBuilder2.append("=?;");
        } else {
            StringBuilder2.append(" IN (?");
            for (int i = 1; i < reservationIDs.size(); ++i) {
                StringBuilder2.append(",?");
            }
            StringBuilder2.append(");");
        }
        PreparedStatement stmt = null;
        try {
            stmt = connection.prepareStatement(StringBuilder2.toString());
            int parameterIndex = 0;
            stmt.setInt(++parameterIndex, contextID);
            for (byte[] reservationID : reservationIDs) {
                stmt.setBytes(++parameterIndex, reservationID);
            }
            n = stmt.executeUpdate();
        }
        catch (Throwable throwable) {
            Databases.closeSQLStuff(stmt);
            throw throwable;
        }
        Databases.closeSQLStuff((Statement)stmt);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int insertReservations(Connection connection, int contextID, long targetFolderID, List<BatchFilenameReservation> reservations) throws SQLException {
        int n;
        if (null == reservations || 0 == reservations.size()) {
            return 0;
        }
        StringBuilder StringBuilder2 = new StringBuilder();
        StringBuilder2.append("INSERT INTO infostoreReservedPaths (uuid,cid,folder,name) VALUES (?,?,?,?)");
        for (int i = 1; i < reservations.size(); ++i) {
            StringBuilder2.append(",(?,?,?,?)");
        }
        StringBuilder2.append(';');
        PreparedStatement stmt = null;
        try {
            stmt = connection.prepareStatement(StringBuilder2.toString());
            int parameterIndex = 0;
            for (BatchFilenameReservation reservation : reservations) {
                stmt.setBytes(++parameterIndex, reservation.getReservationID());
                stmt.setInt(++parameterIndex, contextID);
                stmt.setLong(++parameterIndex, targetFolderID);
                stmt.setString(++parameterIndex, reservation.getFilename());
            }
            n = stmt.executeUpdate();
        }
        catch (Throwable throwable) {
            Databases.closeSQLStuff(stmt);
            throw throwable;
        }
        Databases.closeSQLStuff((Statement)stmt);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<String> getConflictingFilenames(Connection connection, int contextID, long targetFolderID, Set<String> fileNames) throws SQLException {
        int i;
        if (null == fileNames || 0 == fileNames.size()) {
            return Collections.emptySet();
        }
        Set<String> possibleWildcards = Tools.getEnhancedWildcards(fileNames);
        StringBuilder StringBuilder2 = new StringBuilder();
        StringBuilder2.append("SELECT DISTINCT infostore_document.filename FROM infostore JOIN infostore_document ").append("ON infostore.cid=infostore_document.cid AND infostore.version=infostore_document.version_number ").append("AND infostore.id=infostore_document.infostore_id WHERE infostore.cid=? AND infostore.folder_id=? ").append("AND (infostore_document.filename");
        if (1 == fileNames.size()) {
            StringBuilder2.append("=?");
        } else {
            StringBuilder2.append(" IN (?");
            for (i = 1; i < fileNames.size(); ++i) {
                StringBuilder2.append(",?");
            }
            StringBuilder2.append(")");
        }
        for (i = 0; i < possibleWildcards.size(); ++i) {
            StringBuilder2.append(" OR infostore_document.filename LIKE ?");
        }
        StringBuilder2.append(");");
        HashSet<String> conflictingFilenames = new HashSet<String>();
        PreparedStatement stmt = null;
        ResultSet result = null;
        try {
            stmt = connection.prepareStatement(StringBuilder2.toString());
            int parameterIndex = 0;
            stmt.setInt(++parameterIndex, contextID);
            stmt.setLong(++parameterIndex, targetFolderID);
            for (String filename : fileNames) {
                stmt.setString(++parameterIndex, filename);
            }
            for (String possibleWildcard : possibleWildcards) {
                stmt.setString(++parameterIndex, possibleWildcard);
            }
            result = stmt.executeQuery();
            while (result.next()) {
                conflictingFilenames.add(result.getString(1));
            }
        }
        catch (Throwable throwable) {
            DBUtils.closeSQLStuff(result, stmt);
            throw throwable;
        }
        DBUtils.closeSQLStuff(result, stmt);
        return conflictingFilenames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean lockFolder(Connection connection, int contextID, long targetFolderID) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = connection.prepareStatement("SELECT fuid FROM oxfolder_tree WHERE cid=? AND fuid=? FOR UPDATE;");
            stmt.setInt(1, contextID);
            stmt.setLong(2, targetFolderID);
            boolean bl = stmt.execute();
            return bl;
        }
        finally {
            DBUtils.closeSQLStuff(stmt);
        }
    }

    private static Set<String> getFileNames(List<DocumentMetadata> documents) {
        HashSet<String> fileNames = new HashSet<String>(documents.size());
        for (DocumentMetadata document : documents) {
            String fileName = document.getFileName();
            if (null == fileName) continue;
            fileNames.add(fileName);
        }
        return fileNames;
    }

    private static Map<Long, List<DocumentMetadata>> getDocumentsPerFolder(List<DocumentMetadata> documents) {
        HashMap<Long, List<DocumentMetadata>> documentsPerFolder = new HashMap<Long, List<DocumentMetadata>>();
        for (DocumentMetadata document : documents) {
            Long folderID = document.getFolderId();
            ArrayList<DocumentMetadata> documentsInFolder = (ArrayList<DocumentMetadata>)documentsPerFolder.get(folderID);
            if (null == documentsInFolder) {
                documentsInFolder = new ArrayList<DocumentMetadata>();
                documentsPerFolder.put(folderID, documentsInFolder);
            }
            documentsInFolder.add(document);
        }
        return documentsPerFolder;
    }
}

