/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.internal.performers;

import com.openexchange.ajax.requesthandler.AJAXRequestDataTools;
import com.openexchange.exception.OXException;
import com.openexchange.folderstorage.Folder;
import com.openexchange.folderstorage.FolderExceptionErrorMessage;
import com.openexchange.folderstorage.FolderServiceDecorator;
import com.openexchange.folderstorage.FolderStorage;
import com.openexchange.folderstorage.FolderStorageDiscoverer;
import com.openexchange.folderstorage.Permission;
import com.openexchange.folderstorage.UserizedFolder;
import com.openexchange.folderstorage.internal.performers.AbstractPerformer;
import com.openexchange.folderstorage.internal.performers.AbstractUserizedFolderPerformer;
import com.openexchange.folderstorage.internal.performers.ListPerformer;
import com.openexchange.folderstorage.internal.performers.MovePerformer;
import com.openexchange.folderstorage.type.PublicType;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.tools.session.ServerSession;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;

public final class UpdatePerformer
extends AbstractUserizedFolderPerformer {
    public UpdatePerformer(ServerSession session, FolderServiceDecorator decorator) throws OXException {
        super(session, decorator);
    }

    public UpdatePerformer(User user, Context context, FolderServiceDecorator decorator) {
        super(user, context, decorator);
    }

    public UpdatePerformer(ServerSession session, FolderServiceDecorator decorator, FolderStorageDiscoverer folderStorageDiscoverer) throws OXException {
        super(session, decorator, folderStorageDiscoverer);
    }

    public UpdatePerformer(User user, Context context, FolderServiceDecorator decorator, FolderStorageDiscoverer folderStorageDiscoverer) {
        super(user, context, decorator, folderStorageDiscoverer);
    }

    public void doUpdate(Folder folder, Date timeStamp) throws OXException {
        String folderId = folder.getID();
        if (null == folderId) {
            throw FolderExceptionErrorMessage.MISSING_FOLDER_ID.create(new Object[0]);
        }
        String treeId = folder.getTreeID();
        if (null == treeId) {
            throw FolderExceptionErrorMessage.MISSING_TREE_ID.create(new Object[0]);
        }
        FolderStorage storage = this.folderStorageDiscoverer.getFolderStorage(treeId, folderId);
        if (null == storage) {
            throw FolderExceptionErrorMessage.NO_STORAGE_FOR_ID.create(treeId, folderId);
        }
        if (null != timeStamp) {
            this.storageParameters.setTimeStamp(timeStamp);
        }
        ArrayList<FolderStorage> openedStorages = new ArrayList<FolderStorage>(4);
        this.checkOpenedStorage(storage, openedStorages);
        try {
            FolderStorage realStorage;
            boolean changeSubscription;
            boolean changePermissions;
            Permission[] newPerms;
            String newName;
            boolean rename;
            boolean move;
            Folder storageFolder = storage.getFolder(treeId, folderId, this.storageParameters);
            String oldParentId = storageFolder.getParentID();
            String newParentId = folder.getParentID();
            boolean bl = move = null != newParentId && !newParentId.equals(oldParentId);
            if (move) {
                if (null == folder.getName()) {
                    folder.setName(storageFolder.getName());
                }
                if ("infostore".equals(((Object)storageFolder.getContentType()).toString())) {
                    this.checkForDuplicateOnMove(folder, treeId, openedStorages, storageFolder, newParentId);
                } else {
                    this.checkForDuplicateOnMove(folder, treeId, openedStorages, storageFolder, newParentId);
                }
            }
            boolean bl2 = rename = null != (newName = folder.getName()) && !newName.equals(storageFolder.getName());
            if (rename) {
                if ("infostore".equals(((Object)storageFolder.getContentType()).toString())) {
                    if (move) {
                        this.checkForDuplicateOnMove(folder, treeId, openedStorages, storageFolder, folder.getParentID());
                    } else {
                        this.checkForDuplicateOnRename(folder, treeId, openedStorages, storageFolder, newName, false);
                    }
                } else if (move) {
                    this.checkForDuplicateOnMove(folder, treeId, openedStorages, storageFolder, folder.getParentID());
                } else {
                    this.checkForDuplicateOnRename(folder, treeId, openedStorages, storageFolder, newName, false);
                }
            }
            if (null == (newPerms = UpdatePerformer.stripSystemPermissions(folder.getPermissions()))) {
                changePermissions = false;
            } else {
                Permission[] oldPerms = UpdatePerformer.stripSystemPermissions(storageFolder.getPermissions());
                if (newPerms.length != oldPerms.length) {
                    changePermissions = true;
                } else {
                    boolean equals = true;
                    for (int i = 0; equals && i < oldPerms.length; ++i) {
                        Permission oldPerm = oldPerms[i];
                        if (0 != oldPerm.getSystem()) continue;
                        int entity = oldPerm.getEntity();
                        Object compareWith = null;
                        for (int j = 0; null == compareWith && j < newPerms.length; ++j) {
                            Permission newPerm = newPerms[j];
                            if (newPerm.getEntity() != entity) continue;
                            compareWith = newPerm;
                        }
                        equals = null != compareWith && compareWith.equals(oldPerm);
                    }
                    changePermissions = !equals;
                }
            }
            boolean bl3 = changeSubscription = storageFolder.isSubscribed() != folder.isSubscribed();
            if (move) {
                String newParentId2 = folder.getParentID();
                FolderStorage newRealParentStorage = this.folderStorageDiscoverer.getFolderStorage(FolderStorage.REAL_TREE_ID, newParentId2);
                if (null == newRealParentStorage) {
                    throw FolderExceptionErrorMessage.NO_STORAGE_FOR_ID.create(FolderStorage.REAL_TREE_ID, newParentId2);
                }
                FolderStorage realParentStorage = this.folderStorageDiscoverer.getFolderStorage(FolderStorage.REAL_TREE_ID, oldParentId);
                if (null == realParentStorage) {
                    throw FolderExceptionErrorMessage.NO_STORAGE_FOR_ID.create(FolderStorage.REAL_TREE_ID, oldParentId);
                }
                if (!rename) {
                    String newName2 = folder.getName();
                    folder.setName(newName2 == null ? storageFolder.getName() : newName2);
                }
                if (this.equallyNamedSibling(folder.getName(), treeId, newParentId2, openedStorages)) {
                    String parentName = newParentId2;
                    try {
                        Folder parentFolder = newRealParentStorage.getFolder(FolderStorage.REAL_TREE_ID, newParentId2, this.storageParameters);
                        if (null != parentFolder) {
                            parentName = parentFolder.getName();
                        }
                    }
                    catch (OXException e) {
                        // empty catch block
                    }
                    throw FolderExceptionErrorMessage.EQUAL_NAME.create(folder.getName(), parentName, treeId);
                }
                boolean started2 = newRealParentStorage.startTransaction(this.storageParameters, true);
                try {
                    Folder newParent = newRealParentStorage.getFolder(FolderStorage.REAL_TREE_ID, newParentId2, this.storageParameters);
                    if ((FolderStorage.PUBLIC_ID.equals(newParent.getID()) || PublicType.getInstance().equals(newParent.getType())) && "mail".equals(((Object)storageFolder.getContentType()).toString())) {
                        throw FolderExceptionErrorMessage.NO_PUBLIC_MAIL_FOLDER.create();
                    }
                    if (started2) {
                        newRealParentStorage.commitTransaction(this.storageParameters);
                    }
                }
                catch (OXException e) {
                    if (started2) {
                        newRealParentStorage.rollback(this.storageParameters);
                    }
                    throw e;
                }
                catch (Exception e) {
                    if (started2) {
                        newRealParentStorage.rollback(this.storageParameters);
                    }
                    throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(e, e.getMessage());
                }
                MovePerformer movePerformer = this.newMovePerformer();
                movePerformer.setStorageParameters(this.storageParameters);
                if (FolderStorage.REAL_TREE_ID.equals(folder.getTreeID())) {
                    movePerformer.doMoveReal(folder, storage, realParentStorage, newRealParentStorage);
                } else {
                    movePerformer.doMoveVirtual(folder, storage, realParentStorage, newRealParentStorage, storageFolder, openedStorages);
                }
            } else if (rename) {
                folder.setParentID(oldParentId);
                if (this.equallyNamedSibling(folder.getName(), treeId, oldParentId, openedStorages)) {
                    throw FolderExceptionErrorMessage.EQUAL_NAME.create(folder.getName(), oldParentId, treeId);
                }
                if (FolderStorage.REAL_TREE_ID.equals(folder.getTreeID())) {
                    this.doRenameReal(folder, storage);
                } else {
                    this.doRenameVirtual(folder, storage, openedStorages);
                }
            } else if (changePermissions) {
                if (FolderStorage.REAL_TREE_ID.equals(folder.getTreeID())) {
                    storage.updateFolder(folder, this.storageParameters);
                } else {
                    realStorage = this.folderStorageDiscoverer.getFolderStorage(FolderStorage.REAL_TREE_ID, folder.getID());
                    if (null == realStorage) {
                        throw FolderExceptionErrorMessage.NO_STORAGE_FOR_ID.create(FolderStorage.REAL_TREE_ID, folder.getID());
                    }
                    if (storage.equals(realStorage)) {
                        storage.updateFolder(folder, this.storageParameters);
                    } else {
                        this.checkOpenedStorage(realStorage, openedStorages);
                        realStorage.updateFolder(folder, this.storageParameters);
                        storage.updateFolder(folder, this.storageParameters);
                    }
                }
            } else if (changeSubscription) {
                if (FolderStorage.REAL_TREE_ID.equals(folder.getTreeID())) {
                    storage.updateFolder(folder, this.storageParameters);
                } else {
                    realStorage = this.folderStorageDiscoverer.getFolderStorage(FolderStorage.REAL_TREE_ID, folder.getID());
                    if (null == realStorage) {
                        throw FolderExceptionErrorMessage.NO_STORAGE_FOR_ID.create(FolderStorage.REAL_TREE_ID, folder.getID());
                    }
                    if (storage.equals(realStorage)) {
                        storage.updateFolder(folder, this.storageParameters);
                    } else {
                        this.checkOpenedStorage(realStorage, openedStorages);
                        realStorage.updateFolder(folder, this.storageParameters);
                        storage.updateFolder(folder, this.storageParameters);
                    }
                }
            }
            for (FolderStorage fs : openedStorages) {
                fs.commitTransaction(this.storageParameters);
            }
            Set<OXException> warnings = this.storageParameters.getWarnings();
            if (null != warnings) {
                for (OXException warning : warnings) {
                    this.addWarning(warning);
                }
            }
        }
        catch (OXException e) {
            for (FolderStorage fs : openedStorages) {
                fs.rollback(this.storageParameters);
            }
            throw e;
        }
        catch (Exception e) {
            for (FolderStorage fs : openedStorages) {
                fs.rollback(this.storageParameters);
            }
            throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
    }

    private void checkForDuplicateOnMove(Folder folder, String treeId, List<FolderStorage> openedStorages, Folder storageFolder, String newParentId) throws OXException {
        AbstractPerformer.CheckForDuplicateResult result = this.getCheckForDuplicateResult(folder.getName(), treeId, newParentId, openedStorages);
        if (null != result) {
            boolean autoRename = AJAXRequestDataTools.parseBoolParameter(this.getDecoratorStringProperty("autorename"));
            if (!autoRename) {
                throw result.error;
            }
            boolean useParenthesis = PARENTHESIS_CAPABLE.contains(((Object)storageFolder.getContentType()).toString());
            int count = 2;
            StringBuilder nameBuilder = new StringBuilder(folder.getName());
            int resetLen = nameBuilder.length();
            do {
                nameBuilder.setLength(resetLen);
                if (useParenthesis) {
                    nameBuilder.append(" (").append(count++).append(')');
                    continue;
                }
                nameBuilder.append(" ").append(count++);
            } while (null != (result = this.getCheckForDuplicateResult(nameBuilder.toString(), treeId, newParentId, openedStorages)));
            folder.setName(nameBuilder.toString());
        }
    }

    private void checkForDuplicateOnRename(Folder folder, String treeId, List<FolderStorage> openedStorages, Folder storageFolder, String newName, boolean allowAutoRename) throws OXException {
        AbstractPerformer.CheckForDuplicateResult result = this.getCheckForDuplicateResult(newName, treeId, storageFolder.getParentID(), storageFolder.getID(), openedStorages);
        if (null != result) {
            if (!allowAutoRename) {
                throw result.error;
            }
            boolean autoRename = AJAXRequestDataTools.parseBoolParameter(this.getDecoratorStringProperty("autorename"));
            if (!autoRename) {
                throw result.error;
            }
            boolean useParenthesis = PARENTHESIS_CAPABLE.contains(((Object)storageFolder.getContentType()).toString());
            int count = 2;
            StringBuilder nameBuilder = new StringBuilder(folder.getName());
            int resetLen = nameBuilder.length();
            do {
                nameBuilder.setLength(resetLen);
                if (useParenthesis) {
                    nameBuilder.append(" (").append(count++).append(')');
                    continue;
                }
                nameBuilder.append(" ").append(count++);
            } while (null != (result = this.getCheckForDuplicateResult(nameBuilder.toString(), treeId, storageFolder.getParentID(), openedStorages)));
            folder.setName(nameBuilder.toString());
        }
    }

    private MovePerformer newMovePerformer() throws OXException {
        if (null == this.session) {
            return new MovePerformer(this.user, this.context, this.folderStorageDiscoverer);
        }
        return new MovePerformer(this.session, this.folderStorageDiscoverer);
    }

    private void doRenameReal(Folder folder, FolderStorage realStorage) throws OXException {
        realStorage.updateFolder(folder, this.storageParameters);
    }

    private void doRenameVirtual(Folder folder, FolderStorage virtualStorage, List<FolderStorage> openedStorages) throws OXException {
        FolderStorage realStorage = this.folderStorageDiscoverer.getFolderStorage(FolderStorage.REAL_TREE_ID, folder.getID());
        if (null == realStorage) {
            throw FolderExceptionErrorMessage.NO_STORAGE_FOR_ID.create(FolderStorage.REAL_TREE_ID, folder.getID());
        }
        if (virtualStorage.equals(realStorage)) {
            virtualStorage.updateFolder(folder, this.storageParameters);
        } else {
            this.checkOpenedStorage(realStorage, openedStorages);
            Folder realFolder = realStorage.getFolder(FolderStorage.REAL_TREE_ID, folder.getID(), this.storageParameters);
            Folder clone4Real = (Folder)folder.clone();
            clone4Real.setParentID(null);
            clone4Real.setName(this.nonExistingName(clone4Real.getName(), FolderStorage.REAL_TREE_ID, realFolder.getParentID(), openedStorages));
            realStorage.updateFolder(clone4Real, this.storageParameters);
            folder.setNewID(clone4Real.getID());
            virtualStorage.updateFolder(folder, this.storageParameters);
            folder.setID(clone4Real.getID());
        }
    }

    private void checkOpenedStorage(FolderStorage storage, List<FolderStorage> openedStorages) throws OXException {
        for (FolderStorage openedStorage : openedStorages) {
            if (!openedStorage.equals(storage)) continue;
            return;
        }
        if (storage.startTransaction(this.storageParameters, true)) {
            openedStorages.add(storage);
        }
    }

    private boolean equallyNamedSibling(String name, String treeId, String parentId, Collection<FolderStorage> openedStorages) throws OXException {
        UserizedFolder[] subfolders;
        ListPerformer listPerformer = null == this.session ? new ListPerformer(this.user, this.context, null) : new ListPerformer(this.session, null);
        listPerformer.setStorageParameters(this.storageParameters);
        for (UserizedFolder userizedFolder : subfolders = listPerformer.doList(treeId, parentId, true, openedStorages, false)) {
            if (!name.equals(userizedFolder.getName())) continue;
            return true;
        }
        return false;
    }

    private String nonExistingName(String name, String treeId, String parentId, Collection<FolderStorage> openedStorages) throws OXException {
        ListPerformer listPerformer = null == this.session ? new ListPerformer(this.user, this.context, null) : new ListPerformer(this.session, null);
        listPerformer.setStorageParameters(this.storageParameters);
        UserizedFolder[] subfolders = listPerformer.doList(treeId, parentId, true, openedStorages, false);
        StringBuilder sb = new StringBuilder();
        String nonExistingName = name;
        int i = 0;
        int count = 0;
        while (i < subfolders.length) {
            if (nonExistingName.equals(subfolders[i].getName())) {
                sb.setLength(0);
                sb.append(name).append('_').append(String.valueOf(++count));
                nonExistingName = sb.toString();
                i = 0;
                continue;
            }
            ++i;
        }
        return nonExistingName;
    }

    private static Permission[] stripSystemPermissions(Permission[] permissions) {
        if (null == permissions) {
            return null;
        }
        int len = permissions.length;
        ArrayList<Permission> list = new ArrayList<Permission>(len);
        for (int i = 0; i < len; ++i) {
            Permission permission = permissions[i];
            if (0 != permission.getSystem()) continue;
            list.add(permission);
        }
        return list.toArray(new Permission[list.size()]);
    }
}

