/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.database.getfolder;

import com.openexchange.exception.OXException;
import com.openexchange.folderstorage.FolderExceptionErrorMessage;
import com.openexchange.folderstorage.database.DatabaseFolder;
import com.openexchange.folderstorage.database.LocalizedDatabaseFolder;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.groupware.tools.iterator.FolderObjectIterator;
import com.openexchange.groupware.userconfiguration.UserPermissionBits;
import com.openexchange.i18n.tools.StringHelper;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.oxfolder.OXFolderIteratorSQL;
import com.openexchange.tools.oxfolder.memory.ConditionTreeMap;
import com.openexchange.tools.oxfolder.memory.ConditionTreeMapManagement;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Queue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SystemSharedFolder {
    private static final Logger LOG = LoggerFactory.getLogger(SystemSharedFolder.class);

    private SystemSharedFolder() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DatabaseFolder getSystemSharedFolder(FolderObject fo, User user, UserPermissionBits userPerm, Context ctx, Connection con) throws OXException {
        SearchIterator<FolderObject> searchIterator;
        ConditionTreeMap treeMap;
        LocalizedDatabaseFolder retval = new LocalizedDatabaseFolder(fo, false);
        retval.setName("Shared folders");
        try {
            treeMap = ConditionTreeMapManagement.getInstance().optMapFor(ctx.getContextId());
        }
        catch (OXException e) {
            treeMap = null;
        }
        if (null != treeMap) {
            boolean hasNext = treeMap.hasSharedFolder(user.getId(), user.getGroups(), userPerm.getAccessibleModules());
            retval.setSubfolderIDs(hasNext ? null : new String[]{});
            retval.setSubscribedSubfolders(hasNext);
            return retval;
        }
        try {
            searchIterator = OXFolderIteratorSQL.getVisibleSubfoldersIterator(3, user.getId(), user.getGroups(), ctx, userPerm, null, con);
        }
        catch (SQLException e) {
            throw FolderExceptionErrorMessage.SQL_ERROR.create(e, e.getMessage());
        }
        try {
            boolean hasNext = searchIterator.hasNext();
            retval.setSubfolderIDs(hasNext ? null : new String[]{});
            retval.setSubscribedSubfolders(hasNext);
        }
        finally {
            try {
                searchIterator.close();
            }
            catch (OXException e) {
                LOG.error("Failed closing search iterator.", (Throwable)e);
            }
        }
        return retval;
    }

    public static List<String[]> getSystemSharedFolderSubfolder(User user, UserPermissionBits userPerm, Context ctx, Connection con) throws OXException {
        Queue<FolderObject> q;
        try {
            q = ((FolderObjectIterator)OXFolderIteratorSQL.getVisibleSubfoldersIterator(3, user.getId(), user.getGroups(), ctx, userPerm, null, con)).asQueue();
        }
        catch (SQLException e) {
            throw FolderExceptionErrorMessage.SQL_ERROR.create(e, e.getMessage());
        }
        StringHelper strHelper = StringHelper.valueOf(user.getLocale());
        int size = q.size();
        HashMap<String, Integer> displayNames = new HashMap<String, Integer>(size);
        UserStorage us = UserStorage.getInstance();
        Iterator iter = q.iterator();
        for (int i = 0; i < size; ++i) {
            String creatorDisplayName;
            FolderObject sharedFolder = (FolderObject)iter.next();
            try {
                creatorDisplayName = us.getUser(sharedFolder.getCreatedBy(), ctx).getDisplayName();
            }
            catch (OXException e) {
                if (sharedFolder.getCreatedBy() != 0) {
                    throw e;
                }
                creatorDisplayName = strHelper.getString("All users");
            }
            if (displayNames.containsKey(creatorDisplayName)) continue;
            displayNames.put(creatorDisplayName, sharedFolder.getCreatedBy());
        }
        ArrayList sortedDisplayNames = new ArrayList(displayNames.keySet());
        Collections.sort(sortedDisplayNames, new DisplayNameComparator(user.getLocale()));
        StringBuilder sb = new StringBuilder(8);
        ArrayList<String[]> subfolderIds = new ArrayList<String[]>(displayNames.size());
        for (String displayName : sortedDisplayNames) {
            sb.setLength(0);
            int createdBy = (Integer)displayNames.get(displayName);
            subfolderIds.add(new String[]{sb.append("u:").append(createdBy).toString(), displayName});
        }
        return subfolderIds;
    }

    private static final class DisplayNameComparator
    implements Comparator<String> {
        private final Collator collator;

        public DisplayNameComparator(Locale locale) {
            this.collator = Collator.getInstance(locale);
            this.collator.setStrength(1);
        }

        @Override
        public int compare(String displayName1, String displayName2) {
            return this.collator.compare(displayName1, displayName2);
        }
    }
}

