/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.database.getfolder;

import com.openexchange.config.cascade.ConfigView;
import com.openexchange.config.cascade.ConfigViewFactory;
import com.openexchange.exception.OXException;
import com.openexchange.folderstorage.FolderExceptionErrorMessage;
import com.openexchange.folderstorage.database.AltNameLocalizedDatabaseFolder;
import com.openexchange.folderstorage.database.DatabaseFolder;
import com.openexchange.folderstorage.database.contentType.InfostoreContentType;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.tools.iterator.FolderObjectIterator;
import com.openexchange.groupware.userconfiguration.UserPermissionBits;
import com.openexchange.i18n.tools.StringHelper;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.PutIfAbsent;
import com.openexchange.session.Session;
import com.openexchange.tools.oxfolder.OXFolderAccess;
import com.openexchange.tools.oxfolder.OXFolderIteratorSQL;
import gnu.trove.list.TIntList;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import org.slf4j.LoggerFactory;

public final class SystemInfostoreFolder {
    private SystemInfostoreFolder() {
    }

    public static DatabaseFolder getSystemInfostoreFolder(FolderObject fo, boolean altNames) {
        AltNameLocalizedDatabaseFolder retval = new AltNameLocalizedDatabaseFolder(fo, "Drive");
        retval.setName(altNames ? "Drive" : "Infostore");
        retval.setContentType(InfostoreContentType.getInstance());
        retval.setSubfolderIDs(null);
        retval.setSubscribedSubfolders(true);
        if (altNames) {
            retval.setCacheable(false);
        }
        return retval;
    }

    public static List<String[]> getSystemInfostoreFolderSubfolders(User user, UserPermissionBits userPerm, Context ctx, boolean altNames, Session session, Connection con) throws OXException {
        try {
            Queue<FolderObject> q = ((FolderObjectIterator)OXFolderIteratorSQL.getVisibleSubfoldersIterator(9, user.getId(), user.getGroups(), ctx, userPerm, null, con)).asQueue();
            int size = q.size();
            Iterator iter = q.iterator();
            ArrayList<FolderObject> l = new ArrayList<FolderObject>(size);
            for (int j = 0; j < size; ++j) {
                FolderObject fobj = (FolderObject)iter.next();
                if (fobj.getObjectID() == 10) {
                    l.add(0, fobj);
                    continue;
                }
                l.add(fobj);
            }
            StringHelper sh = StringHelper.valueOf(user.getLocale());
            ArrayList<String[]> subfolderIds = new ArrayList<String[]>(size);
            Iterator iter2 = l.iterator();
            for (int i = 0; i < size; ++i) {
                FolderObject fo = (FolderObject)iter2.next();
                int fuid = fo.getObjectID();
                if (fuid == 10) {
                    if (SystemInfostoreFolder.showPersonalBelowInfoStore(session, altNames)) {
                        TIntList subfolders = OXFolderIteratorSQL.getVisibleSubfolders(fuid, user.getId(), user.getGroups(), userPerm.getAccessibleModules(), ctx, null);
                        subfolders.remove(SystemInfostoreFolder.getDefaultInfoStoreFolderId(session, ctx));
                        if (subfolders.isEmpty()) continue;
                        subfolderIds.add(SystemInfostoreFolder.toArray(String.valueOf(fuid), sh.getString("Shared files")));
                        continue;
                    }
                    if (altNames) {
                        subfolderIds.add(SystemInfostoreFolder.toArray(String.valueOf(fuid), sh.getString("Shared files")));
                        continue;
                    }
                    subfolderIds.add(SystemInfostoreFolder.toArray(String.valueOf(fuid), sh.getString("Userstore")));
                    continue;
                }
                if (fuid == 15) {
                    subfolderIds.add(SystemInfostoreFolder.toArray(String.valueOf(fuid), sh.getString(altNames ? "Public files" : "Public infostore")));
                    continue;
                }
                if (16 == fo.getType() && fo.isDefaultFolder()) {
                    subfolderIds.add(SystemInfostoreFolder.toArray(String.valueOf(fuid), sh.getString(altNames ? "Deleted files" : "Trash infostore")));
                    continue;
                }
                subfolderIds.add(SystemInfostoreFolder.toArray(String.valueOf(fuid), fo.getFolderName()));
            }
            boolean hasNonTreeVisibleFolders = OXFolderIteratorSQL.hasVisibleFoldersNotSeenInTreeView(8, user.getId(), user.getGroups(), userPerm, ctx, con);
            if (hasNonTreeVisibleFolders) {
                subfolderIds.add(SystemInfostoreFolder.toArray(String.valueOf(14), sh.getString(altNames ? "Other files" : "Other infostore folders")));
            }
            return subfolderIds;
        }
        catch (SQLException e) {
            throw FolderExceptionErrorMessage.SQL_ERROR.create(e, e.getMessage());
        }
    }

    private static String[] toArray(String ... values) {
        int length = values.length;
        String[] ret = new String[length];
        System.arraycopy(values, 0, ret, 0, length);
        return values;
    }

    private static boolean showPersonalBelowInfoStore(Session session, boolean altNames) {
        if (!altNames) {
            return false;
        }
        String paramName = "com.openexchange.folderstorage.outlook.showPersonalBelowInfoStore";
        Boolean tmp = (Boolean)session.getParameter("com.openexchange.folderstorage.outlook.showPersonalBelowInfoStore");
        if (null != tmp) {
            return tmp;
        }
        ConfigViewFactory configViewFactory = ServerServiceRegistry.getInstance().getService(ConfigViewFactory.class);
        if (null == configViewFactory) {
            return false;
        }
        try {
            ConfigView view = configViewFactory.getView(session.getUserId(), session.getContextId());
            Boolean b = (Boolean)view.opt("com.openexchange.folderstorage.outlook.showPersonalBelowInfoStore", Boolean.TYPE, (Object)Boolean.FALSE);
            if (session instanceof PutIfAbsent) {
                ((PutIfAbsent)session).setParameterIfAbsent("com.openexchange.folderstorage.outlook.showPersonalBelowInfoStore", (Object)b);
            } else {
                session.setParameter("com.openexchange.folderstorage.outlook.showPersonalBelowInfoStore", (Object)b);
            }
            return b;
        }
        catch (OXException e) {
            LoggerFactory.getLogger(SystemInfostoreFolder.class).warn("", (Throwable)e);
            return false;
        }
    }

    private static int getDefaultInfoStoreFolderId(Session session, Context ctx) {
        String paramName = "com.openexchange.folderstorage.defaultInfoStoreFolderId";
        String tmp = (String)session.getParameter("com.openexchange.folderstorage.defaultInfoStoreFolderId");
        if (null != tmp) {
            return Integer.parseInt(tmp);
        }
        try {
            int id = new OXFolderAccess(ctx).getDefaultFolder(session.getUserId(), 8).getObjectID();
            if (session instanceof PutIfAbsent) {
                ((PutIfAbsent)session).setParameterIfAbsent("com.openexchange.folderstorage.defaultInfoStoreFolderId", (Object)Integer.toString(id));
            } else {
                session.setParameter("com.openexchange.folderstorage.defaultInfoStoreFolderId", (Object)Integer.toString(id));
            }
            return id;
        }
        catch (OXException e) {
            LoggerFactory.getLogger(SystemInfostoreFolder.class).error("", (Throwable)e);
            return -1;
        }
    }
}

