/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.cache;

import com.openexchange.folderstorage.FolderStorage;
import com.openexchange.folderstorage.FolderType;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public final class CacheFolderType
implements FolderType {
    private static final CacheFolderType instance = new CacheFolderType();
    private static final Set<String> KNOWN_TREES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(FolderStorage.REAL_TREE_ID, "1")));

    public static CacheFolderType getInstance() {
        return instance;
    }

    private CacheFolderType() {
    }

    @Override
    public boolean servesFolderId(String folderId) {
        return true;
    }

    @Override
    public boolean servesTreeId(String treeId) {
        return KNOWN_TREES.contains(treeId);
    }

    @Override
    public boolean servesParentId(String parentId) {
        return true;
    }
}

