/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.requesthandler.responseRenderers;

import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.ajax.requesthandler.ResponseRenderer;
import java.io.IOException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringResponseRenderer
implements ResponseRenderer {
    private static final Logger LOG = LoggerFactory.getLogger(StringResponseRenderer.class);

    @Override
    public int getRanking() {
        return Integer.MIN_VALUE;
    }

    @Override
    public boolean handles(AJAXRequestData request, AJAXRequestResult result) {
        return true;
    }

    @Override
    public void write(AJAXRequestData request, AJAXRequestResult result, HttpServletRequest req, HttpServletResponse resp) {
        Map<String, String> headers = result.getHeaders();
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            resp.setHeader(entry.getKey(), entry.getValue());
        }
        try {
            Object resultObject = result.getResultObject();
            resp.getWriter().write(resultObject == null ? "" : resultObject.toString());
        }
        catch (IOException e) {
            LOG.error("", (Throwable)e);
        }
        catch (RuntimeException e) {
            LOG.error("", (Throwable)e);
        }
    }
}

