/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.requesthandler.converters.preview.cache.groupware;

import com.openexchange.ajax.requesthandler.cache.ResourceCache;
import com.openexchange.ajax.requesthandler.converters.preview.cache.ResourceCacheMBeanImpl;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.delete.DeleteEvent;
import com.openexchange.groupware.delete.DeleteFailedExceptionCodes;
import com.openexchange.groupware.delete.DeleteListener;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreviewCacheDeleteListener
implements DeleteListener {
    @Override
    public void deletePerformed(DeleteEvent event, Connection readCon, Connection writeCon) throws OXException {
        if (event.getType() == 1) {
            this.deleteUserEntriesFromDB(event, writeCon);
        } else if (event.getType() == 5) {
            this.deleteContextEntriesFromDB(event, writeCon);
        }
    }

    private void deleteContextEntriesFromDB(DeleteEvent event, Connection writeCon) throws OXException {
        int contextId = event.getContext().getContextId();
        ResourceCache resourceCache = ResourceCacheMBeanImpl.CACHE_REF.get();
        if (null != resourceCache) {
            try {
                resourceCache.clearFor(contextId);
            }
            catch (Exception e) {
                Logger logger = LoggerFactory.getLogger(PreviewCacheDeleteListener.class);
                logger.warn("Failed to clean resource for deleted context {}", (Object)contextId, (Object)e);
            }
        }
        PreparedStatement stmt = null;
        try {
            stmt = writeCon.prepareStatement("DELETE FROM preview WHERE cid = ?");
            stmt.setInt(1, contextId);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            throw DeleteFailedExceptionCodes.SQL_ERROR.create(e, e.getMessage());
        }
        catch (Exception e) {
            throw DeleteFailedExceptionCodes.ERROR.create(e, e.getMessage());
        }
        finally {
            DBUtils.closeSQLStuff(stmt);
        }
    }

    private void deleteUserEntriesFromDB(DeleteEvent event, Connection writeCon) throws OXException {
        int contextId = event.getContext().getContextId();
        int userId = event.getId();
        ResourceCache resourceCache = ResourceCacheMBeanImpl.CACHE_REF.get();
        if (null != resourceCache) {
            try {
                resourceCache.remove(userId, contextId);
            }
            catch (Exception e) {
                Logger logger = LoggerFactory.getLogger(PreviewCacheDeleteListener.class);
                logger.warn("Failed to clean resource for deleted user {} in context {}", new Object[]{userId, contextId, e});
            }
        }
        PreparedStatement stmt = null;
        try {
            stmt = writeCon.prepareStatement("DELETE FROM preview WHERE cid = ? AND user = ?");
            int pos = 1;
            stmt.setInt(pos++, contextId);
            stmt.setInt(pos, userId);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            throw DeleteFailedExceptionCodes.SQL_ERROR.create(e, e.getMessage());
        }
        catch (Exception e) {
            throw DeleteFailedExceptionCodes.ERROR.create(e, e.getMessage());
        }
        finally {
            DBUtils.closeSQLStuff(stmt);
        }
    }
}

