/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.publish.json;

import com.openexchange.datatypes.genericonf.DynamicFormDescription;
import com.openexchange.datatypes.genericonf.json.FormDescriptionWriter;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.userconfiguration.UserPermissionBits;
import com.openexchange.i18n.Translator;
import com.openexchange.publish.PublicationTarget;
import com.openexchange.publish.interfaces.UserSpecificPublicationTarget;
import com.openexchange.publish.json.PublicationJSONErrorMessage;
import java.util.Collection;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class PublicationTargetWriter {
    private static final String ID = "id";
    private static final String DISPLAY_NAME = "displayName";
    private static final String ICON = "icon";
    private static final String MODULE = "module";
    private static final String FORM_DESCRIPTION = "formDescription";
    private final Translator translator;

    public PublicationTargetWriter(Translator translator) {
        this.translator = translator;
    }

    public JSONObject write(PublicationTarget target, User user, UserPermissionBits permissionBits) throws JSONException {
        JSONObject object = new JSONObject();
        object.put(ID, (Object)target.getId());
        object.put(DISPLAY_NAME, (Object)target.getDisplayName());
        object.put(ICON, (Object)target.getIcon());
        object.put(MODULE, (Object)target.getModule());
        object.put(FORM_DESCRIPTION, (Object)this.writeFormDescription(this.getFormDescription(target, user, permissionBits)));
        return object;
    }

    private DynamicFormDescription getFormDescription(PublicationTarget target, User user, UserPermissionBits permissionBits) {
        if (UserSpecificPublicationTarget.class.isInstance(target)) {
            UserSpecificPublicationTarget userSpecific = (UserSpecificPublicationTarget)target;
            return userSpecific.getUserSpecificDescription(user, permissionBits);
        }
        return target.getFormDescription();
    }

    private JSONArray writeFormDescription(DynamicFormDescription form) throws JSONException {
        return new FormDescriptionWriter(this.translator).write(form);
    }

    public JSONArray writeArray(PublicationTarget target, String[] columns, User user, UserPermissionBits permissionBits) throws JSONException, OXException {
        JSONArray array = new JSONArray();
        for (String column : columns) {
            if (column.equals(ID)) {
                array.put((Object)target.getId());
                continue;
            }
            if (column.equals(DISPLAY_NAME)) {
                array.put((Object)this.translator.translate(target.getDisplayName()));
                continue;
            }
            if (column.equals(ICON)) {
                array.put((Object)target.getIcon());
                continue;
            }
            if (column.equals(MODULE)) {
                array.put((Object)target.getModule());
                continue;
            }
            if (column.equals(FORM_DESCRIPTION)) {
                array.put((Object)this.writeFormDescription(this.getFormDescription(target, user, permissionBits)));
                continue;
            }
            throw PublicationJSONErrorMessage.UNKNOWN_COLUMN.create(column);
        }
        return array;
    }

    public JSONArray writeJSONArray(Collection<PublicationTarget> targets, String[] columns, User user, UserPermissionBits permissionBits) throws JSONException, OXException {
        JSONArray array = new JSONArray();
        for (PublicationTarget publicationTarget : targets) {
            array.put((Object)this.writeArray(publicationTarget, columns, user, permissionBits));
        }
        return array;
    }
}

