/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.publish.json;

import com.openexchange.i18n.I18nService;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class I18n {
    private static final I18n SINGLETON = new I18n();
    private final Map<Locale, I18nService> services = new ConcurrentHashMap<Locale, I18nService>();
    private static final Locale DEFAULT_LOCALE = Locale.US;

    private I18n() {
    }

    public static final I18n getInstance() {
        return SINGLETON;
    }

    public void addI18nService(I18nService service) {
        Locale locale = service.getLocale();
        if (null == locale) {
            return;
        }
        this.services.put(locale, service);
    }

    public void removeI18nService(I18nService service) {
        Locale locale = service.getLocale();
        if (null == locale) {
            return;
        }
        this.services.remove(locale);
    }

    public I18nService get(Locale locale) {
        return this.services.get(I18n.getLocale(locale));
    }

    public String translate(Locale locale, String translateMe) {
        String retval = translateMe;
        I18nService service = this.services.get(I18n.getLocale(locale));
        if (null != service) {
            retval = service.getLocalized(translateMe);
        }
        return retval;
    }

    private static Locale getLocale(Locale locale) {
        return null == locale ? DEFAULT_LOCALE : locale;
    }
}

