/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.publish.json;

import com.openexchange.ajax.PermissionServlet;
import com.openexchange.ajax.container.Response;
import com.openexchange.exception.OXException;
import com.openexchange.osgi.ExceptionUtils;
import com.openexchange.publish.json.PublicationJSONErrorMessage;
import com.openexchange.session.Session;
import com.openexchange.tools.session.ServerSession;
import java.io.IOException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;

public abstract class AbstractPublicationServlet
extends PermissionServlet {
    private static final long serialVersionUID = 5880236559668102629L;

    protected AbstractPublicationServlet() {
    }

    protected boolean hasModulePermission(ServerSession session) {
        return session.getUserPermissionBits().isPublication();
    }

    protected void writeOXException(OXException x, HttpServletRequest req, HttpServletResponse resp) {
        x.log(this.getLog());
        Response response = new Response(AbstractPublicationServlet.getSessionObject((ServletRequest)req));
        response.setException(x);
        this.writeResponseSafely(response, resp, (Session)AbstractPublicationServlet.getSessionObject((ServletRequest)req));
    }

    protected void writeData(Object data, HttpServletResponse resp, Session session) {
        Response response = new Response();
        response.setData(data);
        this.writeResponseSafely(response, resp, session);
    }

    protected OXException wrapThrowable(Throwable t) {
        ExceptionUtils.handleThrowable((Throwable)t);
        return t instanceof OXException ? (OXException)t : PublicationJSONErrorMessage.THROWABLE.create(t, t.getMessage());
    }

    protected void writeResponseSafely(Response response, HttpServletResponse resp, Session session) {
        try {
            this.writeResponse(response, resp, session);
        }
        catch (IOException e) {
            this.getLog().error("", (Throwable)e);
        }
    }

    protected abstract Logger getLog();
}

