/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.meta.internal;

import com.openexchange.ajax.meta.MetaContributor;
import com.openexchange.ajax.meta.MetaContributorRegistry;
import com.openexchange.ajax.meta.internal.MetaContributorReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public final class MetaContributorTracker
extends ServiceTracker<MetaContributor, MetaContributorReference>
implements MetaContributorRegistry {
    private final List<MetaContributorReference> globalWildcard = new CopyOnWriteArrayList<MetaContributorReference>();
    private final ConcurrentMap<String, List<MetaContributorReference>> partialWildcard = new ConcurrentHashMap<String, List<MetaContributorReference>>();
    private final ConcurrentMap<String, List<MetaContributorReference>> topicName = new ConcurrentHashMap<String, List<MetaContributorReference>>();

    public MetaContributorTracker(BundleContext context) {
        super(context, MetaContributor.class, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetaContributorReference addingService(ServiceReference<MetaContributor> reference) {
        MetaContributorReference wrapper = new MetaContributorReference(reference, this.context);
        MetaContributorTracker metaContributorTracker = this;
        synchronized (metaContributorTracker) {
            if (wrapper.init()) {
                this.bucket(wrapper);
            }
        }
        return wrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifiedService(ServiceReference<MetaContributor> reference, MetaContributorReference service) {
        MetaContributorTracker metaContributorTracker = this;
        synchronized (metaContributorTracker) {
            this.unbucket(service);
            if (service.init()) {
                this.bucket(service);
                return;
            }
        }
        service.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removedService(ServiceReference<MetaContributor> reference, MetaContributorReference service) {
        MetaContributorTracker metaContributorTracker = this;
        synchronized (metaContributorTracker) {
            this.unbucket(service);
        }
        service.flush();
    }

    private void bucket(MetaContributorReference wrapper) {
        String[] topics = wrapper.getTopics();
        int length = topics == null ? 0 : topics.length;
        for (int i = 0; i < length; ++i) {
            String topic = topics[i];
            if (topic.equals("*")) {
                this.globalWildcard.add(wrapper);
                continue;
            }
            if (topic.endsWith("/*")) {
                String key = topic.substring(0, topic.length() - 2);
                ArrayList<MetaContributorReference> wrappers = (ArrayList<MetaContributorReference>)this.partialWildcard.get(key);
                if (wrappers == null) {
                    wrappers = new ArrayList<MetaContributorReference>();
                    this.partialWildcard.put(key, wrappers);
                }
                wrappers.add(wrapper);
                continue;
            }
            ArrayList<MetaContributorReference> wrappers = (ArrayList<MetaContributorReference>)this.topicName.get(topic);
            if (wrappers == null) {
                wrappers = new ArrayList<MetaContributorReference>();
                this.topicName.put(topic, wrappers);
            }
            wrappers.add(wrapper);
        }
    }

    private void unbucket(MetaContributorReference wrapper) {
        String[] topics = wrapper.getTopics();
        int length = topics == null ? 0 : topics.length;
        for (int i = 0; i < length; ++i) {
            String topic = topics[i];
            if (topic.equals("*")) {
                this.globalWildcard.remove(wrapper);
                continue;
            }
            if (topic.endsWith("/*")) {
                String key = topic.substring(0, topic.length() - 2);
                List wrappers = (List)this.partialWildcard.get(key);
                if (wrappers == null) continue;
                wrappers.remove(wrapper);
                if (!wrappers.isEmpty()) continue;
                this.partialWildcard.remove(key);
                continue;
            }
            List wrappers = (List)this.topicName.get(topic);
            if (wrappers == null) continue;
            wrappers.remove(wrapper);
            if (!wrappers.isEmpty()) continue;
            this.topicName.remove(topic);
        }
    }

    public Set<MetaContributor> getContributors(String topic) {
        List wrappers;
        HashSet<MetaContributor> handlers = new HashSet<MetaContributor>(6);
        handlers.addAll(this.globalWildcard);
        if (!this.partialWildcard.isEmpty()) {
            int index = topic.lastIndexOf(47);
            while (index >= 0) {
                String subTopic = topic.substring(0, index);
                List wrappers2 = (List)this.partialWildcard.get(subTopic);
                if (wrappers2 != null) {
                    handlers.addAll(wrappers2);
                }
                index = subTopic.lastIndexOf(47);
            }
        }
        if ((wrappers = (List)this.topicName.get(topic)) != null) {
            handlers.addAll(wrappers);
        }
        return handlers;
    }

    @Override
    public Set<MetaContributor> getMetaContributors(String topic) {
        return this.getContributors(topic);
    }
}

