/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.test.osgi;

import com.meterware.httpunit.PutMethodWebRequest;
import com.meterware.httpunit.WebConversation;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;
import com.openexchange.ajax.LoginTest;
import com.openexchange.ajax.writer.AppointmentWriter;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.java.Charsets;
import com.openexchange.test.osgi.AbstractBundleTest;
import com.openexchange.tools.URLParameter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.util.Date;
import java.util.TimeZone;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public final class BundleTestEventAdmin
extends AbstractBundleTest {
    private static final Logger LOG = LoggerFactory.getLogger(BundleTestEventAdmin.class);
    private static final String BUNDLE_ID = "org.eclipse.equinox.event";
    private static final String APPOINTMENT_URL = "/ajax/calendar";

    public BundleTestEventAdmin(String name) {
        super(name);
    }

    public void testEventAdminAbsence() {
        try {
            LoginTest loginTest = new LoginTest("LoginTest");
            JSONObject loginObject = BundleTestEventAdmin.login(this.getWebConversation(), loginTest.getHostName(), loginTest.getLogin(), loginTest.getPassword());
            BundleTestEventAdmin.assertTrue((String)"Error contained in returned JSON object", (!loginObject.has("error") || loginObject.isNull("error") ? 1 : 0) != 0);
            BundleTestEventAdmin.assertTrue((String)"Missing session ID", (loginObject.has("session") && !loginObject.isNull("session") ? 1 : 0) != 0);
            String sessionId = loginObject.getString("session");
            Appointment newApp = BundleTestEventAdmin.createAppointmentObject("TestAppointment", System.currentTimeMillis(), System.currentTimeMillis() + 3600L, BundleTestEventAdmin.getStandardCalendarFolder(this.getWebConversation(), loginTest.getHostName(), sessionId));
            JSONObject appointmentObject = BundleTestEventAdmin.insertAppointment(this.getWebConversation(), newApp, TimeZone.getTimeZone("UTC"), loginTest.getHostName(), sessionId);
            BundleTestEventAdmin.assertTrue((String)"No error contained in returned JSON object", (appointmentObject.has("error") && !appointmentObject.isNull("error") ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            BundleTestEventAdmin.fail((String)e.getMessage());
        }
    }

    private static JSONObject insertAppointment(WebConversation webCon, Appointment appointmentObj, TimeZone userTimeZone, String host, String session) throws JSONException, MalformedURLException, IOException, SAXException {
        JSONObject json;
        StringWriter stringWriter = new StringWriter();
        JSONObject jsonObj = new JSONObject();
        AppointmentWriter appointmentwriter = new AppointmentWriter(userTimeZone);
        appointmentwriter.writeAppointment(appointmentObj, jsonObj);
        stringWriter.write(jsonObj.toString());
        stringWriter.flush();
        URLParameter parameter = new URLParameter();
        parameter.setParameter("session", session);
        parameter.setParameter("action", "new");
        ByteArrayInputStream bais = new ByteArrayInputStream(stringWriter.toString().getBytes(Charsets.UTF_8));
        PutMethodWebRequest req = new PutMethodWebRequest("http://" + host + APPOINTMENT_URL + parameter.getURLParameters(), (InputStream)bais, "text/javascript");
        WebResponse resp = webCon.getResponse((WebRequest)req);
        BundleTestEventAdmin.assertEquals((String)"Response code is not okay.", (int)200, (int)resp.getResponseCode());
        String body = resp.getText();
        try {
            json = new JSONObject(body);
        }
        catch (JSONException e) {
            LOG.error("Can't parse this body to JSON: \"" + body + '\"');
            throw e;
        }
        return json;
    }

    private static Appointment createAppointmentObject(String title, long startTime, long endTime, int appointmentFolderId) {
        Appointment appointmentobject = new Appointment();
        appointmentobject.setTitle(title);
        appointmentobject.setStartDate(new Date(startTime));
        appointmentobject.setEndDate(new Date(endTime));
        appointmentobject.setLocation("Location");
        appointmentobject.setShownAs(3);
        appointmentobject.setParentFolderID(appointmentFolderId);
        return appointmentobject;
    }

    @Override
    protected String getBundleName() {
        return BUNDLE_ID;
    }
}

