/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.resource;

import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.Init;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.resource.Resource;
import com.openexchange.resource.ResourceService;
import com.openexchange.resource.storage.ResourceStorage;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.test.AjaxInit;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import junit.framework.TestCase;

public final class ResourceUpdateTest
extends TestCase {
    private Context ctx;
    private User user;
    private User admin;
    private static final String SQL_DELETE = "DELETE FROM resource WHERE cid = ? AND id = ?";

    public ResourceUpdateTest() {
    }

    public ResourceUpdateTest(String name) {
        super(name);
    }

    private static Context resolveContext(String ctxStr) throws Exception {
        try {
            int pos = -1;
            pos = ctxStr.indexOf(64);
            String c = pos > -1 ? ctxStr.substring(pos + 1) : ctxStr;
            return ContextStorage.getStorageContext((int)ContextStorage.getInstance().getContextId(c));
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    private static User resolveUser(String user, Context ctx) throws Exception {
        try {
            int pos = -1;
            pos = user.indexOf(64);
            String u = pos > -1 ? user.substring(0, pos) : user;
            return UserStorage.getInstance().getUser(UserStorage.getInstance().getUserId(u, ctx), ctx);
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    protected void setUp() throws Exception {
        try {
            Init.startServer();
            String login = AjaxInit.getAJAXProperty("login");
            this.ctx = ResourceUpdateTest.resolveContext(login);
            this.user = ResourceUpdateTest.resolveUser(login, this.ctx);
            this.admin = UserStorage.getInstance().getUser(this.ctx.getMailadmin(), this.ctx);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    protected void tearDown() throws Exception {
        Init.stopServer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testResourceUpdate() throws OXException, OXException {
        int id = -1;
        try {
            Resource resource = ResourceUpdateTest.createDummyResource(this.admin, this.ctx);
            id = resource.getIdentifier();
            ResourceUpdateTest.assertTrue((String)("Invalid ID detected: " + id + ". ID has not been properly set through creation"), (id != -1 ? 1 : 0) != 0);
            ResourceUpdateTest.assertTrue((String)("Invalid last-modified detected: " + resource.getLastModified() + ". Last-modified timestamp has not been properly set through creation"), (resource.getLastModified() != null && resource.getLastModified().getTime() < System.currentTimeMillis() ? 1 : 0) != 0);
            long beforeLastModified = resource.getLastModified().getTime();
            resource.setSimpleName("Foobar-12334");
            resource.setDisplayName("The Foobar Display Name");
            resource.setAvailable(false);
            ((ResourceService)ServerServiceRegistry.getInstance().getService(ResourceService.class)).update(this.admin, this.ctx, resource, resource.getLastModified());
            Resource storageVersion = ResourceStorage.getInstance().getResource(id, this.ctx);
            ResourceUpdateTest.assertTrue((String)"Invalid last-modified timestamp", (resource.getLastModified().getTime() > beforeLastModified && resource.getLastModified().getTime() == storageVersion.getLastModified().getTime() ? 1 : 0) != 0);
            ResourceUpdateTest.assertTrue((String)"Simple name has not been properly updated", (boolean)resource.getSimpleName().equals(storageVersion.getSimpleName()));
            ResourceUpdateTest.assertTrue((String)"Display name has not been properly updated", (boolean)resource.getDisplayName().equals(storageVersion.getDisplayName()));
            ResourceUpdateTest.assertTrue((String)"Availability has not been properly updated", (resource.isAvailable() == storageVersion.isAvailable() ? 1 : 0) != 0);
            resource.setDisplayName("The Foobar Display Name qwertz");
            resource.setMail("foobar@somewhere.org");
            resource.setAvailable(true);
            ((ResourceService)ServerServiceRegistry.getInstance().getService(ResourceService.class)).update(this.admin, this.ctx, resource, storageVersion.getLastModified());
            storageVersion = ResourceStorage.getInstance().getResource(id, this.ctx);
            ResourceUpdateTest.assertTrue((String)"Invalid last-modified timestamp", (resource.getLastModified().getTime() > beforeLastModified && resource.getLastModified().getTime() == storageVersion.getLastModified().getTime() ? 1 : 0) != 0);
            ResourceUpdateTest.assertTrue((String)"Simple name has not been properly updated", (boolean)resource.getSimpleName().equals(storageVersion.getSimpleName()));
            ResourceUpdateTest.assertTrue((String)"Display name has not been properly updated", (boolean)resource.getDisplayName().equals(storageVersion.getDisplayName()));
            ResourceUpdateTest.assertTrue((String)"Availability has not been properly updated", (resource.isAvailable() == storageVersion.isAvailable() ? 1 : 0) != 0);
        }
        finally {
            ResourceUpdateTest.deleteResource(id, this.ctx.getContextId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testResourceUpdateIncomplete() throws OXException, OXException {
        int id = -1;
        try {
            Resource resource = ResourceUpdateTest.createDummyResource(this.admin, this.ctx);
            id = resource.getIdentifier();
            ResourceUpdateTest.assertTrue((String)("Invalid ID detected: " + id + ". ID has not been properly set through creation"), (id != -1 ? 1 : 0) != 0);
            ResourceUpdateTest.assertTrue((String)("Invalid last-modified detected: " + resource.getLastModified() + ". Last-modified timestamp has not been properly set through creation"), (resource.getLastModified() != null && resource.getLastModified().getTime() < System.currentTimeMillis() ? 1 : 0) != 0);
            long beforeLastModified = resource.getLastModified().getTime();
            String displayNameBefore = resource.getDisplayName();
            String mailBefore = resource.getMail();
            resource.setSimpleName("Foobar-12334");
            resource.removeDisplayName();
            resource.removeMail();
            resource.removeAvailable();
            resource.removeDescription();
            ((ResourceService)ServerServiceRegistry.getInstance().getService(ResourceService.class)).update(this.admin, this.ctx, resource, resource.getLastModified());
            Resource storageVersion = ResourceStorage.getInstance().getResource(id, this.ctx);
            ResourceUpdateTest.assertTrue((String)"Invalid last-modified timestamp", (resource.getLastModified().getTime() > beforeLastModified && resource.getLastModified().getTime() == storageVersion.getLastModified().getTime() ? 1 : 0) != 0);
            ResourceUpdateTest.assertTrue((String)"Simple name has not been properly updated", (boolean)resource.getSimpleName().equals(storageVersion.getSimpleName()));
            ResourceUpdateTest.assertTrue((String)"Display name has been updated, but shouldn't", (boolean)storageVersion.getDisplayName().equals(displayNameBefore));
            ResourceUpdateTest.assertTrue((String)"Email address has been updated, but shouldn't", (boolean)storageVersion.getMail().equals(mailBefore));
        }
        finally {
            ResourceUpdateTest.deleteResource(id, this.ctx.getContextId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testResourceFail001() {
        int id = -1;
        try {
            Resource resource = ResourceUpdateTest.createDummyResource(this.admin, this.ctx);
            id = resource.getIdentifier();
            resource.setSimpleName("\u00f6\u00e4\u00fc\u00df");
            ((ResourceService)ServerServiceRegistry.getInstance().getService(ResourceService.class)).update(this.admin, this.ctx, resource, resource.getLastModified());
            ResourceUpdateTest.fail((String)"Update succeeded with invalid string identifier");
        }
        catch (OXException oXException) {
        }
        finally {
            ResourceUpdateTest.deleteResource(id, this.ctx.getContextId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testResourceFail002() {
        int id = -1;
        try {
            Resource resource = ResourceUpdateTest.createDummyResource(this.admin, this.ctx);
            id = resource.getIdentifier();
            resource.setMail("mytestresourcesomewhere.com");
            ((ResourceService)ServerServiceRegistry.getInstance().getService(ResourceService.class)).update(this.admin, this.ctx, resource, resource.getLastModified());
            ResourceUpdateTest.fail((String)"Update succeeded with invalid email address");
        }
        catch (OXException oXException) {
        }
        finally {
            ResourceUpdateTest.deleteResource(id, this.ctx.getContextId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testResourceFail007() {
        int id = -1;
        try {
            Resource resource = ResourceUpdateTest.createDummyResource(this.admin, this.ctx);
            id = resource.getIdentifier();
            resource.setSimpleName(null);
            ((ResourceService)ServerServiceRegistry.getInstance().getService(ResourceService.class)).update(this.admin, this.ctx, resource, resource.getLastModified());
            ResourceUpdateTest.fail((String)"Update succeeded with missing mandatory field");
        }
        catch (OXException oXException) {
        }
        finally {
            ResourceUpdateTest.deleteResource(id, this.ctx.getContextId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testResourceFail008() {
        int id = -1;
        try {
            Resource resource = ResourceUpdateTest.createDummyResource(this.admin, this.ctx);
            id = resource.getIdentifier();
            resource.setSimpleName(null);
            ((ResourceService)ServerServiceRegistry.getInstance().getService(ResourceService.class)).update(this.admin, this.ctx, resource, resource.getLastModified());
            ResourceUpdateTest.fail((String)"Update succeeded with invalid string identifier");
        }
        catch (OXException oXException) {
        }
        finally {
            ResourceUpdateTest.deleteResource(id, this.ctx.getContextId());
        }
    }

    private static final Resource createDummyResource(User admin, Context ctx) throws OXException {
        Resource resource = new Resource();
        resource.setAvailable(true);
        resource.setDescription("My test resource");
        resource.setDisplayName("MyTestResource");
        resource.setMail("mytestresource@somewhere.com");
        resource.setSimpleName("M-T-R");
        ((ResourceService)ServerServiceRegistry.getInstance().getService(ResourceService.class)).create(admin, ctx, resource);
        return resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void deleteResource(int id, int cid) {
        Connection writeCon;
        if (-1 == id) {
            return;
        }
        try {
            writeCon = Database.get((int)cid, (boolean)true);
        }
        catch (OXException e) {
            e.printStackTrace();
            return;
        }
        PreparedStatement stmt = null;
        try {
            stmt = writeCon.prepareStatement(SQL_DELETE);
            stmt.setInt(1, cid);
            stmt.setInt(2, id);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            if (null != stmt) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {}
                stmt = null;
            }
            Database.back((int)cid, (boolean)true, (Connection)writeCon);
        }
    }
}

