/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.i18n;

import com.openexchange.groupware.Init;
import com.openexchange.i18n.I18nService;
import com.openexchange.server.services.I18nServices;
import com.openexchange.test.I18nTests;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.Assert;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class Bug14154Test {
    private static final Pattern pattern = Pattern.compile("(#.*?#)");
    private final Locale locale;

    public Bug14154Test(Locale locale) {
        this.locale = locale;
    }

    @BeforeClass
    public static void setUp() throws Exception {
        Init.injectProperty();
        Init.startAndInjectConfigBundle();
        Init.startAndInjectI18NBundle();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        Init.dropI18NBundle();
        Init.dropConfigBundle();
        Init.dropProperty();
    }

    @Test
    public void testContainingPattern() {
        I18nService i18nService = I18nServices.getInstance().getService(this.locale);
        Assert.assertNotNull((String)("Can't get i18n service for " + this.locale.toString()), (Object)i18nService);
        String translation = i18nService.getLocalized("---------- Original Message ----------\nFrom: #FROM#\nTo: #TO##CC_LINE#\nDate: #DATE# at #TIME#\nSubject: #SUBJECT#");
        Assert.assertNotNull((String)"Mail forwarding template is not translated.", (Object)translation);
        Matcher matcher = pattern.matcher("---------- Original Message ----------\nFrom: #FROM#\nTo: #TO##CC_LINE#\nDate: #DATE# at #TIME#\nSubject: #SUBJECT#");
        while (matcher.find()) {
            String replacer = matcher.group();
            Assert.assertTrue((String)("Translation does not contain the pattern " + replacer + "."), (translation.indexOf(replacer) >= 0 ? 1 : 0) != 0);
        }
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        ArrayList<Object[]> retval = new ArrayList<Object[]>();
        for (Locale locale : I18nTests.LOCALES) {
            retval.add(new Object[]{locale});
        }
        return retval;
    }
}

