/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.infostore;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.impl.IDGenerator;
import com.openexchange.groupware.infostore.AbstractInfostoreTest;
import com.openexchange.groupware.infostore.DocumentMetadata;
import com.openexchange.groupware.infostore.database.impl.AbstractDocumentListAction;
import com.openexchange.groupware.infostore.database.impl.DocumentMetadataImpl;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public class AbstractDocumentListActionTest
extends AbstractInfostoreTest {
    protected int existingId = 0;
    protected int notExistingId = 0;
    private final List<DocumentMetadata> clean = new LinkedList<DocumentMetadata>();

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.createDocument();
    }

    public void testExists() throws OXException {
        TestDocumentListAction action = this.getActionWithDocumentId(this.existingId);
        action.perform();
    }

    public void testDoesNotExist() {
        TestDocumentListAction action = this.getActionWithDocumentId(this.notExistingId);
        try {
            action.perform();
            AbstractDocumentListActionTest.fail((String)"Should have aborted with document ids that don't exist");
        }
        catch (OXException x) {
            AbstractDocumentListActionTest.assertTrue((String)"Message does not indicate non existence", (boolean)x.getMessage().contains("not exist"));
        }
    }

    private TestDocumentListAction getActionWithDocumentId(int documentID) {
        DocumentMetadataImpl document = new DocumentMetadataImpl();
        document.setId(documentID);
        TestDocumentListAction action = new TestDocumentListAction();
        action.setProvider(this.getProvider());
        action.setContext(this.getCtx());
        action.setDocuments(Arrays.asList(document));
        return action;
    }

    protected void createDocument() throws OXException, SQLException {
        DocumentMetadataImpl document = new DocumentMetadataImpl();
        document.setTitle(this.getName());
        document.setFolderId((long)this.getFolderId());
        this.getInfostore().saveDocumentMetadata((DocumentMetadata)document, -1L, this.getSession());
        this.clean.add((DocumentMetadata)document);
        this.existingId = document.getId();
        this.notExistingId = IDGenerator.getId((Context)this.getCtx(), (int)137);
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
    }

    static final class TestDocumentListAction
    extends AbstractDocumentListAction {
        TestDocumentListAction() {
        }

        public void perform() throws OXException {
            this.assureExistence();
        }

        protected Object[] getAdditionals(DocumentMetadata doc) {
            return null;
        }

        protected void undoAction() {
        }
    }
}

