/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware;

import com.openexchange.api2.AppointmentSQLInterface;
import com.openexchange.calendar.CalendarOperation;
import com.openexchange.calendar.CalendarSql;
import com.openexchange.calendar.CalendarSqlImp;
import com.openexchange.calendar.api.CalendarCollection;
import com.openexchange.event.impl.EventConfigImpl;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.Init;
import com.openexchange.groupware.calendar.CalendarDataObject;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.configuration.AbstractConfigWrapper;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.ExternalUserParticipant;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.container.GroupParticipant;
import com.openexchange.groupware.container.Participant;
import com.openexchange.groupware.container.Participants;
import com.openexchange.groupware.container.ResourceParticipant;
import com.openexchange.groupware.container.UserParticipant;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextImpl;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.groupware.reminder.ReminderHandler;
import com.openexchange.groupware.reminder.ReminderObject;
import com.openexchange.groupware.search.AppointmentSearchObject;
import com.openexchange.groupware.search.Order;
import com.openexchange.groupware.userconfiguration.UserConfigurationStorage;
import com.openexchange.server.impl.DBPool;
import com.openexchange.server.impl.EffectivePermission;
import com.openexchange.server.impl.OCLPermission;
import com.openexchange.session.Session;
import com.openexchange.sessiond.impl.SessionObject;
import com.openexchange.sessiond.impl.SessionObjectWrapper;
import com.openexchange.setuptools.TestConfig;
import com.openexchange.setuptools.TestContextToolkit;
import com.openexchange.test.AjaxInit;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.oxfolder.OXFolderAccess;
import com.openexchange.tools.oxfolder.OXFolderManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.Date;
import java.util.Properties;
import java.util.TimeZone;
import junit.framework.TestCase;

public class CalendarTest
extends TestCase {
    private static final int TEST_PASS = 1;
    private static final int TEST_PASS_HOT_SPOT = 1;
    private static int userid = 11;
    public static int contextid = 1;
    private static boolean init = false;
    private static boolean do_not_delete = false;
    static int[] cols = new int[]{201, 202, 200, 206, 207, 1, 20, 221, 401};

    protected static Date decrementDate(Date d) {
        return new Date(d.getTime() - 1L);
    }

    protected void setUp() throws Exception {
        super.setUp();
        Init.startServer();
        init = true;
        EventConfigImpl event = new EventConfigImpl();
        event.setEventQueueEnabled(false);
        TestConfig config = new TestConfig();
        String userName = config.getUser();
        TestContextToolkit tools = new TestContextToolkit();
        String ctxName = config.getContextName();
        Context ctx = null == ctxName || ctxName.trim().length() == 0 ? tools.getDefaultContext() : tools.getContextByName(ctxName);
        int user = tools.resolveUser(userName, ctx);
        contextid = ctx.getContextId();
        userid = user;
        ContextStorage.start();
    }

    protected void tearDown() throws Exception {
        if (init) {
            init = false;
            Init.stopServer();
        }
        super.tearDown();
    }

    private static Properties getAJAXProperties() {
        Properties properties = AjaxInit.getAJAXProperties();
        return properties;
    }

    private static int resolveUser(String user) throws Exception {
        UserStorage uStorage = UserStorage.getInstance();
        return uStorage.getUserId(user, CalendarTest.getContext());
    }

    public static void dontDelete() {
        do_not_delete = true;
    }

    public static void doDelete() {
        do_not_delete = false;
    }

    public static int getUserId() throws Exception {
        if (!init) {
            Init.startServer();
            init = true;
        }
        String user = AbstractConfigWrapper.parseProperty((Properties)CalendarTest.getAJAXProperties(), (String)"user_participant2", (String)"");
        return CalendarTest.resolveUser(user);
    }

    public static Context getContext() {
        return new ContextImpl(contextid);
    }

    public static SessionObject getSession() throws Exception {
        return SessionObjectWrapper.createSessionObject((int)userid, (int)CalendarTest.getContext().getContextId(), (String)String.valueOf(System.currentTimeMillis()));
    }

    public static final void fillDatesInDao(CalendarDataObject cdao) {
        long start = System.currentTimeMillis();
        long mod = start % 3600000L;
        long end = (start -= mod) + 3600000L;
        long until = start + 864000000L;
        mod = until % 86400000L;
        until -= mod;
        cdao.setStartDate(new Date(start));
        cdao.setEndDate(new Date(end));
    }

    public static int getPrivateFolder() throws Exception {
        int privatefolder = 0;
        Context context = CalendarTest.getContext();
        Connection readcon = DBPool.pickup((Context)context);
        privatefolder = CalendarTest.getCalendarDefaultFolderForUser(userid, context);
        DBPool.push((Context)context, (Connection)readcon);
        return privatefolder;
    }

    public static int getCalendarDefaultFolderForUser(int userid, Context context) throws OXException {
        OXFolderAccess access = new OXFolderAccess(context);
        FolderObject fo = access.getDefaultFolder(userid, 2);
        return fo.getObjectID();
    }

    public static void testDelete(Appointment cdao) throws Exception {
        Connection writecon = DBPool.pickupWriteable((Context)CalendarTest.getContext());
        ContextImpl context = new ContextImpl(contextid);
        SessionObject so = SessionObjectWrapper.createSessionObject((int)userid, (int)context.getContextId(), (String)"delete test");
        CalendarSql csql = new CalendarSql((Session)so);
        CalendarDataObject deleteit = new CalendarDataObject();
        deleteit.setContext(CalendarTest.getContext());
        deleteit.setObjectID(cdao.getObjectID());
        int fid = cdao.getParentFolderID();
        try {
            csql.deleteAppointmentObject(deleteit, fid, new Date(Long.MAX_VALUE));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        DBPool.pushWrite((Context)context, (Connection)writecon);
    }

    void deleteAllAppointments() throws Exception {
        if (do_not_delete) {
            return;
        }
        Connection readcon = DBPool.pickup((Context)CalendarTest.getContext());
        ContextImpl context = new ContextImpl(contextid);
        SessionObject so = SessionObjectWrapper.createSessionObject((int)userid, (int)context.getContextId(), (String)"deleteAllApps");
        CalendarSql csql = new CalendarSql((Session)so);
        SearchIterator si = csql.getAppointmentsBetween(userid, new Date(0L), new Date(253402210800000L), cols, 0, null);
        while (si.hasNext()) {
            Appointment cdao = (Appointment)si.next();
            CalendarTest.testDelete(cdao);
        }
        si.close();
        DBPool.push((Context)context, (Connection)readcon);
    }

    public void testWholeDay() throws Throwable {
        long s = 1149768000000L;
        long e = 1149771600000L;
        CalendarDataObject cdao = new CalendarDataObject();
        cdao.setContext((Context)new ContextImpl(contextid));
        cdao.setObjectID(1);
        cdao.setStartDate(new Date(1149768000000L));
        cdao.setEndDate(new Date(1149771600000L));
        cdao.setFullTime(true);
        cdao.setTitle("Simple Whole Day Test");
        CalendarOperation co = new CalendarOperation();
        Connection readcon = null;
        ContextStorage cs = ContextStorage.getInstance();
        Context context = cs.getContext(cs.getContextId("defaultcontext"));
        readcon = DBPool.pickup((Context)context);
        int privatefolder = CalendarTest.getCalendarDefaultFolderForUser(userid, context);
        CalendarTest.assertFalse((String)"Checking for update", (boolean)co.prepareUpdateAction(cdao, cdao, userid, privatefolder, "Europe/Berlin"));
        long realstart = 1149724800000L;
        CalendarTest.assertEquals((String)"Testing start time", (long)cdao.getStartDate().getTime(), (long)1149724800000L);
        CalendarTest.assertEquals((String)"Testing end time", (long)cdao.getEndDate().getTime(), (long)1149811200000L);
        DBPool.push((Context)context, (Connection)readcon);
    }

    public void testWholeDayWithDB() throws Throwable {
        ContextImpl context = new ContextImpl(contextid);
        int fid = CalendarTest.getCalendarDefaultFolderForUser(userid, (Context)context);
        CalendarDataObject cdao = new CalendarDataObject();
        cdao.setTitle("testWholeDayWithDB - Step 1 - Insert");
        cdao.setParentFolderID(fid);
        SessionObject so = SessionObjectWrapper.createSessionObject((int)userid, (int)context.getContextId(), (String)"myTestIdentifier");
        cdao.setContext(ContextStorage.getInstance().getContext(so.getContextId()));
        cdao.setIgnoreConflicts(true);
        cdao.setFullTime(true);
        cdao.setGlobalFolderID(fid);
        CalendarTest.fillDatesInDao(cdao);
        CalendarSql csql = new CalendarSql((Session)so);
        csql.insertAppointmentObject(cdao);
        int object_id = cdao.getObjectID();
        csql.getObjectById(object_id, fid);
        long check_start = cdao.getStartDate().getTime();
        long check_end = cdao.getEndDate().getTime();
        CalendarDataObject update = new CalendarDataObject();
        update.setContext(ContextStorage.getInstance().getContext(so.getContextId()));
        update.setObjectID(object_id);
        update.setTitle("testWholeDayWithDB - Step 1 - Update");
        csql.updateAppointmentObject(update, fid, new Date());
        CalendarDataObject testobject_update = csql.getObjectById(object_id, fid);
        CalendarTest.assertTrue((String)"Contains fulltime ", (boolean)testobject_update.getFullTime());
        CalendarTest.assertEquals((String)"Check start time ", (long)check_start, (long)testobject_update.getStartDate().getTime());
        CalendarTest.assertEquals((String)"Check end time ", (long)check_end, (long)testobject_update.getEndDate().getTime());
    }

    public void testMultiSpanWholeDay() throws Throwable {
        int wanted_length = 3;
        ContextImpl context = new ContextImpl(contextid);
        int fid = CalendarTest.getCalendarDefaultFolderForUser(userid, (Context)context);
        CalendarDataObject cdao = new CalendarDataObject();
        cdao.setTitle("testMultiSpanWholeDay - Step 1 - Insert");
        cdao.setParentFolderID(fid);
        SessionObject so = SessionObjectWrapper.createSessionObject((int)userid, (int)context.getContextId(), (String)"myTestIdentifier");
        cdao.setContext(ContextStorage.getInstance().getContext(so.getContextId()));
        cdao.setIgnoreConflicts(true);
        cdao.setFullTime(true);
        cdao.setGlobalFolderID(fid);
        CalendarTest.fillDatesInDao(cdao);
        cdao.removeUntil();
        long start_date_long = new CalendarCollection().normalizeLong(cdao.getStartDate().getTime());
        long end_date_long = start_date_long + 259200000L;
        Date start_date = new Date(start_date_long);
        Date end_date = new Date(end_date_long);
        cdao.setStartDate(start_date);
        cdao.setEndDate(end_date);
        CalendarSql csql = new CalendarSql((Session)so);
        csql.insertAppointmentObject(cdao);
        int object_id = cdao.getObjectID();
        csql.getObjectById(object_id, fid);
        long check_start = cdao.getStartDate().getTime();
        long check_end = cdao.getEndDate().getTime();
        int test_length = (int)((check_end - check_start) / 1000L / 60L / 60L / 24L);
        CalendarTest.assertEquals((String)"Check app length ", (int)3, (int)test_length);
    }

    public void testfillUserParticipantsWithoutGroups() throws Exception {
        CalendarDataObject cdao = new CalendarDataObject();
        cdao.setContext(CalendarTest.getContext());
        Participants participants = new Participants();
        UserParticipant p = new UserParticipant(userid);
        participants.add((Participant)p);
        String user2 = AbstractConfigWrapper.parseProperty((Properties)CalendarTest.getAJAXProperties(), (String)"user_participant3", (String)"");
        int uid2 = CalendarTest.resolveUser(user2);
        UserParticipant p2 = new UserParticipant(uid2);
        participants.add((Participant)p2);
        cdao.setParticipants(participants.getList());
        CalendarOperation.fillUserParticipants((CalendarDataObject)cdao);
        CalendarTest.assertEquals((String)"Check participant size", (int)cdao.getParticipants().length, (int)cdao.getUsers().length);
    }

    public void cisco_testFreeBusy() throws Exception {
        Connection readcon = DBPool.pickup((Context)CalendarTest.getContext());
        CalendarSqlImp calmysql = CalendarSql.getCalendarSqlImplementation();
        PreparedStatement prep = calmysql.getFreeBusy(userid, CalendarTest.getContext(), new Date(0L), new Date(253402210800000L), readcon);
        calmysql.getResultSet(prep);
    }

    public void testInsertAndLabel() throws Throwable {
        ContextImpl context = new ContextImpl(contextid);
        int fid = CalendarTest.getCalendarDefaultFolderForUser(userid, (Context)context);
        CalendarDataObject cdao = new CalendarDataObject();
        cdao.setTitle("testInsertAndLabel - Step 1 - Insert");
        cdao.setParentFolderID(fid);
        SessionObject so = SessionObjectWrapper.createSessionObject((int)userid, (int)context.getContextId(), (String)"myTestIdentifier");
        cdao.setContext(ContextStorage.getInstance().getContext(so.getContextId()));
        cdao.setIgnoreConflicts(true);
        CalendarTest.fillDatesInDao(cdao);
        CalendarSql csql = new CalendarSql((Session)so);
        csql.insertAppointmentObject(cdao);
        int object_id = cdao.getObjectID();
        CalendarDataObject update = new CalendarDataObject();
        update.setContext(ContextStorage.getInstance().getContext(so.getContextId()));
        update.setObjectID(object_id);
        update.setIgnoreConflicts(true);
        cdao.setTitle("testInsertAndLabel - Step 2 - Update (only Label)");
        update.setLabel(3);
        csql.updateAppointmentObject(update, fid, new Date());
        CalendarDataObject testobject = csql.getObjectById(object_id, fid);
        CalendarTest.assertEquals((String)"Check label", (int)3, (int)testobject.getLabel());
    }

    public void testNoAlarm() throws Throwable {
        ContextImpl context = new ContextImpl(contextid);
        int fid = CalendarTest.getCalendarDefaultFolderForUser(userid, (Context)context);
        CalendarDataObject cdao = new CalendarDataObject();
        cdao.setTitle("testNoAlarm - Step 1 - Insert");
        cdao.setParentFolderID(fid);
        SessionObject so = SessionObjectWrapper.createSessionObject((int)userid, (int)context.getContextId(), (String)"myTestIdentifier");
        cdao.setContext(ContextStorage.getInstance().getContext(so.getContextId()));
        cdao.setIgnoreConflicts(true);
        CalendarTest.fillDatesInDao(cdao);
        CalendarSql csql = new CalendarSql((Session)so);
        csql.insertAppointmentObject(cdao);
        int object_id = cdao.getObjectID();
        CalendarDataObject testobject = csql.getObjectById(object_id, fid);
        CalendarTest.assertTrue((String)"Alarm should not be set", (!testobject.containsAlarm() ? 1 : 0) != 0);
        CalendarDataObject update = new CalendarDataObject();
        update.setContext(ContextStorage.getInstance().getContext(so.getContextId()));
        update.setObjectID(object_id);
        update.setTitle("testNoAlarm - Step 2 - Update");
        csql.updateAppointmentObject(update, fid, cdao.getLastModified());
        CalendarDataObject testobject2 = csql.getObjectById(object_id, fid);
        CalendarTest.assertTrue((String)"Alarm should not be set", (!testobject2.containsAlarm() ? 1 : 0) != 0);
        CalendarDataObject update2 = testobject2.clone();
        update2.setContext(ContextStorage.getInstance().getContext(so.getContextId()));
        update2.setObjectID(object_id);
        update2.setTitle("testNoAlarm - Step 3 - Update 2");
        csql.updateAppointmentObject(update2, fid, update.getLastModified());
        CalendarDataObject testobject3 = csql.getObjectById(object_id, fid);
        CalendarTest.assertTrue((String)"Alarm should not be set", (!testobject3.containsAlarm() ? 1 : 0) != 0);
    }

    public void testInsertAndAlarm() throws Throwable {
        ContextImpl context = new ContextImpl(contextid);
        int fid = CalendarTest.getCalendarDefaultFolderForUser(userid, (Context)context);
        CalendarDataObject cdao = new CalendarDataObject();
        cdao.setTitle("testInsertAndAlarm - Step 1 - Insert");
        cdao.setParentFolderID(fid);
        SessionObject so = SessionObjectWrapper.createSessionObject((int)userid, (int)context.getContextId(), (String)"myTestIdentifier");
        cdao.setContext(ContextStorage.getInstance().getContext(so.getContextId()));
        cdao.setIgnoreConflicts(true);
        UserParticipant up = new UserParticipant(userid);
        up.setAlarmMinutes(5);
        cdao.setUsers(new UserParticipant[]{up});
        Participants participants = new Participants();
        UserParticipant p = new UserParticipant(userid);
        participants.add((Participant)p);
        String user2 = AbstractConfigWrapper.parseProperty((Properties)CalendarTest.getAJAXProperties(), (String)"user_participant3", (String)"");
        UserParticipant p2 = new UserParticipant(CalendarTest.resolveUser(user2));
        participants.add((Participant)p2);
        cdao.setParticipants(participants.getList());
        CalendarTest.fillDatesInDao(cdao);
        CalendarSql csql = new CalendarSql((Session)so);
        csql.insertAppointmentObject(cdao);
        int object_id = cdao.getObjectID();
        CalendarDataObject testobject = csql.getObjectById(object_id, fid);
        CalendarTest.assertEquals((String)"Check Alarm", (int)5, (int)testobject.getAlarm());
        CalendarDataObject cdao2 = new CalendarDataObject();
        cdao2.setTitle("testInsertAndAlarm(2) - Step 1 - Insert");
        cdao2.setParentFolderID(fid);
        cdao2.setContext(ContextStorage.getInstance().getContext(so.getContextId()));
        cdao2.setIgnoreConflicts(true);
        cdao2.setAlarm(5);
        CalendarTest.fillDatesInDao(cdao2);
        cdao2.setParticipants(participants.getList());
        csql.insertAppointmentObject(cdao2);
        object_id = cdao2.getObjectID();
        CalendarDataObject testobject2 = csql.getObjectById(object_id, fid);
        CalendarTest.assertEquals((String)"Check Alarm", (int)5, (int)testobject2.getAlarm());
        csql.deleteAppointmentObject(testobject2, fid, new Date());
        ReminderHandler rsql = new ReminderHandler((Context)context);
        CalendarTest.assertTrue((String)"Check if reminder has been deleted", (!rsql.existsReminder(object_id, userid, 1) ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBasicSearch() throws Exception {
        ContextImpl context = new ContextImpl(contextid);
        SessionObject so = SessionObjectWrapper.createSessionObject((int)userid, (int)CalendarTest.getContext().getContextId(), (String)"myTestSearch");
        Connection readcon = DBPool.pickup((Context)context);
        Connection writecon = DBPool.pickupWriteable((Context)context);
        int folder_id = CalendarTest.getPrivateFolder();
        CalendarSql csql = new CalendarSql((Session)so);
        OXFolderManager oxma = OXFolderManager.getInstance((Session)so, (AppointmentSQLInterface)csql, (Connection)readcon, (Connection)writecon);
        OCLPermission oclp = new OCLPermission();
        oclp.setEntity(userid);
        oclp.setAllPermission(128, 128, 128, 128);
        oclp.setFolderAdmin(true);
        FolderObject fo = new FolderObject();
        fo.setFolderName("MyTestFolder" + System.currentTimeMillis());
        fo.setParentFolderID(2);
        fo.setModule(2);
        fo.setType(2);
        fo.setPermissionsAsArray(new OCLPermission[]{oclp});
        int public_folder_id = 0;
        try {
            fo = oxma.createFolder(fo, true, System.currentTimeMillis());
            public_folder_id = fo.getObjectID();
            AppointmentSearchObject searchObj = new AppointmentSearchObject();
            searchObj.setPattern("test");
            searchObj.addFolder(folder_id);
            SearchIterator si = csql.searchAppointments(searchObj, 0, Order.ASCENDING, cols);
            boolean gotresults = si.hasNext();
            CalendarTest.assertTrue((String)"Got real results by searching \"test\"", (boolean)gotresults);
            while (si.hasNext()) {
                CalendarDataObject tcdao = (CalendarDataObject)si.next();
                CalendarTest.assertTrue((String)"Found only results with something like *test*", (tcdao.getTitle().toLowerCase().indexOf("test") != -1 ? 1 : 0) != 0);
                CalendarTest.assertTrue((String)"Got real folder id ", (tcdao.getParentFolderID() == folder_id ? 1 : 0) != 0);
            }
            si.close();
            CalendarDataObject cdao = new CalendarDataObject();
            cdao.setContext((Context)context);
            cdao.setTitle("test Public Folder Search - Step 1 - Insert");
            cdao.setParentFolderID(public_folder_id);
            cdao.setIgnoreConflicts(true);
            CalendarTest.fillDatesInDao(cdao);
            cdao.setIgnoreConflicts(true);
            csql.insertAppointmentObject(cdao);
            int test_folder_id = cdao.getEffectiveFolderId();
            cdao.getObjectID();
            CalendarTest.assertEquals((String)"Test correct folder id", (int)public_folder_id, (int)test_folder_id);
            searchObj = new AppointmentSearchObject();
            searchObj.setPattern("*");
            searchObj.addFolder(public_folder_id);
            si = csql.searchAppointments(searchObj, 0, Order.ASCENDING, cols);
            gotresults = si.hasNext();
            CalendarTest.assertTrue((String)"Got real results by searching \"*\"", (boolean)gotresults);
            while (si.hasNext()) {
                CalendarDataObject tcdao = (CalendarDataObject)si.next();
                CalendarTest.assertTrue((String)"Got real folder id ", (tcdao.getParentFolderID() == public_folder_id ? 1 : 0) != 0);
            }
            si.close();
            searchObj.setPattern("*.*");
            si = csql.searchAppointments(searchObj, 0, Order.ASCENDING, cols);
            gotresults = si.hasNext();
            CalendarTest.assertTrue((String)"Got some results by searching \"*e*\"", (!gotresults ? 1 : 0) != 0);
            si.close();
        }
        finally {
            oxma.deleteFolder(new FolderObject(public_folder_id), true, System.currentTimeMillis());
        }
        try {
            DBPool.push((Context)context, (Connection)readcon);
            DBPool.pushWrite((Context)context, (Connection)writecon);
        }
        catch (Exception ignore) {
            ignore.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInsertMoveAndDeleteAppointments() throws Throwable {
        ContextImpl context = new ContextImpl(contextid);
        CalendarDataObject cdao = new CalendarDataObject();
        cdao.setTitle("testInsertMoveAndDeleteAppointments - Step 1 - Insert");
        cdao.setParentFolderID(CalendarTest.getCalendarDefaultFolderForUser(userid, (Context)context));
        SessionObject so = SessionObjectWrapper.createSessionObject((int)userid, (int)context.getContextId(), (String)"myTestIdentifier");
        cdao.setContext(ContextStorage.getInstance().getContext(so.getContextId()));
        CalendarTest.fillDatesInDao(cdao);
        cdao.setIgnoreConflicts(true);
        CalendarSql csql = new CalendarSql((Session)so);
        csql.insertAppointmentObject(cdao);
        int private_folder_id = cdao.getEffectiveFolderId();
        int object_id = cdao.getObjectID();
        Connection readcon = DBPool.pickup((Context)context);
        Connection writecon = DBPool.pickupWriteable((Context)context);
        OXFolderManager oxma = OXFolderManager.getInstance((Session)so, (AppointmentSQLInterface)csql, (Connection)readcon, (Connection)writecon);
        OCLPermission oclp = new OCLPermission();
        oclp.setEntity(userid);
        oclp.setAllPermission(128, 128, 128, 128);
        oclp.setFolderAdmin(true);
        FolderObject fo = new FolderObject();
        fo.setFolderName("MyTestFolder" + System.currentTimeMillis());
        fo.setParentFolderID(2);
        fo.setModule(2);
        fo.setType(2);
        fo.setPermissionsAsArray(new OCLPermission[]{oclp});
        fo = oxma.createFolder(fo, true, System.currentTimeMillis());
        int public_folder_id = fo.getObjectID();
        CalendarDataObject testobject = null;
        try {
            CalendarDataObject update1 = new CalendarDataObject();
            update1.setContext(ContextStorage.getInstance().getContext(so.getContextId()));
            update1.setObjectID(object_id);
            update1.setParentFolderID(public_folder_id);
            update1.setTitle("testInsertMoveAndDeleteAppointments - Step 2 - Update");
            update1.setIgnoreConflicts(true);
            csql.updateAppointmentObject(update1, private_folder_id, new Date());
            testobject = csql.getObjectById(object_id, public_folder_id);
            UserParticipant[] up = testobject.getUsers();
            for (int a = 0; a < up.length; ++a) {
                CalendarTest.assertTrue((String)"check that folder id IS NULL", (up[a].getPersonalFolderId() == -1 ? 1 : 0) != 0);
            }
            CalendarTest.assertEquals((String)"testInsertMoveAndDeleteAppointments - Step 2 - Update", (String)update1.getTitle());
            CalendarDataObject update2 = csql.getObjectById(object_id, public_folder_id);
            update2.setTitle("testInsertMoveAndDeleteAppointments - Step 3 - Update");
            update2.setParentFolderID(private_folder_id);
            update2.setIgnoreConflicts(true);
            csql.updateAppointmentObject(update2, public_folder_id, new Date());
            CalendarDataObject testobject2 = csql.getObjectById(object_id, private_folder_id);
            CalendarTest.assertEquals((String)"Test folder id ", (int)testobject2.getEffectiveFolderId(), (int)private_folder_id);
            UserParticipant[] up2 = testobject2.getUsers();
            CalendarTest.assertEquals((String)"check length ", (int)up2.length, (int)1);
            for (int a = 0; a < up2.length; ++a) {
                CalendarTest.assertEquals((String)"check that folder id private folder ", (int)up2[a].getPersonalFolderId(), (int)private_folder_id);
            }
            CalendarDataObject update3 = csql.getObjectById(object_id, private_folder_id);
            update3.setTitle("testInsertMoveAndDeleteAppointments - Step 4 - Update");
            update3.setParentFolderID(public_folder_id);
            update3.setIgnoreConflicts(true);
            csql.updateAppointmentObject(update3, private_folder_id, new Date());
        }
        finally {
            oxma.deleteFolder(new FolderObject(public_folder_id), true, System.currentTimeMillis());
        }
        try {
            DBPool.push((Context)context, (Connection)readcon);
            DBPool.pushWrite((Context)context, (Connection)writecon);
        }
        catch (Exception ignore) {
            ignore.printStackTrace();
        }
        try {
            testobject = csql.getObjectById(object_id, public_folder_id);
            throw new Exception("Object not deleted! Test failed!");
        }
        catch (Exception not_exist) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInsertMoveAllDelete() throws Throwable {
        ContextImpl context = new ContextImpl(contextid);
        CalendarDataObject cdao = new CalendarDataObject();
        cdao.setTitle("testInsertMoveAllDelete - Step 1 - Insert");
        cdao.setParentFolderID(CalendarTest.getCalendarDefaultFolderForUser(userid, (Context)context));
        SessionObject so = SessionObjectWrapper.createSessionObject((int)userid, (int)context.getContextId(), (String)"myTestIdentifier");
        cdao.setContext(ContextStorage.getInstance().getContext(so.getContextId()));
        CalendarTest.fillDatesInDao(cdao);
        cdao.setIgnoreConflicts(true);
        CalendarSql csql = new CalendarSql((Session)so);
        csql.insertAppointmentObject(cdao);
        int private_folder_id = cdao.getEffectiveFolderId();
        int object_id = cdao.getObjectID();
        Connection readcon = DBPool.pickup((Context)context);
        Connection writecon = DBPool.pickupWriteable((Context)context);
        OXFolderManager oxma = OXFolderManager.getInstance((Session)so, (AppointmentSQLInterface)csql, (Connection)readcon, (Connection)writecon);
        OCLPermission oclp = new OCLPermission();
        oclp.setEntity(userid);
        oclp.setAllPermission(128, 128, 128, 128);
        oclp.setFolderAdmin(true);
        FolderObject fo = new FolderObject();
        fo.setFolderName("MyTestFolder" + System.currentTimeMillis());
        fo.setParentFolderID(2);
        fo.setModule(2);
        fo.setType(2);
        fo.setPermissionsAsArray(new OCLPermission[]{oclp});
        fo = oxma.createFolder(fo, true, System.currentTimeMillis());
        int public_folder_id = fo.getObjectID();
        CalendarDataObject testobject = null;
        try {
            Appointment tdao;
            long startTime = System.currentTimeMillis();
            CalendarDataObject update1 = new CalendarDataObject();
            update1.setContext(ContextStorage.getInstance().getContext(so.getContextId()));
            update1.setObjectID(object_id);
            update1.setParentFolderID(public_folder_id);
            update1.setTitle("testInsertMoveAllDelete - Step 2 - Update");
            update1.setIgnoreConflicts(true);
            csql.updateAppointmentObject(update1, private_folder_id, new Date());
            testobject = csql.getObjectById(object_id, public_folder_id);
            UserParticipant[] up = testobject.getUsers();
            for (int a = 0; a < up.length; ++a) {
                CalendarTest.assertTrue((String)"check that folder id IS NULL", (up[a].getPersonalFolderId() == -1 ? 1 : 0) != 0);
            }
            CalendarTest.assertEquals((String)"testInsertMoveAllDelete - Step 2 - Update", (String)update1.getTitle());
            CalendarDataObject update2 = csql.getObjectById(object_id, public_folder_id);
            update2.setTitle("testInsertMoveAllDelete - Step 3 - Update");
            update2.setParentFolderID(private_folder_id);
            update2.setIgnoreConflicts(true);
            csql.updateAppointmentObject(update2, public_folder_id, new Date());
            CalendarDataObject testobject2 = csql.getObjectById(object_id, private_folder_id);
            CalendarTest.assertEquals((String)"Test folder id ", (int)testobject2.getEffectiveFolderId(), (int)private_folder_id);
            UserParticipant[] up2 = testobject2.getUsers();
            CalendarTest.assertEquals((String)"check length ", (int)up2.length, (int)1);
            for (int a = 0; a < up2.length; ++a) {
                CalendarTest.assertEquals((String)"check that folder id private folder ", (int)up2[a].getPersonalFolderId(), (int)private_folder_id);
            }
            CalendarDataObject update3 = csql.getObjectById(object_id, private_folder_id);
            update3.setTitle("testInsertMoveAllDelete - Step 4 - Update");
            update3.setParentFolderID(public_folder_id);
            update3.setIgnoreConflicts(true);
            csql.updateAppointmentObject(update3, private_folder_id, new Date());
            this.deleteAllAppointments();
            SearchIterator si = csql.getModifiedAppointmentsInFolder(public_folder_id, cols, new Date(0L));
            boolean found = false;
            while (si.hasNext()) {
                tdao = (Appointment)si.next();
                if (tdao == null) continue;
                found = true;
            }
            si.close();
            CalendarTest.assertFalse((String)"Found unexpected Appointment.", (boolean)found);
            si = csql.getAppointmentsBetween(userid, new Date(0L), new Date(253402210800000L), cols, 0, null);
            while (si.hasNext()) {
                tdao = (Appointment)si.next();
                Date compare = tdao.getLastModified();
                if (compare != null) {
                    CalendarTest.assertFalse((String)("Got results. An available appointment created in test case! " + tdao.getTitle()), (compare.getTime() >= startTime && tdao.getTitle().startsWith("testInsertMoveAllDelete") ? 1 : 0) != 0);
                    continue;
                }
                CalendarTest.fail((String)"Missing last-modified time stamp in appointment");
            }
            si.close();
        }
        finally {
            oxma.deleteFolder(new FolderObject(public_folder_id), true, System.currentTimeMillis());
        }
        try {
            DBPool.push((Context)context, (Connection)readcon);
            DBPool.pushWrite((Context)context, (Connection)writecon);
        }
        catch (Exception ignore) {
            ignore.printStackTrace();
        }
        try {
            testobject = csql.getObjectById(object_id, public_folder_id);
            throw new Exception("Object not deleted! Test failed!");
        }
        catch (Exception not_exist) {
            return;
        }
    }

    public void testConflictHandling() throws Exception {
        ContextImpl context = new ContextImpl(contextid);
        CalendarDataObject cdao = new CalendarDataObject();
        cdao.setTitle("testConflict Step 1 - Insert - ignore conflicts");
        cdao.setParentFolderID(CalendarTest.getCalendarDefaultFolderForUser(userid, (Context)context));
        SessionObject so = SessionObjectWrapper.createSessionObject((int)userid, (int)context.getContextId(), (String)"myTestIdentifier");
        cdao.setContext(ContextStorage.getInstance().getContext(so.getContextId()));
        CalendarTest.fillDatesInDao(cdao);
        cdao.setIgnoreConflicts(true);
        CalendarSql csql = new CalendarSql((Session)so);
        csql.insertAppointmentObject(cdao);
        cdao.getObjectID();
        CalendarDataObject conflict_cdao = new CalendarDataObject();
        conflict_cdao.setTitle("testConflict Step 2 - Insert - Must conflict");
        conflict_cdao.setParentFolderID(CalendarTest.getCalendarDefaultFolderForUser(userid, (Context)context));
        conflict_cdao.setContext(ContextStorage.getInstance().getContext(so.getContextId()));
        CalendarTest.fillDatesInDao(conflict_cdao);
        conflict_cdao.setIgnoreConflicts(false);
        CalendarDataObject[] conflicts = csql.insertAppointmentObject(conflict_cdao);
        if (conflicts != null) {
            CalendarTest.assertTrue((String)"Check if the conflict has been detected", (conflicts.length > 0 ? 1 : 0) != 0);
            boolean found_first_appointment = false;
            for (int a = 0; a < conflicts.length; ++a) {
                if (conflicts[a].getObjectID() != cdao.getObjectID()) continue;
                found_first_appointment = true;
                break;
            }
            if (conflicts.length != 999) {
                CalendarTest.assertTrue((String)"Check for conflict object ", (boolean)found_first_appointment);
            }
            CalendarTest.assertTrue((String)"Check that we did not create the second appointment", (!conflict_cdao.containsObjectID() ? 1 : 0) != 0);
        } else {
            CalendarTest.fail((String)"No conflict!");
        }
    }

    public void testGetAllAppointmentsFromUserInAllFolders() throws Exception {
        Appointment cdao;
        Connection readcon = DBPool.pickup((Context)CalendarTest.getContext());
        ContextImpl context = new ContextImpl(contextid);
        SessionObject so = SessionObjectWrapper.createSessionObject((int)userid, (int)context.getContextId(), (String)"testGetAllAppointmentsFromUserInAllFolders");
        CalendarSql csql = new CalendarSql((Session)so);
        SearchIterator si = csql.getAppointmentsBetween(userid, new Date(0L), new Date(253402210800000L), cols, 0, null);
        CalendarTest.assertTrue((String)"Test if we got appointments", (boolean)si.hasNext());
        while (si.hasNext()) {
            cdao = (Appointment)si.next();
            CalendarTest.assertTrue((String)"Check folder ", (cdao.getParentFolderID() != 0 ? 1 : 0) != 0);
            CalendarTest.testDelete(cdao);
        }
        si.close();
        si = csql.getAppointmentsBetween(userid, new Date(0L), new Date(253402210800000L), cols, 0, null);
        while (si.hasNext()) {
            cdao = (Appointment)si.next();
            EffectivePermission ep = new OXFolderAccess((Context)context).getFolderPermission(cdao.getParentFolderID(), userid, UserConfigurationStorage.getInstance().getUserConfiguration(userid, (Context)context));
            if (ep.getDeletePermission() == 0 || !ep.canDeleteAllObjects() && (cdao.getCreatedBy() != userid || !ep.canDeleteOwnObjects())) continue;
            CalendarTest.fail((String)("Not all appointments were deleted: objectID=" + cdao.getObjectID() + " title=" + cdao.getTitle()));
        }
        DBPool.push((Context)context, (Connection)readcon);
    }

    public void testResourceConflictHandling() throws Exception {
        ContextImpl context = new ContextImpl(contextid);
        SessionObject so = SessionObjectWrapper.createSessionObject((int)userid, (int)context.getContextId(), (String)"myTestIdentifier");
        int folder_id = CalendarTest.getCalendarDefaultFolderForUser(userid, (Context)context);
        CalendarDataObject cdao = new CalendarDataObject();
        cdao.setTimezone("Europe/Berlin");
        cdao.setContext(ContextStorage.getInstance().getContext(so.getContextId()));
        cdao.setParentFolderID(folder_id);
        CalendarTest.fillDatesInDao(cdao);
        cdao.setTitle("testResourceConflictHandling - Step 1 - Insert");
        Participants p = new Participants();
        ResourceParticipant resource = new ResourceParticipant(100);
        p.add((Participant)resource);
        cdao.setParticipants(p.getList());
        CalendarDataObject cdao_conflict = cdao.clone();
        cdao.setIgnoreConflicts(true);
        CalendarSql csql = new CalendarSql((Session)so);
        csql.insertAppointmentObject(cdao);
        int object_id = cdao.getObjectID();
        CalendarTest.assertTrue((String)"Check that the object really exists ", (object_id > 0 ? 1 : 0) != 0);
        cdao.getLastModified();
        cdao.setIgnoreConflicts(true);
        cdao_conflict.setParentFolderID(folder_id);
        CalendarDataObject[] conflicts = csql.insertAppointmentObject(cdao_conflict);
        CalendarTest.assertTrue((String)"Got conflicts ", (conflicts != null ? 1 : 0) != 0);
        boolean found = false;
        for (int a = 0; a < conflicts.length; ++a) {
            CalendarDataObject tcdao = conflicts[a];
            if (tcdao.getObjectID() != object_id) continue;
            found = true;
        }
        CalendarTest.assertTrue((String)"Conflict object not found", (boolean)found);
        Participants p2 = new Participants();
        ResourceParticipant resource2 = new ResourceParticipant(1001);
        p2.add((Participant)resource2);
        cdao.setParticipants(p2.getList());
        String titel = "testResourceConflictHandling - Step 2 - Update";
        cdao.setTitle("testResourceConflictHandling - Step 2 - Update");
        conflicts = csql.updateAppointmentObject(cdao, folder_id, new Date());
        CalendarDataObject testobject = csql.getObjectById(object_id, folder_id);
        Participant[] test_participants = testobject.getParticipants();
        CalendarTest.assertEquals((String)"Check size after update ", (int)2, (int)test_participants.length);
        CalendarTest.assertEquals((String)"Check changed titlel", (String)"testResourceConflictHandling - Step 2 - Update", (String)testobject.getTitle());
        found = false;
        for (int a = 0; a < test_participants.length; ++a) {
            if (test_participants[a].getIdentifier() != 1001) continue;
            found = true;
        }
        CalendarTest.assertTrue((String)"Check for updated (new) resource", (boolean)found);
        csql.deleteAppointmentObject(cdao, folder_id, new Date());
    }

    public void testComplexConflictHandling() throws Exception {
        Appointment cdao;
        this.deleteAllAppointments();
        ContextImpl context = new ContextImpl(contextid);
        SessionObject so = SessionObjectWrapper.createSessionObject((int)userid, (int)context.getContextId(), (String)"myTestIdentifier");
        int fid = CalendarTest.getCalendarDefaultFolderForUser(userid, (Context)context);
        CalendarSql csql = new CalendarSql((Session)so);
        SearchIterator si = csql.getAppointmentsBetween(userid, new Date(0L), new Date(253402210800000L), cols, 0, null);
        while (si.hasNext()) {
            cdao = (Appointment)si.next();
            EffectivePermission ep = new OXFolderAccess((Context)context).getFolderPermission(cdao.getParentFolderID(), userid, UserConfigurationStorage.getInstance().getUserConfiguration(userid, (Context)context));
            if (ep.getDeletePermission() == 0 || !ep.canDeleteAllObjects() && (cdao.getCreatedBy() != userid || !ep.canDeleteOwnObjects())) continue;
            CalendarTest.fail((String)("Not all appointments were deleted: objectID=" + cdao.getObjectID() + " title=" + cdao.getTitle()));
        }
        si.close();
        cdao = new CalendarDataObject();
        cdao.setTimezone("Europe/Berlin");
        cdao.setTitle("testComplexConflictHandling - Step 1 - Insert");
        cdao.setParentFolderID(fid);
        cdao.setContext(ContextStorage.getInstance().getContext(so.getContextId()));
        cdao.setShownAs(4);
        CalendarTest.fillDatesInDao((CalendarDataObject)cdao);
        CalendarDataObject cdao_conflict = cdao.clone();
        TimeZone conflictTimeZone = TimeZone.getTimeZone(cdao_conflict.getTimezone());
        int conflictOffset = conflictTimeZone.getOffset(cdao_conflict.getStartDate().getTime());
        cdao_conflict.setStartDate(new Date(cdao_conflict.getStartDate().getTime() - (long)conflictOffset));
        cdao_conflict.setEndDate(new Date(cdao_conflict.getEndDate().getTime() - (long)conflictOffset));
        cdao_conflict.setShownAs(1);
        cdao_conflict.setTitle("testComplexConflictHandling - Step 2 - Insert");
        CalendarDataObject[] conflicts = csql.insertAppointmentObject((CalendarDataObject)cdao);
        CalendarTest.assertTrue((String)"Found no conflicts", (conflicts == null ? 1 : 0) != 0);
        conflicts = csql.insertAppointmentObject(cdao_conflict);
        CalendarTest.assertTrue((String)"Found no conflicts (free)", (conflicts == null ? 1 : 0) != 0);
        CalendarTest.assertTrue((String)"ID check", (cdao.getObjectID() != cdao_conflict.getObjectID() ? 1 : 0) != 0);
        cdao.setTitle("testComplexConflictHandling - Step 3 - Update");
        cdao.setShownAs(1);
        cdao.setFullTime(true);
        conflicts = csql.updateAppointmentObject((CalendarDataObject)cdao, fid, new Date());
        CalendarTest.assertTrue((String)"Found conflicts ", (conflicts != null ? 1 : 0) != 0);
        CalendarTest.assertEquals((String)"Check correct result size", (int)1, (int)conflicts.length);
        CalendarTest.assertEquals((String)"Check conflict results", (int)conflicts[0].getObjectID(), (int)cdao_conflict.getObjectID());
        cdao.setIgnoreConflicts(true);
        conflicts = csql.updateAppointmentObject((CalendarDataObject)cdao, fid, new Date());
        CalendarTest.assertTrue((String)"Found conflicts ", (conflicts == null ? 1 : 0) != 0);
        cdao_conflict.setTitle("testComplexConflictHandling - Step 4 - Update");
        cdao_conflict.setShownAs(2);
        conflicts = csql.updateAppointmentObject(cdao_conflict, fid, new Date());
        CalendarTest.assertNotNull((String)"Found no conflicts ", (Object)conflicts);
        CalendarTest.assertEquals((String)"Check correct result size", (int)1, (int)conflicts.length);
        CalendarTest.assertEquals((String)"Check conflict results", (int)conflicts[0].getObjectID(), (int)cdao.getObjectID());
    }

    public void testConfirmation() throws Throwable {
        ContextImpl context = new ContextImpl(contextid);
        int fid = CalendarTest.getCalendarDefaultFolderForUser(userid, (Context)context);
        String user2 = AbstractConfigWrapper.parseProperty((Properties)CalendarTest.getAJAXProperties(), (String)"user_participant3", (String)"");
        CalendarDataObject cdao = new CalendarDataObject();
        cdao.setTitle("testConfirmation - Step 1 - Insert");
        cdao.setParentFolderID(fid);
        SessionObject so = SessionObjectWrapper.createSessionObject((int)userid, (int)context.getContextId(), (String)"myTestIdentifier");
        cdao.setContext(ContextStorage.getInstance().getContext(so.getContextId()));
        cdao.setIgnoreConflicts(true);
        UserParticipant userparticipants = new UserParticipant(userid);
        userparticipants.setConfirm(1);
        String check_confirm_message = "Check this";
        userparticipants.setConfirmMessage("Check this");
        cdao.setUsers(new UserParticipant[]{userparticipants});
        CalendarTest.assertEquals((String)"Check id", (int)userid, (int)userparticipants.getIdentifier());
        CalendarTest.assertEquals((String)"Check confirm state", (int)1, (int)userparticipants.getConfirm());
        CalendarTest.assertEquals((String)"Check confirm message", (String)"Check this", (String)userparticipants.getConfirmMessage());
        Participants participants = new Participants();
        UserParticipant p2 = new UserParticipant(CalendarTest.resolveUser(user2));
        participants.add((Participant)p2);
        cdao.setParticipants(participants.getList());
        CalendarTest.fillDatesInDao(cdao);
        UserParticipant[] up = cdao.getUsers();
        CalendarTest.assertTrue((String)"Check participants (1)", (up != null ? 1 : 0) != 0);
        CalendarTest.assertTrue((String)"Check participants (1)", (up.length > 0 ? 1 : 0) != 0);
        boolean found = false;
        for (int a = 0; a < up.length; ++a) {
            if (up[a].getIdentifier() != userid) continue;
            CalendarTest.assertEquals((String)"Check confirm state (1)", (int)1, (int)up[a].getConfirm());
            found = true;
        }
        CalendarTest.assertTrue((String)"Check correct participants", (boolean)found);
        CalendarSql csql = new CalendarSql((Session)so);
        csql.insertAppointmentObject(cdao);
        int object_id = cdao.getObjectID();
        CalendarDataObject testobject = csql.getObjectById(object_id, fid);
        up = testobject.getUsers();
        CalendarTest.assertTrue((String)"Check participants (2)", (up != null ? 1 : 0) != 0);
        CalendarTest.assertTrue((String)"Check participants (2)", (up.length > 0 ? 1 : 0) != 0);
        found = false;
        for (int a = 0; a < up.length; ++a) {
            if (up[a].getIdentifier() != userid) continue;
            CalendarTest.assertEquals((String)"Check confirm state (2)", (int)1, (int)up[a].getConfirm());
            CalendarTest.assertEquals((String)"Check confirm message", (String)"Check this", (String)up[a].getConfirmMessage());
            found = true;
        }
        CalendarTest.assertTrue((String)"Check correct participants", (boolean)found);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSharedFolder() throws Throwable {
        ContextImpl context = new ContextImpl(contextid);
        SessionObject so = SessionObjectWrapper.createSessionObject((int)userid, (int)CalendarTest.getContext().getContextId(), (String)"myTestSearch");
        String user2 = AbstractConfigWrapper.parseProperty((Properties)CalendarTest.getAJAXProperties(), (String)"user_participant3", (String)"");
        int uid2 = CalendarTest.resolveUser(user2);
        SessionObject so2 = SessionObjectWrapper.createSessionObject((int)uid2, (int)context.getContextId(), (String)"myTestIdentifier");
        Connection readcon = DBPool.pickup((Context)context);
        Connection writecon = DBPool.pickupWriteable((Context)context);
        int fid = CalendarTest.getPrivateFolder();
        CalendarSql csql = new CalendarSql((Session)so);
        OXFolderManager oxma = OXFolderManager.getInstance((Session)so, (AppointmentSQLInterface)csql, (Connection)readcon, (Connection)writecon);
        FolderObject fo = new FolderObject();
        OCLPermission oclp1 = new OCLPermission();
        oclp1.setEntity(userid);
        oclp1.setAllPermission(128, 128, 128, 128);
        oclp1.setFolderAdmin(true);
        OCLPermission oclp2 = new OCLPermission();
        oclp2.setEntity(uid2);
        oclp2.setAllPermission(4, 128, 128, 128);
        fo.setFolderName("testSharedFolder_" + String.valueOf(System.currentTimeMillis()));
        fo.setParentFolderID(fid);
        fo.setModule(2);
        fo.setType(1);
        fo.setPermissionsAsArray(new OCLPermission[]{oclp1, oclp2});
        fo = oxma.createFolder(fo, true, System.currentTimeMillis());
        int shared_folder_id = 0;
        try {
            shared_folder_id = fo.getObjectID();
            CalendarDataObject cdao = new CalendarDataObject();
            cdao.setContext(ContextStorage.getInstance().getContext(so.getContextId()));
            cdao.setParentFolderID(shared_folder_id);
            CalendarTest.fillDatesInDao(cdao);
            cdao.setTitle("testSharedFolder");
            cdao.setIgnoreConflicts(true);
            csql.insertAppointmentObject(cdao);
            int object_id = cdao.getObjectID();
            CalendarSql csql2 = new CalendarSql((Session)so2);
            SearchIterator si = csql2.getModifiedAppointmentsInFolder(shared_folder_id, cols, new Date(0L));
            boolean found = false;
            while (si.hasNext()) {
                Appointment tdao = (Appointment)si.next();
                if (object_id != tdao.getObjectID()) continue;
                found = true;
            }
            si.close();
            CalendarTest.assertTrue((String)"User2 got object in shared folder created by user1 ", (boolean)found);
            CalendarDataObject ddao = new CalendarDataObject();
            ddao.setContext(ContextStorage.getInstance().getContext(so.getContextId()));
            ddao.setObjectID(object_id);
            csql.deleteAppointmentObject(ddao, shared_folder_id, new Date());
            boolean found_deleted = false;
            si = csql2.getDeletedAppointmentsInFolder(shared_folder_id, cols, new Date(0L));
            while (si.hasNext()) {
                si.next();
                if (object_id != cdao.getObjectID()) continue;
                found_deleted = true;
            }
            si.close();
            CalendarTest.assertTrue((String)"User2 got no object in shared folder created by user1 ", (boolean)found_deleted);
        }
        finally {
            try {
                if (shared_folder_id > 0) {
                    oxma.deleteFolder(new FolderObject(shared_folder_id), true, System.currentTimeMillis());
                } else {
                    CalendarTest.fail((String)"Folder was not created.");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                CalendarTest.fail((String)"Error deleting folder object.");
            }
        }
        try {
            DBPool.push((Context)context, (Connection)readcon);
            DBPool.pushWrite((Context)context, (Connection)writecon);
        }
        catch (Exception ignore) {
            ignore.printStackTrace();
        }
    }

    public void testHasAppointmentsBetween() throws Throwable {
        this.deleteAllAppointments();
        new ContextImpl(contextid);
        SessionObject so = SessionObjectWrapper.createSessionObject((int)userid, (int)CalendarTest.getContext().getContextId(), (String)"myTestSearch");
        int fid = CalendarTest.getPrivateFolder();
        CalendarDataObject cdao = new CalendarDataObject();
        cdao.setContext(ContextStorage.getInstance().getContext(so.getContextId()));
        cdao.setTitle("testHasAppointmentsBetween - Normal app");
        cdao.setParentFolderID(fid);
        cdao.setIgnoreConflicts(true);
        cdao.setStartDate(TimeTools.D("01.10.2013 08:00"));
        cdao.setEndDate(TimeTools.D("01.10.2013 09:00"));
        CalendarSql csql = new CalendarSql((Session)so);
        csql.insertAppointmentObject(cdao);
        cdao.getObjectID();
        Object m = null;
        CalendarDataObject cdao2 = new CalendarDataObject();
        cdao2.setContext(ContextStorage.getInstance().getContext(so.getContextId()));
        cdao2.setParentFolderID(fid);
        cdao2.setTimezone("Europe/Berlin");
        cdao2.setStartDate(TimeTools.D("04.10.2013 08:00"));
        cdao2.setEndDate(TimeTools.D("04.10.2013 09:00"));
        cdao2.setTitle("testHasAppointmentsBetween - Rec app");
        cdao2.setRecurrenceType(2);
        cdao2.setInterval(1);
        cdao2.setDays(32);
        cdao2.setIgnoreConflicts(true);
        csql.insertAppointmentObject(cdao2);
        cdao2.getObjectID();
        Date range_start = TimeTools.D("01.10.2013 00:00");
        Date range_end = TimeTools.D("01.11.2013 00:00");
        boolean[] check_array = new boolean[]{true, false, false, true, false, false, false, false, false, false, true, false, false, false, false, false, false, true, false, false, false, false, false, false, true, false, false, false, false, false, false};
        boolean[] test_array = csql.hasAppointmentsBetween(range_start, range_end);
        CalendarTest.assertEquals((String)"Check arrays (length)", (int)check_array.length, (int)test_array.length);
        for (int a = 0; a < check_array.length; ++a) {
            CalendarTest.assertEquals((String)("Check arrays (position " + a + ")"), (boolean)check_array[a], (boolean)test_array[a]);
        }
    }

    public void testInsertUpdateAlarm() throws Throwable {
        ContextImpl context = new ContextImpl(contextid);
        int fid = CalendarTest.getCalendarDefaultFolderForUser(userid, (Context)context);
        CalendarDataObject cdao = new CalendarDataObject();
        cdao.setTitle("testInsertUpdateAlarm - Step 1 - Insert");
        cdao.setParentFolderID(fid);
        SessionObject so = SessionObjectWrapper.createSessionObject((int)userid, (int)context.getContextId(), (String)"myTestIdentifier");
        cdao.setContext(ContextStorage.getInstance().getContext(so.getContextId()));
        cdao.setIgnoreConflicts(true);
        cdao.setAlarm(15);
        cdao.setAlarmFlag(true);
        CalendarTest.fillDatesInDao(cdao);
        CalendarSql csql = new CalendarSql((Session)so);
        csql.insertAppointmentObject(cdao);
        int object_id = cdao.getObjectID();
        CalendarDataObject testobject = csql.getObjectById(object_id, fid);
        CalendarTest.assertTrue((String)"Check alarm", (boolean)testobject.containsAlarm());
        CalendarTest.assertEquals((String)"Check correct alarm value", (int)15, (int)testobject.getAlarm());
        CalendarDataObject update = new CalendarDataObject();
        update.setTitle("testInsertUpdateAlarm - Step 2 - Update");
        update.setObjectID(object_id);
        update.setContext(ContextStorage.getInstance().getContext(so.getContextId()));
        update.setIgnoreConflicts(true);
        csql.updateAppointmentObject(update, fid, testobject.getLastModified());
        testobject = csql.getObjectById(object_id, fid);
        CalendarTest.assertTrue((String)"Check alarm", (boolean)testobject.containsAlarm());
        CalendarTest.assertEquals((String)"Check correct alarm value", (int)15, (int)testobject.getAlarm());
        CalendarDataObject update2 = new CalendarDataObject();
        update2.setTitle("testInsertUpdateAlarm - Step 3 - Update");
        update2.setObjectID(object_id);
        update2.setContext(ContextStorage.getInstance().getContext(so.getContextId()));
        update2.setIgnoreConflicts(true);
        UserParticipant up = new UserParticipant(userid);
        update2.setUsers(new UserParticipant[]{up});
        csql.updateAppointmentObject(update2, fid, testobject.getLastModified());
        testobject = csql.getObjectById(object_id, fid);
        CalendarTest.assertTrue((String)"Check alarm", (boolean)testobject.containsAlarm());
        CalendarTest.assertEquals((String)"Check correct alarm value", (int)15, (int)testobject.getAlarm());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInsertMoveAndDeleteAppointmentsWithPrivateFlag() throws Throwable {
        ContextImpl context = new ContextImpl(contextid);
        CalendarDataObject cdao = new CalendarDataObject();
        cdao.setTitle("testInsertMoveAndDeleteAppointmentsWithPrivateFlag - Step 1 - Insert");
        cdao.setParentFolderID(CalendarTest.getCalendarDefaultFolderForUser(userid, (Context)context));
        SessionObject so = SessionObjectWrapper.createSessionObject((int)userid, (int)context.getContextId(), (String)"myTestIdentifier");
        cdao.setContext(ContextStorage.getInstance().getContext(so.getContextId()));
        CalendarTest.fillDatesInDao(cdao);
        cdao.setIgnoreConflicts(true);
        cdao.setPrivateFlag(true);
        CalendarSql csql = new CalendarSql((Session)so);
        csql.insertAppointmentObject(cdao);
        int private_folder_id = cdao.getEffectiveFolderId();
        int object_id = cdao.getObjectID();
        Connection readcon = DBPool.pickup((Context)context);
        Connection writecon = DBPool.pickupWriteable((Context)context);
        OXFolderManager oxma = OXFolderManager.getInstance((Session)so, (AppointmentSQLInterface)csql, (Connection)readcon, (Connection)writecon);
        OCLPermission oclp = new OCLPermission();
        oclp.setEntity(userid);
        oclp.setAllPermission(128, 128, 128, 128);
        oclp.setFolderAdmin(true);
        FolderObject fo = new FolderObject();
        fo.setFolderName("testInsertMoveAndDeleteAppointmentsWithPrivateFlagFolder" + System.currentTimeMillis());
        fo.setParentFolderID(2);
        fo.setModule(2);
        fo.setType(2);
        fo.setPermissionsAsArray(new OCLPermission[]{oclp});
        fo = oxma.createFolder(fo, true, System.currentTimeMillis());
        int public_folder_id = fo.getObjectID();
        try {
            CalendarDataObject update1 = new CalendarDataObject();
            update1.setContext(ContextStorage.getInstance().getContext(so.getContextId()));
            update1.setObjectID(object_id);
            update1.setParentFolderID(public_folder_id);
            update1.setTitle("testInsertMoveAndDeleteAppointments - Step 2 - Update");
            update1.setIgnoreConflicts(true);
            try {
                csql.updateAppointmentObject(update1, private_folder_id, new Date());
                CalendarTest.fail((String)"Move from a private folder with private flag should not be possibe!");
            }
            catch (OXException e) {
            }
            catch (Exception e) {
                CalendarTest.fail((String)("Nooo " + e.getMessage()));
            }
        }
        finally {
            oxma.deleteFolder(new FolderObject(public_folder_id), true, System.currentTimeMillis());
        }
        try {
            DBPool.push((Context)context, (Connection)readcon);
            DBPool.pushWrite((Context)context, (Connection)writecon);
        }
        catch (Exception ignore) {
            ignore.printStackTrace();
        }
        try {
            csql.getObjectById(object_id, public_folder_id);
            throw new Exception("Object not deleted! Test failed!");
        }
        catch (Exception not_exist) {
            return;
        }
    }

    public void testAlarmAndUpdate() throws Throwable {
        ContextImpl context = new ContextImpl(contextid);
        int fid = CalendarTest.getCalendarDefaultFolderForUser(userid, (Context)context);
        CalendarDataObject cdao = new CalendarDataObject();
        cdao.setTitle("testAlarmAndUpdate - Step 1 - Insert");
        cdao.setParentFolderID(fid);
        SessionObject so = SessionObjectWrapper.createSessionObject((int)userid, (int)context.getContextId(), (String)"myTestIdentifier");
        cdao.setContext(ContextStorage.getInstance().getContext(so.getContextId()));
        cdao.setIgnoreConflicts(true);
        cdao.setAlarm(15);
        CalendarTest.fillDatesInDao(cdao);
        CalendarSql csql = new CalendarSql((Session)so);
        csql.insertAppointmentObject(cdao);
        int object_id = cdao.getObjectID();
        CalendarDataObject testobject = csql.getObjectById(object_id, fid);
        CalendarTest.assertTrue((String)"Alarm should be set", (boolean)testobject.containsAlarm());
        CalendarTest.assertEquals((String)"Test correct alarm value", (int)15, (int)testobject.getAlarm());
        CalendarDataObject update = new CalendarDataObject();
        update.setContext(ContextStorage.getInstance().getContext(so.getContextId()));
        update.setObjectID(object_id);
        update.setTitle("testAlarmAndUpdate - Step 2 - Update");
        update.setIgnoreConflicts(true);
        Participants participants = new Participants();
        UserParticipant p = new UserParticipant(userid);
        participants.add((Participant)p);
        UserParticipant up = new UserParticipant(userid);
        update.setUsers(new UserParticipant[]{up});
        update.setParticipants(participants.getList());
        csql.updateAppointmentObject(update, fid, testobject.getLastModified());
        CalendarDataObject testobject2 = csql.getObjectById(object_id, fid);
        CalendarTest.assertTrue((String)"Alarm should be set", (boolean)testobject2.containsAlarm());
        CalendarTest.assertEquals((String)"Test correct alarm value", (int)15, (int)testobject2.getAlarm());
        ReminderHandler rsql = new ReminderHandler(ContextStorage.getInstance().getContext(so.getContextId()));
        ReminderObject ro = rsql.loadReminder(object_id, userid, 1);
        long check_date = new Date(testobject2.getStartDate().getTime() - 900000L).getTime();
        CalendarTest.assertEquals((String)"Check correct alam in reminder object", (long)check_date, (long)ro.getDate().getTime());
        CalendarDataObject update2 = new CalendarDataObject();
        update2.setContext(ContextStorage.getInstance().getContext(so.getContextId()));
        update2.setObjectID(object_id);
        String title = "testAlarmAndUpdate - Step 3 - Update";
        update2.setTitle("testAlarmAndUpdate - Step 3 - Update");
        update2.setAlarm(30);
        update2.setIgnoreConflicts(true);
        csql.updateAppointmentObject(update2, fid, testobject2.getLastModified());
        CalendarDataObject testobject3 = csql.getObjectById(object_id, fid);
        CalendarTest.assertEquals((String)"Check title", (String)"testAlarmAndUpdate - Step 3 - Update", (String)testobject3.getTitle());
        CalendarTest.assertTrue((String)"Alarm should be set", (boolean)testobject3.containsAlarm());
        CalendarTest.assertEquals((String)"Test correct alarm value", (int)30, (int)testobject3.getAlarm());
        ro = rsql.loadReminder(object_id, userid, 1);
        check_date = new Date(testobject3.getStartDate().getTime() - 1800000L).getTime();
        CalendarTest.assertEquals((String)"Check correct alam in reminder object", (long)check_date, (long)ro.getDate().getTime());
    }

    public void testDataTuncationException() throws Throwable {
        ContextImpl context = new ContextImpl(contextid);
        int fid = CalendarTest.getCalendarDefaultFolderForUser(userid, (Context)context);
        SessionObject so = SessionObjectWrapper.createSessionObject((int)userid, (int)context.getContextId(), (String)"myTestIdentifier");
        CalendarDataObject cdao = new CalendarDataObject();
        StringBuilder sb = new StringBuilder("testDataTuncationException ");
        sb.append("extrem long test to force an error message and in detail a DataTruncation Exception! ");
        sb.append("extrem long test to force an error message and in detail a DataTruncation Exception! ");
        sb.append("extrem long test to force an error message and in detail a DataTruncation Exception! ");
        sb.append("extrem long test to force an error message and in detail a DataTruncation Exception! ");
        sb.append("extrem long test to force an error message and in detail a DataTruncation Exception! ");
        sb.append("extrem long test to force an error message and in detail a DataTruncation Exception! ");
        sb.append("extrem long test to force an error message and in detail a DataTruncation Exception! ");
        sb.append("extrem long test to force an error message and in detail a DataTruncation Exception! ");
        sb.append("extrem long test to force an error message and in detail a DataTruncation Exception! ");
        sb.append("extrem long test to force an error message and in detail a DataTruncation Exception! ");
        sb.append("extrem long test to force an error message and in detail a DataTruncation Exception! ");
        sb.append("extrem long test to force an error message and in detail a DataTruncation Exception! ");
        sb.append("extrem long test to force an error message and in detail a DataTruncation Exception! ");
        cdao.setTitle(sb.toString());
        cdao.setParentFolderID(fid);
        cdao.setContext(ContextStorage.getInstance().getContext(so.getContextId()));
        cdao.setIgnoreConflicts(true);
        CalendarTest.fillDatesInDao(cdao);
        CalendarSql csql = new CalendarSql((Session)so);
        int object_id = 0;
        try {
            csql.insertAppointmentObject(cdao);
            object_id = cdao.getObjectID();
        }
        catch (OXException oxe) {
            OXException.ProblematicAttribute[] problematics = oxe.getProblematics();
            if (problematics.length == 0) {
                CalendarTest.fail((String)"Got no TruncatedIds ");
            }
        }
        catch (Exception e) {
            CalendarTest.fail((String)"Wrong exception!");
        }
        if (object_id > 0) {
            CalendarTest.fail((String)"Test not executed correctly");
        }
    }

    public void testExternalParticipants() throws Throwable {
        ContextImpl context = new ContextImpl(contextid);
        int fid = CalendarTest.getCalendarDefaultFolderForUser(userid, (Context)context);
        CalendarDataObject cdao = new CalendarDataObject();
        cdao.setTitle("testExternalParticipants - Step 1 - Insert");
        cdao.setParentFolderID(fid);
        SessionObject so = SessionObjectWrapper.createSessionObject((int)userid, (int)context.getContextId(), (String)"myTestIdentifier");
        cdao.setContext(ContextStorage.getInstance().getContext(so.getContextId()));
        cdao.setIgnoreConflicts(true);
        UserParticipant up = new UserParticipant(userid);
        up.setAlarmMinutes(5);
        cdao.setUsers(new UserParticipant[]{up});
        String mail_address = "firsttest@example.org";
        String display_name = "Externer test user";
        String mail_address2 = "othertest@example.org";
        String display_name2 = "Externer test user2";
        Participants participants = new Participants();
        ExternalUserParticipant p1 = new ExternalUserParticipant("firsttest@example.org");
        p1.setDisplayName("Externer test user");
        participants.add((Participant)p1);
        ExternalUserParticipant p2 = new ExternalUserParticipant("othertest@example.org");
        p2.setDisplayName("Externer test user2");
        participants.add((Participant)p2);
        cdao.setParticipants(participants.getList());
        CalendarTest.fillDatesInDao(cdao);
        CalendarSql csql = new CalendarSql((Session)so);
        csql.insertAppointmentObject(cdao);
        int object_id = cdao.getObjectID();
        CalendarDataObject testobject = csql.getObjectById(object_id, fid);
        Participant[] test_participants = testobject.getParticipants();
        CalendarTest.assertTrue((String)"Check return is not null", (test_participants != null ? 1 : 0) != 0);
        boolean found = false;
        for (int a = 0; a < test_participants.length; ++a) {
            if (test_participants[a].getType() != 5) continue;
            if (test_participants[a].getEmailAddress().equals("firsttest@example.org")) {
                CalendarTest.assertEquals((String)"Check display name", (String)"Externer test user", (String)test_participants[a].getDisplayName());
                CalendarTest.assertEquals((String)"Check mail address", (String)"firsttest@example.org", (String)test_participants[a].getEmailAddress());
            } else if (test_participants[a].getEmailAddress().equals("othertest@example.org")) {
                CalendarTest.assertEquals((String)"Check display name", (String)"Externer test user2", (String)test_participants[a].getDisplayName());
                CalendarTest.assertEquals((String)"Check mail address", (String)"othertest@example.org", (String)test_participants[a].getEmailAddress());
            }
            found = true;
        }
        CalendarTest.assertTrue((String)"Got external participant", (boolean)found);
        CalendarDataObject update = new CalendarDataObject();
        String display_name_2_fail = "Externer test user without mail address";
        participants = new Participants();
        ExternalUserParticipant p_fail = new ExternalUserParticipant(null);
        p_fail.setDisplayName("Externer test user without mail address");
        participants.add((Participant)p_fail);
        update.setContext(ContextStorage.getInstance().getContext(so.getContextId()));
        update.setObjectID(object_id);
        update.setParticipants(participants.getList());
        update.setIgnoreConflicts(true);
        boolean check_update = false;
        try {
            csql.updateAppointmentObject(update, fid, cdao.getLastModified());
            check_update = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        CalendarTest.assertFalse((String)"Participant has no mail, update must fail!", (boolean)check_update);
        CalendarDataObject update_participants = new CalendarDataObject();
        String update_new_display_1 = "External Update 1";
        String update_new_mail_1 = "abc@de";
        String update_new_display_2 = "External Update 2";
        String update_new_mail_2 = "def2@de";
        Participants participants_update = new Participants();
        ExternalUserParticipant p3 = new ExternalUserParticipant("abc@de");
        p3.setDisplayName("External Update 1");
        participants_update.add((Participant)p3);
        ExternalUserParticipant p4 = new ExternalUserParticipant("def2@de");
        p4.setDisplayName("External Update 2");
        participants_update.add((Participant)p4);
        participants_update.add((Participant)p1);
        participants_update.add((Participant)p2);
        update_participants.setContext(ContextStorage.getInstance().getContext(so.getContextId()));
        update_participants.setObjectID(object_id);
        update_participants.setParticipants(participants_update.getList());
        update_participants.setIgnoreConflicts(true);
        csql.updateAppointmentObject(update_participants, fid, cdao.getLastModified());
        CalendarDataObject testobject_update = csql.getObjectById(object_id, fid);
        Participant[] test_participants_update = testobject_update.getParticipants();
        int found_external = 0;
        for (int a = 0; a < test_participants_update.length; ++a) {
            if (test_participants_update[a].getType() != 5) continue;
            if (test_participants_update[a].getEmailAddress().equals("firsttest@example.org")) {
                CalendarTest.assertEquals((String)"Check display name", (String)"Externer test user", (String)test_participants_update[a].getDisplayName());
                CalendarTest.assertEquals((String)"Check mail address", (String)"firsttest@example.org", (String)test_participants_update[a].getEmailAddress());
                ++found_external;
                continue;
            }
            if (test_participants_update[a].getEmailAddress().equals("othertest@example.org")) {
                CalendarTest.assertEquals((String)"Check display name", (String)"Externer test user2", (String)test_participants_update[a].getDisplayName());
                CalendarTest.assertEquals((String)"Check mail address", (String)"othertest@example.org", (String)test_participants_update[a].getEmailAddress());
                ++found_external;
                continue;
            }
            if (test_participants_update[a].getEmailAddress().equals("abc@de")) {
                CalendarTest.assertEquals((String)"Check display name", (String)"External Update 1", (String)test_participants_update[a].getDisplayName());
                CalendarTest.assertEquals((String)"Check mail address", (String)"abc@de", (String)test_participants_update[a].getEmailAddress());
                ++found_external;
                continue;
            }
            if (!test_participants_update[a].getEmailAddress().equals("def2@de")) continue;
            CalendarTest.assertEquals((String)"Check display name", (String)"External Update 2", (String)test_participants_update[a].getDisplayName());
            CalendarTest.assertEquals((String)"Check mail address", (String)"def2@de", (String)test_participants_update[a].getEmailAddress());
            ++found_external;
        }
        CalendarTest.assertEquals((String)"Found all 4 external participants after update", (int)4, (int)found_external);
        CalendarDataObject update_participants2 = new CalendarDataObject();
        Participants participants_update2 = new Participants();
        participants_update2.add((Participant)p1);
        participants_update2.add((Participant)p2);
        update_participants2.setContext(ContextStorage.getInstance().getContext(so.getContextId()));
        update_participants2.setObjectID(object_id);
        update_participants2.setParticipants(participants_update2.getList());
        update_participants2.setIgnoreConflicts(true);
        csql.updateAppointmentObject(update_participants2, fid, update_participants.getLastModified());
        CalendarDataObject testobject_update2 = csql.getObjectById(object_id, fid);
        Participant[] test_participants_update2 = testobject_update2.getParticipants();
        found_external = 0;
        for (int a = 0; a < test_participants_update2.length; ++a) {
            if (test_participants_update2[a].getType() != 5) continue;
            if (test_participants_update2[a].getEmailAddress().equals("firsttest@example.org")) {
                CalendarTest.assertEquals((String)"Check display name", (String)"Externer test user", (String)test_participants_update2[a].getDisplayName());
                CalendarTest.assertEquals((String)"Check mail address", (String)"firsttest@example.org", (String)test_participants_update2[a].getEmailAddress());
                ++found_external;
                continue;
            }
            if (test_participants_update2[a].getEmailAddress().equals("othertest@example.org")) {
                CalendarTest.assertEquals((String)"Check display name", (String)"Externer test user2", (String)test_participants_update2[a].getDisplayName());
                CalendarTest.assertEquals((String)"Check mail address", (String)"othertest@example.org", (String)test_participants_update2[a].getEmailAddress());
                ++found_external;
                continue;
            }
            if (test_participants_update2[a].getEmailAddress().equals("abc@de")) {
                CalendarTest.assertEquals((String)"Check display name", (String)"External Update 1", (String)test_participants_update2[a].getDisplayName());
                CalendarTest.assertEquals((String)"Check mail address", (String)"abc@de", (String)test_participants_update2[a].getEmailAddress());
                ++found_external;
                continue;
            }
            if (!test_participants_update2[a].getEmailAddress().equals("def2@de")) continue;
            CalendarTest.assertEquals((String)"Check display name", (String)"External Update 2", (String)test_participants_update2[a].getDisplayName());
            CalendarTest.assertEquals((String)"Check mail address", (String)"def2@de", (String)test_participants_update2[a].getEmailAddress());
            ++found_external;
        }
        CalendarTest.assertEquals((String)"Found last 2 external participants after second update", (int)2, (int)found_external);
    }

    public void testGroupZero() throws Exception {
        CalendarDataObject cdao = new CalendarDataObject();
        cdao.setContext(CalendarTest.getContext());
        Participants participants = new Participants();
        GroupParticipant p = new GroupParticipant(0);
        participants.add((Participant)p);
        cdao.setParticipants(participants.getList());
        cdao.setTitle("testGroupZero");
        CalendarTest.fillDatesInDao(cdao);
        SessionObject so = SessionObjectWrapper.createSessionObject((int)userid, (int)CalendarTest.getContext().getContextId(), (String)"myTestIdentifier");
        cdao.setContext(ContextStorage.getInstance().getContext(so.getContextId()));
        cdao.setIgnoreConflicts(true);
        int fid = CalendarTest.getCalendarDefaultFolderForUser(userid, CalendarTest.getContext());
        cdao.setGlobalFolderID(fid);
        CalendarSql csql = new CalendarSql((Session)so);
        csql.insertAppointmentObject(cdao);
        cdao.getObjectID();
    }

    public void testSetAlarmAndConfirmStateWithParticipantsAndChangeTime() throws Exception {
        CalendarDataObject tdao;
        String user2 = AbstractConfigWrapper.parseProperty((Properties)CalendarTest.getAJAXProperties(), (String)"user_participant3", (String)"");
        int userid2 = CalendarTest.resolveUser(user2);
        int fid = CalendarTest.getCalendarDefaultFolderForUser(userid, CalendarTest.getContext());
        int fid2 = CalendarTest.getCalendarDefaultFolderForUser(userid2, CalendarTest.getContext());
        SessionObject so = SessionObjectWrapper.createSessionObject((int)userid, (int)CalendarTest.getContext().getContextId(), (String)"myTestIdentifier");
        SessionObject so2 = SessionObjectWrapper.createSessionObject((int)userid2, (int)CalendarTest.getContext().getContextId(), (String)"myTestIdentifier");
        CalendarDataObject cdao = new CalendarDataObject();
        cdao.setContext(ContextStorage.getInstance().getContext(so.getContextId()));
        cdao.setParentFolderID(fid);
        cdao.setTitle("testSetAlarmAndConfirmStateWithParticipantsAndChangeTime");
        cdao.setIgnoreConflicts(true);
        CalendarTest.fillDatesInDao(cdao);
        UserParticipant userA = new UserParticipant(userid);
        userA.setAlarmMinutes(15);
        UserParticipant userB = new UserParticipant(userid2);
        cdao.setParticipants((Participant[])new UserParticipant[]{userA, userB});
        cdao.setUsers(new UserParticipant[]{userA, userB});
        CalendarSql csql = new CalendarSql((Session)so);
        CalendarSql csql2 = new CalendarSql((Session)so2);
        csql.insertAppointmentObject(cdao);
        int object_id = cdao.getObjectID();
        CalendarDataObject update_user2 = csql2.getObjectById(object_id, fid2);
        update_user2.setContext(CalendarTest.getContext());
        update_user2.setIgnoreConflicts(true);
        update_user2.setAlarm(30);
        csql2.updateAppointmentObject(update_user2, fid2, cdao.getLastModified());
        CalendarDataObject testobject = csql.getObjectById(object_id, fid);
        SearchIterator si = csql.getModifiedAppointmentsInFolder(fid, cols, CalendarTest.decrementDate(cdao.getLastModified()));
        boolean found = false;
        while (si.hasNext()) {
            CalendarDataObject tdao2 = (CalendarDataObject)si.next();
            if (tdao2.getObjectID() != object_id) continue;
            found = true;
            CalendarTest.assertTrue((String)"Check that userA has an alarm set in the cdao", (boolean)tdao2.containsAlarm());
            CalendarTest.assertEquals((String)"Check that we got the correct reminder", (int)15, (int)tdao2.getAlarm());
        }
        CalendarTest.assertTrue((String)"Found our object (userA)", (boolean)found);
        SearchIterator si2 = csql2.getModifiedAppointmentsInFolder(fid2, cols, CalendarTest.decrementDate(cdao.getLastModified()));
        found = false;
        while (si2.hasNext()) {
            CalendarDataObject tdao3 = (CalendarDataObject)si2.next();
            if (tdao3.getObjectID() != object_id) continue;
            found = true;
            CalendarTest.assertTrue((String)"Check that userB has an alarm set in the cdao", (boolean)tdao3.containsAlarm());
            CalendarTest.assertEquals((String)"Check that we got the correct reminder", (int)30, (int)tdao3.getAlarm());
        }
        CalendarTest.assertTrue((String)"Found our object (userB)", (boolean)found);
        CalendarDataObject update_with_time_change = testobject.clone();
        update_with_time_change.setContext(CalendarTest.getContext());
        update_with_time_change.setIgnoreConflicts(true);
        update_with_time_change.setObjectID(object_id);
        Date test_date = new Date(testobject.getStartDate().getTime() + 3600000L);
        update_with_time_change.setStartDate(test_date);
        update_with_time_change.setEndDate(new Date(testobject.getEndDate().getTime() + 3600000L));
        csql.updateAppointmentObject(update_with_time_change, fid, testobject.getLastModified());
        si = csql.getModifiedAppointmentsInFolder(fid, cols, CalendarTest.decrementDate(cdao.getLastModified()));
        found = false;
        while (si.hasNext()) {
            tdao = (CalendarDataObject)si.next();
            if (tdao.getObjectID() != object_id) continue;
            found = true;
            CalendarTest.assertTrue((String)"Check that userA has an alarm set in the cdao", (boolean)tdao.containsAlarm());
            CalendarTest.assertEquals((String)"Check that we got the correct reminder", (int)15, (int)tdao.getAlarm());
        }
        CalendarTest.assertTrue((String)"Found our object (userA)", (boolean)found);
        si2 = csql2.getModifiedAppointmentsInFolder(fid2, cols, CalendarTest.decrementDate(cdao.getLastModified()));
        found = false;
        while (si2.hasNext()) {
            tdao = (CalendarDataObject)si2.next();
            if (tdao.getObjectID() != object_id) continue;
            found = true;
            CalendarTest.assertTrue((String)"Check that userB has an alarm set in the cdao", (boolean)tdao.containsAlarm());
            CalendarTest.assertEquals((String)"Check that we got the correct reminder", (int)30, (int)tdao.getAlarm());
            UserParticipant[] up_test = tdao.getUsers();
            for (int a = 0; a < up_test.length; ++a) {
                Date check_date;
                ReminderObject ro;
                ReminderHandler rh;
                if (up_test[a].getIdentifier() == userid2) {
                    CalendarTest.assertEquals((String)"Check Confirm State", (int)0, (int)up_test[a].getConfirm());
                    rh = new ReminderHandler(CalendarTest.getContext());
                    ro = rh.loadReminder(object_id, userid2, 1);
                    check_date = ro.getDate();
                    CalendarTest.assertEquals((String)"Check correct Alarm", (Object)new Date(test_date.getTime() - 1800000L), (Object)check_date);
                    continue;
                }
                if (up_test[a].getIdentifier() != userid) continue;
                CalendarTest.assertEquals((String)"Check Confirm State", (int)1, (int)up_test[a].getConfirm());
                rh = new ReminderHandler(CalendarTest.getContext());
                ro = rh.loadReminder(object_id, userid, 1);
                check_date = ro.getDate();
                CalendarTest.assertEquals((String)"Check correct Alarm", (Object)new Date(test_date.getTime() - 900000L), (Object)check_date);
            }
        }
        CalendarTest.assertTrue((String)"Found our object (userB)", (boolean)found);
        CalendarDataObject test_fid = csql.getObjectById(object_id, fid);
        CalendarTest.assertEquals((String)"Check folder for userA", (int)fid, (int)test_fid.getParentFolderID());
        CalendarDataObject test_fid2 = csql2.getObjectById(object_id, fid2);
        CalendarTest.assertEquals((String)"Check folder for userB", (int)fid2, (int)test_fid2.getParentFolderID());
    }
}

