/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.dav.caldav.bugs;

import com.openexchange.dav.PropertyNames;
import com.openexchange.dav.caldav.CalDAVTest;
import java.util.HashSet;
import java.util.List;
import org.apache.jackrabbit.webdav.MultiStatusResponse;
import org.apache.jackrabbit.webdav.client.methods.PropFindMethod;
import org.apache.jackrabbit.webdav.property.DavPropertyNameSet;
import org.w3c.dom.Node;

public class Bug29554Test
extends CalDAVTest {
    public Bug29554Test(String name) {
        super(name);
    }

    public void testSupportedComponentSets() throws Exception {
        DavPropertyNameSet props = new DavPropertyNameSet();
        props.add(PropertyNames.SUPPORTED_CALENDAR_COMPONENT_SETS);
        PropFindMethod propFind = new PropFindMethod(this.getWebDAVClient().getBaseURI() + "/caldav/", 0, props, 0);
        MultiStatusResponse[] responses = this.getWebDAVClient().doPropFind(propFind);
        Bug29554Test.assertNotNull((String)"got no response", (Object)responses);
        Bug29554Test.assertTrue((String)"got no responses", (0 < responses.length ? 1 : 0) != 0);
        HashSet<String> comps = new HashSet<String>();
        for (MultiStatusResponse response : responses) {
            if (response.getProperties(200).contains(PropertyNames.SUPPORTED_CALENDAR_COMPONENT_SETS)) {
                List<Node> nodes = this.extractNodeListValue(PropertyNames.SUPPORTED_CALENDAR_COMPONENT_SETS, response);
                Bug29554Test.assertNotNull(nodes);
                for (Node node : nodes) {
                    comps.add(node.getChildNodes().item(0).getAttributes().getNamedItem("name").getTextContent());
                }
                continue;
            }
            Bug29554Test.fail((String)"no multistatus response");
        }
        Bug29554Test.assertTrue((String)"no VEVENT found", (boolean)comps.contains("VEVENT"));
        Bug29554Test.assertTrue((String)"no VTODO found", (boolean)comps.contains("VTODO"));
    }
}

