/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.subscribe.test;

import com.openexchange.ajax.folder.actions.FolderUpdatesResponse;
import com.openexchange.ajax.folder.actions.GetResponse;
import com.openexchange.ajax.framework.AbstractColumnsResponse;
import com.openexchange.ajax.subscribe.actions.NewSubscriptionRequest;
import com.openexchange.ajax.subscribe.actions.NewSubscriptionResponse;
import com.openexchange.ajax.subscribe.test.AbstractSubscriptionTest;
import com.openexchange.datatypes.genericonf.DynamicFormDescription;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.subscribe.Subscription;
import com.openexchange.test.FolderTestManager;
import java.util.Date;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SubscriptionFolderIconTest
extends AbstractSubscriptionTest {
    private static final int FLAG_SUBSCRIBED = 3020;
    private static final String KEY_SUBSCRIBED = "com.openexchange.subscribe.subscriptionFlag";
    private FolderTestManager fMgr;
    private FolderObject folder;

    public SubscriptionFolderIconTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.fMgr = this.getFolderManager();
        this.folder = this.fMgr.generatePublicFolder("publishedContacts", 3, this.getClient().getValues().getPrivateContactFolder(), this.getClient().getValues().getUserId());
        this.fMgr.insertFolderOnServer(this.folder);
        Contact contact = this.generateContact("Herbert", "Meier");
        contact.setParentFolderID(this.folder.getObjectID());
        this.getContactManager().newAction(contact);
    }

    protected void subscribe() throws Exception {
        DynamicFormDescription form = this.generateFormDescription();
        Subscription expected = this.generateOXMFSubscription(form);
        expected.setFolderId(String.valueOf(this.folder.getObjectID()));
        NewSubscriptionRequest newReq = new NewSubscriptionRequest(expected, form);
        NewSubscriptionResponse newResp = this.getClient().execute(newReq);
        SubscriptionFolderIconTest.assertFalse((String)("Should succeed creating the subscription: " + (Object)((Object)newResp.getException())), (boolean)newResp.hasError());
        expected.setId(newResp.getId());
    }

    public void testShouldSetTheIconViaGet() throws Exception {
        this.fMgr.getFolderFromServer(this.folder.getObjectID(), false, new int[]{3020});
        GetResponse response = (GetResponse)this.fMgr.getLastResponse();
        JSONObject data = (JSONObject)response.getData();
        SubscriptionFolderIconTest.assertTrue((String)"Should contain the key 'com.openexchange.subscribe.subscriptionFlag' even before publication", (boolean)data.has(KEY_SUBSCRIBED));
        SubscriptionFolderIconTest.assertFalse((String)"Key 'com.openexchange.subscribe.subscriptionFlag' should have 'false' value before publication", (boolean)data.getBoolean(KEY_SUBSCRIBED));
        this.subscribe();
        this.fMgr.getFolderFromServer(this.folder.getObjectID(), false, new int[]{3020});
        response = (GetResponse)this.fMgr.getLastResponse();
        data = (JSONObject)response.getData();
        SubscriptionFolderIconTest.assertTrue((String)"Should contain the key 'com.openexchange.subscribe.subscriptionFlag'", (boolean)data.has(KEY_SUBSCRIBED));
        SubscriptionFolderIconTest.assertTrue((String)"Key 'com.openexchange.subscribe.subscriptionFlag' should have 'true' value after publication", (boolean)data.getBoolean(KEY_SUBSCRIBED));
    }

    public void testShouldSetTheIconViaList() throws Exception {
        boolean published;
        int id;
        JSONArray subfolder;
        int i;
        this.fMgr.listFoldersOnServer(this.folder.getParentFolderID(), new int[]{3020});
        AbstractColumnsResponse response = (AbstractColumnsResponse)this.fMgr.getLastResponse();
        JSONArray folders = (JSONArray)response.getData();
        SubscriptionFolderIconTest.assertTrue((String)"Should return at least one folder", (folders.length() > 0 ? 1 : 0) != 0);
        boolean found = false;
        for (i = 0; i < folders.length(); ++i) {
            subfolder = folders.getJSONArray(i);
            id = subfolder.getInt(response.getColumnPos(1));
            published = subfolder.getBoolean(response.getColumnPos(3020));
            if (id != this.folder.getObjectID()) continue;
            found = true;
            SubscriptionFolderIconTest.assertFalse((String)("Folder " + id + " should not be published already"), (boolean)published);
        }
        SubscriptionFolderIconTest.assertTrue((String)("Should find folder " + this.folder.getObjectID() + " as a subfolder of " + this.folder.getParentFolderID() + "."), (boolean)found);
        this.subscribe();
        this.fMgr.listFoldersOnServer(this.folder.getParentFolderID(), new int[]{3020});
        response = (AbstractColumnsResponse)this.fMgr.getLastResponse();
        folders = (JSONArray)response.getData();
        SubscriptionFolderIconTest.assertTrue((String)"Should return at least one folder", (folders.length() > 0 ? 1 : 0) != 0);
        found = false;
        for (i = 0; i < folders.length(); ++i) {
            subfolder = folders.getJSONArray(i);
            id = subfolder.getInt(response.getColumnPos(1));
            published = subfolder.getBoolean(response.getColumnPos(3020));
            if (id != this.folder.getObjectID()) continue;
            found = true;
            SubscriptionFolderIconTest.assertTrue((String)("Folder " + id + " should not published"), (boolean)published);
        }
        SubscriptionFolderIconTest.assertTrue((String)("Should find folder " + this.folder.getObjectID() + " as a subfolder of " + this.folder.getParentFolderID() + "."), (boolean)found);
    }

    public void testShouldSetTheIconViaUpdates() throws Exception {
        Date lastModified = new Date(this.fMgr.getLastResponse().getTimestamp().getTime() - 1L);
        this.fMgr.getUpdatedFoldersOnServer(this.folder.getParentFolderID(), lastModified, new int[]{3020});
        FolderUpdatesResponse response = (FolderUpdatesResponse)this.fMgr.getLastResponse();
        int idPos = this.findPositionOfColumn(response.getColumns(), 1);
        int flagPos = this.findPositionOfColumn(response.getColumns(), 3020);
        JSONArray arr = (JSONArray)response.getData();
        SubscriptionFolderIconTest.assertTrue((String)"Should return at least one update", (arr.length() > 0 ? 1 : 0) != 0);
        int folderPos = this.findPosition(arr, this.folder.getObjectID(), idPos);
        JSONArray data = arr.getJSONArray(folderPos);
        SubscriptionFolderIconTest.assertFalse((String)"Should be false if not published", (boolean)data.getBoolean(flagPos));
        this.subscribe();
        lastModified = new Date(this.fMgr.getLastResponse().getTimestamp().getTime() - 1L);
        this.fMgr.getUpdatedFoldersOnServer(this.folder.getParentFolderID(), lastModified, new int[]{3020});
        response = (FolderUpdatesResponse)this.fMgr.getLastResponse();
        arr = (JSONArray)response.getData();
        SubscriptionFolderIconTest.assertTrue((String)"Should return at least one update", (arr.length() > 0 ? 1 : 0) != 0);
        folderPos = this.findPosition(arr, this.folder.getObjectID(), idPos);
        data = arr.getJSONArray(folderPos);
        SubscriptionFolderIconTest.assertTrue((String)"Should be true if published", (boolean)data.getBoolean(flagPos));
    }

    private int findPositionOfColumn(int[] haystack, int needle) {
        for (int i = 0; i < haystack.length; ++i) {
            if (haystack[i] != needle) continue;
            return i;
        }
        return -1;
    }

    private int findPosition(JSONArray arr, int objectID, int idPos) throws JSONException {
        for (int i = 0; i < arr.length(); ++i) {
            if (arr.getJSONArray(i).getInt(idPos) != objectID) continue;
            return i;
        }
        return -1;
    }
}

