/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.importexport;

import com.openexchange.ajax.importexport.AbstractICalTest;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.tasks.Task;
import com.openexchange.webdav.xml.AppointmentTest;
import com.openexchange.webdav.xml.TaskTest;

public class ICalExportTest
extends AbstractICalTest {
    public ICalExportTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testExportICalAppointment() throws Exception {
        String title = "testExportICalAppointment" + System.currentTimeMillis();
        Appointment appointmentObj = new Appointment();
        appointmentObj.setTitle(title);
        appointmentObj.setStartDate(this.startTime);
        appointmentObj.setEndDate(this.endTime);
        appointmentObj.setShownAs(1);
        appointmentObj.setParentFolderID(this.appointmentFolderId);
        appointmentObj.setIgnoreConflicts(true);
        int objectId = AppointmentTest.insertAppointment(this.getWebConversation(), appointmentObj, this.getHostName(), this.getLogin(), this.getPassword(), "");
        Appointment[] appointmentArray = this.exportAppointment(this.getWebConversation(), this.appointmentFolderId, this.timeZone, this.getHostName(), this.getSessionId(), null);
        boolean found = false;
        for (int a = 0; a < appointmentArray.length; ++a) {
            if (null == appointmentArray[a].getTitle() || !appointmentArray[a].getTitle().equals(title)) continue;
            found = true;
            appointmentObj.setUntil(appointmentArray[a].getUntil());
            appointmentArray[a].setParentFolderID(this.appointmentFolderId);
            AppointmentTest.compareObject(appointmentObj, appointmentArray[a]);
        }
        ICalExportTest.assertTrue((String)("appointment with title: " + title + " not found"), (boolean)found);
        AppointmentTest.deleteAppointment(this.getWebConversation(), objectId, this.appointmentFolderId, this.getHostName(), this.getLogin(), this.getPassword(), "");
    }

    public void testExportICalTask() throws Exception {
        String title = "testExportICalTask" + System.currentTimeMillis();
        Task taskObj = new Task();
        taskObj.setTitle(title);
        taskObj.setStartDate(this.startTime);
        taskObj.setEndDate(this.endTime);
        taskObj.setParentFolderID(this.taskFolderId);
        int objectId = TaskTest.insertTask(this.getWebConversation(), taskObj, this.getHostName(), this.getLogin(), this.getPassword(), "");
        Task[] taskArray = this.exportTask(this.getWebConversation(), this.taskFolderId, this.emailaddress, this.timeZone, this.getHostName(), this.getSessionId(), null);
        boolean found = false;
        for (int a = 0; a < taskArray.length; ++a) {
            if (!title.equals(taskArray[a].getTitle())) continue;
            found = true;
            taskObj.setStartDate(taskArray[a].getStartDate());
            taskArray[a].setParentFolderID(this.taskFolderId);
            TaskTest.compareObject(taskObj, taskArray[a]);
        }
        ICalExportTest.assertTrue((String)("task with id: " + objectId + " not found"), (boolean)found);
        TaskTest.deleteTask(this.getWebConversation(), objectId, this.taskFolderId, this.getHostName(), this.getLogin(), this.getPassword(), "");
    }
}

