/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.contact;

import com.openexchange.ajax.contact.AbstractManagedContactTest;
import com.openexchange.ajax.contact.action.UpdateRequest;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.container.DistributionListEntryObject;
import java.util.ArrayList;
import org.json.JSONException;
import org.json.JSONObject;

public class DistListMemberUpdateTest
extends AbstractManagedContactTest {
    private Contact referencedContact1;
    private Contact referencedContact2;

    public DistListMemberUpdateTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.referencedContact1 = super.generateContact("Test1");
        this.referencedContact1.setEmail1("email1@example.com");
        this.referencedContact1.setEmail2("email2@example.com");
        this.referencedContact1.setEmail3("email3@example.com");
        this.referencedContact1 = this.manager.newAction(this.referencedContact1);
        this.referencedContact2 = super.generateContact("Test2");
        this.referencedContact2.setEmail1("email1@example.org");
        this.referencedContact2.setEmail2("email2@example.org");
        this.referencedContact2.setEmail3("email3@example.org");
        this.referencedContact2 = this.manager.newAction(this.referencedContact2);
    }

    private Contact createDistributionList(int mailField, Contact ... referencedContacts) throws OXException {
        Contact distributionList = super.generateContact("List");
        ArrayList<DistributionListEntryObject> members = new ArrayList<DistributionListEntryObject>();
        for (Contact referencedContact : referencedContacts) {
            DistributionListEntryObject member = new DistributionListEntryObject();
            member.setEntryID(referencedContact.getObjectID());
            member.setEmailfield(mailField);
            member.setFolderID(referencedContact.getParentFolderID());
            member.setDisplayname(referencedContact.getDisplayName());
            if (1 == mailField) {
                member.setEmailaddress(referencedContact.getEmail1());
            } else if (2 == mailField) {
                member.setEmailaddress(referencedContact.getEmail2());
            } else if (3 == mailField) {
                member.setEmailaddress(referencedContact.getEmail3());
            } else {
                throw new IllegalArgumentException();
            }
            members.add(member);
        }
        distributionList.setDistributionList(members.toArray(new DistributionListEntryObject[0]));
        return this.manager.newAction(distributionList);
    }

    public void testUpdateEMail1() throws OXException {
        Contact distributionList = this.createDistributionList(1, this.referencedContact1, this.referencedContact2);
        this.referencedContact1.setEmail1("update_" + this.referencedContact1.getEmail1());
        this.manager.updateAction(this.referencedContact1);
        distributionList = this.manager.getAction(distributionList);
        DistListMemberUpdateTest.assertMatches(distributionList.getDistributionList(), this.referencedContact1, this.referencedContact2);
        this.referencedContact2.setEmail1("update_" + this.referencedContact2.getEmail1());
        this.manager.updateAction(this.referencedContact2);
        distributionList = this.manager.getAction(distributionList);
        DistListMemberUpdateTest.assertMatches(distributionList.getDistributionList(), this.referencedContact1, this.referencedContact2);
    }

    public void testUpdateEMail2() throws OXException {
        Contact distributionList = this.createDistributionList(2, this.referencedContact1, this.referencedContact2);
        this.referencedContact1.setEmail2("update_" + this.referencedContact1.getEmail2());
        this.manager.updateAction(this.referencedContact1);
        distributionList = this.manager.getAction(distributionList);
        DistListMemberUpdateTest.assertMatches(distributionList.getDistributionList(), this.referencedContact1, this.referencedContact2);
        this.referencedContact2.setEmail2("update_" + this.referencedContact2.getEmail2());
        this.manager.updateAction(this.referencedContact2);
        distributionList = this.manager.getAction(distributionList);
        DistListMemberUpdateTest.assertMatches(distributionList.getDistributionList(), this.referencedContact1, this.referencedContact2);
    }

    public void testUpdateEMail3() throws OXException {
        Contact distributionList = this.createDistributionList(3, this.referencedContact1, this.referencedContact2);
        this.referencedContact1.setEmail3("update_" + this.referencedContact1.getEmail1());
        this.manager.updateAction(this.referencedContact1);
        distributionList = this.manager.getAction(distributionList);
        DistListMemberUpdateTest.assertMatches(distributionList.getDistributionList(), this.referencedContact1, this.referencedContact2);
        this.referencedContact2.setEmail3("update_" + this.referencedContact2.getEmail3());
        this.manager.updateAction(this.referencedContact2);
        distributionList = this.manager.getAction(distributionList);
        DistListMemberUpdateTest.assertMatches(distributionList.getDistributionList(), this.referencedContact1, this.referencedContact2);
    }

    public void testRemoveEMail1() throws Exception {
        Contact distributionList = this.createDistributionList(1, this.referencedContact1, this.referencedContact2);
        this.referencedContact1.setEmail1(null);
        this.updateContact(this.referencedContact1, this.referencedContact1.getParentFolderID());
        distributionList = this.manager.getAction(distributionList);
        DistListMemberUpdateTest.assertMatches(distributionList.getDistributionList(), this.referencedContact1, this.referencedContact2);
        this.referencedContact2.setEmail1(null);
        this.updateContact(this.referencedContact2, this.referencedContact2.getParentFolderID());
        distributionList = this.manager.getAction(distributionList);
        DistListMemberUpdateTest.assertMatches(distributionList.getDistributionList(), this.referencedContact1, this.referencedContact2);
    }

    public void testRemoveEMail2() throws Exception {
        Contact distributionList = this.createDistributionList(2, this.referencedContact1, this.referencedContact2);
        this.referencedContact1.setEmail2(null);
        this.updateContact(this.referencedContact1, this.referencedContact1.getParentFolderID());
        distributionList = this.manager.getAction(distributionList);
        DistListMemberUpdateTest.assertMatches(distributionList.getDistributionList(), this.referencedContact1, this.referencedContact2);
        this.referencedContact2.setEmail2(null);
        this.updateContact(this.referencedContact2, this.referencedContact2.getParentFolderID());
        distributionList = this.manager.getAction(distributionList);
        DistListMemberUpdateTest.assertMatches(distributionList.getDistributionList(), this.referencedContact1, this.referencedContact2);
    }

    public void testRemoveEMail3() throws Exception {
        Contact distributionList = this.createDistributionList(3, this.referencedContact1, this.referencedContact2);
        this.referencedContact1.setEmail3(null);
        this.updateContact(this.referencedContact1, this.referencedContact1.getParentFolderID());
        distributionList = this.manager.getAction(distributionList);
        DistListMemberUpdateTest.assertMatches(distributionList.getDistributionList(), this.referencedContact1, this.referencedContact2);
        this.referencedContact2.setEmail3(null);
        this.updateContact(this.referencedContact2, this.referencedContact2.getParentFolderID());
        distributionList = this.manager.getAction(distributionList);
        DistListMemberUpdateTest.assertMatches(distributionList.getDistributionList(), this.referencedContact1, this.referencedContact2);
    }

    private static void assertMatches(DistributionListEntryObject[] members, Contact ... contacts) {
        for (Contact contact : contacts) {
            boolean found = false;
            for (DistributionListEntryObject member : members) {
                if (contact.getObjectID() != member.getEntryID()) continue;
                found = true;
                String referencedMail = null;
                if (1 == member.getEmailfield()) {
                    referencedMail = contact.getEmail1();
                } else if (2 == member.getEmailfield()) {
                    referencedMail = contact.getEmail2();
                } else if (3 == member.getEmailfield()) {
                    referencedMail = contact.getEmail3();
                } else {
                    DistListMemberUpdateTest.fail((String)"wrong mailfiled set in member");
                }
                DistListMemberUpdateTest.assertEquals((String)"referenced mail wrong", (String)member.getEmailaddress(), (String)referencedMail);
            }
            DistListMemberUpdateTest.assertTrue((String)"contact not found in distlist members", (boolean)found);
        }
    }

    private void updateContact(Contact contact, int inFolder) throws Exception {
        UpdateRequest request = new UpdateRequest(inFolder, contact, true);
        JSONObject jsonObject = (JSONObject)request.getBody();
        jsonObject = this.setEmail(jsonObject, contact.getEmail1(), contact.getEmail2(), contact.getEmail3());
        EmptyEmailUpdateRequest modifiedRequest = new EmptyEmailUpdateRequest(contact, jsonObject);
        this.client.execute(modifiedRequest);
    }

    private JSONObject setEmail(JSONObject jo, String email1, String email2, String email3) throws JSONException {
        jo.put("email1", email1 == null ? JSONObject.NULL : email1);
        jo.put("email2", email2 == null ? JSONObject.NULL : email3);
        jo.put("email3", email3 == null ? JSONObject.NULL : email3);
        return jo;
    }

    private class EmptyEmailUpdateRequest
    extends UpdateRequest {
        private JSONObject modifiedBody;

        public EmptyEmailUpdateRequest(Contact contactObj) {
            super(contactObj);
        }

        public EmptyEmailUpdateRequest(Contact co, JSONObject jo) {
            super(co);
            this.modifiedBody = jo;
        }

        @Override
        public Object getBody() throws JSONException {
            return this.modifiedBody;
        }
    }
}

