/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment.recurrence;

import com.openexchange.ajax.appointment.recurrence.ManagedAppointmentTest;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.Changes;
import com.openexchange.groupware.container.CommonObject;
import com.openexchange.groupware.container.Expectations;

public class TestsForUsingRecurrencePositionToGetChangeExceptions
extends ManagedAppointmentTest {
    private Appointment app;
    private Changes changes;
    private Appointment update;

    public TestsForUsingRecurrencePositionToGetChangeExceptions(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.app = this.generateDailyAppointment();
        this.app.setOccurrence(3);
        this.calendarManager.insert(this.app);
        this.changes = new Changes();
        this.changes.put(207, (Object)2);
        this.changes.put(201, (Object)this.D("2/1/2008 1:00", this.utc));
        this.changes.put(202, (Object)this.D("2/1/2008 2:00", this.utc));
        this.update = this.app.clone();
        this.changes.update((CommonObject)this.update);
        this.calendarManager.update(this.update);
    }

    public void testShouldFindUnchangedFirstOccurrence() throws OXException {
        Appointment actual = this.calendarManager.get(this.folder.getObjectID(), this.app.getObjectID(), 1);
        Expectations expectations = new Expectations();
        expectations.put(201, (Object)this.D("1/1/2008 1:00"));
        expectations.put(202, (Object)this.D("1/1/2008 2:00"));
        expectations.verify((CommonObject)actual);
    }

    public void testShouldFindSomethingElseAsSecondOccurrenceButDoesNot() throws OXException {
        Appointment actual = this.calendarManager.get(this.folder.getObjectID(), this.app.getObjectID(), 2);
        Expectations expectations = new Expectations();
        expectations.put(201, (Object)this.D("2/1/2008 1:00"));
        expectations.put(202, (Object)this.D("2/1/2008 2:00"));
        expectations.verify((CommonObject)actual);
    }

    public void testShouldFindUnchangedLastOccurrence() throws OXException {
        Appointment actual = this.calendarManager.get(this.folder.getObjectID(), this.app.getObjectID(), 3);
        Expectations expectations = new Expectations();
        expectations.put(201, (Object)this.D("3/1/2008 1:00"));
        expectations.put(202, (Object)this.D("3/1/2008 2:00"));
        expectations.verify((CommonObject)actual);
    }
}

