/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment;

import com.openexchange.ajax.AppointmentTest;
import com.openexchange.ajax.appointment.action.DeleteRequest;
import com.openexchange.ajax.appointment.action.InsertRequest;
import com.openexchange.ajax.folder.Create;
import com.openexchange.ajax.folder.actions.API;
import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.CommonInsertResponse;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.DataObject;
import com.openexchange.groupware.container.FolderObject;
import java.util.Date;

public class UserStory1085Test
extends AppointmentTest {
    private AJAXClient clientA;
    private AJAXClient clientB;
    private AJAXClient clientC;
    private int userIdA;
    private int userIdB;
    private int userIdC;
    private FolderObject folder;
    private Appointment appointmenShare;
    private Appointment appointmentNormal;
    private Appointment appointmentPrivate;
    private Date start;
    private Date end;

    public UserStory1085Test(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.clientA = this.getClient();
        this.clientB = new AJAXClient(AJAXClient.User.User2);
        this.clientC = new AJAXClient(AJAXClient.User.User3);
        this.userIdA = this.clientA.getValues().getUserId();
        this.userIdB = this.clientB.getValues().getUserId();
        this.userIdC = this.clientC.getValues().getUserId();
        this.folder = Create.folder(1, "UserStory1085Test - " + Long.toString(System.currentTimeMillis()), 2, 1, Create.ocl(this.userIdB, false, true, 128, 128, 128, 128), Create.ocl(this.userIdA, false, false, 128, 128, 128, 128));
        CommonInsertResponse response = this.clientB.execute(new com.openexchange.ajax.folder.actions.InsertRequest(EnumAPI.OX_OLD, this.folder));
        response.fillObject((DataObject)this.folder);
        this.appointmenShare = new Appointment();
        this.appointmenShare.setTitle("Full");
        this.appointmenShare.setStartDate(TimeTools.D("01.02.2009 12:00"));
        this.appointmenShare.setEndDate(TimeTools.D("01.02.2009 14:00"));
        this.appointmenShare.setParentFolderID(this.folder.getObjectID());
        this.appointmenShare.setIgnoreConflicts(true);
        CommonInsertResponse insertResponse = this.clientB.execute(new InsertRequest(this.appointmenShare, this.clientB.getValues().getTimeZone()));
        insertResponse.fillObject((DataObject)this.appointmenShare);
        this.appointmentPrivate = new Appointment();
        this.appointmentPrivate.setTitle("Title of private flagged appointment");
        this.appointmentPrivate.setStartDate(TimeTools.D("01.02.2009 12:00"));
        this.appointmentPrivate.setEndDate(TimeTools.D("01.02.2009 14:00"));
        this.appointmentPrivate.setPrivateFlag(true);
        this.appointmentPrivate.setIgnoreConflicts(true);
        this.appointmentPrivate.setParentFolderID(this.clientC.getValues().getPrivateAppointmentFolder());
        insertResponse = this.clientC.execute(new InsertRequest(this.appointmentPrivate, this.clientC.getValues().getTimeZone()));
        insertResponse.fillObject((DataObject)this.appointmentPrivate);
        this.appointmentNormal = new Appointment();
        this.appointmentNormal.setTitle("Title of appointment in not shared folder");
        this.appointmentNormal.setStartDate(TimeTools.D("01.02.2009 12:00"));
        this.appointmentNormal.setEndDate(TimeTools.D("01.02.2009 14:00"));
        this.appointmentNormal.setIgnoreConflicts(true);
        this.appointmentNormal.setParentFolderID(this.clientC.getValues().getPrivateAppointmentFolder());
        insertResponse = this.clientC.execute(new InsertRequest(this.appointmentNormal, this.clientC.getValues().getTimeZone()));
        insertResponse.fillObject((DataObject)this.appointmentNormal);
        this.start = TimeTools.D("01.02.2009 00:00");
        this.end = TimeTools.D("02.02.2009 00:00");
    }

    @Override
    public void tearDown() throws Exception {
        this.clientB.execute(new DeleteRequest(this.appointmenShare));
        this.clientC.execute(new DeleteRequest(this.appointmentPrivate));
        this.clientC.execute(new DeleteRequest(this.appointmentNormal));
        this.clientB.execute(new com.openexchange.ajax.folder.actions.DeleteRequest((API)EnumAPI.OX_OLD, this.folder.getObjectID(), this.folder.getLastModified()));
        super.tearDown();
    }

    public void testUserStory1085() throws Exception {
        Appointment[] appointmentsB = UserStory1085Test.getFreeBusy(this.getWebConversation(), this.userIdB, 1, this.start, this.end, this.clientB.getValues().getTimeZone(), this.getHostName(), this.getSessionId());
        Appointment[] appointmentsC = UserStory1085Test.getFreeBusy(this.getWebConversation(), this.userIdC, 1, this.start, this.end, this.clientB.getValues().getTimeZone(), this.getHostName(), this.getSessionId());
        boolean foundShare = false;
        boolean foundPrivate = false;
        boolean foundNormal = false;
        for (Appointment app : appointmentsB) {
            if (app.getObjectID() != this.appointmenShare.getObjectID()) continue;
            foundShare = true;
            this.validateShare(app);
        }
        for (Appointment app : appointmentsC) {
            if (app.getObjectID() == this.appointmentNormal.getObjectID()) {
                foundNormal = true;
                this.validateNormal(app);
                continue;
            }
            if (app.getObjectID() != this.appointmentPrivate.getObjectID()) continue;
            foundPrivate = true;
            this.validatePrivate(app);
        }
        UserStory1085Test.assertTrue((String)"Missing appointment", (boolean)foundShare);
        UserStory1085Test.assertTrue((String)"Missing appointment", (boolean)foundPrivate);
        UserStory1085Test.assertTrue((String)"Missing appointment", (boolean)foundNormal);
    }

    private void validatePrivate(Appointment app) {
        UserStory1085Test.assertFalse((String)("No title for private flagged appointment expected but found: " + app.getTitle()), (boolean)this.appointmentPrivate.getTitle().equals(app.getTitle()));
        UserStory1085Test.assertFalse((String)"No folderId expected", (boolean)app.containsParentFolderID());
    }

    private void validateNormal(Appointment app) {
        UserStory1085Test.assertFalse((String)("No title for appointment in not shared folder expected but found: " + app.getTitle()), (boolean)this.appointmentNormal.getTitle().equals(app.getTitle()));
        UserStory1085Test.assertFalse((String)"No folderId expected", (boolean)app.containsParentFolderID());
    }

    private void validateShare(Appointment app) {
        UserStory1085Test.assertEquals((String)"Missing or wrong folderId in Appointment", (int)this.folder.getObjectID(), (int)app.getParentFolderID());
    }
}

