/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment;

import com.openexchange.ajax.AppointmentTest;
import com.openexchange.ajax.ContactTest;
import com.openexchange.ajax.ResourceTest;
import com.openexchange.ajax.appointment.action.GetRequest;
import com.openexchange.ajax.appointment.action.GetResponse;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AJAXSession;
import com.openexchange.ajax.framework.Executor;
import com.openexchange.ajax.group.GroupTest;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.container.GroupParticipant;
import com.openexchange.groupware.container.Participant;
import com.openexchange.groupware.container.ResourceParticipant;
import com.openexchange.groupware.container.UserParticipant;
import com.openexchange.groupware.search.ContactSearchObject;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.json.JSONObject;

public class GetTest
extends AppointmentTest {
    public GetTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testGet() throws Exception {
        Appointment appointmentObj = this.createAppointmentObject("testGet");
        appointmentObj.setOrganizer(AJAXClient.User.User1.name());
        int objectId = GetTest.insertAppointment(this.getWebConversation(), appointmentObj, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        Appointment loadAppointment = GetTest.loadAppointment(this.getWebConversation(), objectId, appointmentFolderId, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        appointmentObj.setObjectID(objectId);
        this.compareObject(appointmentObj, loadAppointment, appointmentObj.getStartDate().getTime(), appointmentObj.getEndDate().getTime());
        GetTest.deleteAppointment(this.getWebConversation(), objectId, appointmentFolderId, "http://" + this.getHostName(), this.getSessionId(), false);
    }

    public void testGetWithParticipants() throws Exception {
        Appointment appointmentObj = this.createAppointmentObject("testGetWithParticipants");
        ContactSearchObject cso = new ContactSearchObject();
        cso.setEmail1(this.userParticipant3);
        Contact[] contacts = ContactTest.searchContactAdvanced(this.getWebConversation(), cso, 6, new int[]{524}, "http://" + this.getHostName(), this.getSessionId());
        GetTest.assertTrue((String)(this.userParticipant3 + " not found"), (null != contacts && 0 < contacts.length ? 1 : 0) != 0);
        GetTest.assertTrue((String)("multiple results for " + this.userParticipant3), (1 == contacts.length ? 1 : 0) != 0);
        int userParticipantId = contacts[0].getInternalUserId();
        int groupParticipantId = GroupTest.searchGroup(this.getWebConversation(), this.groupParticipant, "http://", this.getHostName(), this.getSessionId())[0].getIdentifier();
        int resourceParticipantId = ResourceTest.searchResource(this.getWebConversation(), this.resourceParticipant, "http://" + this.getHostName(), this.getSessionId())[0].getIdentifier();
        Participant[] participants = new Participant[]{new UserParticipant(this.userId), new UserParticipant(userParticipantId), new GroupParticipant(groupParticipantId), new ResourceParticipant(resourceParticipantId)};
        appointmentObj.setParticipants(participants);
        int objectId = GetTest.insertAppointment(this.getWebConversation(), appointmentObj, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        Appointment loadAppointment = GetTest.loadAppointment(this.getWebConversation(), objectId, appointmentFolderId, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        appointmentObj.setObjectID(objectId);
        this.compareObject(appointmentObj, loadAppointment, appointmentObj.getStartDate().getTime(), appointmentObj.getEndDate().getTime());
        GetTest.deleteAppointment(this.getWebConversation(), objectId, appointmentFolderId, "http://" + this.getHostName(), this.getSessionId(), false);
    }

    public void testGetWithAllFields() throws Exception {
        Appointment appointmentObj = new Appointment();
        appointmentObj.setTitle("testGetWithAllFields");
        appointmentObj.setStartDate(new Date(startTime));
        appointmentObj.setEndDate(new Date(endTime));
        appointmentObj.setLocation("Location");
        appointmentObj.setShownAs(4);
        appointmentObj.setParentFolderID(appointmentFolderId);
        appointmentObj.setPrivateFlag(false);
        appointmentObj.setFullTime(true);
        appointmentObj.setLabel(2);
        appointmentObj.setNote("note");
        appointmentObj.setCategories("testcat1,testcat2,testcat3");
        int userParticipantId = ContactTest.searchContact(this.getWebConversation(), this.userParticipant3, 6, new int[]{524}, "http://" + this.getHostName(), this.getSessionId())[0].getInternalUserId();
        int groupParticipantId = GroupTest.searchGroup(this.getWebConversation(), this.groupParticipant, "http://", this.getHostName(), this.getSessionId())[0].getIdentifier();
        int resourceParticipantId = ResourceTest.searchResource(this.getWebConversation(), this.resourceParticipant, "http://" + this.getHostName(), this.getSessionId())[0].getIdentifier();
        Participant[] participants = new Participant[]{new UserParticipant(this.userId), new UserParticipant(userParticipantId), new GroupParticipant(groupParticipantId), new ResourceParticipant(resourceParticipantId)};
        appointmentObj.setParticipants(participants);
        int objectId = GetTest.insertAppointment(this.getWebConversation(), appointmentObj, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        Appointment loadAppointment = GetTest.loadAppointment(this.getWebConversation(), objectId, appointmentFolderId, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        Calendar c = Calendar.getInstance();
        c.setTimeZone(TimeZone.getTimeZone("UTC"));
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        long newStartTime = c.getTimeInMillis();
        long newEndTime = newStartTime + 86400000L;
        appointmentObj.setObjectID(objectId);
        this.compareObject(appointmentObj, loadAppointment, newStartTime, newEndTime);
        GetTest.deleteAppointment(this.getWebConversation(), objectId, appointmentFolderId, "http://" + this.getHostName(), this.getSessionId(), false);
    }

    public void testGetWithAllFieldsOnUpdate() throws Exception {
        Appointment appointmentObj = new Appointment();
        appointmentObj.setTitle("testGetWithAllFieldsOnUpdate");
        appointmentObj.setStartDate(new Date(startTime));
        appointmentObj.setEndDate(new Date(endTime));
        appointmentObj.setParentFolderID(appointmentFolderId);
        appointmentObj.setIgnoreConflicts(true);
        int objectId = GetTest.insertAppointment(this.getWebConversation(), appointmentObj, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        appointmentObj.setLocation("Location");
        appointmentObj.setShownAs(4);
        appointmentObj.setPrivateFlag(false);
        appointmentObj.setFullTime(true);
        appointmentObj.setLabel(2);
        appointmentObj.setNote("note");
        appointmentObj.setCategories("testcat1,testcat2,testcat3");
        int userParticipantId = ContactTest.searchContact(this.getWebConversation(), this.userParticipant3, 6, new int[]{524}, "http://" + this.getHostName(), this.getSessionId())[0].getInternalUserId();
        int groupParticipantId = GroupTest.searchGroup(this.getWebConversation(), this.groupParticipant, "http://", this.getHostName(), this.getSessionId())[0].getIdentifier();
        int resourceParticipantId = ResourceTest.searchResource(this.getWebConversation(), this.resourceParticipant, "http://" + this.getHostName(), this.getSessionId())[0].getIdentifier();
        Participant[] participants = new Participant[]{new UserParticipant(this.userId), new UserParticipant(userParticipantId), new GroupParticipant(groupParticipantId), new ResourceParticipant(resourceParticipantId)};
        appointmentObj.setParticipants(participants);
        appointmentObj.removeParentFolderID();
        GetTest.updateAppointment(this.getWebConversation(), appointmentObj, objectId, appointmentFolderId, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        Appointment loadAppointment = GetTest.loadAppointment(this.getWebConversation(), objectId, appointmentFolderId, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        Calendar c = Calendar.getInstance();
        c.setTimeZone(TimeZone.getTimeZone("UTC"));
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        long newStartTime = c.getTimeInMillis();
        long newEndTime = newStartTime + 86400000L;
        appointmentObj.setObjectID(objectId);
        appointmentObj.setParentFolderID(appointmentFolderId);
        this.compareObject(appointmentObj, loadAppointment, newStartTime, newEndTime);
        GetTest.deleteAppointment(this.getWebConversation(), objectId, appointmentFolderId, "http://" + this.getHostName(), this.getSessionId(), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLastModifiedUTC() throws Exception {
        AJAXClient client = new AJAXClient(new AJAXSession(this.getWebConversation(), this.getHostName(), this.getSessionId()), false);
        Appointment appointmentObj = this.createAppointmentObject("testShowLastModifiedUTC");
        appointmentObj.setStartDate(new Date());
        appointmentObj.setEndDate(new Date(System.currentTimeMillis() + 3600000L));
        appointmentObj.setIgnoreConflicts(true);
        int objectId = GetTest.insertAppointment(this.getWebConversation(), appointmentObj, this.timeZone, this.getHostName(), this.getSessionId());
        try {
            GetRequest getRequest = new GetRequest(appointmentFolderId, objectId);
            GetResponse response = Executor.execute(client, getRequest);
            JSONObject appointment = (JSONObject)response.getResponse().getData();
            GetTest.assertNotNull((Object)appointment);
            GetTest.assertTrue((boolean)appointment.has("last_modified_utc"));
        }
        finally {
            GetTest.deleteAppointment(this.getWebConversation(), objectId, appointmentFolderId, this.getHostName(), this.getSessionId(), false);
        }
    }
}

