/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.subscribe.osgi;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.subscribe.CompositeSubscriptionSourceDiscoveryService;
import com.openexchange.subscribe.SubscriptionSource;
import com.openexchange.subscribe.SubscriptionSourceDiscoveryService;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class OSGiSubscriptionSourceDiscoveryCollector
implements ServiceTrackerCustomizer,
SubscriptionSourceDiscoveryService {
    private final BundleContext context;
    private final ServiceTracker tracker;
    private final List<ServiceReference> references = new ArrayList<ServiceReference>();
    private final CompositeSubscriptionSourceDiscoveryService delegate = new CompositeSubscriptionSourceDiscoveryService();
    private final Set<SubscriptionSourceDiscoveryService> blacklist = new HashSet<SubscriptionSourceDiscoveryService>();

    public OSGiSubscriptionSourceDiscoveryCollector(BundleContext context) {
        this.context = context;
        this.tracker = new ServiceTracker(context, SubscriptionSourceDiscoveryService.class.getName(), (ServiceTrackerCustomizer)this);
        this.tracker.open();
    }

    public void close() {
        this.delegate.clear();
        for (ServiceReference reference : this.references) {
            this.context.ungetService(reference);
        }
        this.tracker.close();
    }

    public Object addingService(ServiceReference reference) {
        SubscriptionSourceDiscoveryService service = (SubscriptionSourceDiscoveryService)this.context.getService(reference);
        if (this.blacklist.contains(service) || service.getClass() == this.getClass()) {
            this.context.ungetService(reference);
            return service;
        }
        this.delegate.addSubscriptionSourceDiscoveryService(service);
        return service;
    }

    public void modifiedService(ServiceReference reference, Object service) {
    }

    public void removedService(ServiceReference reference, Object service) {
        this.delegate.removeSubscriptionSourceDiscoveryService((SubscriptionSourceDiscoveryService)service);
        this.references.remove(reference);
        this.context.ungetService(reference);
    }

    @Override
    public SubscriptionSource getSource(Context context, int subscriptionId) throws OXException {
        return this.delegate.getSource(context, subscriptionId);
    }

    @Override
    public SubscriptionSource getSource(String identifier) {
        return this.delegate.getSource(identifier);
    }

    @Override
    public List<SubscriptionSource> getSources() {
        return this.delegate.getSources();
    }

    @Override
    public List<SubscriptionSource> getSources(int folderModule) {
        return this.delegate.getSources(folderModule);
    }

    @Override
    public boolean knowsSource(String identifier) {
        return this.delegate.knowsSource(identifier);
    }

    @Override
    public SubscriptionSourceDiscoveryService filter(int user, int context) throws OXException {
        return this.delegate.filter(user, context);
    }

    public void addSubscriptionSourceDiscoveryService(SubscriptionSourceDiscoveryService service) {
        this.delegate.addSubscriptionSourceDiscoveryService(service);
    }

    public void removeSubscriptionSourceDiscoveryService(SubscriptionSourceDiscoveryService service) {
        this.delegate.removeSubscriptionSourceDiscoveryService(service);
    }
}

