/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.subscribe;

import com.openexchange.crypto.CryptoService;
import com.openexchange.exception.OXException;
import com.openexchange.folder.FolderService;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.userconfiguration.UserPermissionBits;
import com.openexchange.java.Strings;
import com.openexchange.secret.SecretEncryptionFactoryService;
import com.openexchange.secret.SecretEncryptionService;
import com.openexchange.secret.SecretEncryptionStrategy;
import com.openexchange.server.impl.EffectivePermission;
import com.openexchange.server.impl.OCLPermission;
import com.openexchange.session.Session;
import com.openexchange.subscribe.EncryptedField;
import com.openexchange.subscribe.SubscribeService;
import com.openexchange.subscribe.Subscription;
import com.openexchange.subscribe.SubscriptionErrorMessage;
import com.openexchange.subscribe.SubscriptionSource;
import com.openexchange.subscribe.SubscriptionStorage;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.iterator.SearchIteratorDelegator;
import com.openexchange.tools.oxfolder.OXFolderAccess;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.session.ServerSessionAdapter;
import com.openexchange.userconf.UserPermissionService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.json.JSONObject;

public abstract class AbstractSubscribeService
implements SubscribeService {
    public static final AtomicReference<SubscriptionStorage> STORAGE = new AtomicReference();
    public static final AtomicReference<SecretEncryptionFactoryService> ENCRYPTION_FACTORY = new AtomicReference();
    public static final AtomicReference<CryptoService> CRYPTO_SERVICE = new AtomicReference();
    public static final AtomicReference<FolderService> FOLDERS = new AtomicReference();
    public static final AtomicReference<UserPermissionService> USER_PERMISSIONS = new AtomicReference();

    @Override
    public Collection<Subscription> loadSubscriptions(Context ctx, String folderId, String secret) throws OXException {
        List<Subscription> allSubscriptions = STORAGE.get().getSubscriptions(ctx, folderId);
        return this.prepareSubscriptions(allSubscriptions, secret, ctx, -1);
    }

    @Override
    public Collection<Subscription> loadSubscriptions(Context context, int userId, String secret) throws OXException {
        List<Subscription> allSubscriptions = STORAGE.get().getSubscriptionsOfUser(context, userId);
        return this.prepareSubscriptions(allSubscriptions, secret, context, userId);
    }

    private Collection<Subscription> prepareSubscriptions(List<Subscription> allSubscriptions, String secret, Context context, int userId) throws OXException {
        ArrayList<Subscription> subscriptions = new ArrayList<Subscription>();
        HashMap<String, Boolean> canSee = new HashMap<String, Boolean>();
        for (Subscription subscription : allSubscriptions) {
            if (subscription.getSource() == null || this.getSubscriptionSource() == null || !subscription.getSource().getId().equals(this.getSubscriptionSource().getId())) continue;
            if (userId == -1) {
                subscriptions.add(subscription);
                continue;
            }
            if (canSee.containsKey(subscription.getFolderId()) && ((Boolean)canSee.get(subscription.getFolderId())).booleanValue()) {
                subscriptions.add(subscription);
                continue;
            }
            EffectivePermission folderPermission = FOLDERS.get().getFolderPermission(Integer.parseInt(subscription.getFolderId()), userId, context.getContextId());
            boolean visible = folderPermission.isFolderVisible();
            canSee.put(subscription.getFolderId(), visible);
            if (!visible) continue;
            subscriptions.add(subscription);
        }
        for (Subscription subscription : subscriptions) {
            subscription.setSecret(secret);
            this.modifyOutgoing(subscription);
        }
        return subscriptions;
    }

    @Override
    public Subscription loadSubscription(Context ctx, int subscriptionId, String secret) throws OXException {
        Subscription subscription = STORAGE.get().getSubscription(ctx, subscriptionId);
        if (null == subscription) {
            return null;
        }
        subscription.setSecret(secret);
        this.modifyOutgoing(subscription);
        return subscription;
    }

    @Override
    public void subscribe(Subscription subscription) throws OXException {
        this.checkCreate(subscription);
        this.modifyIncoming(subscription);
        STORAGE.get().rememberSubscription(subscription);
        this.modifyOutgoing(subscription);
    }

    @Override
    public void unsubscribe(Subscription subscription) throws OXException {
        this.checkDelete(this.loadSubscription(subscription.getContext(), subscription.getId(), null));
        STORAGE.get().forgetSubscription(subscription);
    }

    @Override
    public void update(Subscription subscription) throws OXException {
        Subscription loadedSubscription = this.loadSubscription(subscription.getContext(), subscription.getId(), null);
        if (null == loadedSubscription) {
            throw SubscriptionErrorMessage.SubscriptionNotFound.create();
        }
        this.checkUpdate(loadedSubscription);
        this.modifyIncoming(subscription);
        STORAGE.get().updateSubscription(subscription);
        this.modifyOutgoing(subscription);
    }

    public void modifyIncoming(Subscription subscription) throws OXException {
        Object accountIDObject = subscription.getConfiguration().get("account");
        Object accountId = null;
        if (JSONObject.NULL == accountIDObject) {
            throw SubscriptionErrorMessage.NO_OAUTH_ACCOUNT_GIVEN.create();
        }
    }

    public void modifyOutgoing(Subscription subscription) throws OXException {
    }

    @Override
    public boolean knows(Context ctx, int subscriptionId) throws OXException {
        Subscription subscription = STORAGE.get().getSubscription(ctx, subscriptionId);
        if (subscription == null) {
            return false;
        }
        return subscription.getSource().getId().equals(this.getSubscriptionSource().getId());
    }

    @Override
    public void touch(Context ctx, int subscriptionId) throws OXException {
        STORAGE.get().touch(ctx, subscriptionId, System.currentTimeMillis());
    }

    public static void encrypt(Session session, Map<String, Object> map, String ... keys) throws OXException {
        SecretEncryptionFactoryService encryptionFactoryService = ENCRYPTION_FACTORY.get();
        if (encryptionFactoryService == null) {
            return;
        }
        if (session == null) {
            return;
        }
        SecretEncryptionService encryptionService = encryptionFactoryService.createService((SecretEncryptionStrategy)STORAGE.get());
        for (String key : keys) {
            if (!map.containsKey(key)) continue;
            String toEncrypt = (String)map.get(key);
            String encrypted = encryptionService.encrypt(session, toEncrypt);
            map.put(key, encrypted);
        }
    }

    public static void decrypt(Subscription subscription, Session session, Map<String, Object> map, String ... keys) throws OXException {
        SecretEncryptionFactoryService encryptionFactoryService = ENCRYPTION_FACTORY.get();
        if (encryptionFactoryService == null) {
            return;
        }
        if (session == null) {
            return;
        }
        SecretEncryptionService encryptionService = encryptionFactoryService.createService((SecretEncryptionStrategy)STORAGE.get());
        for (String key : keys) {
            String decrypted;
            if (!map.containsKey(key)) continue;
            EncryptedField encryptedField = new EncryptedField(subscription, key);
            String toDecrypt = (String)map.get(key);
            try {
                decrypted = encryptionService.decrypt(session, toDecrypt, (Object)encryptedField);
            }
            catch (OXException e) {
                decrypted = null;
            }
            map.put(key, decrypted);
        }
    }

    @Override
    public boolean hasAccounts(Context ctx, User user) throws OXException {
        Set<String> passwordFields = this.getSubscriptionSource().getPasswordFields();
        if (passwordFields.isEmpty()) {
            return false;
        }
        return STORAGE.get().hasSubscriptions(ctx, user);
    }

    @Override
    public void migrateSecret(Session session, String oldSecret, String newSecret) throws OXException {
        SubscriptionSource subscriptionSource = this.getSubscriptionSource();
        Set<String> passwordFields = subscriptionSource.getPasswordFields();
        if (passwordFields.isEmpty()) {
            return;
        }
        ServerSession serverSession = ServerSessionAdapter.valueOf((Session)session);
        List<Subscription> allSubscriptions = STORAGE.get().getSubscriptionsOfUser(serverSession.getContext(), session.getUserId());
        String id = subscriptionSource.getId();
        CryptoService cryptoService = CRYPTO_SERVICE.get();
        HashMap<String, Object> update = new HashMap<String, Object>();
        for (Subscription subscription : allSubscriptions) {
            if (!id.equals(AbstractSubscribeService.getSubscriptionSourceId(subscription))) continue;
            Map<String, Object> configuration = subscription.getConfiguration();
            update.clear();
            boolean save = false;
            for (String passwordField : passwordFields) {
                String password = (String)configuration.get(passwordField);
                if (AbstractSubscribeService.isEmpty(password)) continue;
                try {
                    cryptoService.decrypt(password, newSecret);
                }
                catch (OXException x) {
                    String transcriptedPassword = cryptoService.encrypt(cryptoService.decrypt(password, oldSecret), newSecret);
                    update.put(passwordField, transcriptedPassword);
                    save = true;
                }
            }
            if (!save) continue;
            subscription.setConfiguration(update);
            STORAGE.get().updateSubscription(subscription);
        }
    }

    @Override
    public void cleanUp(String secret, Session session) throws OXException {
        SubscriptionSource subscriptionSource = this.getSubscriptionSource();
        Set<String> passwordFields = subscriptionSource.getPasswordFields();
        if (passwordFields.isEmpty()) {
            return;
        }
        ServerSession serverSession = ServerSessionAdapter.valueOf((Session)session);
        List<Subscription> allSubscriptions = STORAGE.get().getSubscriptionsOfUser(serverSession.getContext(), session.getUserId());
        String id = subscriptionSource.getId();
        CryptoService cryptoService = CRYPTO_SERVICE.get();
        HashMap<String, Object> update = new HashMap<String, Object>();
        for (Subscription subscription : allSubscriptions) {
            if (!id.equals(AbstractSubscribeService.getSubscriptionSourceId(subscription))) continue;
            Map<String, Object> configuration = subscription.getConfiguration();
            update.clear();
            boolean save = false;
            for (String passwordField : passwordFields) {
                String password = (String)configuration.get(passwordField);
                if (AbstractSubscribeService.isEmpty(password)) continue;
                try {
                    cryptoService.decrypt(password, secret);
                }
                catch (OXException x) {
                    update.put(passwordField, "");
                    save = true;
                }
            }
            if (!save) continue;
            subscription.setConfiguration(update);
            STORAGE.get().updateSubscription(subscription);
        }
    }

    @Override
    public void removeUnrecoverableItems(String secret, Session session) throws OXException {
        SubscriptionSource subscriptionSource = this.getSubscriptionSource();
        Set<String> passwordFields = subscriptionSource.getPasswordFields();
        if (passwordFields.isEmpty()) {
            return;
        }
        ServerSession serverSession = ServerSessionAdapter.valueOf((Session)session);
        List<Subscription> allSubscriptions = STORAGE.get().getSubscriptionsOfUser(serverSession.getContext(), session.getUserId());
        String id = subscriptionSource.getId();
        CryptoService cryptoService = CRYPTO_SERVICE.get();
        ArrayList<Subscription> subscriptionsToDelete = new ArrayList<Subscription>(allSubscriptions.size());
        for (Subscription subscription : allSubscriptions) {
            if (!id.equals(AbstractSubscribeService.getSubscriptionSourceId(subscription))) continue;
            Map<String, Object> configuration = subscription.getConfiguration();
            for (String passwordField : passwordFields) {
                String password = (String)configuration.get(passwordField);
                if (AbstractSubscribeService.isEmpty(password)) continue;
                try {
                    cryptoService.decrypt(password, secret);
                }
                catch (OXException x) {
                    if (subscriptionsToDelete.contains((Object)subscription)) continue;
                    subscriptionsToDelete.add(subscription);
                }
            }
        }
        for (Subscription subscription : subscriptionsToDelete) {
            this.unsubscribe(subscription);
        }
    }

    @Override
    public SearchIterator<?> loadContent(Subscription subscription) throws OXException {
        return new SearchIteratorDelegator(this.getContent(subscription));
    }

    private static String getSubscriptionSourceId(Subscription subscription) {
        if (null == subscription) {
            return null;
        }
        SubscriptionSource source = subscription.getSource();
        return null == source ? null : source.getId();
    }

    protected void removeWhereConfigMatches(Context context, Map<String, Object> query) throws OXException {
        STORAGE.get().deleteAllSubscriptionsWhereConfigMatches(query, this.getSubscriptionSource().getId(), context);
    }

    public void checkCreate(Subscription subscription) throws OXException {
        if (this.canWrite(subscription)) {
            return;
        }
        throw SubscriptionErrorMessage.PERMISSION_DENIED.create();
    }

    public void checkUpdate(Subscription subscription) throws OXException {
        if (subscription.getSession().getUserId() == subscription.getUserId() || this.isFolderAdmin(subscription)) {
            return;
        }
        throw SubscriptionErrorMessage.PERMISSION_DENIED.create();
    }

    public void checkDelete(Subscription subscription) throws OXException {
        if (subscription.getSession().getUserId() == subscription.getUserId() || this.isFolderAdmin(subscription)) {
            return;
        }
        throw SubscriptionErrorMessage.PERMISSION_DENIED.create();
    }

    private boolean canWrite(Subscription subscription) throws OXException {
        OCLPermission permission = this.loadFolderPermission(subscription);
        return permission.isFolderAdmin() || permission.getFolderPermission() >= 128 || permission.getFolderPermission() >= 4 && permission.getWritePermission() >= 4;
    }

    private boolean isFolderAdmin(Subscription subscription) throws OXException {
        OCLPermission permission = this.loadFolderPermission(subscription);
        return permission.isFolderAdmin() || permission.getFolderPermission() >= 128;
    }

    private OCLPermission loadFolderPermission(Subscription subscription) throws OXException {
        int folderId = Integer.parseInt(subscription.getFolderId());
        int userId = subscription.getSession().getUserId();
        Context ctx = subscription.getContext();
        UserPermissionBits userPerm = USER_PERMISSIONS.get().getUserPermissionBits(userId, ctx);
        return new OXFolderAccess(ctx).getFolderPermission(folderId, userId, userPerm);
    }

    private static boolean isEmpty(String string) {
        if (null == string) {
            return true;
        }
        int len = string.length();
        boolean isWhitespace = true;
        for (int i = 0; isWhitespace && i < len; ++i) {
            isWhitespace = Strings.isWhitespace((char)string.charAt(i));
        }
        return isWhitespace;
    }
}

