/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.xml;

import com.openexchange.contact.ContactService;
import com.openexchange.contact.SortOptions;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contact.helpers.ContactField;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.container.DistributionListEntryObject;
import com.openexchange.groupware.container.LinkEntryObject;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.mail.mime.QuotedInternetAddress;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.tools.encoding.Base64;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.iterator.SearchIteratorException;
import com.openexchange.webdav.xml.CommonWriter;
import com.openexchange.webdav.xml.XmlServlet;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.Text;
import org.jdom2.output.XMLOutputter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContactWriter
extends CommonWriter {
    protected static final ContactField[] changeFields = new ContactField[]{ContactField.OBJECT_ID, ContactField.CREATED_BY, ContactField.CREATION_DATE, ContactField.LAST_MODIFIED, ContactField.MODIFIED_BY, ContactField.FOLDER_ID, ContactField.PRIVATE_FLAG, ContactField.CATEGORIES, ContactField.GIVEN_NAME, ContactField.SUR_NAME, ContactField.ANNIVERSARY, ContactField.ASSISTANT_NAME, ContactField.BIRTHDAY, ContactField.BRANCHES, ContactField.BUSINESS_CATEGORY, ContactField.CATEGORIES, ContactField.CELLULAR_TELEPHONE1, ContactField.CELLULAR_TELEPHONE2, ContactField.CITY_BUSINESS, ContactField.CITY_HOME, ContactField.CITY_OTHER, ContactField.COMMERCIAL_REGISTER, ContactField.COMPANY, ContactField.COUNTRY_BUSINESS, ContactField.COUNTRY_HOME, ContactField.COUNTRY_OTHER, ContactField.DEPARTMENT, ContactField.DISPLAY_NAME, ContactField.DISTRIBUTIONLIST, ContactField.EMAIL1, ContactField.EMAIL2, ContactField.EMAIL3, ContactField.EMPLOYEE_TYPE, ContactField.FAX_BUSINESS, ContactField.FAX_HOME, ContactField.FAX_OTHER, ContactField.FILE_AS, ContactField.FOLDER_ID, ContactField.GIVEN_NAME, ContactField.IMAGE1, ContactField.IMAGE1_CONTENT_TYPE, ContactField.INFO, ContactField.INSTANT_MESSENGER1, ContactField.INSTANT_MESSENGER2, ContactField.LINKS, ContactField.MANAGER_NAME, ContactField.MARITAL_STATUS, ContactField.MIDDLE_NAME, ContactField.NICKNAME, ContactField.NOTE, ContactField.NUMBER_OF_CHILDREN, ContactField.NUMBER_OF_EMPLOYEE, ContactField.POSITION, ContactField.POSTAL_CODE_BUSINESS, ContactField.POSTAL_CODE_HOME, ContactField.POSTAL_CODE_OTHER, ContactField.PRIVATE_FLAG, ContactField.PROFESSION, ContactField.ROOM_NUMBER, ContactField.SALES_VOLUME, ContactField.SPOUSE_NAME, ContactField.STATE_BUSINESS, ContactField.STATE_HOME, ContactField.STATE_OTHER, ContactField.STREET_BUSINESS, ContactField.STREET_HOME, ContactField.STREET_OTHER, ContactField.SUFFIX, ContactField.TAX_ID, ContactField.TELEPHONE_ASSISTANT, ContactField.TELEPHONE_BUSINESS1, ContactField.TELEPHONE_BUSINESS2, ContactField.TELEPHONE_CALLBACK, ContactField.TELEPHONE_CAR, ContactField.TELEPHONE_COMPANY, ContactField.TELEPHONE_HOME1, ContactField.TELEPHONE_HOME2, ContactField.TELEPHONE_IP, ContactField.TELEPHONE_ISDN, ContactField.TELEPHONE_OTHER, ContactField.TELEPHONE_PAGER, ContactField.TELEPHONE_PRIMARY, ContactField.TELEPHONE_RADIO, ContactField.TELEPHONE_TELEX, ContactField.TELEPHONE_TTYTDD, ContactField.TITLE, ContactField.URL, ContactField.USERFIELD01, ContactField.USERFIELD02, ContactField.USERFIELD03, ContactField.USERFIELD04, ContactField.USERFIELD05, ContactField.USERFIELD06, ContactField.USERFIELD07, ContactField.USERFIELD08, ContactField.USERFIELD09, ContactField.USERFIELD10, ContactField.USERFIELD11, ContactField.USERFIELD12, ContactField.USERFIELD13, ContactField.USERFIELD14, ContactField.USERFIELD15, ContactField.USERFIELD16, ContactField.USERFIELD17, ContactField.USERFIELD18, ContactField.USERFIELD19, ContactField.USERFIELD20, ContactField.DEFAULT_ADDRESS, ContactField.NUMBER_OF_ATTACHMENTS};
    protected static final ContactField[] deleteFields = new ContactField[]{ContactField.OBJECT_ID, ContactField.LAST_MODIFIED};
    private static final Logger LOG = LoggerFactory.getLogger(ContactWriter.class);

    public ContactWriter() {
    }

    public ContactWriter(User userObj, Context ctx, Session sessionObj) {
        this.userObj = userObj;
        this.ctx = ctx;
        this.sessionObj = sessionObj;
    }

    public void startWriter(int objectId, int folderId, OutputStream os) throws Exception {
        Element eProp = new Element("prop", "D", "DAV:");
        XMLOutputter xo = new XMLOutputter();
        try {
            ContactService contactService = ServerServiceRegistry.getInstance().getService(ContactService.class);
            Contact contactobject = contactService.getContact(this.sessionObj, Integer.toString(folderId), Integer.toString(objectId));
            this.writeObject(contactobject, eProp, false, xo, os);
        }
        catch (OXException exc) {
            if (exc.isGeneric(OXException.Generic.NOT_FOUND)) {
                this.writeResponseElement(eProp, 0, 404, "[1001] Object not found", xo, os);
            } else {
                this.writeResponseElement(eProp, 0, 500, ContactWriter.getErrorMessage("[%s] Server Error - ", 1500), xo, os);
            }
        }
        catch (Exception ex) {
            LOG.error("", (Throwable)ex);
            this.writeResponseElement(eProp, 0, 500, ContactWriter.getErrorMessage("[%s] Server Error - ", 1500), xo, os);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startWriter(boolean bModified, boolean bDeleted, boolean bList, int folder_id, Date lastsync, OutputStream os) throws Exception {
        SearchIterator<Contact> it;
        XMLOutputter xo = new XMLOutputter();
        ContactService contactService = ServerServiceRegistry.getInstance().getService(ContactService.class);
        if (bDeleted) {
            it = null;
            try {
                it = contactService.getDeletedContacts(this.sessionObj, Integer.toString(folder_id), lastsync, deleteFields);
                this.writeIterator(it, true, xo, os);
            }
            finally {
                if (it != null) {
                    it.close();
                }
            }
        }
        if (bModified) {
            it = null;
            try {
                it = contactService.getModifiedContacts(this.sessionObj, Integer.toString(folder_id), lastsync, changeFields);
                this.writeIterator(it, false, xo, os);
            }
            finally {
                if (it != null) {
                    it.close();
                }
            }
        }
        if (bList) {
            it = null;
            try {
                it = contactService.getAllContacts(this.sessionObj, Integer.toString(folder_id), deleteFields, new SortOptions(0, 50000));
                this.writeList(it, xo, os);
            }
            finally {
                if (it != null) {
                    it.close();
                }
            }
        }
    }

    public void writeIterator(SearchIterator<Contact> it, boolean delete, XMLOutputter xo, OutputStream os) throws Exception {
        while (it.hasNext()) {
            this.writeObject((Contact)it.next(), delete, xo, os);
        }
    }

    public void writeObject(Contact contactObj, boolean delete, XMLOutputter xo, OutputStream os) throws Exception {
        this.writeObject(contactObj, new Element("prop", "D", "DAV:"), delete, xo, os);
    }

    public void writeObject(Contact contactObj, Element eProp, boolean delete, XMLOutputter xo, OutputStream os) throws Exception {
        int status = 200;
        String description = "OK";
        int object_id = 0;
        try {
            object_id = contactObj.getObjectID();
            if (contactObj.containsImage1() && !delete) {
                ContactService contactService = ServerServiceRegistry.getInstance().getService(ContactService.class);
                Contact contactObjectWithImage = contactService.getContact(this.sessionObj, Integer.toString(contactObj.getParentFolderID()), Integer.toString(contactObj.getObjectID()));
                this.addContent2PropElement(eProp, contactObjectWithImage, delete);
            } else {
                this.addContent2PropElement(eProp, contactObj, delete);
            }
        }
        catch (Exception exc) {
            LOG.error("writeObject", (Throwable)exc);
            status = 500;
            description = "Server Error: " + exc.getMessage();
            object_id = 0;
        }
        this.writeResponseElement(eProp, object_id, status, description, xo, os);
    }

    protected void addContent2PropElement(Element e, Contact contactobject, boolean delete) throws Exception {
        this.addContent2PropElement(e, contactobject, delete, false);
    }

    public void addContent2PropElement(Element e, Contact contactobject, boolean delete, boolean externalUser) throws OXException, SearchIteratorException, UnsupportedEncodingException, AddressException {
        if (delete) {
            ContactWriter.addElement("object_id", contactobject.getObjectID(), e);
            ContactWriter.addElement("last_modified", contactobject.getLastModified(), e);
            ContactWriter.addElement("object_status", "DELETE", e);
        } else {
            this.writeCommonElements(contactobject, e);
            this.writeContactElement(contactobject, e);
            if (contactobject.containsImage1()) {
                ContactWriter.addElement("image_content_type", contactobject.getImageContentType(), e);
                ContactWriter.addElement("image1", Base64.encode(contactobject.getImage1()), e);
            }
            if (contactobject.getDistributionList() != null) {
                ContactWriter.addElement("distributionlist_flag", true, e);
                this.writeDistributionList(contactobject, e);
            } else {
                ContactWriter.addElement("distributionlist_flag", false, e);
            }
            if (contactobject.getNumberOfLinks() > 0) {
                this.writeLinks(contactobject, e);
            }
        }
    }

    protected void writeContactElement(Contact contactobject, Element e) throws AddressException {
        this.writeContactElement(contactobject, e, null);
    }

    protected void writeContactElement(Contact contactobject, Element e, Set<InternetAddress> internalAddresses) throws AddressException {
        ContactWriter.addElement("object_status", "CREATE", e);
        ContactWriter.addElement("last_name", contactobject.getSurName(), e);
        ContactWriter.addElement("first_name", contactobject.getGivenName(), e);
        ContactWriter.addElement("anniversary", contactobject.getAnniversary(), e);
        ContactWriter.addElement("assistants_name", contactobject.getAssistantName(), e);
        ContactWriter.addElement("birthday", contactobject.getBirthday(), e);
        ContactWriter.addElement("branches", contactobject.getBranches(), e);
        ContactWriter.addElement("business_category", contactobject.getBusinessCategory(), e);
        ContactWriter.addElement("categories", contactobject.getCategories(), e);
        ContactWriter.addElement("mobile1", contactobject.getCellularTelephone1(), e);
        ContactWriter.addElement("mobile2", contactobject.getCellularTelephone2(), e);
        ContactWriter.addElement("city", contactobject.getCityHome(), e);
        ContactWriter.addElement("business_city", contactobject.getCityBusiness(), e);
        ContactWriter.addElement("second_city", contactobject.getCityOther(), e);
        ContactWriter.addElement("commercial_register", contactobject.getCommercialRegister(), e);
        ContactWriter.addElement("company", contactobject.getCompany(), e);
        ContactWriter.addElement("country", contactobject.getCountryHome(), e);
        ContactWriter.addElement("business_country", contactobject.getCountryBusiness(), e);
        ContactWriter.addElement("second_country", contactobject.getCountryOther(), e);
        ContactWriter.addElement("department", contactobject.getDepartment(), e);
        ContactWriter.addElement("displayname", contactobject.getDisplayName(), e);
        if (null == internalAddresses || internalAddresses.isEmpty()) {
            ContactWriter.addElement("email1", contactobject.getEmail1(), e);
            ContactWriter.addElement("email2", contactobject.getEmail2(), e);
            ContactWriter.addElement("email3", contactobject.getEmail3(), e);
        } else {
            ContactWriter.addEmailAddress("email1", contactobject.getEmail1(), e, internalAddresses);
            ContactWriter.addEmailAddress("email2", contactobject.getEmail2(), e, internalAddresses);
            ContactWriter.addEmailAddress("email3", contactobject.getEmail3(), e, internalAddresses);
        }
        ContactWriter.addElement("employee_type", contactobject.getEmployeeType(), e);
        ContactWriter.addElement("fax_business", contactobject.getFaxBusiness(), e);
        ContactWriter.addElement("fax_home", contactobject.getFaxHome(), e);
        ContactWriter.addElement("fax_other", contactobject.getFaxOther(), e);
        ContactWriter.addElement("file_as", contactobject.getFileAs(), e);
        ContactWriter.addElement("note", contactobject.getNote(), e);
        ContactWriter.addElement("more_info", contactobject.getInfo(), e);
        ContactWriter.addElement("instant_messenger", contactobject.getInstantMessenger1(), e);
        ContactWriter.addElement("instant_messenger2", contactobject.getInstantMessenger2(), e);
        ContactWriter.addElement("martital_status", contactobject.getMaritalStatus(), e);
        ContactWriter.addElement("managers_name", contactobject.getManagerName(), e);
        ContactWriter.addElement("second_name", contactobject.getMiddleName(), e);
        ContactWriter.addElement("nickname", contactobject.getNickname(), e);
        ContactWriter.addElement("number_of_children", contactobject.getNumberOfChildren(), e);
        ContactWriter.addElement("number_of_employee", contactobject.getNumberOfEmployee(), e);
        ContactWriter.addElement("position", contactobject.getPosition(), e);
        ContactWriter.addElement("postal_code", contactobject.getPostalCodeHome(), e);
        ContactWriter.addElement("business_postal_code", contactobject.getPostalCodeBusiness(), e);
        ContactWriter.addElement("second_postal_code", contactobject.getPostalCodeOther(), e);
        ContactWriter.addElement("profession", contactobject.getProfession(), e);
        ContactWriter.addElement("room_number", contactobject.getRoomNumber(), e);
        ContactWriter.addElement("sales_volume", contactobject.getSalesVolume(), e);
        ContactWriter.addElement("spouse_name", contactobject.getSpouseName(), e);
        ContactWriter.addElement("state", contactobject.getStateHome(), e);
        ContactWriter.addElement("business_state", contactobject.getStateBusiness(), e);
        ContactWriter.addElement("second_state", contactobject.getStateOther(), e);
        ContactWriter.addElement("street", contactobject.getStreetHome(), e);
        ContactWriter.addElement("business_street", contactobject.getStreetBusiness(), e);
        ContactWriter.addElement("second_street", contactobject.getStreetOther(), e);
        ContactWriter.addElement("suffix", contactobject.getSuffix(), e);
        ContactWriter.addElement("tax_id", contactobject.getTaxID(), e);
        ContactWriter.addElement("phone_assistant", contactobject.getTelephoneAssistant(), e);
        ContactWriter.addElement("phone_business", contactobject.getTelephoneBusiness1(), e);
        ContactWriter.addElement("phone_business2", contactobject.getTelephoneBusiness2(), e);
        ContactWriter.addElement("callback", contactobject.getTelephoneCallback(), e);
        ContactWriter.addElement("phone_car", contactobject.getTelephoneCar(), e);
        ContactWriter.addElement("phone_company", contactobject.getTelephoneCompany(), e);
        ContactWriter.addElement("phone_home", contactobject.getTelephoneHome1(), e);
        ContactWriter.addElement("phone_home2", contactobject.getTelephoneHome2(), e);
        ContactWriter.addElement("ip_phone", contactobject.getTelephoneIP(), e);
        ContactWriter.addElement("isdn", contactobject.getTelephoneISDN(), e);
        ContactWriter.addElement("phone_other", contactobject.getTelephoneOther(), e);
        ContactWriter.addElement("pager", contactobject.getTelephonePager(), e);
        ContactWriter.addElement("primary", contactobject.getTelephonePrimary(), e);
        ContactWriter.addElement("radio", contactobject.getTelephoneRadio(), e);
        ContactWriter.addElement("telex", contactobject.getTelephoneTelex(), e);
        ContactWriter.addElement("tty_tdd", contactobject.getTelephoneTTYTTD(), e);
        ContactWriter.addElement("title", contactobject.getTitle(), e);
        ContactWriter.addElement("url", contactobject.getURL(), e);
        ContactWriter.addElement("userfield01", contactobject.getUserField01(), e);
        ContactWriter.addElement("userfield02", contactobject.getUserField02(), e);
        ContactWriter.addElement("userfield03", contactobject.getUserField03(), e);
        ContactWriter.addElement("userfield04", contactobject.getUserField04(), e);
        ContactWriter.addElement("userfield05", contactobject.getUserField05(), e);
        ContactWriter.addElement("userfield06", contactobject.getUserField06(), e);
        ContactWriter.addElement("userfield07", contactobject.getUserField07(), e);
        ContactWriter.addElement("userfield08", contactobject.getUserField08(), e);
        ContactWriter.addElement("userfield09", contactobject.getUserField09(), e);
        ContactWriter.addElement("userfield10", contactobject.getUserField10(), e);
        ContactWriter.addElement("userfield11", contactobject.getUserField11(), e);
        ContactWriter.addElement("userfield12", contactobject.getUserField12(), e);
        ContactWriter.addElement("userfield13", contactobject.getUserField13(), e);
        ContactWriter.addElement("userfield14", contactobject.getUserField14(), e);
        ContactWriter.addElement("userfield15", contactobject.getUserField15(), e);
        ContactWriter.addElement("userfield16", contactobject.getUserField16(), e);
        ContactWriter.addElement("userfield17", contactobject.getUserField17(), e);
        ContactWriter.addElement("userfield18", contactobject.getUserField18(), e);
        ContactWriter.addElement("userfield19", contactobject.getUserField19(), e);
        ContactWriter.addElement("userfield20", contactobject.getUserField20(), e);
        ContactWriter.addElement("defaultaddress", contactobject.getDefaultAddress(), e);
    }

    private static void addEmailAddress(String name, String emailAddress, Element e, Set<InternetAddress> internalAddresses) throws AddressException {
        if (null != emailAddress) {
            List children = e.getChildren(name, Namespace.getNamespace((String)"ox", (String)"http://www.open-xchange.org"));
            QuotedInternetAddress ia = new QuotedInternetAddress(emailAddress);
            if (null != children && !children.isEmpty()) {
                if (children.size() > 1) {
                    LOG.warn("Conflicting email address detected! Multiple elements named \"{}\" already exist.", (Object)name);
                    return;
                }
                Element elem = (Element)children.get(0);
                Text text = (Text)elem.getContent().get(0);
                if (!new QuotedInternetAddress(text.getText()).equals((Object)ia)) {
                    LOG.warn("Conflicting email address detected! An element named \"{}\" already exists.", (Object)name);
                    return;
                }
                Attribute attr = elem.getAttribute("isInternal");
                if (null == attr && internalAddresses.contains((Object)ia)) {
                    elem.setAttribute("isInternal", "true");
                }
                return;
            }
            Element child = ContactWriter.addElement(name, emailAddress, e);
            if (internalAddresses.contains((Object)ia)) {
                child.setAttribute("isInternal", "true");
            }
        }
    }

    protected void writeLinks(Contact contactobject, Element e_prop) {
        Element e_links = new Element("links", XmlServlet.NS);
        LinkEntryObject[] links2 = contactobject.getLinks();
        if (links2 != null) {
            for (int a = 0; a < links2.length; ++a) {
                int id = links2[a].getLinkID();
                String displayname = links2[a].getLinkDisplayname();
                if (displayname == null) {
                    displayname = Integer.toString(id);
                }
                Element e = new Element("link", XmlServlet.NS);
                e.addContent(Integer.toString(id));
                e.setAttribute("displayname", displayname, XmlServlet.NS);
                e_links.addContent((Content)e);
            }
            e_prop.addContent((Content)e_links);
        }
    }

    protected void writeDistributionList(Contact contactobject, Element e_prop) {
        Element e_distributionlist = new Element("distributionlist", XmlServlet.NS);
        DistributionListEntryObject[] distributionlist = contactobject.getDistributionList();
        for (int a = 0; a < distributionlist.length; ++a) {
            String displayname = distributionlist[a].getDisplayname();
            String email = distributionlist[a].getEmailaddress();
            if (displayname == null) {
                displayname = email;
            }
            Element e = new Element("email", XmlServlet.NS);
            e.addContent(ContactWriter.correctCharacterData(email));
            e.setAttribute("id", Integer.toString(distributionlist[a].getEntryID()), XmlServlet.NS);
            e.setAttribute("folder_id", Integer.toString(distributionlist[a].getFolderID()), XmlServlet.NS);
            e.setAttribute("displayname", displayname.trim(), XmlServlet.NS);
            e.setAttribute("emailfield", Integer.toString(distributionlist[a].getEmailfield()), XmlServlet.NS);
            e_distributionlist.addContent((Content)e);
        }
        e_prop.addContent((Content)e_distributionlist);
    }

    @Override
    protected int getModule() {
        return 7;
    }
}

