/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.action;

import com.openexchange.webdav.action.AbstractAction;
import com.openexchange.webdav.action.WebdavRequest;
import com.openexchange.webdav.action.WebdavResponse;
import com.openexchange.webdav.loader.LoadingHints;
import com.openexchange.webdav.protocol.Protocol;
import com.openexchange.webdav.protocol.WebdavPath;
import com.openexchange.webdav.protocol.WebdavProtocolException;
import com.openexchange.webdav.xml.resources.PropertiesMarshaller;
import com.openexchange.webdav.xml.resources.PropfindAllPropsMarshaller;
import com.openexchange.webdav.xml.resources.PropfindPropNamesMarshaller;
import com.openexchange.webdav.xml.resources.PropfindResponseMarshaller;
import com.openexchange.webdav.xml.resources.RecursiveMarshaller;
import com.openexchange.webdav.xml.resources.ResourceMarshaller;
import java.io.IOException;
import java.util.List;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;
import org.jdom2.output.XMLOutputter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebdavPropfindAction
extends AbstractAction {
    protected static final Namespace DAV_NS = Protocol.DAV_NS;
    private static final Logger LOG = LoggerFactory.getLogger(WebdavPropfindAction.class);
    protected final XMLOutputter outputter = new XMLOutputter();
    protected Protocol protocol;

    public WebdavPropfindAction(Protocol protocol) {
        this.protocol = protocol;
    }

    @Override
    public void perform(WebdavRequest req, WebdavResponse res) throws WebdavProtocolException {
        Element response = new Element("multistatus", DAV_NS);
        List<Namespace> namespaces = this.protocol.getAdditionalNamespaces();
        for (Namespace namespace : namespaces) {
            response.addNamespaceDeclaration(namespace);
        }
        Document responseBody = new Document(response);
        boolean forceAllProp = false;
        Document requestBody = null;
        try {
            requestBody = req.getBodyAsDocument();
        }
        catch (JDOMException e1) {
            forceAllProp = true;
        }
        catch (IOException e1) {
            throw WebdavProtocolException.Code.GENERAL_ERROR.create(new WebdavPath(new String[0]), 400);
        }
        LoadingHints loadingHints = new LoadingHints();
        ResourceMarshaller marshaller = this.getMarshaller(req, forceAllProp, requestBody, loadingHints);
        if (null != req.getHeader("Depth")) {
            int depth = 0;
            depth = req.getHeader("depth").trim().equalsIgnoreCase("infinity") ? -1 : Integer.parseInt(req.getHeader("Depth"));
            marshaller = new RecursiveMarshaller(marshaller, depth);
            loadingHints.setDepth(depth);
        }
        this.preLoad(loadingHints);
        if (marshaller != null) {
            response.addContent(marshaller.marshal(req.getResource()));
        }
        try {
            res.setStatus(207);
            res.setContentType("text/xml; charset=UTF-8");
            this.outputter.output(responseBody, res.getOutputStream());
        }
        catch (IOException e) {
            LOG.debug("Client gone?", (Throwable)e);
        }
    }

    protected ResourceMarshaller getMarshaller(WebdavRequest req, boolean forceAllProp, Document requestBody, LoadingHints loadingHints) {
        if (loadingHints == null) {
            loadingHints = new LoadingHints();
        }
        PropertiesMarshaller marshaller = null;
        loadingHints.setUrl(req.getUrl());
        if (null != requestBody && null != requestBody.getRootElement().getChild("propname", DAV_NS)) {
            marshaller = new PropfindPropNamesMarshaller(req.getURLPrefix(), req.getCharset());
            loadingHints.setProps(LoadingHints.Property.ALL);
        }
        if (null != requestBody && null != requestBody.getRootElement().getChild("allprop", DAV_NS) || forceAllProp) {
            marshaller = new PropfindAllPropsMarshaller(req.getURLPrefix(), req.getCharset());
            loadingHints.setProps(LoadingHints.Property.ALL);
        }
        if (null != requestBody && null != requestBody.getRootElement().getChild("prop", DAV_NS)) {
            marshaller = new PropfindResponseMarshaller(req.getURLPrefix(), req.getCharset(), req.isBrief());
            loadingHints.setProps(LoadingHints.Property.SOME);
            for (Element props : requestBody.getRootElement().getChildren("prop", DAV_NS)) {
                for (Element requested : props.getChildren()) {
                    ((PropfindResponseMarshaller)marshaller).addProperty(requested.getNamespaceURI(), requested.getName());
                    loadingHints.addProperty(requested.getNamespaceURI(), requested.getName());
                }
            }
        }
        return marshaller;
    }
}

