/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.action;

import com.openexchange.java.Charsets;
import com.openexchange.java.Streams;
import com.openexchange.java.StringAllocator;
import com.openexchange.webdav.action.AbstractAction;
import com.openexchange.webdav.action.CapturingWebdavResponse;
import com.openexchange.webdav.action.ReplayWebdavRequest;
import com.openexchange.webdav.action.WebdavRequest;
import com.openexchange.webdav.action.WebdavResponse;
import com.openexchange.webdav.protocol.WebdavProtocolException;
import com.openexchange.webdav.protocol.WebdavResource;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebdavLogAction
extends AbstractAction {
    private static final Logger LOG = LoggerFactory.getLogger(WebdavLogAction.class);
    private static final Set<String> CONFIDENTIAL_HEADERS = new HashSet<String>(){
        {
            this.add("AUTHORIZATION");
        }
    };
    private boolean logBody;
    private boolean logResponse;

    @Override
    public void perform(WebdavRequest req, WebdavResponse resp) throws WebdavProtocolException {
        if (!LOG.isDebugEnabled()) {
            this.yield(req, resp);
            return;
        }
        WebdavRequest webdavReq = req;
        WebdavResponse webdavResp = resp;
        String lineSeparator = System.getProperty("line.separator");
        StringAllocator b = new StringAllocator(8192);
        try {
            b.append("URL: ").append((Object)webdavReq.getUrl()).append(lineSeparator);
            for (String header : webdavReq.getHeaderNames()) {
                if (CONFIDENTIAL_HEADERS.contains(header.toUpperCase())) {
                    b.append(header).append(": ").append("xxxxxxxxxxx").append(lineSeparator);
                    continue;
                }
                b.append(header).append(": ").append(webdavReq.getHeader(header)).append(lineSeparator);
            }
            WebdavResource resource = webdavReq.getResource();
            b.append("Resource: ").append((Object)resource).append(lineSeparator);
            b.append("exists: ").append(resource.exists()).append(lineSeparator);
            b.append("isCollection: ").append(resource.isCollection()).append(lineSeparator);
            LOG.debug(b.toString());
            b = null;
            CapturingWebdavResponse capturingRes = null;
            if (LOG.isTraceEnabled()) {
                if (this.logBody) {
                    webdavReq = new ReplayWebdavRequest(webdavReq);
                    WebdavLogAction.logRequestBody(webdavReq, lineSeparator);
                }
                if (this.logResponse) {
                    capturingRes = new CapturingWebdavResponse(webdavResp);
                    webdavResp = capturingRes;
                }
            }
            this.yield(webdavReq, webdavResp);
            LOG.debug("DONE URL: {} {}{}", new Object[]{webdavReq.getUrl(), webdavResp.getStatus(), lineSeparator});
            if (null != capturingRes) {
                LOG.trace(capturingRes.getBodyAsString());
            }
        }
        catch (WebdavProtocolException x) {
            b = new StringAllocator(2048);
            b.append("Status: ").append(x.getMessage()).append(' ').append(x.getStatus()).append(lineSeparator);
            b.append("WebdavException: ");
            if (LOG.isDebugEnabled()) {
                LOG.debug(b.toString(), (Throwable)((Object)x));
            } else if (x.getStatus() == 500) {
                LOG.error("The request: {} caused an internal server error", (Object)b, (Object)x);
            }
            throw x;
        }
        catch (RuntimeException x) {
            LOG.error("RuntimeException In WebDAV for request: {}", (Object)b, (Object)x);
            throw x;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void logRequestBody(WebdavRequest req, String lineSeparator) {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(req.getBody(), Charsets.UTF_8));
            String line = null;
            StringAllocator b = new StringAllocator(65536);
            while ((line = reader.readLine()) != null) {
                b.append(line);
                b.append(lineSeparator);
            }
            LOG.trace(b.toString());
            Streams.close((Closeable)reader);
        }
        catch (IOException x) {
            LOG.debug("", (Throwable)x);
        }
        finally {
            Streams.close(reader);
        }
    }

    public void setLogRequestBody(boolean b) {
        this.logBody = b;
    }

    public void setLogResponseBody(boolean b) {
        this.logResponse = b;
    }
}

