/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.codec;

import com.openexchange.java.Charsets;
import com.openexchange.tools.stream.UnsynchronizedByteArrayInputStream;
import com.openexchange.tools.stream.UnsynchronizedByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import javax.mail.MessagingException;
import javax.mail.internet.MimeUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodecUtils {
    private static final Logger LOG = LoggerFactory.getLogger(CodecUtils.class);
    private static final String ENCODING_QP = "quoted-printable";
    private static final String ENCODING_BASE64 = "base64";
    private static final String ENCODING_7BIT = "7bit";
    private static final String ENCODING_8BIT = "8bit";
    private static final String ENCODING_BINARY = "binary";
    private static final String ENCODING_UUENCODE = "uuencode";
    private static final String[] ENCODINGS = new String[]{"quoted-printable", "base64", "7bit", "8bit", "binary", "uuencode"};
    private static final String ENCODE_Q = "Q";
    private static final String ENCODE_B = "B";
    private static final String REGEX_PREFIX = "((\\?=)? ?=\\?";
    private static final String REGEX_APPENDIX = "\\?(?:Q|B)\\?)|(\\?=)";
    private static final String[] RPL = new String[]{"_", "\\r", "\\n"};
    private static final String[] SUB = new String[]{" ", "=0D", "=0A"};

    private CodecUtils() {
    }

    public static String encodeQuotedPrintable(String originalStr, String charset) throws UnsupportedEncodingException {
        String encStr = MimeUtility.encodeText((String)originalStr, (String)charset, (String)ENCODE_Q);
        encStr = encStr.replaceAll(REGEX_PREFIX + charset + REGEX_APPENDIX, "");
        for (int i = 0; i < RPL.length; ++i) {
            encStr = encStr.replaceAll(RPL[i], SUB[i]);
        }
        return encStr;
    }

    public static String encodeBase64(String originalStr, String charset) throws UnsupportedEncodingException {
        String encStr = MimeUtility.encodeText((String)originalStr, (String)charset, (String)ENCODE_B);
        encStr = encStr.replaceAll(REGEX_PREFIX + charset + REGEX_APPENDIX, "");
        return encStr;
    }

    public static String decode(String encoded, String charset) {
        for (int i = 0; i < ENCODINGS.length; ++i) {
            if ((i == 0 || i == 1) && !CodecUtils.isAscii(encoded)) continue;
            String result = null;
            try {
                result = CodecUtils.decode(encoded, ENCODINGS[i], charset);
            }
            catch (IOException e) {
                LOG.debug("", (Throwable)e);
                result = encoded;
            }
            catch (MessagingException e) {
                LOG.debug("", (Throwable)e);
                result = encoded;
            }
            if (encoded.equals(result)) continue;
            return result;
        }
        return encoded;
    }

    public static String decodeQuotedPrintable(String quotedPrintableStr, String charset) throws IOException, MessagingException {
        return CodecUtils.decode(quotedPrintableStr, ENCODING_QP, charset);
    }

    public static String decodeBase64(String base64Str, String charset) throws IOException, MessagingException {
        return CodecUtils.decode(base64Str, ENCODING_BASE64, charset);
    }

    private static String decode(String encodedStr, String transferEncoding, String charset) throws IOException, MessagingException {
        InputStream inStream = MimeUtility.decode((InputStream)new UnsynchronizedByteArrayInputStream(encodedStr.getBytes(charset)), (String)transferEncoding);
        UnsynchronizedByteArrayOutputStream decodedBytes = new UnsynchronizedByteArrayOutputStream();
        int k = -1;
        byte[] buffer = new byte[512];
        while ((k = inStream.read(buffer)) > 0) {
            decodedBytes.write(buffer, 0, k);
        }
        return new String(decodedBytes.toByteArray(), Charsets.forName((String)charset));
    }

    private static boolean isAscii(String s) {
        int length = s.length();
        boolean isAscii = true;
        for (int i = 0; i < length && isAscii; ++i) {
            isAscii = s.charAt(i) < '\u0080';
        }
        return isAscii;
    }
}

