/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mailaccount.internal;

import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.impl.IDGenerator;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.java.Autoboxing;
import com.openexchange.java.StringAllocator;
import com.openexchange.java.Strings;
import com.openexchange.mail.MailProviderRegistry;
import com.openexchange.mail.MailSessionCache;
import com.openexchange.mail.MailSessionParameterNames;
import com.openexchange.mail.api.IMailFolderStorage;
import com.openexchange.mail.api.IMailMessageStorage;
import com.openexchange.mail.api.MailAccess;
import com.openexchange.mail.cache.IMailAccessCache;
import com.openexchange.mail.config.IPRange;
import com.openexchange.mail.config.MailProperties;
import com.openexchange.mail.utils.DefaultFolderNamesProvider;
import com.openexchange.mail.utils.MailFolderUtility;
import com.openexchange.mail.utils.MailPasswordUtil;
import com.openexchange.mail.utils.ProviderUtility;
import com.openexchange.mailaccount.Attribute;
import com.openexchange.mailaccount.MailAccount;
import com.openexchange.mailaccount.MailAccountDescription;
import com.openexchange.mailaccount.MailAccountExceptionCodes;
import com.openexchange.mailaccount.MailAccountStorageService;
import com.openexchange.mailaccount.UnifiedInboxManagement;
import com.openexchange.mailaccount.internal.AbstractMailAccount;
import com.openexchange.mailaccount.internal.CustomMailAccount;
import com.openexchange.mailaccount.internal.DefaultMailAccount;
import com.openexchange.mailaccount.internal.DeleteListenerRegistry;
import com.openexchange.mailaccount.internal.GenericProperty;
import com.openexchange.mailaccount.internal.UpdateMailAccountBuilder;
import com.openexchange.mailaccount.internal.UpdateTransportAccountBuilder;
import com.openexchange.mailaccount.json.fields.GetSwitch;
import com.openexchange.mailaccount.json.fields.MailAccountGetSwitch;
import com.openexchange.mailaccount.json.fields.SetSwitch;
import com.openexchange.secret.SecretEncryptionFactoryService;
import com.openexchange.secret.SecretEncryptionService;
import com.openexchange.secret.SecretEncryptionStrategy;
import com.openexchange.server.ServiceExceptionCode;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.session.SetableSession;
import com.openexchange.session.SetableSessionFactory;
import com.openexchange.sessiond.SessiondService;
import com.openexchange.tools.Collections;
import com.openexchange.tools.net.URIDefaults;
import com.openexchange.tools.sql.DBUtils;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.locks.Lock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.internet.idn.IDNA;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RdbMailAccountStorage
implements MailAccountStorageService {
    private static final Logger LOG = LoggerFactory.getLogger(RdbMailAccountStorage.class);
    private static final SecretEncryptionStrategy<GenericProperty> STRATEGY = MailPasswordUtil.STRATEGY;
    private static final int TYPE_VARCHAR = 12;
    private static final String SELECT_MAIL_ACCOUNT = "SELECT name, url, login, password, primary_addr, default_flag, trash, sent, drafts, spam, confirmed_spam, confirmed_ham, spam_handler, unified_inbox, trash_fullname, sent_fullname, drafts_fullname, spam_fullname, confirmed_spam_fullname, confirmed_ham_fullname, personal, replyTo, archive, archive_fullname FROM user_mail_account WHERE cid = ? AND id = ? AND user = ?";
    private static final String SELECT_TRANSPORT_ACCOUNT = "SELECT name, url, login, password, send_addr, default_flag, personal, replyTo FROM user_transport_account WHERE cid = ? AND id = ? AND user = ?";
    private static final String SELECT_MAIL_ACCOUNTS = "SELECT id, url FROM user_mail_account WHERE cid = ? AND user = ? ORDER BY id";
    private static final String SELECT_BY_LOGIN = "SELECT id, user FROM user_mail_account WHERE cid = ? AND login = ?";
    private static final String SELECT_BY_PRIMARY_ADDR = "SELECT id, user FROM user_mail_account WHERE cid = ? AND primary_addr = ?";
    private static final String SELECT_ACCOUNT_BY_PRIMARY_ADDR = "SELECT id FROM user_mail_account WHERE cid = ? AND primary_addr = ? AND user = ?";
    private static final String DELETE_MAIL_ACCOUNT = "DELETE FROM user_mail_account WHERE cid = ? AND id = ? AND user = ?";
    private static final String DELETE_TRANSPORT_ACCOUNT = "DELETE FROM user_transport_account WHERE cid = ? AND id = ? AND user = ?";
    private static final String UPDATE_MAIL_ACCOUNT = "UPDATE user_mail_account SET name = ?, url = ?, login = ?, password = ?, primary_addr = ?, spam_handler = ?, trash = ?, sent = ?, drafts = ?, spam = ?, confirmed_spam = ?, confirmed_ham = ?, unified_inbox = ?, trash_fullname = ?, sent_fullname = ?, drafts_fullname = ?, spam_fullname = ?, confirmed_spam_fullname = ?, confirmed_ham_fullname = ?, personal = ?, replyTo = ? WHERE cid = ? AND id = ? AND user = ?";
    private static final String INSERT_MAIL_ACCOUNT = "INSERT INTO user_mail_account (cid, id, user, name, url, login, password, primary_addr, default_flag, trash, sent, drafts, spam, confirmed_spam, confirmed_ham, spam_handler, unified_inbox, trash_fullname, sent_fullname, drafts_fullname, spam_fullname, confirmed_spam_fullname, confirmed_ham_fullname, personal, replyTo, archive, archive_fullname) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private static final String UPDATE_TRANSPORT_ACCOUNT = "UPDATE user_transport_account SET name = ?, url = ?, login = ?, password = ?, send_addr = ?, personal = ?, replyTo = ? WHERE cid = ? AND id = ? AND user = ?";
    private static final String INSERT_TRANSPORT_ACCOUNT = "INSERT INTO user_transport_account (cid, id, user, name, url, login, password, send_addr, default_flag, personal, replyTo) VALUES (?,?,?,?,?,?,?,?,?,?,?)";
    private static final String UPDATE_UNIFIED_INBOX_FLAG = "UPDATE user_mail_account SET unified_inbox = ? WHERE cid = ? AND id = ? AND user = ?";
    private static final String UPDATE_PERSONAL1 = "UPDATE user_mail_account SET personal = ? WHERE cid = ? AND id = ? AND user = ?";
    private static final String UPDATE_PERSONAL2 = "UPDATE user_transport_account SET personal = ? WHERE cid = ? AND id = ? AND user = ?";
    private static final String SELECT_EXISTS_FOR_USER1 = "SELECT 1 FROM user_mail_account WHERE cid = ? AND user = ? AND id > 0 LIMIT 1";
    private static final String SELECT_EXISTS_FOR_USER2 = "SELECT 1 FROM user_transport_account WHERE cid = ? AND user = ? AND id > 0 LIMIT 1";
    private static final String SELECT_PASSWORD1 = "SELECT id, password, login, url FROM user_mail_account WHERE cid = ? AND user = ?";
    private static final String SELECT_PASSWORD2 = "SELECT id, password, login, url FROM user_transport_account WHERE cid = ? AND user = ?";
    private static final String UPDATE_PASSWORD1 = "UPDATE user_mail_account SET password = ?  WHERE cid = ? AND id = ? AND user = ?";
    private static final String UPDATE_PASSWORD2 = "UPDATE user_transport_account SET password = ?  WHERE cid = ? AND id = ? AND user = ?";
    private static final String PARAM_POP3_STORAGE_FOLDERS = "com.openexchange.mailaccount.pop3Folders";
    private static final TIntObjectMap<String> INDEX_2_COL;
    private static final Pattern PATTERN_CONSTRAINT_VIOLATION;
    private static final EnumSet<Attribute> DEFAULT;
    private static final EnumSet<Attribute> DEFAULT_FULL_NAMES;
    private static final EnumSet<Attribute> PRIMARY_EDITABLE;
    private static final char[] CHARS_INVALID;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <V> V performSynchronized(Callable<V> task, Session session) throws Exception {
        Lock lock = (Lock)session.getParameter(Session.PARAM_LOCK);
        if (null == lock) {
            lock = Session.EMPTY_LOCK;
        }
        lock.lock();
        try {
            V v = task.call();
            return v;
        }
        finally {
            lock.unlock();
        }
    }

    private static void dropPOP3StorageFolders(int userId, int contextId) {
        SessiondService service = ServerServiceRegistry.getInstance().getService(SessiondService.class);
        if (null != service) {
            for (Session session : service.getSessions(userId, contextId)) {
                session.setParameter(PARAM_POP3_STORAGE_FOLDERS, null);
            }
        }
    }

    @Override
    public void invalidateMailAccount(int id, int user, int cid) throws OXException {
    }

    @Override
    public void invalidateMailAccounts(int user, int cid) throws OXException {
    }

    public static Set<String> getPOP3StorageFolders(final Session session) throws OXException {
        Set<String> set = (Set<String>)session.getParameter(PARAM_POP3_STORAGE_FOLDERS);
        if (null == set) {
            try {
                Callable<Set<String>> task = new Callable<Set<String>>(){

                    @Override
                    public Set<String> call() throws OXException {
                        Set<String> set = (Set<String>)session.getParameter(RdbMailAccountStorage.PARAM_POP3_STORAGE_FOLDERS);
                        if (null == set) {
                            set = RdbMailAccountStorage.getPOP3StorageFolders0(session);
                            session.setParameter(RdbMailAccountStorage.PARAM_POP3_STORAGE_FOLDERS, set);
                        }
                        return set;
                    }
                };
                set = RdbMailAccountStorage.performSynchronized(task, session);
            }
            catch (OXException e) {
                throw e;
            }
            catch (Exception e) {
                throw MailAccountExceptionCodes.UNEXPECTED_ERROR.create(e, e.getMessage());
            }
        }
        return set;
    }

    static Set<String> getPOP3StorageFolders0(Session session) throws OXException {
        HashSet<String> hashSet;
        int contextId = session.getContextId();
        Connection con = Database.get(contextId, false);
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.prepareStatement("SELECT value FROM user_mail_account_properties WHERE cid = ? AND user = ? AND name = ?");
            stmt.setInt(1, contextId);
            stmt.setInt(2, session.getUserId());
            stmt.setString(3, "pop3.path");
            rs = stmt.executeQuery();
            HashSet<String> set = new HashSet<String>(4);
            while (rs.next()) {
                set.add(rs.getString(1));
            }
            hashSet = set;
        }
        catch (SQLException e) {
            try {
                if (null != stmt) {
                    final String sql = stmt.toString();
                    LOG.debug("\n\tFailed mail account statement:\n\t{}", new Object(){

                        public String toString() {
                            return sql.substring(sql.indexOf(": ") + 2);
                        }
                    });
                }
                throw MailAccountExceptionCodes.SQL_ERROR.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(rs, stmt);
                Database.back(contextId, false, con);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(rs, stmt);
        Database.back(contextId, false, con);
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillMailAccount(AbstractMailAccount mailAccount, int id, int user, int cid) throws OXException {
        Connection con = Database.get(cid, false);
        try {
            this.fillMailAccount(mailAccount, id, user, cid, con);
        }
        finally {
            Database.back(cid, false, con);
        }
    }

    private void fillMailAccount(AbstractMailAccount mailAccount, int id, int user, int cid, Connection con) throws OXException {
        PreparedStatement stmt = null;
        ResultSet result = null;
        try {
            stmt = con.prepareStatement(SELECT_MAIL_ACCOUNT);
            stmt.setLong(1, cid);
            stmt.setLong(2, id);
            stmt.setLong(3, user);
            result = stmt.executeQuery();
            if (!result.next()) {
                throw MailAccountExceptionCodes.NOT_FOUND.create(Autoboxing.I((int)id), Autoboxing.I((int)user), Autoboxing.I((int)cid));
            }
            mailAccount.setId(id);
            mailAccount.setLogin(result.getString(3));
            mailAccount.parseMailServerURL(result.getString(2));
            mailAccount.setName(result.getString(1));
            String pw = result.getString(4);
            if (result.wasNull()) {
                mailAccount.setPassword(null);
            } else {
                mailAccount.setPassword(pw);
            }
            mailAccount.setPrimaryAddress(result.getString(5));
            mailAccount.setTrash(RdbMailAccountStorage.getOptionalString(result.getString(7)));
            mailAccount.setSent(RdbMailAccountStorage.getOptionalString(result.getString(8)));
            mailAccount.setDrafts(RdbMailAccountStorage.getOptionalString(result.getString(9)));
            mailAccount.setSpam(RdbMailAccountStorage.getOptionalString(result.getString(10)));
            mailAccount.setConfirmedSpam(RdbMailAccountStorage.getOptionalString(result.getString(11)));
            mailAccount.setConfirmedHam(RdbMailAccountStorage.getOptionalString(result.getString(12)));
            mailAccount.setArchive(RdbMailAccountStorage.getOptionalString(result.getString(23)));
            mailAccount.setSpamHandler(result.getString(13));
            mailAccount.setUnifiedINBOXEnabled(result.getInt(14) > 0);
            Session session = ((SessiondService)SessiondService.SERVICE_REFERENCE.get()).getAnyActiveSessionForUser(user, cid);
            if (null != session) {
                String parameterName = MailSessionParameterNames.getParamDefaultFolderArray();
                String[] fullNames = (String[])MailSessionCache.getInstance(session).getParameter(id, parameterName);
                String s = RdbMailAccountStorage.getOptionalString(result.getString(15));
                mailAccount.setTrashFullname((String)(s == null ? (null == fullNames ? null : fullNames[3]) : s));
                s = RdbMailAccountStorage.getOptionalString(result.getString(16));
                mailAccount.setSentFullname((String)(s == null ? (null == fullNames ? null : fullNames[1]) : s));
                s = RdbMailAccountStorage.getOptionalString(result.getString(17));
                mailAccount.setDraftsFullname((String)(s == null ? (null == fullNames ? null : fullNames[0]) : s));
                s = RdbMailAccountStorage.getOptionalString(result.getString(18));
                mailAccount.setSpamFullname((String)(s == null ? (null == fullNames ? null : fullNames[2]) : s));
                s = RdbMailAccountStorage.getOptionalString(result.getString(24));
                mailAccount.setArchiveFullname(s);
            }
            mailAccount.setConfirmedSpamFullname(RdbMailAccountStorage.getOptionalString(result.getString(19)));
            mailAccount.setConfirmedHamFullname(RdbMailAccountStorage.getOptionalString(result.getString(20)));
            String pers = result.getString(21);
            if (result.wasNull()) {
                mailAccount.setPersonal(null);
            } else {
                mailAccount.setPersonal(pers);
            }
            String replyTo = result.getString(22);
            if (result.wasNull()) {
                mailAccount.setReplyTo(null);
            } else {
                mailAccount.setReplyTo(replyTo);
            }
            mailAccount.setUserId(user);
            RdbMailAccountStorage.fillProperties(mailAccount, cid, user, id, con);
        }
        catch (SQLException e) {
            try {
                if (null != stmt) {
                    final String sql = stmt.toString();
                    LOG.debug("\n\tFailed mail account statement:\n\t{}", new Object(){

                        public String toString() {
                            return sql.substring(sql.indexOf(": ") + 2);
                        }
                    });
                }
                throw MailAccountExceptionCodes.SQL_ERROR.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(result, stmt);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(result, stmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillTransportAccount(AbstractMailAccount mailAccount, int id, int user, int cid) throws OXException {
        Connection con = Database.get(cid, false);
        try {
            this.fillTransportAccount(mailAccount, id, user, cid, con);
        }
        finally {
            Database.back(cid, false, con);
        }
    }

    private void fillTransportAccount(AbstractMailAccount mailAccount, int id, int user, int cid, Connection con) throws OXException {
        ResultSet result;
        PreparedStatement stmt;
        block12: {
            stmt = null;
            result = null;
            try {
                stmt = con.prepareStatement(SELECT_TRANSPORT_ACCOUNT);
                stmt.setLong(1, cid);
                stmt.setLong(2, id);
                stmt.setLong(3, user);
                result = stmt.executeQuery();
                if (result.next()) {
                    mailAccount.parseTransportServerURL(result.getString(2));
                    String transportLogin = result.getString(3);
                    if (result.wasNull()) {
                        mailAccount.setTransportLogin(null);
                    } else {
                        mailAccount.setTransportLogin(transportLogin);
                    }
                    String transportPassword = result.getString(4);
                    if (result.wasNull()) {
                        mailAccount.setTransportPassword(null);
                    } else {
                        mailAccount.setTransportPassword(transportPassword);
                    }
                    String pers = result.getString(7);
                    if (!result.wasNull()) {
                        mailAccount.setPersonal(pers);
                    }
                    String replyTo = result.getString(8);
                    if (!result.wasNull()) {
                        mailAccount.setReplyTo(replyTo);
                    }
                    break block12;
                }
                mailAccount.setTransportServer((String)null);
            }
            catch (SQLException e) {
                try {
                    if (null != stmt) {
                        final String sql = stmt.toString();
                        LOG.debug("\n\tFailed mail account statement:\n\t{}", new Object(){

                            public String toString() {
                                return sql.substring(sql.indexOf(": ") + 2);
                            }
                        });
                    }
                    throw MailAccountExceptionCodes.SQL_ERROR.create(e, e.getMessage());
                }
                catch (Throwable throwable) {
                    DBUtils.closeSQLStuff(result, stmt);
                    throw throwable;
                }
            }
        }
        DBUtils.closeSQLStuff(result, stmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fillProperties(AbstractMailAccount mailAccount, int cid, int user, int id, Connection con) throws SQLException {
        ResultSet rs;
        PreparedStatement stmt;
        block6: {
            stmt = null;
            rs = null;
            try {
                stmt = con.prepareStatement("SELECT name, value FROM user_mail_account_properties WHERE cid = ? AND user = ? AND id = ?");
                int pos = 1;
                stmt.setInt(pos++, cid);
                stmt.setInt(pos++, user);
                stmt.setInt(pos, id);
                rs = stmt.executeQuery();
                if (rs.next()) {
                    HashMap<String, String> properties = new HashMap<String, String>(8, 1.0f);
                    do {
                        String name = rs.getString(1);
                        if (rs.wasNull()) continue;
                        String value = rs.getString(2);
                        if (rs.wasNull()) continue;
                        properties.put(name, value);
                    } while (rs.next());
                    if (0 == id) {
                        properties.put("addresses", RdbMailAccountStorage.getAliases(user, cid, mailAccount));
                    }
                    mailAccount.setProperties(properties);
                    break block6;
                }
                if (0 == id) {
                    HashMap<String, String> properties = new HashMap<String, String>(8, 1.0f);
                    properties.put("addresses", RdbMailAccountStorage.getAliases(user, cid, mailAccount));
                    mailAccount.setProperties(properties);
                    break block6;
                }
                mailAccount.setProperties(Collections.<String, String>emptyMap());
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(rs, stmt);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(rs, stmt);
    }

    private static String getAliases(int user, int cid, AbstractMailAccount mailAccount) {
        String[] aliases;
        StringAllocator sb = new StringAllocator(128);
        sb.append(mailAccount.getPrimaryAddress());
        HashSet<String> s = new HashSet<String>(4);
        s.add(mailAccount.getPrimaryAddress());
        try {
            aliases = UserStorage.getInstance().getUser(user, cid).getAliases();
        }
        catch (OXException e) {
            LOG.warn("", (Throwable)e);
            return sb.toString();
        }
        for (String alias : aliases) {
            if (!s.add(alias)) continue;
            sb.append(", ").append(alias);
        }
        return sb.toString();
    }

    RdbMailAccountStorage() {
    }

    @Override
    public void clearFullNamesForMailAccount(int id, int user, int cid) throws OXException {
        this.clearFullNamesForMailAccount(id, null, user, cid);
    }

    @Override
    public void clearFullNamesForMailAccount(int id, int[] indexes, int user, int cid) throws OXException {
        Connection con = Database.get(cid, true);
        boolean rollback = false;
        try {
            con.setAutoCommit(false);
            rollback = true;
            this.clearFullNamesForMailAccount(id, indexes, user, cid, con);
            con.commit();
            rollback = false;
        }
        catch (SQLException e) {
            throw MailAccountExceptionCodes.SQL_ERROR.create(e, e.getMessage());
        }
        catch (RuntimeException e) {
            throw MailAccountExceptionCodes.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
        finally {
            if (rollback) {
                DBUtils.rollback(con);
            }
            DBUtils.autocommit(con);
            Database.back(cid, true, con);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void clearFullNamesForMailAccount(int id, int[] indexes, int user, int cid, Connection con) throws OXException {
        if (null == con) {
            this.clearFullNamesForMailAccount(id, indexes, user, cid);
            return;
        }
        stmt = null;
        try {
            block10: {
                if (null != indexes && indexes.length != 0) break block10;
                stmt = con.prepareStatement("UPDATE user_mail_account SET trash_fullname=?, sent_fullname=?, drafts_fullname=?, spam_fullname=?, confirmed_spam_fullname=?, confirmed_ham_fullname=? WHERE cid=? AND id=? AND user=?");
                num = 1;
                stmt.setString(num++, "");
                stmt.setString(num++, "");
                stmt.setString(num++, "");
                stmt.setString(num++, "");
                stmt.setString(num++, "");
                stmt.setString(num++, "");
                stmt.setLong(num++, cid);
                stmt.setLong(num++, id);
                stmt.setLong(num++, user);
                ** GOTO lbl56
            }
            stmtBuilder = new StringAllocator(512).append("UPDATE user_mail_account SET ");
            finds = 0;
            for (int index : indexes) {
                col = (String)RdbMailAccountStorage.INDEX_2_COL.get(index);
                if (null == col) continue;
                ++finds;
                stmtBuilder.append(col).append("=?,");
            }
            if (finds <= 0) {
            }
            ** GOTO lbl-1000
        }
        catch (SQLException e) {
            try {
                throw MailAccountExceptionCodes.SQL_ERROR.create(e, new Object[]{e.getMessage()});
                catch (RuntimeException e) {
                    throw MailAccountExceptionCodes.UNEXPECTED_ERROR.create(e, new Object[]{e.getMessage()});
                }
            }
            catch (Throwable var14_18) {
                DBUtils.closeSQLStuff(stmt);
                throw var14_18;
            }
        }
        DBUtils.closeSQLStuff(stmt);
        return;
lbl-1000:
        // 1 sources

        {
            stmtBuilder.deleteLastChar();
            stmtBuilder.append(" WHERE cid=? AND id=? AND user=?");
            stmt = con.prepareStatement(stmtBuilder.toString());
            stmtBuilder = null;
            num = 1;
            i = finds;
            while (i-- > 0) {
                stmt.setString(num++, "");
            }
            stmt.setLong(num++, cid);
            stmt.setLong(num++, id);
            stmt.setLong(num++, user);
lbl56:
            // 2 sources

            stmt.executeUpdate();
        }
        DBUtils.closeSQLStuff(stmt);
    }

    @Override
    public void deleteMailAccount(int id, Map<String, Object> properties, int user, int cid) throws OXException {
        this.deleteMailAccount(id, properties, user, cid, false);
    }

    @Override
    public void deleteMailAccount(int id, Map<String, Object> properties, int user, int cid, boolean deletePrimary) throws OXException {
        if (!deletePrimary && 0 == id) {
            throw MailAccountExceptionCodes.NO_DEFAULT_DELETE.create(Autoboxing.I((int)user), Autoboxing.I((int)cid));
        }
        RdbMailAccountStorage.dropPOP3StorageFolders(user, cid);
        Connection con = Database.get(cid, true);
        try {
            con.setAutoCommit(false);
            this.deleteMailAccount(id, properties, user, cid, deletePrimary, con);
            con.commit();
        }
        catch (SQLException e) {
            DBUtils.rollback(con);
            throw MailAccountExceptionCodes.SQL_ERROR.create(e, e.getMessage());
        }
        catch (OXException e) {
            DBUtils.rollback(con);
            throw e;
        }
        catch (Exception e) {
            DBUtils.rollback(con);
            throw MailAccountExceptionCodes.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
        finally {
            DBUtils.autocommit(con);
            Database.back(cid, true, con);
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void deleteMailAccount(int id, Map<String, Object> properties, int user, int cid, boolean deletePrimary, Connection con) throws OXException {
        if (!deletePrimary && 0 == id) {
            throw MailAccountExceptionCodes.NO_DEFAULT_DELETE.create(Autoboxing.I((int)user), Autoboxing.I((int)cid));
        }
        RdbMailAccountStorage.dropPOP3StorageFolders(user, cid);
        boolean restoreConstraints = RdbMailAccountStorage.disableForeignKeyChecks(con);
        PreparedStatement stmt = null;
        String pop3Path = RdbMailAccountStorage.getPOP3Path(id, user, cid, con);
        if (null != pop3Path) {
            try {
                RdbMailAccountStorage.cleanseFromPrimary(pop3Path, user, cid);
            }
            catch (OXException e) {
                LOG.warn("Couldn't delete POP3 backup folders in primary mail account", (Throwable)e);
            }
        }
        DeleteListenerRegistry registry = DeleteListenerRegistry.getInstance();
        registry.triggerOnBeforeDeletion(id, properties, user, cid, con);
        this.deleteProperties(cid, user, id, con);
        this.deleteTransportProperties(cid, user, id, con);
        stmt = con.prepareStatement(DELETE_MAIL_ACCOUNT);
        stmt.setLong(1, cid);
        stmt.setLong(2, id);
        stmt.setLong(3, user);
        stmt.executeUpdate();
        DBUtils.closeSQLStuff(stmt);
        stmt = con.prepareStatement(DELETE_TRANSPORT_ACCOUNT);
        stmt.setLong(1, cid);
        stmt.setLong(2, id);
        stmt.setLong(3, user);
        stmt.executeUpdate();
        registry.triggerOnAfterDeletion(id, properties, user, cid, con);
        DBUtils.closeSQLStuff(stmt);
        if (!restoreConstraints) return;
        try {
            RdbMailAccountStorage.enableForeignKeyChecks(con);
            return;
        }
        catch (SQLException e) {
            LOG.error("", (Throwable)e);
        }
        return;
        catch (SQLException e) {
            String className = e.getClass().getName();
            if (null == className || !className.endsWith("MySQLIntegrityConstraintViolationException")) throw MailAccountExceptionCodes.SQL_ERROR.create(e, e.getMessage());
            try {
                if (!RdbMailAccountStorage.handleConstraintViolationException(e, id, user, cid, con)) throw MailAccountExceptionCodes.SQL_ERROR.create(e, e.getMessage());
                this.deleteMailAccount(id, properties, user, cid, deletePrimary, con);
                return;
            }
            catch (RuntimeException re) {
                LOG.debug("", (Throwable)re);
            }
            throw MailAccountExceptionCodes.SQL_ERROR.create(e, e.getMessage());
        }
        finally {
            DBUtils.closeSQLStuff(stmt);
            if (restoreConstraints) {
                try {
                    RdbMailAccountStorage.enableForeignKeyChecks(con);
                }
                catch (SQLException e) {
                    LOG.error("", (Throwable)e);
                }
            }
        }
    }

    private static String getPOP3Path(int id, int user, int cid, Connection con) throws OXException {
        String string;
        ResultSet rs;
        PreparedStatement stmt;
        block6: {
            stmt = null;
            rs = null;
            stmt = con.prepareStatement("SELECT url FROM user_mail_account WHERE cid = ? AND id = ? AND user = ?");
            stmt.setLong(1, cid);
            stmt.setLong(2, id);
            stmt.setLong(3, user);
            rs = stmt.executeQuery();
            if (rs.next() && rs.getString(1).startsWith("pop3")) break block6;
            String string2 = null;
            DBUtils.closeSQLStuff(rs, stmt);
            return string2;
        }
        try {
            DBUtils.closeSQLStuff(rs, stmt);
            stmt = con.prepareStatement("SELECT value FROM user_mail_account_properties WHERE cid = ? AND id = ? AND user = ? AND name = ?");
            stmt.setLong(1, cid);
            stmt.setLong(2, id);
            stmt.setLong(3, user);
            stmt.setString(4, "pop3.path");
            rs = stmt.executeQuery();
            string = rs.next() ? rs.getString(1) : null;
        }
        catch (SQLException e) {
            try {
                if (null != stmt) {
                    final String sql = stmt.toString();
                    LOG.debug("\n\tFailed mail account statement:\n\t{}", new Object(){

                        public String toString() {
                            return sql.substring(sql.indexOf(": ") + 2);
                        }
                    });
                }
                throw MailAccountExceptionCodes.SQL_ERROR.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(rs, stmt);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(rs, stmt);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cleanseFromPrimary(String path, int user, int cid) throws OXException {
        if (RdbMailAccountStorage.isEmpty(path)) {
            return;
        }
        MailAccess<IMailFolderStorage, IMailMessageStorage> defaultMailAccess = null;
        try {
            defaultMailAccess = MailAccess.getInstance(user, cid);
            defaultMailAccess.connect(false);
            defaultMailAccess.getFolderStorage().deleteFolder(path, true);
        }
        finally {
            if (null != defaultMailAccess) {
                defaultMailAccess.close(false);
            }
        }
    }

    private static boolean handleConstraintViolationException(SQLException e, int id, int user, int cid, Connection con) throws OXException {
        Matcher m = PATTERN_CONSTRAINT_VIOLATION.matcher(e.getMessage());
        if (!m.matches()) {
            return false;
        }
        String[] rows = m.group(2).replaceAll(Pattern.quote("`"), "").split(" *, *");
        if (rows.length != 3) {
            return false;
        }
        HashSet<String> set = new HashSet<String>(Arrays.asList(rows));
        set.removeAll(Arrays.asList("cid", "user", "id"));
        if (!set.isEmpty()) {
            return false;
        }
        String tableName = m.group(1);
        int pos = tableName.indexOf(47) + 1;
        if (pos > 0) {
            tableName = tableName.substring(pos);
        }
        return RdbMailAccountStorage.dropReferenced(id, user, cid, tableName, con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean dropReferenced(int id, int user, int cid, String tableName, Connection con) throws OXException {
        boolean transactional;
        try {
            boolean bl = transactional = !con.getAutoCommit();
            if (transactional) {
                DBUtils.rollback(con);
                con.setAutoCommit(true);
            }
        }
        catch (SQLException e) {
            throw MailAccountExceptionCodes.SQL_ERROR.create(e, e.getMessage());
        }
        String sql = new StringAllocator(64).append("DELETE FROM ").append(tableName).append(" WHERE cid = ? AND id = ? and user = ?").toString();
        PreparedStatement stmt = null;
        boolean retval = false;
        try {
            stmt = con.prepareStatement(sql);
            stmt.setLong(1, cid);
            stmt.setLong(2, id);
            stmt.setLong(3, user);
            stmt.executeUpdate();
            retval = true;
        }
        catch (SQLException e) {
            LOG.warn("Couldn't delete referenced entries with: {}", (Object)sql, (Object)e);
        }
        catch (Exception e) {
            LOG.warn("Couldn't delete referenced entries with: {}", (Object)sql, (Object)e);
        }
        finally {
            DBUtils.closeSQLStuff(stmt);
        }
        try {
            if (transactional) {
                con.setAutoCommit(false);
            }
        }
        catch (SQLException e) {
            throw MailAccountExceptionCodes.SQL_ERROR.create(e, e.getMessage());
        }
        return retval;
    }

    public MailAccount getDefaultMailAccount(int user, int cid, Connection con) throws OXException {
        return this.getMailAccount(0, user, cid, con);
    }

    @Override
    public MailAccount getDefaultMailAccount(int user, int cid) throws OXException {
        return this.getMailAccount(0, user, cid);
    }

    public MailAccount getMailAccount(int id, int user, int cid, Connection con) throws OXException {
        if (null == con) {
            return this.getMailAccount(id, user, cid);
        }
        AbstractMailAccount retval = 0 == id ? new DefaultMailAccount() : new CustomMailAccount();
        this.fillMailAccount(retval, id, user, cid, con);
        this.fillTransportAccount(retval, id, user, cid, con);
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MailAccount getMailAccount(int id, int user, int cid) throws OXException {
        Connection rcon = Database.get(cid, false);
        try {
            MailAccount mailAccount = this.getMailAccount(id, user, cid, rcon);
            return mailAccount;
        }
        finally {
            Database.back(cid, false, rcon);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MailAccount[] getUserMailAccounts(int user, int cid) throws OXException {
        Connection con = Database.get(cid, false);
        try {
            MailAccount[] mailAccountArray = this.getUserMailAccounts(user, cid, con);
            return mailAccountArray;
        }
        finally {
            Database.back(cid, false, con);
        }
    }

    @Override
    public MailAccount[] getUserMailAccounts(int user, int cid, Connection con) throws OXException {
        int[] ids = this.getUserMailAccountIDs(user, cid, con);
        MailAccount[] retval = new MailAccount[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            retval[i] = this.getMailAccount(ids[i], user, cid, con);
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int[] getUserMailAccountIDs(int user, int cid) throws OXException {
        Connection con = Database.get(cid, false);
        try {
            int[] nArray = this.getUserMailAccountIDs(user, cid, con);
            return nArray;
        }
        finally {
            Database.back(cid, false, con);
        }
    }

    int[] getUserMailAccountIDs(int user, int cid, Connection con) throws OXException {
        int[] nArray;
        ResultSet result;
        PreparedStatement stmt;
        block6: {
            stmt = null;
            result = null;
            stmt = con.prepareStatement(SELECT_MAIL_ACCOUNTS);
            stmt.setLong(1, cid);
            stmt.setLong(2, user);
            result = stmt.executeQuery();
            if (result.next()) break block6;
            int[] nArray2 = new int[]{};
            DBUtils.closeSQLStuff(result, stmt);
            return nArray2;
        }
        try {
            TIntArrayList ids = new TIntArrayList(8);
            do {
                String url;
                if (null == MailProviderRegistry.getRealMailProvider(ProviderUtility.extractProtocol(url = result.getString(2), URIDefaults.IMAP.getProtocol()))) continue;
                ids.add(result.getInt(1));
            } while (result.next());
            nArray = ids.toArray();
        }
        catch (SQLException e) {
            try {
                throw MailAccountExceptionCodes.SQL_ERROR.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(result, stmt);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(result, stmt);
        return nArray;
    }

    @Override
    public MailAccount[] resolveLogin(String login, int cid) throws OXException {
        int[][] idsAndUsers = this.resolveLogin2IDs(login, cid);
        MailAccount[] retval = new MailAccount[idsAndUsers.length];
        for (int i = 0; i < idsAndUsers.length; ++i) {
            int[] idAndUser = idsAndUsers[i];
            retval[i] = this.getMailAccount(idAndUser[0], idAndUser[1], cid);
        }
        return retval;
    }

    int[][] resolveLogin2IDs(String login, int cid) throws OXException {
        Collections.SmartIntArray usersArr;
        Collections.SmartIntArray idsArr;
        ResultSet result;
        PreparedStatement stmt;
        Connection con;
        block7: {
            con = Database.get(cid, false);
            stmt = null;
            result = null;
            idsArr = new Collections.SmartIntArray(8);
            usersArr = new Collections.SmartIntArray(8);
            stmt = con.prepareStatement(SELECT_BY_LOGIN);
            stmt.setLong(1, cid);
            stmt.setString(2, login);
            result = stmt.executeQuery();
            if (result.next()) break block7;
            int[][] nArrayArray = new int[][]{};
            DBUtils.closeSQLStuff(result, stmt);
            Database.back(cid, false, con);
            return nArrayArray;
        }
        try {
            do {
                idsArr.append(result.getInt(1));
                usersArr.append(result.getInt(2));
            } while (result.next());
        }
        catch (SQLException e) {
            try {
                throw MailAccountExceptionCodes.SQL_ERROR.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(result, stmt);
                Database.back(cid, false, con);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(result, stmt);
        Database.back(cid, false, con);
        int[] ids = idsArr.toArray();
        int[] users = usersArr.toArray();
        int[][] retval = new int[ids.length][];
        for (int i = 0; i < ids.length; ++i) {
            retval[i] = new int[]{ids[i], users[i]};
        }
        return retval;
    }

    @Override
    public MailAccount[] resolveLogin(String login, String serverUrl, int cid) throws OXException {
        int[][] idsAndUsers = this.resolveLogin2IDs(login, cid);
        ArrayList<MailAccount> l = new ArrayList<MailAccount>(idsAndUsers.length);
        for (int[] idAndUser : idsAndUsers) {
            MailAccount candidate = this.getMailAccount(idAndUser[0], idAndUser[1], cid);
            if (!serverUrl.equals(ProviderUtility.toSocketAddrString(candidate.generateMailServerURL(), 143))) continue;
            l.add(candidate);
        }
        return l.toArray(new MailAccount[l.size()]);
    }

    @Override
    public MailAccount[] resolvePrimaryAddr(String primaryAddress, int cid) throws OXException {
        int[][] idsAndUsers = this.resolvePrimaryAddr2IDs(primaryAddress, cid);
        ArrayList<MailAccount> l = new ArrayList<MailAccount>(idsAndUsers.length);
        for (int[] idAndUser : idsAndUsers) {
            MailAccount candidate = this.getMailAccount(idAndUser[0], idAndUser[1], cid);
            l.add(candidate);
        }
        return l.toArray(new MailAccount[l.size()]);
    }

    int[][] resolvePrimaryAddr2IDs(String primaryAddress, int cid) throws OXException {
        Collections.SmartIntArray usersArr;
        Collections.SmartIntArray idsArr;
        ResultSet result;
        PreparedStatement stmt;
        Connection con;
        block7: {
            con = Database.get(cid, false);
            stmt = null;
            result = null;
            idsArr = new Collections.SmartIntArray(8);
            usersArr = new Collections.SmartIntArray(8);
            stmt = con.prepareStatement(SELECT_BY_PRIMARY_ADDR);
            stmt.setLong(1, cid);
            stmt.setString(2, primaryAddress);
            result = stmt.executeQuery();
            if (result.next()) break block7;
            int[][] nArrayArray = new int[][]{};
            DBUtils.closeSQLStuff(result, stmt);
            Database.back(cid, false, con);
            return nArrayArray;
        }
        try {
            do {
                idsArr.append(result.getInt(1));
                usersArr.append(result.getInt(2));
            } while (result.next());
        }
        catch (SQLException e) {
            try {
                throw MailAccountExceptionCodes.SQL_ERROR.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(result, stmt);
                Database.back(cid, false, con);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(result, stmt);
        Database.back(cid, false, con);
        int[] ids = idsArr.toArray();
        int[] users = usersArr.toArray();
        int[][] idsAndUsers = new int[ids.length][];
        for (int i = 0; i < ids.length; ++i) {
            idsAndUsers[i] = new int[]{ids[i], users[i]};
        }
        return idsAndUsers;
    }

    @Override
    public void updateMailAccount(MailAccountDescription mailAccount, Set<Attribute> attributes, int user, int cid, Session session) throws OXException {
        this.updateMailAccount(mailAccount, attributes, user, cid, session, false);
    }

    private void updateMailAccount(MailAccountDescription mailAccount, Set<Attribute> attributes, int user, int cid, Session session, boolean changePrimary) throws OXException {
        Connection con = Database.get(cid, true);
        try {
            con.setAutoCommit(false);
            this.updateMailAccount(mailAccount, attributes, user, cid, session, con, changePrimary);
            con.commit();
        }
        catch (SQLException e) {
            DBUtils.rollback(con);
            throw MailAccountExceptionCodes.SQL_ERROR.create(e, e.getMessage());
        }
        catch (OXException e) {
            DBUtils.rollback(con);
            throw e;
        }
        catch (Exception e) {
            DBUtils.rollback(con);
            throw MailAccountExceptionCodes.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
        finally {
            DBUtils.autocommit(con);
            Database.back(cid, true, con);
        }
    }

    @Override
    public void updateMailAccount(MailAccountDescription mailAccount, Set<Attribute> attributes, int user, int cid, Session session, Connection con, boolean changePrimary) throws OXException {
        String name;
        if (null == con) {
            this.updateMailAccount(mailAccount, attributes, user, cid, session, changePrimary);
            return;
        }
        RdbMailAccountStorage.dropPOP3StorageFolders(user, cid);
        if (attributes.contains((Object)Attribute.NAME_LITERAL) && !RdbMailAccountStorage.isValid(name = mailAccount.getName())) {
            throw MailAccountExceptionCodes.INVALID_NAME.create(name);
        }
        if (!changePrimary && (mailAccount.isDefaultFlag() || 0 == mailAccount.getId())) {
            boolean containsUnifiedInbox = attributes.contains((Object)Attribute.UNIFIED_INBOX_ENABLED_LITERAL);
            boolean containsPersonal = attributes.contains((Object)Attribute.PERSONAL_LITERAL);
            boolean containsReplyTo = attributes.contains((Object)Attribute.REPLY_TO_LITERAL);
            boolean containsArchive = attributes.contains((Object)Attribute.ARCHIVE_LITERAL);
            boolean containsArchiveFullName = attributes.contains((Object)Attribute.ARCHIVE_FULLNAME_LITERAL);
            if (!(containsUnifiedInbox || containsPersonal || containsReplyTo || containsArchive || containsArchiveFullName)) {
                throw MailAccountExceptionCodes.NO_DEFAULT_UPDATE.create(Autoboxing.I((int)user), Autoboxing.I((int)cid));
            }
            MailAccount storageVersion = this.getMailAccount(mailAccount.getId(), user, cid, con);
            MailAccountGetSwitch storageGetSwitch = new MailAccountGetSwitch(storageVersion);
            GetSwitch getSwitch = new GetSwitch(mailAccount);
            for (Attribute attribute : attributes) {
                if (PRIMARY_EDITABLE.contains((Object)attribute)) continue;
                Object storageValue = attribute.doSwitch(storageGetSwitch);
                Object newValue = attribute.doSwitch(getSwitch);
                if (null == storageValue || !(Attribute.PASSWORD_LITERAL.equals((Object)attribute) || Attribute.TRANSPORT_PASSWORD_LITERAL.equals((Object)attribute) || Attribute.TRANSPORT_LOGIN_LITERAL.equals((Object)attribute) ? null != newValue : !(!DEFAULT_FULL_NAMES.contains((Object)attribute) ? storageValue.equals(newValue) : MailFolderUtility.prepareMailFolderParam(storageValue.toString()).equals(MailFolderUtility.prepareMailFolderParam(newValue.toString()))))) continue;
                throw MailAccountExceptionCodes.NO_DEFAULT_UPDATE_ATTR.create(attribute.getName(), Autoboxing.I((int)user), Autoboxing.I((int)cid));
            }
            if (containsUnifiedInbox) {
                UnifiedInboxManagement management;
                this.updateUnifiedINBOXEnabled(mailAccount.isUnifiedINBOXEnabled(), 0, user, cid, con);
                if (mailAccount.isUnifiedINBOXEnabled() && null != (management = ServerServiceRegistry.getInstance().getService(UnifiedInboxManagement.class)) && !management.exists(user, cid, con)) {
                    management.createUnifiedINBOX(user, cid, con);
                }
            }
            if (containsPersonal) {
                this.updatePersonal(mailAccount.getPersonal(), 0, user, cid, con);
            }
            if (containsReplyTo) {
                this.updateReplyTo(mailAccount.getReplyTo(), 0, user, cid, con);
            }
            if (containsArchive) {
                this.updateArchive(mailAccount.getArchive(), 0, user, cid, con);
            }
            if (containsArchiveFullName) {
                this.updateArchiveFullName(mailAccount.getArchiveFullname(), 0, user, cid, con);
            }
        } else {
            UnifiedInboxManagement management;
            Object stmt = null;
            ResultSet rs = null;
            try {
                Object value;
                SetSwitch setSwitch;
                MailAccountGetSwitch getSwitch;
                MailAccount storageVersion = null;
                if (this.prepareURL(attributes, Attribute.MAIL_URL_ATTRIBUTES, Attribute.MAIL_URL_LITERAL)) {
                    storageVersion = this.getMailAccount(mailAccount.getId(), user, cid, con);
                    getSwitch = new MailAccountGetSwitch(storageVersion);
                    setSwitch = new SetSwitch(mailAccount);
                    for (Attribute attribute : Attribute.MAIL_URL_ATTRIBUTES) {
                        if (attributes.contains((Object)attribute)) continue;
                        value = attribute.doSwitch(getSwitch);
                        setSwitch.setValue(value);
                        attribute.doSwitch(setSwitch);
                    }
                    this.checkDuplicateMailAccount(mailAccount, (TIntSet)new TIntHashSet(new int[]{mailAccount.getId()}), user, cid, con);
                } else if (attributes.contains((Object)Attribute.MAIL_URL_LITERAL)) {
                    this.checkDuplicateMailAccount(mailAccount, (TIntSet)new TIntHashSet(new int[]{mailAccount.getId()}), user, cid, con);
                }
                if (this.prepareURL(attributes, Attribute.TRANSPORT_URL_ATTRIBUTES, Attribute.TRANSPORT_URL_LITERAL)) {
                    if (null == storageVersion) {
                        storageVersion = this.getMailAccount(mailAccount.getId(), user, cid, con);
                    }
                    getSwitch = new MailAccountGetSwitch(storageVersion);
                    setSwitch = new SetSwitch(mailAccount);
                    for (Attribute attribute : Attribute.TRANSPORT_URL_ATTRIBUTES) {
                        if (attributes.contains((Object)attribute)) continue;
                        value = attribute.doSwitch(getSwitch);
                        setSwitch.setValue(value);
                        attribute.doSwitch(setSwitch);
                    }
                    this.checkDuplicateTransportAccount(mailAccount, (TIntSet)new TIntHashSet(new int[]{mailAccount.getId()}), user, cid, con);
                } else if (attributes.contains((Object)Attribute.TRANSPORT_URL_LITERAL)) {
                    this.checkDuplicateTransportAccount(mailAccount, (TIntSet)new TIntHashSet(new int[]{mailAccount.getId()}), user, cid, con);
                }
                attributes.removeAll(Attribute.MAIL_URL_ATTRIBUTES);
                attributes.removeAll(Attribute.TRANSPORT_URL_ATTRIBUTES);
                String encryptedPassword = null;
                ArrayList<Attribute> orderedAttributes = null;
                if (UpdateMailAccountBuilder.needsUpdate(attributes)) {
                    orderedAttributes = new ArrayList<Attribute>(attributes);
                    UpdateMailAccountBuilder sqlBuilder = new UpdateMailAccountBuilder();
                    for (Attribute attribute : orderedAttributes) {
                        attribute.doSwitch(sqlBuilder);
                    }
                    stmt = con.prepareStatement(sqlBuilder.getUpdateQuery());
                    GetSwitch getter = new GetSwitch(mailAccount);
                    int pos = 1;
                    for (Attribute attribute : orderedAttributes) {
                        String s;
                        if (!sqlBuilder.handles(attribute)) continue;
                        Object value2 = attribute.doSwitch(getter);
                        if (Attribute.PASSWORD_LITERAL == attribute) {
                            encryptedPassword = this.encrypt(mailAccount.getPassword(), session);
                            RdbMailAccountStorage.setOptionalString((PreparedStatement)stmt, pos++, encryptedPassword);
                            continue;
                        }
                        if (Attribute.PERSONAL_LITERAL == attribute) {
                            String personal = mailAccount.getPersonal();
                            if (RdbMailAccountStorage.isEmpty(personal)) {
                                stmt.setNull(pos++, 12);
                                continue;
                            }
                            stmt.setString(pos++, personal);
                            continue;
                        }
                        if (Attribute.REPLY_TO_LITERAL == attribute) {
                            String replyTo = mailAccount.getReplyTo();
                            if (RdbMailAccountStorage.isEmpty(replyTo)) {
                                stmt.setNull(pos++, 12);
                                continue;
                            }
                            stmt.setString(pos++, replyTo);
                            continue;
                        }
                        if (Attribute.ARCHIVE_LITERAL == attribute) {
                            s = mailAccount.getArchive();
                            if (RdbMailAccountStorage.isEmpty(s)) {
                                stmt.setString(pos++, "");
                                continue;
                            }
                            stmt.setString(pos++, s);
                            continue;
                        }
                        if (Attribute.ARCHIVE_FULLNAME_LITERAL == attribute) {
                            s = mailAccount.getArchiveFullname();
                            if (RdbMailAccountStorage.isEmpty(s)) {
                                stmt.setString(pos++, "");
                                continue;
                            }
                            stmt.setString(pos++, MailFolderUtility.prepareMailFolderParam(s).getFullname());
                            continue;
                        }
                        if (DEFAULT.contains((Object)attribute)) {
                            if (DEFAULT_FULL_NAMES.contains((Object)attribute)) {
                                String fullName = null == value2 ? "" : MailFolderUtility.prepareMailFolderParam((String)value2).getFullname();
                                stmt.setString(pos++, fullName);
                                continue;
                            }
                            if (null == value2) {
                                stmt.setObject(pos++, "");
                                continue;
                            }
                            stmt.setObject(pos++, value2);
                            continue;
                        }
                        stmt.setObject(pos++, value2);
                    }
                    stmt.setLong(pos++, cid);
                    stmt.setLong(pos++, mailAccount.getId());
                    stmt.setLong(pos++, user);
                    if (LOG.isDebugEnabled()) {
                        String query = stmt.toString();
                        LOG.debug("Trying to perform SQL update query for attributes {} :\n{}", orderedAttributes, (Object)query.substring(query.indexOf(58) + 1));
                    }
                    stmt.executeUpdate();
                    DBUtils.closeSQLStuff((Statement)stmt);
                }
                if (UpdateTransportAccountBuilder.needsUpdate(attributes)) {
                    if (orderedAttributes == null) {
                        orderedAttributes = new ArrayList<Attribute>(attributes);
                    }
                    stmt = con.prepareStatement("SELECT 1 FROM user_transport_account WHERE cid = ? AND id = ? AND user = ?");
                    int pos = 1;
                    stmt.setLong(pos++, cid);
                    stmt.setLong(pos++, mailAccount.getId());
                    stmt.setLong(pos++, user);
                    rs = stmt.executeQuery();
                    boolean exists = rs.next();
                    DBUtils.closeSQLStuff(rs, (Statement)stmt);
                    if (exists) {
                        UpdateTransportAccountBuilder sqlBuilder = new UpdateTransportAccountBuilder();
                        for (Attribute attribute : orderedAttributes) {
                            attribute.doSwitch(sqlBuilder);
                        }
                        stmt = con.prepareStatement(sqlBuilder.getUpdateQuery());
                        GetSwitch getter = new GetSwitch(mailAccount);
                        pos = 1;
                        for (Attribute attribute : orderedAttributes) {
                            if (!sqlBuilder.handles(attribute)) continue;
                            Object value3 = attribute.doSwitch(getter);
                            if (Attribute.TRANSPORT_PASSWORD_LITERAL == attribute) {
                                if (encryptedPassword == null) {
                                    encryptedPassword = this.encrypt(mailAccount.getTransportPassword(), session);
                                }
                                RdbMailAccountStorage.setOptionalString((PreparedStatement)stmt, pos++, encryptedPassword);
                                continue;
                            }
                            if (Attribute.TRANSPORT_LOGIN_LITERAL == attribute) {
                                RdbMailAccountStorage.setOptionalString((PreparedStatement)stmt, pos++, (String)value3);
                                continue;
                            }
                            if (Attribute.TRANSPORT_URL_LITERAL == attribute) {
                                RdbMailAccountStorage.setOptionalString((PreparedStatement)stmt, pos++, (String)value3);
                                continue;
                            }
                            if (Attribute.PERSONAL_LITERAL == attribute) {
                                String personal = mailAccount.getPersonal();
                                if (RdbMailAccountStorage.isEmpty(personal)) {
                                    stmt.setNull(pos++, 12);
                                    continue;
                                }
                                stmt.setString(pos++, personal);
                                continue;
                            }
                            if (Attribute.REPLY_TO_LITERAL == attribute) {
                                String replyTo = mailAccount.getReplyTo();
                                if (RdbMailAccountStorage.isEmpty(replyTo)) {
                                    stmt.setNull(pos++, 12);
                                    continue;
                                }
                                stmt.setString(pos++, replyTo);
                                continue;
                            }
                            stmt.setObject(pos++, value3);
                        }
                        stmt.setLong(pos++, cid);
                        stmt.setLong(pos++, mailAccount.getId());
                        stmt.setLong(pos++, user);
                        if (LOG.isDebugEnabled()) {
                            String query = stmt.toString();
                            LOG.debug("Trying to perform SQL update query for attributes {} :\n{}", orderedAttributes, (Object)query.substring(query.indexOf(58) + 1));
                        }
                        stmt.executeUpdate();
                        DBUtils.closeSQLStuff((Statement)stmt);
                    } else {
                        String transportURL = mailAccount.generateTransportServerURL();
                        if (null != transportURL) {
                            stmt.close();
                            String encryptedTransportPassword = session == null ? null : this.encrypt(mailAccount.getTransportPassword(), session);
                            stmt = con.prepareStatement(INSERT_TRANSPORT_ACCOUNT);
                            pos = 1;
                            stmt.setLong(pos++, cid);
                            stmt.setLong(pos++, mailAccount.getId());
                            stmt.setLong(pos++, user);
                            RdbMailAccountStorage.setOptionalString((PreparedStatement)stmt, pos++, mailAccount.getName());
                            stmt.setString(pos++, transportURL);
                            if (null == mailAccount.getTransportLogin()) {
                                stmt.setString(pos++, "");
                            } else {
                                stmt.setString(pos++, mailAccount.getTransportLogin());
                            }
                            RdbMailAccountStorage.setOptionalString((PreparedStatement)stmt, pos++, encryptedTransportPassword);
                            RdbMailAccountStorage.setOptionalString((PreparedStatement)stmt, pos++, mailAccount.getPrimaryAddress());
                            stmt.setInt(pos++, 0);
                            String personal = mailAccount.getPersonal();
                            if (RdbMailAccountStorage.isEmpty(personal)) {
                                stmt.setNull(pos++, 12);
                            } else {
                                stmt.setString(pos++, personal);
                            }
                            String replyTo = mailAccount.getReplyTo();
                            if (RdbMailAccountStorage.isEmpty(replyTo)) {
                                stmt.setNull(pos++, 12);
                            } else {
                                stmt.setString(pos++, replyTo);
                            }
                            if (LOG.isDebugEnabled()) {
                                String query = stmt.toString();
                                LOG.debug("Trying to perform SQL insert query for attributes {} :\n{}", orderedAttributes, (Object)query.substring(query.indexOf(58) + 1));
                            }
                            stmt.executeUpdate();
                            DBUtils.closeSQLStuff((Statement)stmt);
                        }
                    }
                }
                Map<String, String> properties = mailAccount.getProperties();
                if (attributes.contains((Object)Attribute.POP3_DELETE_WRITE_THROUGH_LITERAL)) {
                    this.updateProperty(cid, user, mailAccount.getId(), "pop3.deletewt", properties.get("pop3.deletewt"), con);
                }
                if (attributes.contains((Object)Attribute.POP3_EXPUNGE_ON_QUIT_LITERAL)) {
                    this.updateProperty(cid, user, mailAccount.getId(), "pop3.expunge", properties.get("pop3.expunge"), con);
                }
                if (attributes.contains((Object)Attribute.POP3_REFRESH_RATE_LITERAL)) {
                    this.updateProperty(cid, user, mailAccount.getId(), "pop3.refreshrate", properties.get("pop3.refreshrate"), con);
                }
                if (attributes.contains((Object)Attribute.POP3_STORAGE_LITERAL)) {
                    this.updateProperty(cid, user, mailAccount.getId(), "pop3.storage", properties.get("pop3.storage"), con);
                }
                if (attributes.contains((Object)Attribute.POP3_PATH_LITERAL)) {
                    this.updateProperty(cid, user, mailAccount.getId(), "pop3.path", properties.get("pop3.path"), con);
                }
            }
            catch (SQLException e) {
                try {
                    if (null != stmt) {
                        final String sql = stmt.toString();
                        LOG.debug("\n\tFailed mail account statement:\n\t{}", new Object(){

                            public String toString() {
                                return sql.substring(sql.indexOf(": ") + 2);
                            }
                        });
                    }
                    throw MailAccountExceptionCodes.SQL_ERROR.create(e, e.getMessage());
                }
                catch (Throwable throwable) {
                    DBUtils.closeSQLStuff(rs, stmt);
                    throw throwable;
                }
            }
            DBUtils.closeSQLStuff(rs, (Statement)stmt);
            if (attributes.contains((Object)Attribute.UNIFIED_INBOX_ENABLED_LITERAL) && mailAccount.isUnifiedINBOXEnabled() && null != (management = ServerServiceRegistry.getInstance().getService(UnifiedInboxManagement.class)) && !management.exists(user, cid, con)) {
                management.createUnifiedINBOX(user, cid, con);
            }
        }
    }

    private void updateUnifiedINBOXEnabled(boolean unifiedINBOXEnabled, int id, int user, int cid, Connection con) throws OXException {
        PreparedStatement stmt = null;
        try {
            stmt = con.prepareStatement(UPDATE_UNIFIED_INBOX_FLAG);
            int pos = 1;
            stmt.setInt(pos++, unifiedINBOXEnabled ? 1 : 0);
            stmt.setInt(pos++, cid);
            stmt.setInt(pos++, id);
            stmt.setInt(pos++, user);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            if (null != stmt) {
                final String sql = stmt.toString();
                LOG.debug("\n\tFailed mail account statement:\n\t{}", new Object(){

                    public String toString() {
                        return sql.substring(sql.indexOf(": ") + 2);
                    }
                });
            }
            throw MailAccountExceptionCodes.SQL_ERROR.create(e, e.getMessage());
        }
        finally {
            DBUtils.closeSQLStuff(stmt);
        }
    }

    private void updatePersonal(String personal, int id, int user, int cid, Connection con) throws OXException {
        PreparedStatement stmt = null;
        try {
            stmt = con.prepareStatement(UPDATE_PERSONAL1);
            int pos = 1;
            if (null == personal) {
                stmt.setNull(pos++, 12);
            } else {
                stmt.setString(pos++, personal);
            }
            stmt.setInt(pos++, cid);
            stmt.setInt(pos++, id);
            stmt.setInt(pos++, user);
            stmt.executeUpdate();
            DBUtils.closeSQLStuff(stmt);
            stmt = con.prepareStatement(UPDATE_PERSONAL2);
            pos = 1;
            if (null == personal) {
                stmt.setNull(pos++, 12);
            } else {
                stmt.setString(pos++, personal);
            }
            stmt.setInt(pos++, cid);
            stmt.setInt(pos++, id);
            stmt.setInt(pos++, user);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            throw MailAccountExceptionCodes.SQL_ERROR.create(e, e.getMessage());
        }
        finally {
            DBUtils.closeSQLStuff(stmt);
        }
    }

    private void updateReplyTo(String replyTo, int id, int user, int cid, Connection con) throws OXException {
        PreparedStatement stmt = null;
        try {
            stmt = con.prepareStatement("UPDATE user_mail_account SET replyTo = ? WHERE cid = ? AND id = ? AND user = ?");
            int pos = 1;
            if (null == replyTo) {
                stmt.setNull(pos++, 12);
            } else {
                stmt.setString(pos++, replyTo);
            }
            stmt.setInt(pos++, cid);
            stmt.setInt(pos++, id);
            stmt.setInt(pos++, user);
            stmt.executeUpdate();
            DBUtils.closeSQLStuff(stmt);
            stmt = con.prepareStatement("UPDATE user_transport_account SET replyTo = ? WHERE cid = ? AND id = ? AND user = ?");
            pos = 1;
            if (null == replyTo) {
                stmt.setNull(pos++, 12);
            } else {
                stmt.setString(pos++, replyTo);
            }
            stmt.setInt(pos++, cid);
            stmt.setInt(pos++, id);
            stmt.setInt(pos++, user);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            throw MailAccountExceptionCodes.SQL_ERROR.create(e, e.getMessage());
        }
        finally {
            DBUtils.closeSQLStuff(stmt);
        }
    }

    private void updateArchive(String archive, int id, int user, int cid, Connection con) throws OXException {
        PreparedStatement stmt = null;
        try {
            stmt = con.prepareStatement("UPDATE user_mail_account SET archive = ? WHERE cid = ? AND id = ? AND user = ?");
            int pos = 1;
            if (null == archive) {
                stmt.setNull(pos++, 12);
            } else {
                stmt.setString(pos++, archive);
            }
            stmt.setInt(pos++, cid);
            stmt.setInt(pos++, id);
            stmt.setInt(pos++, user);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            throw MailAccountExceptionCodes.SQL_ERROR.create(e, e.getMessage());
        }
        finally {
            DBUtils.closeSQLStuff(stmt);
        }
    }

    private void updateArchiveFullName(String archiveFullName, int id, int user, int cid, Connection con) throws OXException {
        PreparedStatement stmt = null;
        try {
            stmt = con.prepareStatement("UPDATE user_mail_account SET archive_fullname = ? WHERE cid = ? AND id = ? AND user = ?");
            int pos = 1;
            if (null == archiveFullName) {
                stmt.setNull(pos++, 12);
            } else {
                stmt.setString(pos++, archiveFullName);
            }
            stmt.setInt(pos++, cid);
            stmt.setInt(pos++, id);
            stmt.setInt(pos++, user);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            throw MailAccountExceptionCodes.SQL_ERROR.create(e, e.getMessage());
        }
        finally {
            DBUtils.closeSQLStuff(stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateProperty(int cid, int user, int accountId, String name, String newValue, Connection con) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = con.prepareStatement("DELETE FROM user_mail_account_properties WHERE cid = ? AND user = ? AND id = ? AND name = ?");
            int pos = 1;
            stmt.setInt(pos++, cid);
            stmt.setInt(pos++, user);
            stmt.setInt(pos++, accountId);
            stmt.setString(pos++, name);
            stmt.executeUpdate();
            if (null != newValue && newValue.length() > 0) {
                DBUtils.closeSQLStuff(stmt);
                stmt = con.prepareStatement("INSERT INTO user_mail_account_properties (cid, user, id, name, value) VALUES (?, ?, ?, ?, ?)");
                pos = 1;
                stmt.setInt(pos++, cid);
                stmt.setInt(pos++, user);
                stmt.setInt(pos++, accountId);
                stmt.setString(pos++, name);
                stmt.setString(pos++, newValue);
                stmt.executeUpdate();
            }
        }
        finally {
            DBUtils.closeSQLStuff(stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteProperties(int cid, int user, int accountId, Connection con) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = con.prepareStatement("DELETE FROM user_mail_account_properties WHERE cid = ? AND user = ? AND id = ?");
            int pos = 1;
            stmt.setInt(pos++, cid);
            stmt.setInt(pos++, user);
            stmt.setInt(pos++, accountId);
            stmt.executeUpdate();
        }
        finally {
            DBUtils.closeSQLStuff(stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteTransportProperties(int cid, int user, int accountId, Connection con) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = con.prepareStatement("DELETE FROM user_transport_account_properties WHERE cid = ? AND user = ? AND id = ?");
            int pos = 1;
            stmt.setInt(pos++, cid);
            stmt.setInt(pos++, user);
            stmt.setInt(pos++, accountId);
            stmt.executeUpdate();
        }
        finally {
            DBUtils.closeSQLStuff(stmt);
        }
    }

    private boolean prepareURL(Set<Attribute> attributes, Set<Attribute> compareWith, Attribute urlAttribute) {
        EnumSet<Attribute> copy;
        EnumSet<Attribute> enumSet = copy = attributes.isEmpty() ? EnumSet.noneOf(Attribute.class) : EnumSet.copyOf(attributes);
        if (copy.removeAll(compareWith)) {
            attributes.add(urlAttribute);
            return !attributes.containsAll(compareWith);
        }
        return false;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void updateMailAccount(MailAccountDescription mailAccount, int user, int cid, Session session) throws OXException {
        if (mailAccount.isDefaultFlag() || 0 == mailAccount.getId()) {
            throw MailAccountExceptionCodes.NO_DEFAULT_UPDATE.create(Autoboxing.I((int)user), Autoboxing.I((int)cid));
        }
        String name = mailAccount.getName();
        if (!RdbMailAccountStorage.isValid(name)) {
            throw MailAccountExceptionCodes.INVALID_NAME.create(name);
        }
        RdbMailAccountStorage.dropPOP3StorageFolders(user, cid);
        Connection con = Database.get(cid, true);
        PreparedStatement stmt = null;
        try {
            UnifiedInboxManagement management;
            Map<String, String> properties;
            this.checkDuplicateMailAccount(mailAccount, (TIntSet)new TIntHashSet(new int[]{mailAccount.getId()}), user, cid, con);
            this.checkDuplicateTransportAccount(mailAccount, (TIntSet)new TIntHashSet(new int[]{mailAccount.getId()}), user, cid, con);
            con.setAutoCommit(false);
            String encryptedPassword = this.encrypt(mailAccount.getPassword(), session);
            stmt = con.prepareStatement(UPDATE_MAIL_ACCOUNT);
            int pos = 1;
            stmt.setString(pos++, name);
            stmt.setString(pos++, mailAccount.generateMailServerURL());
            stmt.setString(pos++, mailAccount.getLogin());
            RdbMailAccountStorage.setOptionalString(stmt, pos++, encryptedPassword);
            stmt.setString(pos++, mailAccount.getPrimaryAddress());
            String sh = mailAccount.getSpamHandler();
            if (null == sh) {
                stmt.setNull(pos++, 12);
            } else {
                stmt.setString(pos++, sh);
            }
            RdbMailAccountStorage.setOptionalString(stmt, pos++, mailAccount.getTrash());
            RdbMailAccountStorage.setOptionalString(stmt, pos++, mailAccount.getSent());
            RdbMailAccountStorage.setOptionalString(stmt, pos++, mailAccount.getDrafts());
            RdbMailAccountStorage.setOptionalString(stmt, pos++, mailAccount.getSpam());
            RdbMailAccountStorage.setOptionalString(stmt, pos++, mailAccount.getConfirmedSpam());
            RdbMailAccountStorage.setOptionalString(stmt, pos++, mailAccount.getConfirmedHam());
            stmt.setInt(pos++, mailAccount.isUnifiedINBOXEnabled() ? 1 : 0);
            RdbMailAccountStorage.setOptionalString(stmt, pos++, mailAccount.getTrashFullname());
            RdbMailAccountStorage.setOptionalString(stmt, pos++, mailAccount.getSentFullname());
            RdbMailAccountStorage.setOptionalString(stmt, pos++, mailAccount.getDraftsFullname());
            RdbMailAccountStorage.setOptionalString(stmt, pos++, mailAccount.getSpamFullname());
            RdbMailAccountStorage.setOptionalString(stmt, pos++, mailAccount.getConfirmedSpamFullname());
            RdbMailAccountStorage.setOptionalString(stmt, pos++, mailAccount.getConfirmedHamFullname());
            String personal = mailAccount.getPersonal();
            if (RdbMailAccountStorage.isEmpty(personal)) {
                stmt.setNull(pos++, 12);
            } else {
                stmt.setString(pos++, personal);
            }
            String replyTo = mailAccount.getReplyTo();
            if (RdbMailAccountStorage.isEmpty(replyTo)) {
                stmt.setNull(pos++, 12);
            } else {
                stmt.setString(pos++, replyTo);
            }
            stmt.setLong(pos++, cid);
            stmt.setLong(pos++, mailAccount.getId());
            stmt.setLong(pos++, user);
            stmt.executeUpdate();
            String transportURL = mailAccount.generateTransportServerURL();
            if (null != transportURL) {
                String encryptedTransportPassword = this.encrypt(mailAccount.getTransportPassword(), session);
                stmt.close();
                stmt = con.prepareStatement(UPDATE_TRANSPORT_ACCOUNT);
                int pos2 = 1;
                stmt.setString(pos2++, name);
                stmt.setString(pos2++, transportURL);
                RdbMailAccountStorage.setOptionalString(stmt, pos2++, mailAccount.getTransportLogin());
                RdbMailAccountStorage.setOptionalString(stmt, pos2++, encryptedTransportPassword);
                stmt.setString(pos2++, mailAccount.getPrimaryAddress());
                personal = mailAccount.getPersonal();
                if (RdbMailAccountStorage.isEmpty(personal)) {
                    stmt.setNull(pos2++, 12);
                } else {
                    stmt.setString(pos2++, personal);
                }
                replyTo = mailAccount.getReplyTo();
                if (RdbMailAccountStorage.isEmpty(replyTo)) {
                    stmt.setNull(pos2++, 12);
                } else {
                    stmt.setString(pos2++, replyTo);
                }
                stmt.setLong(pos2++, cid);
                stmt.setLong(pos2++, mailAccount.getId());
                stmt.setLong(pos2++, user);
                stmt.executeUpdate();
            }
            if ((properties = mailAccount.getProperties()).containsKey("pop3.deletewt")) {
                this.updateProperty(cid, user, mailAccount.getId(), "pop3.deletewt", properties.get("pop3.deletewt"), con);
            }
            if (properties.containsKey("pop3.expunge")) {
                this.updateProperty(cid, user, mailAccount.getId(), "pop3.expunge", properties.get("pop3.expunge"), con);
            }
            if (properties.containsKey("pop3.refreshrate")) {
                this.updateProperty(cid, user, mailAccount.getId(), "pop3.refreshrate", properties.get("pop3.refreshrate"), con);
            }
            if (properties.containsKey("pop3.storage")) {
                this.updateProperty(cid, user, mailAccount.getId(), "pop3.storage", properties.get("pop3.storage"), con);
            }
            if (properties.containsKey("pop3.path")) {
                this.updateProperty(cid, user, mailAccount.getId(), "pop3.path", properties.get("pop3.path"), con);
            }
            con.commit();
            DBUtils.autocommit(con);
            if (mailAccount.isUnifiedINBOXEnabled() && null != (management = ServerServiceRegistry.getInstance().getService(UnifiedInboxManagement.class)) && !management.exists(user, cid, con)) {
                management.createUnifiedINBOX(user, cid, con);
            }
        }
        catch (SQLException e) {
            try {
                DBUtils.rollback(con);
                throw MailAccountExceptionCodes.SQL_ERROR.create(e, e.getMessage());
                catch (OXException e2) {
                    DBUtils.rollback(con);
                    throw e2;
                }
                catch (Exception e3) {
                    DBUtils.rollback(con);
                    throw MailAccountExceptionCodes.UNEXPECTED_ERROR.create(e3, e3.getMessage());
                }
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(null, stmt);
                DBUtils.autocommit(con);
                Database.back(cid, true, con);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(null, stmt);
        DBUtils.autocommit(con);
        Database.back(cid, true, con);
    }

    @Override
    public int insertMailAccount(MailAccountDescription mailAccount, int user, Context ctx, Session session, Connection con) throws OXException {
        UnifiedInboxManagement management;
        int id;
        int cid = ctx.getContextId();
        boolean isUnifiedMail = mailAccount.getMailProtocol().startsWith(UnifiedInboxManagement.PROTOCOL_UNIFIED_INBOX, 0);
        String primaryAddress = mailAccount.getPrimaryAddress();
        String name = mailAccount.getName();
        if (!isUnifiedMail) {
            List<IPRange> ranges = MailProperties.getInstance().getAccountBlacklistRanges();
            if (!mailAccount.isDefaultFlag() && null != ranges && !ranges.isEmpty()) {
                this.checkHostIfBlacklisted(mailAccount.getMailServer(), ranges);
                this.checkHostIfBlacklisted(mailAccount.getTransportServer(), ranges);
            }
            if (-1 != this.getByPrimaryAddress(primaryAddress, user, cid, con)) {
                throw MailAccountExceptionCodes.CONFLICT_ADDR.create(primaryAddress, Autoboxing.I((int)user), Autoboxing.I((int)cid));
            }
            this.checkDuplicateMailAccount(mailAccount, null, user, cid, con);
            this.checkDuplicateTransportAccount(mailAccount, null, user, cid, con);
            if (!RdbMailAccountStorage.isValid(name)) {
                throw MailAccountExceptionCodes.INVALID_NAME.create(name);
            }
        }
        RdbMailAccountStorage.dropPOP3StorageFolders(user, cid);
        if (mailAccount.isDefaultFlag()) {
            try {
                this.getDefaultMailAccount(user, cid, con);
                throw MailAccountExceptionCodes.NO_DUPLICATE_DEFAULT.create();
            }
            catch (OXException e) {
                LOG.trace("", (Throwable)e);
                id = 0;
            }
        } else {
            try {
                id = IDGenerator.getId(ctx, 1132, con);
            }
            catch (SQLException e) {
                throw MailAccountExceptionCodes.SQL_ERROR.create(e, e.getMessage());
            }
        }
        PreparedStatement stmt = null;
        try {
            Map<String, String> properties;
            stmt = con.prepareStatement(INSERT_MAIL_ACCOUNT);
            String encryptedPassword = session == null ? null : this.encrypt(mailAccount.getPassword(), session);
            int pos = 1;
            stmt.setLong(pos++, cid);
            stmt.setLong(pos++, id);
            stmt.setLong(pos++, user);
            stmt.setString(pos++, name);
            stmt.setString(pos++, mailAccount.generateMailServerURL());
            stmt.setString(pos++, mailAccount.getLogin());
            if (mailAccount.isDefaultFlag()) {
                stmt.setNull(pos++, 12);
            } else {
                RdbMailAccountStorage.setOptionalString(stmt, pos++, encryptedPassword);
            }
            stmt.setString(pos++, primaryAddress);
            stmt.setInt(pos++, mailAccount.isDefaultFlag() ? 1 : 0);
            RdbMailAccountStorage.setOptionalString(stmt, pos++, mailAccount.getTrash());
            RdbMailAccountStorage.setOptionalString(stmt, pos++, mailAccount.getSent());
            RdbMailAccountStorage.setOptionalString(stmt, pos++, mailAccount.getDrafts());
            RdbMailAccountStorage.setOptionalString(stmt, pos++, mailAccount.getSpam());
            RdbMailAccountStorage.setOptionalString(stmt, pos++, mailAccount.getConfirmedSpam());
            RdbMailAccountStorage.setOptionalString(stmt, pos++, mailAccount.getConfirmedHam());
            String sh = mailAccount.getSpamHandler();
            if (null == sh) {
                stmt.setNull(pos++, 12);
            } else {
                stmt.setString(pos++, sh);
            }
            stmt.setInt(pos++, mailAccount.isUnifiedINBOXEnabled() ? 1 : 0);
            RdbMailAccountStorage.setOptionalString(stmt, pos++, DefaultFolderNamesProvider.extractFullname(mailAccount.getTrashFullname()));
            RdbMailAccountStorage.setOptionalString(stmt, pos++, DefaultFolderNamesProvider.extractFullname(mailAccount.getSentFullname()));
            RdbMailAccountStorage.setOptionalString(stmt, pos++, DefaultFolderNamesProvider.extractFullname(mailAccount.getDraftsFullname()));
            RdbMailAccountStorage.setOptionalString(stmt, pos++, DefaultFolderNamesProvider.extractFullname(mailAccount.getSpamFullname()));
            RdbMailAccountStorage.setOptionalString(stmt, pos++, DefaultFolderNamesProvider.extractFullname(mailAccount.getConfirmedSpamFullname()));
            RdbMailAccountStorage.setOptionalString(stmt, pos++, DefaultFolderNamesProvider.extractFullname(mailAccount.getConfirmedHamFullname()));
            String personal = mailAccount.getPersonal();
            if (RdbMailAccountStorage.isEmpty(personal)) {
                stmt.setNull(pos++, 12);
            } else {
                stmt.setString(pos++, personal);
            }
            String replyTo = mailAccount.getReplyTo();
            if (RdbMailAccountStorage.isEmpty(replyTo)) {
                stmt.setNull(pos++, 12);
            } else {
                stmt.setString(pos++, replyTo);
            }
            RdbMailAccountStorage.setOptionalString(stmt, pos++, mailAccount.getArchive());
            RdbMailAccountStorage.setOptionalString(stmt, pos++, mailAccount.getArchiveFullname());
            stmt.executeUpdate();
            String transportURL = mailAccount.generateTransportServerURL();
            if (null != transportURL) {
                stmt.close();
                String encryptedTransportPassword = session == null ? null : this.encrypt(mailAccount.getTransportPassword(), session);
                stmt = con.prepareStatement(INSERT_TRANSPORT_ACCOUNT);
                int pos2 = 1;
                stmt.setLong(pos2++, cid);
                stmt.setLong(pos2++, id);
                stmt.setLong(pos2++, user);
                stmt.setString(pos2++, name);
                stmt.setString(pos2++, transportURL);
                if (null == mailAccount.getTransportLogin()) {
                    stmt.setString(pos2++, "");
                } else {
                    stmt.setString(pos2++, mailAccount.getTransportLogin());
                }
                if (mailAccount.isDefaultFlag()) {
                    stmt.setNull(pos2++, 12);
                } else {
                    RdbMailAccountStorage.setOptionalString(stmt, pos2++, encryptedTransportPassword);
                }
                stmt.setString(pos2++, primaryAddress);
                stmt.setInt(pos2++, mailAccount.isDefaultFlag() ? 1 : 0);
                personal = mailAccount.getPersonal();
                if (RdbMailAccountStorage.isEmpty(personal)) {
                    stmt.setNull(pos2++, 12);
                } else {
                    stmt.setString(pos2++, personal);
                }
                replyTo = mailAccount.getReplyTo();
                if (RdbMailAccountStorage.isEmpty(replyTo)) {
                    stmt.setNull(pos2++, 12);
                } else {
                    stmt.setString(pos2++, replyTo);
                }
                stmt.executeUpdate();
            }
            if (!(properties = mailAccount.getProperties()).isEmpty()) {
                if (properties.containsKey("pop3.deletewt")) {
                    this.updateProperty(cid, user, id, "pop3.deletewt", properties.get("pop3.deletewt"), con);
                }
                if (properties.containsKey("pop3.expunge")) {
                    this.updateProperty(cid, user, id, "pop3.expunge", properties.get("pop3.expunge"), con);
                }
                if (properties.containsKey("pop3.refreshrate")) {
                    this.updateProperty(cid, user, id, "pop3.refreshrate", properties.get("pop3.refreshrate"), con);
                }
                if (properties.containsKey("pop3.storage")) {
                    this.updateProperty(cid, user, id, "pop3.storage", properties.get("pop3.storage"), con);
                }
                if (properties.containsKey("pop3.path")) {
                    this.updateProperty(cid, user, id, "pop3.path", properties.get("pop3.path"), con);
                }
            }
        }
        catch (SQLException e) {
            throw MailAccountExceptionCodes.SQL_ERROR.create(e, e.getMessage());
        }
        finally {
            DBUtils.closeSQLStuff(null, stmt);
        }
        if (mailAccount.isUnifiedINBOXEnabled() && null != (management = ServerServiceRegistry.getInstance().getService(UnifiedInboxManagement.class)) && !management.exists(user, cid, con)) {
            management.createUnifiedINBOX(user, cid, con);
        }
        return id;
    }

    private void checkHostIfBlacklisted(String host, List<IPRange> ranges) throws OXException {
        if (!RdbMailAccountStorage.isEmpty(host)) {
            boolean allowed = true;
            try {
                String hostAddress = InetAddress.getByName(host).getHostAddress();
                int j = ranges.size();
                while (allowed && j-- > 0) {
                    IPRange ipRange = ranges.get(j);
                    if (!ipRange.contains(hostAddress)) continue;
                    allowed = false;
                }
            }
            catch (Exception e) {
                LOG.warn("Could not check host name \"" + host + "\" against IP range black-list", (Throwable)e);
            }
            if (!allowed) {
                throw MailAccountExceptionCodes.BLACKLISTED_SERVER.create(host);
            }
        }
    }

    @Override
    public int insertMailAccount(MailAccountDescription mailAccount, int user, Context ctx, Session session) throws OXException {
        int retval;
        int cid = ctx.getContextId();
        Connection con = Database.get(cid, true);
        try {
            con.setAutoCommit(false);
            retval = this.insertMailAccount(mailAccount, user, ctx, session, con);
            con.commit();
        }
        catch (SQLException e) {
            DBUtils.rollback(con);
            throw MailAccountExceptionCodes.SQL_ERROR.create(e, e.getMessage());
        }
        catch (OXException e) {
            DBUtils.rollback(con);
            throw e;
        }
        catch (Exception e) {
            DBUtils.rollback(con);
            throw MailAccountExceptionCodes.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
        finally {
            DBUtils.autocommit(con);
            Database.back(cid, true, con);
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] getByHostNames(Collection<String> hostNames, int user, int cid) throws OXException {
        Connection con = Database.get(cid, false);
        try {
            int[] nArray = this.getByHostNames(hostNames, user, cid, con);
            return nArray;
        }
        finally {
            Database.back(cid, false, con);
        }
    }

    private int[] getByHostNames(Collection<String> hostNames, int user, int cid, Connection con) throws OXException {
        int[] nArray;
        TIntArrayList ids;
        ResultSet result;
        PreparedStatement stmt;
        block10: {
            HashSet<String> set;
            block9: {
                if (null == hostNames || hostNames.isEmpty()) {
                    return new int[0];
                }
                set = new HashSet<String>(hostNames.size());
                for (String hostName : hostNames) {
                    set.add(hostName.toLowerCase(Locale.ENGLISH));
                }
                stmt = null;
                result = null;
                stmt = con.prepareStatement(SELECT_MAIL_ACCOUNTS);
                stmt.setLong(1, cid);
                stmt.setLong(2, user);
                result = stmt.executeQuery();
                if (result.next()) break block9;
                int[] nArray2 = new int[]{};
                DBUtils.closeSQLStuff(result, stmt);
                return nArray2;
            }
            CustomMailAccount tmp = new CustomMailAccount();
            ids = new TIntArrayList(6);
            do {
                tmp.parseMailServerURL(result.getString(2));
                if (!set.contains(tmp.getMailServer().toLowerCase(Locale.ENGLISH))) continue;
                ids.add(result.getInt(1));
            } while (result.next());
            if (!ids.isEmpty()) break block10;
            int[] nArray3 = new int[]{};
            DBUtils.closeSQLStuff(result, stmt);
            return nArray3;
        }
        try {
            int[] array = ids.toArray();
            Arrays.sort(array);
            nArray = array;
        }
        catch (SQLException e) {
            try {
                throw MailAccountExceptionCodes.SQL_ERROR.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(result, stmt);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(result, stmt);
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getByPrimaryAddress(String primaryAddress, int user, int cid) throws OXException {
        Connection con = Database.get(cid, false);
        try {
            int n = this.getByPrimaryAddress(primaryAddress, user, cid, con);
            return n;
        }
        finally {
            Database.back(cid, false, con);
        }
    }

    private int getByPrimaryAddress(String primaryAddress, int user, int cid, Connection con) throws OXException {
        int n;
        ResultSet result;
        PreparedStatement stmt;
        block6: {
            stmt = null;
            result = null;
            stmt = con.prepareStatement(SELECT_ACCOUNT_BY_PRIMARY_ADDR);
            stmt.setLong(1, cid);
            stmt.setString(2, primaryAddress);
            stmt.setLong(3, user);
            result = stmt.executeQuery();
            if (result.next()) break block6;
            int n2 = -1;
            DBUtils.closeSQLStuff(result, stmt);
            return n2;
        }
        try {
            int id = result.getInt(1);
            if (result.next()) {
                throw MailAccountExceptionCodes.CONFLICT_ADDR.create(primaryAddress, Autoboxing.I((int)user), Autoboxing.I((int)cid));
            }
            n = id;
        }
        catch (SQLException e) {
            try {
                throw MailAccountExceptionCodes.SQL_ERROR.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(result, stmt);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(result, stmt);
        return n;
    }

    private void checkDuplicateMailAccount(MailAccountDescription mailAccount, TIntSet excepts, int user, int cid, Connection con) throws OXException {
        ResultSet result;
        PreparedStatement stmt;
        String server;
        block9: {
            server = mailAccount.getMailServer();
            if (RdbMailAccountStorage.isEmpty(server)) {
                return;
            }
            stmt = null;
            result = null;
            stmt = con.prepareStatement("SELECT id, url, login FROM user_mail_account WHERE cid = ? AND user = ?");
            stmt.setLong(1, cid);
            stmt.setLong(2, user);
            result = stmt.executeQuery();
            if (result.next()) break block9;
            DBUtils.closeSQLStuff(result, stmt);
            return;
        }
        try {
            InetAddress addr;
            try {
                addr = InetAddress.getByName(IDNA.toASCII((String)server));
            }
            catch (UnknownHostException e) {
                LOG.warn("", (Throwable)e);
                addr = null;
            }
            int port = mailAccount.getMailPort();
            String login = mailAccount.getLogin();
            do {
                int id = (int)result.getLong(1);
                if (null != excepts && excepts.contains(id)) continue;
                AbstractMailAccount current = 0 == id ? new DefaultMailAccount() : new CustomMailAccount();
                String url = result.getString(2);
                if (null == url) continue;
                current.parseMailServerURL(url);
                if (!RdbMailAccountStorage.checkMailServer(server, addr, current) || !RdbMailAccountStorage.checkProtocol(mailAccount.getMailProtocol(), current.getMailProtocol()) || current.getMailPort() != port || null == login || !login.equals(result.getString(3))) continue;
                throw MailAccountExceptionCodes.DUPLICATE_MAIL_ACCOUNT.create(Autoboxing.I((int)user), Autoboxing.I((int)cid));
            } while (result.next());
        }
        catch (SQLException e) {
            try {
                throw MailAccountExceptionCodes.SQL_ERROR.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(result, stmt);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(result, stmt);
    }

    private static boolean checkMailServer(String server, InetAddress addr, AbstractMailAccount current) {
        String mailServer = current.getMailServer();
        if (RdbMailAccountStorage.isEmpty(mailServer)) {
            return false;
        }
        if (null == addr) {
            return server.equalsIgnoreCase(mailServer);
        }
        try {
            return addr.equals(InetAddress.getByName(IDNA.toASCII((String)mailServer)));
        }
        catch (UnknownHostException e) {
            LOG.warn("", (Throwable)e);
            return server.equalsIgnoreCase(mailServer);
        }
    }

    private static boolean checkProtocol(String protocol1, String protocol2) {
        if (RdbMailAccountStorage.isEmpty(protocol1) || RdbMailAccountStorage.isEmpty(protocol2)) {
            return false;
        }
        return protocol1.equalsIgnoreCase(protocol2);
    }

    private void checkDuplicateTransportAccount(MailAccountDescription mailAccount, TIntSet excepts, int user, int cid, Connection con) throws OXException {
        ResultSet result;
        PreparedStatement stmt;
        String server;
        block10: {
            server = mailAccount.getTransportServer();
            if (RdbMailAccountStorage.isEmpty(server)) {
                return;
            }
            stmt = null;
            result = null;
            stmt = con.prepareStatement("SELECT id, url, login FROM user_transport_account WHERE cid = ? AND user = ?");
            stmt.setLong(1, cid);
            stmt.setLong(2, user);
            result = stmt.executeQuery();
            if (result.next()) break block10;
            DBUtils.closeSQLStuff(result, stmt);
            return;
        }
        try {
            InetAddress addr;
            try {
                addr = InetAddress.getByName(IDNA.toASCII((String)server));
            }
            catch (UnknownHostException e) {
                LOG.warn("", (Throwable)e);
                addr = null;
            }
            int port = mailAccount.getTransportPort();
            String login = mailAccount.getTransportLogin();
            if (null == login) {
                login = mailAccount.getLogin();
            }
            do {
                int id = (int)result.getLong(1);
                if (null != excepts && excepts.contains(id)) continue;
                AbstractMailAccount current = 0 == id ? new DefaultMailAccount() : new CustomMailAccount();
                current.parseTransportServerURL(result.getString(2));
                if (!RdbMailAccountStorage.checkTransportServer(server, addr, current) || !RdbMailAccountStorage.checkProtocol(mailAccount.getTransportProtocol(), current.getTransportProtocol()) || current.getTransportPort() != port || null == login || !login.equals(result.getString(3))) continue;
                throw MailAccountExceptionCodes.DUPLICATE_TRANSPORT_ACCOUNT.create(Autoboxing.I((int)user), Autoboxing.I((int)cid));
            } while (result.next());
        }
        catch (SQLException e) {
            try {
                throw MailAccountExceptionCodes.SQL_ERROR.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(result, stmt);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(result, stmt);
    }

    private static boolean checkTransportServer(String server, InetAddress addr, AbstractMailAccount current) {
        String transportServer = current.getTransportServer();
        if (RdbMailAccountStorage.isEmpty(transportServer)) {
            return false;
        }
        if (null == addr) {
            return server.equalsIgnoreCase(transportServer);
        }
        try {
            return addr.equals(InetAddress.getByName(IDNA.toASCII((String)transportServer)));
        }
        catch (UnknownHostException e) {
            LOG.warn("", (Throwable)e);
            return server.equalsIgnoreCase(transportServer);
        }
    }

    @Override
    public MailAccount getTransportAccountForID(int id, int user, int cid) throws OXException {
        MailAccount account = this.getMailAccount(id, user, cid);
        if (null == account.getTransportServer()) {
            return this.getDefaultMailAccount(user, cid);
        }
        return account;
    }

    @Override
    public boolean hasAccounts(Session session) throws OXException {
        boolean bl;
        int user;
        int cid;
        ResultSet rs;
        PreparedStatement stmt;
        Connection con;
        block8: {
            con = null;
            stmt = null;
            rs = null;
            cid = session.getContextId();
            user = session.getUserId();
            con = Database.get(cid, false);
            stmt = con.prepareStatement(SELECT_EXISTS_FOR_USER1);
            stmt.setInt(1, cid);
            stmt.setInt(2, user);
            rs = stmt.executeQuery();
            if (!rs.next()) break block8;
            boolean bl2 = true;
            DBUtils.closeSQLStuff(rs, stmt);
            if (con != null) {
                Database.back(cid, false, con);
            }
            return bl2;
        }
        try {
            DBUtils.closeSQLStuff(rs, stmt);
            stmt = con.prepareStatement(SELECT_EXISTS_FOR_USER2);
            stmt.setInt(1, cid);
            stmt.setInt(2, user);
            rs = stmt.executeQuery();
            bl = rs.next();
        }
        catch (SQLException e) {
            try {
                throw MailAccountExceptionCodes.SQL_ERROR.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(rs, stmt);
                if (con != null) {
                    Database.back(cid, false, con);
                }
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(rs, stmt);
        if (con != null) {
            Database.back(cid, false, con);
        }
        return bl;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void migratePasswords(String oldSecret, String newSecret, Session session) throws OXException {
        ResultSet rs;
        Statement updateStmt;
        PreparedStatement selectStmt;
        Connection con;
        int cid;
        block17: {
            cid = session.getContextId();
            int user = session.getUserId();
            this.cleanUp(user, cid);
            con = null;
            selectStmt = null;
            updateStmt = null;
            rs = null;
            boolean rollback = false;
            try {
                String transcribed;
                String decrypted;
                SetableSession setableSession;
                String login;
                int id;
                String password;
                con = Database.get(cid, true);
                con.setAutoCommit(false);
                rollback = true;
                selectStmt = con.prepareStatement(SELECT_PASSWORD1);
                selectStmt.setInt(1, cid);
                selectStmt.setInt(2, user);
                rs = selectStmt.executeQuery();
                SecretEncryptionService encryptionService = ServerServiceRegistry.getInstance().getService(SecretEncryptionFactoryService.class).createService(STRATEGY);
                if (null == encryptionService) {
                    throw ServiceExceptionCode.SERVICE_UNAVAILABLE.create(new Object[]{SecretEncryptionService.class.getName()});
                }
                CustomMailAccount parser = new CustomMailAccount();
                while (rs.next()) {
                    password = rs.getString(2);
                    if (RdbMailAccountStorage.isEmpty(password) || (id = rs.getInt(1)) == 0) continue;
                    login = rs.getString(3);
                    parser.parseMailServerURL(rs.getString(4));
                    String mailServer = parser.getMailServer();
                    try {
                        encryptionService.decrypt(session, password, (Object)new GenericProperty(id, session, login, mailServer));
                    }
                    catch (OXException x) {
                        setableSession = SetableSessionFactory.getFactory().setableSessionFor(session);
                        setableSession.setPassword(oldSecret);
                        decrypted = encryptionService.decrypt((Session)setableSession, password, (Object)new GenericProperty(id, (Session)setableSession, login, mailServer));
                        transcribed = encryptionService.encrypt(session, decrypted);
                        if (null == updateStmt) {
                            updateStmt = con.prepareStatement(UPDATE_PASSWORD1);
                            updateStmt.setInt(2, cid);
                            updateStmt.setInt(4, user);
                        }
                        updateStmt.setString(1, transcribed);
                        updateStmt.setInt(3, id);
                        updateStmt.addBatch();
                    }
                }
                if (null != updateStmt) {
                    updateStmt.executeBatch();
                    DBUtils.closeSQLStuff(updateStmt);
                    updateStmt = null;
                }
                DBUtils.closeSQLStuff(rs, selectStmt);
                selectStmt = con.prepareStatement(SELECT_PASSWORD2);
                selectStmt.setInt(1, cid);
                selectStmt.setInt(2, user);
                rs = selectStmt.executeQuery();
                while (rs.next()) {
                    password = rs.getString(2);
                    if (RdbMailAccountStorage.isEmpty(password) || (id = rs.getInt(1)) == 0) continue;
                    login = rs.getString(3);
                    parser.parseTransportServerURL(rs.getString(4));
                    String transportServer = parser.getTransportServer();
                    try {
                        encryptionService.decrypt(session, password, (Object)new GenericProperty(id, session, login, transportServer));
                    }
                    catch (OXException x) {
                        setableSession = SetableSessionFactory.getFactory().setableSessionFor(session);
                        setableSession.setPassword(oldSecret);
                        decrypted = encryptionService.decrypt((Session)setableSession, password, (Object)new GenericProperty(id, (Session)setableSession, login, transportServer));
                        transcribed = encryptionService.encrypt(session, decrypted);
                        if (null == updateStmt) {
                            updateStmt = con.prepareStatement(UPDATE_PASSWORD2);
                            updateStmt.setInt(2, cid);
                            updateStmt.setInt(4, user);
                        }
                        updateStmt.setString(1, transcribed);
                        updateStmt.setInt(3, id);
                        updateStmt.addBatch();
                    }
                }
                if (null != updateStmt) {
                    updateStmt.executeBatch();
                    DBUtils.closeSQLStuff(updateStmt);
                    updateStmt = null;
                }
                con.commit();
                rollback = false;
                if (!rollback) break block17;
            }
            catch (SQLException e) {
                try {
                    throw MailAccountExceptionCodes.SQL_ERROR.create(e, e.getMessage());
                    catch (RuntimeException e2) {
                        throw MailAccountExceptionCodes.UNEXPECTED_ERROR.create(e2, e2.getMessage());
                    }
                }
                catch (Throwable throwable) {
                    if (rollback) {
                        DBUtils.rollback(con);
                    }
                    DBUtils.closeSQLStuff(rs, selectStmt);
                    DBUtils.closeSQLStuff(updateStmt);
                    if (con == null) throw throwable;
                    DBUtils.autocommit(con);
                    Database.back(cid, true, con);
                    throw throwable;
                }
            }
            DBUtils.rollback(con);
        }
        DBUtils.closeSQLStuff(rs, selectStmt);
        DBUtils.closeSQLStuff(updateStmt);
        if (con == null) return;
        DBUtils.autocommit(con);
        Database.back(cid, true, con);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void cleanUp(String secret, Session session) throws OXException {
        boolean modified;
        ResultSet rs;
        Statement updateStmt;
        PreparedStatement selectStmt;
        Connection con;
        int cid;
        block18: {
            int user = session.getUserId();
            cid = session.getContextId();
            this.cleanUp(user, cid);
            con = null;
            selectStmt = null;
            updateStmt = null;
            rs = null;
            boolean rollback = false;
            modified = false;
            try {
                int id;
                String password;
                con = Database.get(cid, true);
                con.setAutoCommit(false);
                rollback = true;
                selectStmt = con.prepareStatement(SELECT_PASSWORD1);
                selectStmt.setInt(1, cid);
                selectStmt.setInt(2, user);
                rs = selectStmt.executeQuery();
                while (rs.next()) {
                    password = rs.getString(2);
                    if (RdbMailAccountStorage.isEmpty(password) || (id = rs.getInt(1)) == 0) continue;
                    try {
                        MailPasswordUtil.decrypt(password, secret);
                    }
                    catch (GeneralSecurityException x) {
                        if (null == updateStmt) {
                            updateStmt = con.prepareStatement(UPDATE_PASSWORD1);
                            updateStmt.setInt(2, cid);
                            updateStmt.setInt(4, user);
                        }
                        updateStmt.setString(1, "");
                        updateStmt.setInt(3, id);
                        updateStmt.addBatch();
                    }
                }
                if (null != updateStmt) {
                    updateStmt.executeBatch();
                    modified = true;
                    DBUtils.closeSQLStuff(updateStmt);
                    updateStmt = null;
                }
                DBUtils.closeSQLStuff(rs, selectStmt);
                selectStmt = con.prepareStatement(SELECT_PASSWORD2);
                selectStmt.setInt(1, cid);
                selectStmt.setInt(2, user);
                rs = selectStmt.executeQuery();
                while (rs.next()) {
                    password = rs.getString(2);
                    if (RdbMailAccountStorage.isEmpty(password) || (id = rs.getInt(1)) == 0) continue;
                    try {
                        MailPasswordUtil.decrypt(password, secret);
                    }
                    catch (GeneralSecurityException x) {
                        if (null == updateStmt) {
                            updateStmt = con.prepareStatement(UPDATE_PASSWORD2);
                            updateStmt.setInt(2, cid);
                            updateStmt.setInt(4, user);
                        }
                        updateStmt.setString(1, "");
                        updateStmt.setInt(3, id);
                        updateStmt.addBatch();
                    }
                }
                if (null != updateStmt) {
                    updateStmt.executeBatch();
                    modified = false;
                    DBUtils.closeSQLStuff(updateStmt);
                    updateStmt = null;
                }
                con.commit();
                rollback = false;
                if (!rollback) break block18;
            }
            catch (SQLException e) {
                try {
                    throw MailAccountExceptionCodes.SQL_ERROR.create(e, e.getMessage());
                    catch (RuntimeException e2) {
                        throw MailAccountExceptionCodes.UNEXPECTED_ERROR.create(e2, e2.getMessage());
                    }
                }
                catch (Throwable throwable) {
                    if (rollback) {
                        DBUtils.rollback(con);
                    }
                    DBUtils.closeSQLStuff(rs, selectStmt);
                    DBUtils.closeSQLStuff(updateStmt);
                    if (con == null) throw throwable;
                    DBUtils.autocommit(con);
                    if (modified) {
                        Database.getDatabaseService().backWritable(cid, con);
                        throw throwable;
                    }
                    Database.getDatabaseService().backWritableAfterReading(cid, con);
                    throw throwable;
                }
            }
            DBUtils.rollback(con);
        }
        DBUtils.closeSQLStuff(rs, selectStmt);
        DBUtils.closeSQLStuff(updateStmt);
        if (con == null) return;
        DBUtils.autocommit(con);
        if (modified) {
            Database.getDatabaseService().backWritable(cid, con);
            return;
        }
        Database.getDatabaseService().backWritableAfterReading(cid, con);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void removeUnrecoverableItems(String secret, Session session) throws OXException {
        ResultSet rs;
        Statement updateStmt;
        PreparedStatement selectStmt;
        Connection con;
        int cid;
        int user;
        block18: {
            user = session.getUserId();
            cid = session.getContextId();
            this.cleanUp(user, cid);
            con = null;
            selectStmt = null;
            updateStmt = null;
            rs = null;
            boolean rollback = false;
            try {
                int id;
                String password;
                con = Database.get(cid, true);
                con.setAutoCommit(false);
                rollback = true;
                selectStmt = con.prepareStatement(SELECT_PASSWORD1);
                selectStmt.setInt(1, cid);
                selectStmt.setInt(2, user);
                rs = selectStmt.executeQuery();
                while (rs.next()) {
                    password = rs.getString(2);
                    if (RdbMailAccountStorage.isEmpty(password) || (id = rs.getInt(1)) == 0) continue;
                    try {
                        MailPasswordUtil.decrypt(password, secret);
                    }
                    catch (GeneralSecurityException x) {
                        if (null == updateStmt) {
                            updateStmt = con.prepareStatement(DELETE_MAIL_ACCOUNT);
                            updateStmt.setInt(1, cid);
                            updateStmt.setInt(3, user);
                        }
                        updateStmt.setInt(2, id);
                        updateStmt.addBatch();
                    }
                }
                if (null != updateStmt) {
                    updateStmt.executeBatch();
                    DBUtils.closeSQLStuff(updateStmt);
                    updateStmt = null;
                }
                DBUtils.closeSQLStuff(rs, selectStmt);
                selectStmt = con.prepareStatement(SELECT_PASSWORD2);
                selectStmt.setInt(1, cid);
                selectStmt.setInt(2, user);
                rs = selectStmt.executeQuery();
                while (rs.next()) {
                    password = rs.getString(2);
                    if (RdbMailAccountStorage.isEmpty(password) || (id = rs.getInt(1)) == 0) continue;
                    try {
                        MailPasswordUtil.decrypt(password, secret);
                    }
                    catch (GeneralSecurityException x) {
                        if (null == updateStmt) {
                            updateStmt = con.prepareStatement(DELETE_TRANSPORT_ACCOUNT);
                            updateStmt.setInt(1, cid);
                            updateStmt.setInt(3, user);
                        }
                        updateStmt.setInt(2, id);
                        updateStmt.addBatch();
                    }
                }
                if (null != updateStmt) {
                    updateStmt.executeBatch();
                    DBUtils.closeSQLStuff(updateStmt);
                    updateStmt = null;
                }
                con.commit();
                rollback = false;
                if (!rollback) break block18;
            }
            catch (SQLException e) {
                try {
                    throw MailAccountExceptionCodes.SQL_ERROR.create(e, e.getMessage());
                    catch (RuntimeException e2) {
                        throw MailAccountExceptionCodes.UNEXPECTED_ERROR.create(e2, e2.getMessage());
                    }
                }
                catch (Throwable throwable) {
                    if (rollback) {
                        DBUtils.rollback(con);
                    }
                    DBUtils.closeSQLStuff(rs, selectStmt);
                    DBUtils.closeSQLStuff(updateStmt);
                    if (con != null) {
                        DBUtils.autocommit(con);
                        Database.back(cid, true, con);
                    }
                    throw throwable;
                }
            }
            DBUtils.rollback(con);
        }
        DBUtils.closeSQLStuff(rs, selectStmt);
        DBUtils.closeSQLStuff(updateStmt);
        if (con != null) {
            DBUtils.autocommit(con);
            Database.back(cid, true, con);
        }
        this.cleanUp(user, cid);
    }

    private void cleanUp(int user, int cid) {
        Session session;
        SessiondService service = ServerServiceRegistry.getInstance().getService(SessiondService.class);
        if (null != service && null != (session = service.getAnyActiveSessionForUser(user, cid))) {
            try {
                int[] ids;
                IMailAccessCache mac = MailAccess.getMailAccessCache();
                for (int id : ids = this.getUserMailAccountIDs(user, cid)) {
                    while (mac.removeMailAccess(session, id) != null) {
                    }
                }
            }
            catch (Exception exc) {
                LOG.error("Unable to clear cached mail accesses.", (Throwable)exc);
            }
        }
    }

    private String encrypt(String toCrypt, Session session) throws OXException {
        if (null == toCrypt) {
            return null;
        }
        SecretEncryptionService encryptionService = RdbMailAccountStorage.getService(SecretEncryptionFactoryService.class).createService(STRATEGY);
        return encryptionService.encrypt(session, toCrypt);
    }

    private static <S> S getService(Class<? extends S> clazz) {
        return ServerServiceRegistry.getInstance().getService(clazz);
    }

    private static boolean disableForeignKeyChecks(Connection con) {
        if (null == con) {
            return false;
        }
        try {
            DBUtils.disableMysqlForeignKeyChecks(con);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static void enableForeignKeyChecks(Connection con) throws SQLException {
        if (null == con) {
            return;
        }
        DBUtils.enableMysqlForeignKeyChecks(con);
    }

    private static void setOptionalString(PreparedStatement stmt, int pos, String string) throws SQLException {
        stmt.setString(pos, null == string ? "" : string);
    }

    private static String getOptionalString(String string) {
        return null == string || 0 == string.length() ? null : string;
    }

    private static boolean isEmpty(String string) {
        if (null == string) {
            return true;
        }
        int len = string.length();
        boolean isWhitespace = true;
        for (int i = 0; isWhitespace && i < len; ++i) {
            isWhitespace = Strings.isWhitespace((char)string.charAt(i));
        }
        return isWhitespace;
    }

    private static boolean isValid(String name) {
        return null != name && 0 != name.length();
    }

    static {
        TIntObjectHashMap map = new TIntObjectHashMap(8);
        map.put(5, (Object)"confirmed_ham_fullname");
        map.put(4, (Object)"confirmed_spam_fullname");
        map.put(0, (Object)"drafts_fullname");
        map.put(1, (Object)"sent_fullname");
        map.put(2, (Object)"spam_fullname");
        map.put(3, (Object)"trash_fullname");
        INDEX_2_COL = map;
        String quote1 = Pattern.quote("Cannot delete or update a parent row: a foreign key constraint fails (`");
        String quote2 = Pattern.quote("`, CONSTRAINT `");
        String quote3 = Pattern.quote("` FOREIGN KEY (");
        String quote4 = Pattern.quote(") REFERENCES `user_mail_account` (`cid`, `user`, `id`))");
        PATTERN_CONSTRAINT_VIOLATION = Pattern.compile(quote1 + "([^`]+)" + quote2 + "[^`]+" + quote3 + "([^)]+)" + quote4, 2);
        DEFAULT = EnumSet.of(Attribute.CONFIRMED_HAM_FULLNAME_LITERAL, new Attribute[]{Attribute.CONFIRMED_HAM_LITERAL, Attribute.CONFIRMED_SPAM_FULLNAME_LITERAL, Attribute.CONFIRMED_SPAM_LITERAL, Attribute.DRAFTS_FULLNAME_LITERAL, Attribute.DRAFTS_LITERAL, Attribute.SENT_FULLNAME_LITERAL, Attribute.SENT_LITERAL, Attribute.SPAM_FULLNAME_LITERAL, Attribute.SPAM_LITERAL, Attribute.TRASH_FULLNAME_LITERAL, Attribute.TRASH_LITERAL});
        DEFAULT_FULL_NAMES = EnumSet.of(Attribute.CONFIRMED_HAM_FULLNAME_LITERAL, new Attribute[]{Attribute.CONFIRMED_SPAM_FULLNAME_LITERAL, Attribute.DRAFTS_FULLNAME_LITERAL, Attribute.SENT_FULLNAME_LITERAL, Attribute.SPAM_FULLNAME_LITERAL, Attribute.TRASH_FULLNAME_LITERAL});
        PRIMARY_EDITABLE = EnumSet.of(Attribute.UNIFIED_INBOX_ENABLED_LITERAL, Attribute.PERSONAL_LITERAL, Attribute.REPLY_TO_LITERAL, Attribute.ARCHIVE_LITERAL, Attribute.ARCHIVE_FULLNAME_LITERAL);
        CHARS_INVALID = new char[]{'\t', '\n', '\f', '\r', '!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '.', '/', ':', ';', '<', '=', '>', '?', '@', '[', '\\', ']', '^', '`', '{', '|', '}', '~'};
    }
}

