/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.mime.dataobjects;

import com.openexchange.exception.OXException;
import com.openexchange.java.CharsetDetector;
import com.openexchange.java.Streams;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.dataobjects.MailPart;
import com.openexchange.mail.mime.ContentDisposition;
import com.openexchange.mail.mime.MimeType2ExtMap;
import com.openexchange.mail.mime.datasource.FileDataSource;
import com.openexchange.mail.mime.datasource.MessageDataSource;
import com.openexchange.mail.utils.MessageUtility;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MimeFileMailPart
extends MailPart {
    private static final long serialVersionUID = 257902073011243269L;
    private static final transient Logger LOG = LoggerFactory.getLogger(MimeFileMailPart.class);
    private final File file;
    private transient DataSource dataSource;
    private transient Object cachedContent;
    private static final String TEXT = "text/";

    protected MimeFileMailPart(FileDataSource fileDataSource) throws OXException {
        this.file = fileDataSource.getFile();
        String preparedFileName = fileDataSource.getName();
        this.setContentType(MimeFileMailPart.prepareContentType(fileDataSource.getContentType(), preparedFileName));
        this.setFileName(preparedFileName);
        this.setSize(fileDataSource.getFile().length());
        ContentDisposition cd = new ContentDisposition();
        cd.setDisposition("attachment");
        cd.setFilenameParameter(this.getFileName());
        this.setContentDisposition(cd);
        try {
            if (this.getContentType().getCharsetParameter() == null && this.getContentType().startsWith(TEXT)) {
                String cs = CharsetDetector.detectCharset((InputStream)new FileInputStream(this.file));
                this.getContentType().setCharsetParameter(cs);
            }
            this.dataSource = fileDataSource;
        }
        catch (IOException e) {
            LOG.error("", (Throwable)e);
            this.dataSource = new MessageDataSource(new byte[0], "application/octet-stream");
        }
    }

    private static String prepareContentType(String contentType, String preparedFileName) {
        if (null == contentType || contentType.length() == 0) {
            return "application/octet-stream";
        }
        int mlen = contentType.length() - 1;
        String retval = 0 == contentType.indexOf(34) && mlen == contentType.lastIndexOf(34) ? contentType.substring(1, mlen) : contentType;
        if ("multipart/form-data".equalsIgnoreCase(retval)) {
            return MimeType2ExtMap.getContentType(preparedFileName);
        }
        return contentType;
    }

    private DataSource getDataSource() {
        if (null == this.dataSource) {
            try {
                if (this.getContentType().getCharsetParameter() == null && this.getContentType().startsWith(TEXT)) {
                    String cs = CharsetDetector.detectCharset((InputStream)new FileInputStream(this.file));
                    this.getContentType().setCharsetParameter(cs);
                }
                this.dataSource = new FileDataSource(this.file, this.getContentType().toString());
            }
            catch (IOException e) {
                LOG.error("", (Throwable)e);
                this.dataSource = new MessageDataSource(new byte[0], "application/octet-stream");
            }
        }
        return this.dataSource;
    }

    public File getFile() {
        return this.file;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object getContent() throws OXException {
        if (this.cachedContent != null) {
            return this.cachedContent;
        }
        if (!this.getContentType().isMimeType("text/*")) return null;
        String charset = this.getContentType().getCharsetParameter();
        if (charset == null) {
            try {
                charset = CharsetDetector.detectCharset((InputStream)new FileInputStream(this.file));
                LOG.warn("Uploaded file contains textual content but does not specify a charset. Assumed charset is: {}", (Object)charset);
            }
            catch (FileNotFoundException e) {
                throw MailExceptionCode.IO_ERROR.create(e, e.getMessage());
            }
        }
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(this.file);
            this.cachedContent = MessageUtility.readStream(fis, charset);
        }
        catch (FileNotFoundException e) {
            try {
                throw MailExceptionCode.IO_ERROR.create(e, e.getMessage());
                catch (IOException e2) {
                    if ("com.sun.mail.util.MessageRemovedIOException".equals(e2.getClass().getName())) {
                        throw MailExceptionCode.MAIL_NOT_FOUND_SIMPLE.create(e2, new Object[0]);
                    }
                    throw MailExceptionCode.IO_ERROR.create(e2, e2.getMessage());
                }
            }
            catch (Throwable throwable) {
                Streams.close(fis);
                throw throwable;
            }
        }
        Streams.close((Closeable)fis);
        return this.cachedContent;
    }

    @Override
    public DataHandler getDataHandler() throws OXException {
        return new DataHandler(this.getDataSource());
    }

    @Override
    public int getEnclosedCount() throws OXException {
        return -1;
    }

    @Override
    public MailPart getEnclosedMailPart(int index) throws OXException {
        return null;
    }

    @Override
    public InputStream getInputStream() throws OXException {
        try {
            return new FileInputStream(this.file);
        }
        catch (FileNotFoundException e) {
            throw MailExceptionCode.IO_ERROR.create(e, e.getMessage());
        }
    }

    @Override
    public void loadContent() {
    }

    @Override
    public void prepareForCaching() {
    }
}

