/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.json.actions;

import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.documentation.RequestMethod;
import com.openexchange.documentation.annotations.Action;
import com.openexchange.documentation.annotations.Parameter;
import com.openexchange.exception.OXException;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.MailServletInterface;
import com.openexchange.mail.json.MailRequest;
import com.openexchange.mail.json.actions.AbstractMailAction;
import com.openexchange.server.ServiceLookup;
import org.json.JSONException;
import org.json.JSONObject;

@Action(method=RequestMethod.PUT, name="copy", description="Copy mails.", parameters={@Parameter(name="session", description="A session ID previously obtained from the login module."), @Parameter(name="id", description="Object ID of the requested mail."), @Parameter(name="folder", description="Object ID of the source folder.")}, requestBody="A JSON object containing the id of the destination folder inside the \"folder_id\" field: e.g.: {\"folder_id\": 1376}.", responseDescription="A JSON array containing the ID of the copied mail.")
public final class CopyAction
extends AbstractMailAction {
    public CopyAction(ServiceLookup services) {
        super(services);
    }

    @Override
    protected AJAXRequestResult perform(MailRequest req) throws OXException {
        try {
            String uid = req.checkParameter("id");
            String sourceFolder = req.checkParameter("folder");
            String destFolder = ((JSONObject)req.getRequest().requireData()).getString("folder_id");
            MailServletInterface mailInterface = this.getMailInterface(req);
            String msgUID = mailInterface.copyMessages(sourceFolder, destFolder, new String[]{uid}, false)[0];
            JSONObject data = new JSONObject();
            data.put("folder_id", (Object)destFolder);
            data.put("id", (Object)msgUID);
            return new AJAXRequestResult((Object)data, "json");
        }
        catch (JSONException e) {
            throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
        }
        catch (RuntimeException e) {
            throw MailExceptionCode.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
    }
}

