/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.dataobjects.compose;

import com.openexchange.exception.OXException;
import com.openexchange.file.storage.File;
import com.openexchange.file.storage.FileStorageFileAccess;
import com.openexchange.file.storage.composition.IDBasedFileAccess;
import com.openexchange.file.storage.composition.IDBasedFileAccessFactory;
import com.openexchange.java.Strings;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.config.MailProperties;
import com.openexchange.mail.dataobjects.MailPart;
import com.openexchange.mail.dataobjects.compose.ComposedMailPart;
import com.openexchange.mail.mime.datasource.StreamDataSource;
import com.openexchange.mail.utils.MessageUtility;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.internet.MimeUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class InfostoreDocumentMailPart
extends MailPart
implements ComposedMailPart {
    private static final long serialVersionUID = -3158021272821196715L;
    private static final transient Logger LOG = LoggerFactory.getLogger(InfostoreDocumentMailPart.class);
    private final transient Session session;
    private final transient String documentId;
    private transient Object cachedContent;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InfostoreDocumentMailPart(String documentId, Session session) throws OXException {
        this.documentId = documentId;
        this.session = session;
        IDBasedFileAccess fileAccess = null;
        try {
            IDBasedFileAccessFactory fileAccessFactory = ServerServiceRegistry.getInstance().getService(IDBasedFileAccessFactory.class, true);
            fileAccess = fileAccessFactory.createAccess(session);
            File fileMetadata = fileAccess.getFileMetadata(documentId, FileStorageFileAccess.CURRENT_VERSION);
            this.setSize(fileMetadata.getFileSize());
            String docMIMEType = fileMetadata.getFileMIMEType();
            this.setContentType(docMIMEType == null || docMIMEType.length() == 0 ? "application/octet-stream" : fileMetadata.getFileMIMEType());
            String fileName = fileMetadata.getFileName();
            if (!InfostoreDocumentMailPart.isEmpty(fileName)) {
                try {
                    this.setFileName(MimeUtility.encodeText((String)fileName, (String)MailProperties.getInstance().getDefaultMimeCharset(), (String)"Q"));
                }
                catch (UnsupportedEncodingException e) {
                    this.setFileName(fileName);
                }
            }
        }
        finally {
            if (fileAccess != null) {
                try {
                    fileAccess.finish();
                }
                catch (Exception e) {}
            }
        }
    }

    private StreamDataSource.InputStreamProvider inputStreamProvider() {
        return new DocumentInputStreamProvider(this.documentId, this.session, this.getFileName());
    }

    private DataSource getDataSource() {
        return new StreamDataSource(this.inputStreamProvider(), this.getContentType().toString());
    }

    @Override
    public Object getContent() throws OXException {
        if (this.cachedContent != null) {
            return this.cachedContent;
        }
        if (this.getContentType().isMimeType("text/*")) {
            String charset = this.getContentType().getCharsetParameter();
            if (charset == null) {
                charset = "ISO-8859-1";
            }
            InputStream docInputSream = null;
            try {
                docInputSream = this.inputStreamProvider().getInputStream();
                this.cachedContent = MessageUtility.readStream(docInputSream, charset);
            }
            catch (FileNotFoundException e) {
                throw MailExceptionCode.IO_ERROR.create(e, e.getMessage());
            }
            catch (IOException e) {
                if ("com.sun.mail.util.MessageRemovedIOException".equals(e.getClass().getName())) {
                    throw MailExceptionCode.MAIL_NOT_FOUND_SIMPLE.create(e, new Object[0]);
                }
                throw MailExceptionCode.IO_ERROR.create(e, e.getMessage());
            }
            finally {
                if (docInputSream != null) {
                    try {
                        docInputSream.close();
                    }
                    catch (IOException e) {
                        LOG.error("", (Throwable)e);
                    }
                    docInputSream = null;
                }
            }
            return this.cachedContent;
        }
        return null;
    }

    @Override
    public DataHandler getDataHandler() throws OXException {
        return new DataHandler(this.getDataSource());
    }

    @Override
    public int getEnclosedCount() throws OXException {
        return -1;
    }

    @Override
    public MailPart getEnclosedMailPart(int index) throws OXException {
        return null;
    }

    @Override
    public InputStream getInputStream() throws OXException {
        try {
            return this.inputStreamProvider().getInputStream();
        }
        catch (IOException e) {
            if ("com.sun.mail.util.MessageRemovedIOException".equals(e.getClass().getName())) {
                throw MailExceptionCode.MAIL_NOT_FOUND_SIMPLE.create(e, new Object[0]);
            }
            throw MailExceptionCode.IO_ERROR.create(e, e.getMessage());
        }
    }

    @Override
    public void prepareForCaching() {
    }

    @Override
    public void loadContent() {
    }

    @Override
    public ComposedMailPart.ComposedPartType getType() {
        return ComposedMailPart.ComposedPartType.DOCUMENT;
    }

    private static boolean isEmpty(String string) {
        if (null == string) {
            return true;
        }
        int len = string.length();
        boolean isWhitespace = true;
        for (int i = 0; isWhitespace && i < len; ++i) {
            isWhitespace = Strings.isWhitespace((char)string.charAt(i));
        }
        return isWhitespace;
    }

    private static final class ClosingInputStream
    extends InputStream {
        private final InputStream in;
        private final IDBasedFileAccess fileAccess;

        protected ClosingInputStream(InputStream in, IDBasedFileAccess fileAccess) {
            this.in = in;
            this.fileAccess = fileAccess;
        }

        @Override
        public int read() throws IOException {
            return this.in.read();
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.in.read(b);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.in.read(b, off, len);
        }

        @Override
        public long skip(long n) throws IOException {
            return this.in.skip(n);
        }

        @Override
        public int available() throws IOException {
            return this.in.available();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            try {
                this.in.close();
            }
            finally {
                try {
                    this.fileAccess.finish();
                }
                catch (Exception exception) {}
            }
        }

        @Override
        public void mark(int readlimit) {
            this.in.mark(readlimit);
        }

        @Override
        public void reset() throws IOException {
            this.in.reset();
        }

        @Override
        public boolean markSupported() {
            return this.in.markSupported();
        }
    }

    private static final class DocumentInputStreamProvider
    implements StreamDataSource.InputStreamProvider {
        private final Session session;
        private final String documentId;
        private final String name;

        protected DocumentInputStreamProvider(String documentId, Session session, String name) {
            this.name = name;
            this.session = session;
            this.documentId = documentId;
        }

        private static IDBasedFileAccess fileAccess(Session session) throws OXException {
            IDBasedFileAccessFactory fileAccessFactory = ServerServiceRegistry.getInstance().getService(IDBasedFileAccessFactory.class, true);
            return fileAccessFactory.createAccess(session);
        }

        @Override
        public InputStream getInputStream() throws IOException {
            IDBasedFileAccess fileAccess = null;
            try {
                fileAccess = DocumentInputStreamProvider.fileAccess(this.session);
                InputStream inputStream = fileAccess.getDocument(this.documentId, FileStorageFileAccess.CURRENT_VERSION);
                return inputStream;
            }
            catch (OXException e) {
                throw new IOException("Input stream cannot be retrieved", e);
            }
            finally {
                if (fileAccess != null) {
                    try {
                        fileAccess.finish();
                    }
                    catch (Exception e) {}
                }
            }
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

