/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.login.internal;

import com.openexchange.authentication.Authenticated;
import com.openexchange.authentication.Cookie;
import com.openexchange.authentication.LoginExceptionCodes;
import com.openexchange.authentication.ResponseEnhancement;
import com.openexchange.authentication.ResultCode;
import com.openexchange.authentication.SessionEnhancement;
import com.openexchange.authorization.Authorization;
import com.openexchange.authorization.AuthorizationService;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextExceptionCodes;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.groupware.userconfiguration.UserConfigurationStorage;
import com.openexchange.java.Autoboxing;
import com.openexchange.java.Strings;
import com.openexchange.login.Blocking;
import com.openexchange.login.LoginHandlerService;
import com.openexchange.login.LoginRequest;
import com.openexchange.login.LoginResult;
import com.openexchange.login.NonTransient;
import com.openexchange.login.internal.AddSessionParameterImpl;
import com.openexchange.login.internal.AutoLoginMethod;
import com.openexchange.login.internal.LoginHandlerRegistry;
import com.openexchange.login.internal.LoginMethodClosure;
import com.openexchange.login.internal.LoginPerformerTask;
import com.openexchange.login.internal.LoginResultImpl;
import com.openexchange.login.internal.NormalLoginMethod;
import com.openexchange.mail.config.MailProperties;
import com.openexchange.server.ServiceExceptionCode;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.sessiond.AddSessionParameter;
import com.openexchange.sessiond.SessiondService;
import com.openexchange.threadpool.Task;
import com.openexchange.threadpool.ThreadPoolCompletionService;
import com.openexchange.threadpool.ThreadPoolService;
import com.openexchange.threadpool.ThreadPools;
import com.openexchange.threadpool.behavior.CallerRunsBehavior;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LoginPerformer {
    private static final Logger LOG = LoggerFactory.getLogger(LoginPerformer.class);
    private static final LoginPerformer SINGLETON = new LoginPerformer();
    private static final Pattern SPLIT = Pattern.compile(" *, *");

    private LoginPerformer() {
    }

    public static LoginPerformer getInstance() {
        return SINGLETON;
    }

    public LoginResult doLogin(LoginRequest request) throws OXException {
        return this.doLogin(request, new HashMap<String, Object>(1));
    }

    public LoginResult doLogin(LoginRequest request, Map<String, Object> properties) throws OXException {
        return this.doLogin(request, properties, new NormalLoginMethod(request, properties));
    }

    public LoginResult doAutoLogin(LoginRequest request) throws OXException {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        return this.doLogin(request, properties, new AutoLoginMethod(request, properties));
    }

    private LoginResult doLogin(LoginRequest request, Map<String, Object> properties, LoginMethodClosure loginMethod) throws OXException {
        LoginPerformer.sanityChecks(request);
        LoginResultImpl retval = new LoginResultImpl();
        retval.setRequest(request);
        try {
            Authenticated authed;
            Cookie[] cookies;
            Map<String, List<String>> headers = request.getHeaders();
            if (headers != null) {
                properties.put("headers", headers);
            }
            if (null != (cookies = request.getCookies())) {
                properties.put("cookies", cookies);
            }
            if (null == (authed = loginMethod.doAuthentication(retval))) {
                LoginResult loginResult = null;
                return loginResult;
            }
            if (authed instanceof ResponseEnhancement) {
                ResponseEnhancement responseEnhancement = (ResponseEnhancement)authed;
                retval.setHeaders(responseEnhancement.getHeaders());
                retval.setCookies(responseEnhancement.getCookies());
                retval.setRedirect(responseEnhancement.getRedirect());
                ResultCode code = responseEnhancement.getCode();
                retval.setCode(code);
                if (ResultCode.REDIRECT.equals((Object)code) || ResultCode.FAILED.equals((Object)code)) {
                    LoginResultImpl loginResultImpl = retval;
                    return loginResultImpl;
                }
            }
            Context ctx = LoginPerformer.findContext(authed.getContextInfo());
            retval.setContext(ctx);
            String username = authed.getUserInfo();
            User user = LoginPerformer.findUser(ctx, username);
            retval.setUser(user);
            AuthorizationService authService = Authorization.getService();
            if (null == authService) {
                OXException e = ServiceExceptionCode.SERVICE_UNAVAILABLE.create(new Object[]{AuthorizationService.class.getName()});
                LOG.error("unable to find AuthorizationService", (Throwable)e);
                throw e;
            }
            authService.authorizeUser(ctx, user);
            LoginPerformer.checkClient(request, user, ctx);
            SessiondService sessiondService = (SessiondService)SessiondService.SERVICE_REFERENCE.get();
            if (null == sessiondService && null == (sessiondService = ServerServiceRegistry.getInstance().getService(SessiondService.class))) {
                throw ServiceExceptionCode.absentService(SessiondService.class);
            }
            Session session = sessiondService.addSession((AddSessionParameter)new AddSessionParameterImpl(username, request, user, ctx));
            if (null == session) {
                throw LoginExceptionCodes.UNKNOWN.create(new Object[]{"Session could not be created."});
            }
            String capabilities = (String)properties.get("client.capabilities");
            if (null == capabilities) {
                session.setParameter(Session.PARAM_CAPABILITIES, Collections.emptyList());
            } else {
                String[] sa = SPLIT.split(capabilities, 0);
                int length = sa.length;
                if (0 == length) {
                    session.setParameter(Session.PARAM_CAPABILITIES, Collections.emptyList());
                } else {
                    session.setParameter(Session.PARAM_CAPABILITIES, Collections.unmodifiableList(Arrays.asList(sa)));
                }
            }
            retval.setServerToken((String)session.getParameter("serverToken"));
            if (SessionEnhancement.class.isInstance(authed)) {
                ((SessionEnhancement)authed).enhanceSession(session);
            }
            retval.setSession(session);
            LoginPerformer.triggerLoginHandlers(retval);
            LoginResultImpl loginResultImpl = retval;
            return loginResultImpl;
        }
        catch (OXException e) {
            if ("DBP".equals(e.getPrefix())) {
                LOG.error(e.getLogMessage(), (Throwable)e);
            }
            throw e;
        }
        catch (RuntimeException e) {
            throw LoginExceptionCodes.UNKNOWN.create((Throwable)e, new Object[]{e.getMessage()});
        }
        finally {
            LoginPerformer.logLoginRequest(request, retval);
        }
    }

    private static void sanityChecks(LoginRequest request) throws OXException {
        String client = request.getClient();
        if (null != client && client.equals(request.getUserAgent())) {
            throw LoginExceptionCodes.DONT_USER_AGENT.create();
        }
    }

    private static void checkClient(LoginRequest request, User user, Context ctx) throws OXException {
        UserConfigurationStorage ucs;
        UserConfiguration userConfiguration;
        String client = request.getClient();
        if ("USM-JSON".equalsIgnoreCase(client) && !(userConfiguration = (ucs = UserConfigurationStorage.getInstance()).getUserConfiguration(user.getId(), user.getGroups(), ctx)).hasOLOX20()) {
            throw LoginExceptionCodes.CLIENT_DENIED.create(new Object[]{client});
        }
    }

    private static Context findContext(String contextInfo) throws OXException {
        ContextStorage contextStor = ContextStorage.getInstance();
        int contextId = contextStor.getContextId(contextInfo);
        if (-1 == contextId) {
            throw ContextExceptionCodes.NO_MAPPING.create(contextInfo);
        }
        Context context = contextStor.getContext(contextId);
        if (null == context) {
            throw ContextExceptionCodes.NOT_FOUND.create(Autoboxing.I((int)contextId));
        }
        return context;
    }

    private static User findUser(Context ctx, String userInfo) throws OXException {
        String proxyDelimiter = MailProperties.getInstance().getAuthProxyDelimiter();
        UserStorage us = UserStorage.getInstance();
        int userId = 0;
        userId = null != proxyDelimiter && userInfo.contains(proxyDelimiter) ? us.getUserId(userInfo.substring(userInfo.indexOf(proxyDelimiter) + proxyDelimiter.length(), userInfo.length()), ctx) : us.getUserId(userInfo, ctx);
        return us.getUser(userId, ctx);
    }

    public Session doLogout(String sessionId) throws OXException {
        SessiondService sessiondService = (SessiondService)SessiondService.SERVICE_REFERENCE.get();
        if (null == sessiondService && null == (sessiondService = ServerServiceRegistry.getInstance().getService(SessiondService.class))) {
            throw ServiceExceptionCode.absentService(SessiondService.class);
        }
        Session session = sessiondService.getSession(sessionId);
        if (null == session) {
            LOG.debug("No session found for ID: {}", (Object)sessionId);
            return null;
        }
        ContextStorage contextStor = ContextStorage.getInstance();
        Context context = contextStor.getContext(session.getContextId());
        if (null == context) {
            throw ContextExceptionCodes.NOT_FOUND.create(session.getContextId());
        }
        UserStorage us = UserStorage.getInstance();
        User u = us.getUser(session.getUserId(), context);
        LoginResultImpl logout = new LoginResultImpl(session, context, u);
        sessiondService.removeSession(sessionId);
        LoginPerformer.logLogout(logout);
        LoginPerformer.triggerLogoutHandlers(logout);
        return session;
    }

    private static void triggerLoginHandlers(final LoginResult login) {
        block8: {
            ThreadPoolService executor;
            block7: {
                executor = ThreadPools.getThreadPool();
                if (null != executor) break block7;
                Iterator<LoginHandlerService> it = LoginHandlerRegistry.getInstance().getLoginHandlers();
                while (it.hasNext()) {
                    LoginHandlerService handler = it.next();
                    LoginPerformer.handleSafely(login, handler, true);
                }
                break block8;
            }
            ThreadPoolCompletionService completionService = null;
            int blocking = 0;
            boolean tranzient = login.getSession().isTransient();
            Iterator<LoginHandlerService> it = LoginHandlerRegistry.getInstance().getLoginHandlers();
            while (it.hasNext()) {
                final LoginHandlerService handler = it.next();
                if (tranzient && NonTransient.class.isInstance(handler)) continue;
                if (handler instanceof Blocking) {
                    if (null == completionService) {
                        completionService = new ThreadPoolCompletionService(executor);
                    }
                    Callable<Void> callable = new Callable<Void>(){

                        @Override
                        public Void call() {
                            LoginPerformer.handleSafely(login, handler, true);
                            return null;
                        }
                    };
                    completionService.submit((Callable)callable);
                    ++blocking;
                    continue;
                }
                executor.submit((Task)new LoginPerformerTask(){

                    public Object call() {
                        LoginPerformer.handleSafely(login, handler, true);
                        return null;
                    }
                }, CallerRunsBehavior.getInstance());
            }
            if (blocking <= 0 || null == completionService) break block8;
            for (int i = 0; i < blocking; ++i) {
                try {
                    completionService.take();
                    continue;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    private static void triggerLogoutHandlers(final LoginResult logout) {
        block8: {
            ThreadPoolService executor;
            block7: {
                executor = ThreadPools.getThreadPool();
                if (null != executor) break block7;
                Iterator<LoginHandlerService> it = LoginHandlerRegistry.getInstance().getLoginHandlers();
                while (it.hasNext()) {
                    LoginPerformer.handleSafely(logout, it.next(), false);
                }
                break block8;
            }
            ThreadPoolCompletionService completionService = null;
            int blocking = 0;
            Iterator<LoginHandlerService> it = LoginHandlerRegistry.getInstance().getLoginHandlers();
            while (it.hasNext()) {
                final LoginHandlerService handler = it.next();
                if (handler instanceof Blocking) {
                    if (null == completionService) {
                        completionService = new ThreadPoolCompletionService(executor);
                    }
                    Callable<Void> callable = new Callable<Void>(){

                        @Override
                        public Void call() {
                            LoginPerformer.handleSafely(logout, handler, false);
                            return null;
                        }
                    };
                    completionService.submit((Callable)callable);
                    ++blocking;
                    continue;
                }
                executor.submit((Task)new LoginPerformerTask(){

                    public Object call() {
                        LoginPerformer.handleSafely(logout, handler, false);
                        return null;
                    }
                }, CallerRunsBehavior.getInstance());
            }
            if (blocking <= 0 || null == completionService) break block8;
            for (int i = 0; i < blocking; ++i) {
                try {
                    completionService.take();
                    continue;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    protected static void handleSafely(LoginResult login, LoginHandlerService handler, boolean isLogin) {
        if (null == login || null == handler) {
            return;
        }
        try {
            if (isLogin) {
                handler.handleLogin(login);
            } else {
                handler.handleLogout(login);
            }
        }
        catch (OXException e) {
            e.log(LOG);
        }
        catch (RuntimeException e) {
            LOG.error("", (Throwable)e);
        }
    }

    private static void logLoginRequest(LoginRequest request, LoginResult result) {
        Session session;
        User user;
        StringBuilder sb = new StringBuilder();
        sb.append("Login:");
        sb.append(Strings.abbreviate((String)request.getLogin(), (int)256));
        sb.append(" IP:");
        sb.append(request.getClientIP());
        sb.append(" AuthID:");
        sb.append(request.getAuthId());
        sb.append(" Agent:");
        sb.append(request.getUserAgent());
        sb.append(" Client:");
        sb.append(request.getClient());
        sb.append('(');
        sb.append(request.getVersion());
        sb.append(") Interface:");
        sb.append(request.getInterface().toString());
        Context ctx = result.getContext();
        if (null != ctx) {
            sb.append(" Context:");
            sb.append(ctx.getContextId());
            sb.append('(');
            sb.append(Strings.join((Object[])ctx.getLoginInfo(), (String)","));
            sb.append(')');
        }
        if (null != (user = result.getUser())) {
            sb.append(" User:");
            sb.append(user.getId());
            sb.append('(');
            sb.append(user.getLoginInfo());
            sb.append(')');
        }
        if (null == (session = result.getSession())) {
            sb.append(" No session created.");
        } else {
            sb.append(" Session:");
            sb.append(session.getSessionID());
            sb.append(" Random:");
            sb.append(session.getRandomToken());
            sb.append(" Transient:");
            sb.append(session.isTransient());
        }
        LOG.info(sb.toString());
    }

    private static void logLogout(LoginResult result) {
        StringBuilder sb = new StringBuilder();
        sb.append("Logout ");
        Context ctx = result.getContext();
        sb.append(" Context:");
        sb.append(ctx.getContextId());
        sb.append('(');
        sb.append(Strings.join((Object[])ctx.getLoginInfo(), (String)","));
        sb.append(')');
        User user = result.getUser();
        sb.append(" User:");
        sb.append(user.getId());
        sb.append('(');
        sb.append(user.getLoginInfo());
        sb.append(')');
        Session session = result.getSession();
        sb.append(" Session:");
        sb.append(session.getSessionID());
        LOG.info(sb.toString());
    }

    public Session lookupSession(String sessionId) throws OXException {
        return ServerServiceRegistry.getInstance().getService(SessiondService.class, true).getSession(sessionId);
    }

    public Session lookupSessionWithTokens(String clientToken, String serverToken) throws OXException {
        return ServerServiceRegistry.getInstance().getService(SessiondService.class, true).getSessionWithTokens(clientToken, serverToken);
    }
}

