/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.tasks;

import com.openexchange.exception.Category;
import com.openexchange.exception.DisplayableOXExceptionCode;
import com.openexchange.exception.OXException;
import com.openexchange.exception.OXExceptionCode;
import com.openexchange.exception.OXExceptionFactory;

public enum TaskExceptionCode implements DisplayableOXExceptionCode
{
    INSERT_FAILED("Error while inserting task: %s.", "Error while inserting task.", Category.CATEGORY_ERROR, 1),
    AUTO_COMMIT("Problem setting auto commit to true.", Category.CATEGORY_SERVICE_DOWN, 2),
    NO_CONNECTION("Cannot get database connection.", Category.CATEGORY_SERVICE_DOWN, 3),
    UNIMPLEMENTED("This method is not implemented.", Category.CATEGORY_ERROR, 4),
    SQL_ERROR("SQL Problem.", Category.CATEGORY_ERROR, 5),
    NOT_TASK_FOLDER("Folder %1$s (%2$d) is not a task folder.", "Folder \"%1$s\" is not a task folder.", Category.CATEGORY_PERMISSION_DENIED, 6),
    MODIFIED("Edit conflict. Your change cannot be completed because somebody else has made a conflicting change to the same item. Please refresh or synchronize and try again.", "Edit conflict. Your change cannot be completed because somebody else has made a conflicting change to the same item. Please refresh or synchronize and try again.", Category.CATEGORY_CONFLICT, 7),
    PRIVATE_FLAG("Cannot create private task in public/shared folder %1$d.", "Cannot create private task in public/shared folder.", Category.CATEGORY_USER_INPUT, 8),
    UPDATE_FAILED("SQL problem while updating task: %s.", "Error while updating task.", Category.CATEGORY_ERROR, 9),
    NO_COUNT_RESULT("Counting tasks did not return a result.", Category.CATEGORY_ERROR, 10),
    DELETE_FAILED("SQL problem while deleting task: %s.", "Error while deleting task.", Category.CATEGORY_ERROR, 11),
    PARTICIPANT_FOLDER_INCONSISTENCY("Cannot find folder for task %2$d and participant %1$d in context %3$d.", Category.CATEGORY_ERROR, 12),
    SEARCH_FAILED("SQL problem while listing tasks: %s.", "Error while listing tasks.", Category.CATEGORY_ERROR, 13),
    NO_DELETE_PERMISSION("You are not allowed to delete the task.", "You do not have the appropriate permissions to delete the task.", Category.CATEGORY_PERMISSION_DENIED, 14),
    FOLDER_DELETE_WRONG("Tried to delete %1$d folders but only %2$d were deleted.", Category.CATEGORY_ERROR, 15),
    PARTICIPANT_DELETE_WRONG("Tried to delete %1$d participants but only %2$d were deleted.", Category.CATEGORY_ERROR, 16),
    PARTICIPANT_NOT_FOUND("Participant %d for task %d is not found.", Category.CATEGORY_ERROR, 18),
    TASK_NOT_FOUND("Cannot find task %d in context %d.", Category.CATEGORY_ERROR, 19),
    UNKNOWN_ATTRIBUTE("Unknown task attribute %d.", Category.CATEGORY_ERROR, 20),
    WRONG_DATE_RANGE("Date range in search must contain 2 and not %d values.", "Date range in search must contain 2 and not %d values.", Category.CATEGORY_USER_INPUT, 21),
    WRONG_ATTACHMENT_COUNT("Cannot detach more attachments than actually available.", Category.CATEGORY_ERROR, 22),
    NO_READ_PERMISSION("You are not allowed to read the contents of folder %1$s (%2$d).", "You do not have the appropriate permissions to read the contents of folder \"%1$s\".", Category.CATEGORY_PERMISSION_DENIED, 23),
    NO_TASKS("Tasks are disabled for you (%d).", "Tasks are disabled for you.", Category.CATEGORY_PERMISSION_DENIED, 24),
    NO_CREATE_PERMISSION("You are not allowed to create tasks in folder %1$s (%2$d).", "You do not have the appropriate permissions to create tasks in folder \"%1$s\".", Category.CATEGORY_PERMISSION_DENIED, 25),
    NO_DELEGATE_PERMISSION("You are not allowed to delegate tasks.", "You do not have the appropriate permission to delegate tasks.", Category.CATEGORY_PERMISSION_DENIED, 26),
    FOLDER_IS_MISSING("Missing folder id for creating task.", Category.CATEGORY_ERROR, 27),
    NO_PRIVATE_DELEGATE("Tasks with private flag cannot be delegated.", "Tasks with private flag cannot be delegated.", Category.CATEGORY_USER_INPUT, 28),
    INVALID_PERCENTAGE("Percent is %d but must be between 0 and 100.", "Percent is %d but must be between 0 and 100.", Category.CATEGORY_USER_INPUT, 30),
    PERCENTAGE_NOT_ZERO("Tasks that have not been started yet need to have a 'Done' percentage of 0 and not %d.", "Tasks that have not been started yet need to have a 'Done' percentage of 0 and not %d.", Category.CATEGORY_USER_INPUT, 31),
    EVENT("Cannot send event to event system.", Category.CATEGORY_ERROR, 32),
    NO_WRITE_PERMISSION("You are not allowed to edit tasks in folder %1$s (%2$d).", "You do not have the appropriate permissions to edit tasks in folder \"%1$s\".", Category.CATEGORY_PERMISSION_DENIED, 33),
    NO_SHARED_MOVE("Moving items from or into shared folder %1$s (%2$d) is not allowed.", "Moving items from or into shared folder \"%1$s\" is not allowed.", Category.CATEGORY_PERMISSION_DENIED, 34),
    MISSING_FOLDER("Missing folder mapping for task %1$d.", Category.CATEGORY_ERROR, 35),
    UNKNOWN_RECURRENCE("Unknown recurrence type %d.", "Unknown recurrence type %d.", Category.CATEGORY_USER_INPUT, 36),
    MISSING_RECURRENCE_VALUE("Value for the recurrence is missing: %d.", "Value for the recurrence is missing: %d.", Category.CATEGORY_USER_INPUT, 37),
    PERCENTAGE_NOT_FULL("Finished tasks need to have a percentage of 100 and not %d.", "Finished tasks need to have a percentage of 100 and not %d.", Category.CATEGORY_USER_INPUT, 38),
    INVALID_TASK_STATE("Invalid task state %d.", Category.CATEGORY_ERROR, 39),
    START_NOT_BEFORE_END("Start date %1$s must be before end date %2$s.", "Start date \"%1$s\" must be before end date \"%2$s\".", Category.CATEGORY_USER_INPUT, 40),
    TRUNCATED("The task could not be saved. Please shorten the %1$s and try again. Current length %3$d is more than allowed length of %2$d characters.", "The task could not be saved. Please shorten the \"%1$s\" and try again. Current length \"%3$d\" is more than allowed length of \"%2$d\" characters.", Category.CATEGORY_TRUNCATED, 41),
    NO_PRIVATE_MOVE_TO_PUBLIC("Tasks with private flag cannot be moved to a public folder %1$s (%2$d).", "Tasks with private flag cannot be moved to a public folder \"%1$s\".", Category.CATEGORY_PERMISSION_DENIED, 42),
    ONLY_CREATOR_PRIVATE("Only the task creator is allowed to set the private flag.", "Only the task creator is allowed to set the private flag.", Category.CATEGORY_USER_INPUT, 43),
    EXTERNAL_WITHOUT_MAIL("External participants without E-Mail address can not be added.", "External participants without E-Mail address can not be added.", Category.CATEGORY_USER_INPUT, 44),
    THREAD_ISSUE("Unexpected error.", Category.CATEGORY_ERROR, 45),
    NO_PERMISSION("You are not allowed to see the task %1$d in folder %2$s (%3$d).", "You do not have the appropriate permisson to see the task %1$d in folder %2$s.", Category.CATEGORY_PERMISSION_DENIED, 46),
    INVALID_DATA("Task contains invalid data: \"%1$s\"", "Task contains invalid data: \"%1$s\".", Category.CATEGORY_USER_INPUT, 47),
    NOT_IN_FOLDER("The task %1$d is not stored in folder %2$s (%3$d).", "The task %1$d is not stored in folder %2$s.", Category.CATEGORY_PERMISSION_DENIED, 48),
    UNKNOWN_PARTICIPANT("Unknown participant type %1$d.", Category.CATEGORY_ERROR, 49),
    PATTERN_TOO_SHORT("In order to accomplish the search, %1$d or more characters are required.", "In order to accomplish the search, %1$d or more characters are required.", Category.CATEGORY_USER_INPUT, 51),
    GROUP_IS_EMPTY("Group %1$d is empty. You can not add an empty group to a task.", "Group %1$d is empty. You can not add an empty group to a task.", Category.CATEGORY_USER_INPUT, 52),
    NO_UID_CHANGE("Tasks uids can not be changed.", Category.CATEGORY_ERROR, 53),
    DELETE_FAILED_RETRY("SQL problem while deleting task: %s.", "Error while deleting task.", Category.CATEGORY_TRY_AGAIN, 54),
    CONTAINS_NON_DIGITS("Value \"%1$s\" of attribute \"%2$s\" contains non digit characters.", "Value \"%1$s\" of attribute \"%2$s\" contains non digit characters.", Category.CATEGORY_USER_INPUT, 55),
    UNKNOWN_DELEGATOR("Can not determine delegator of task %1$d.", Category.CATEGORY_ERROR, 56);

    private String message;
    private String displayMessage;
    private Category category;
    private int number;

    private TaskExceptionCode(String message, String displayMessage, Category category, int number) {
        this.message = message;
        this.displayMessage = displayMessage != null ? displayMessage : "An error occurred inside the server which prevented it from fulfilling the request.";
        this.category = category;
        this.number = number;
    }

    private TaskExceptionCode(String message, Category category, int number) {
        this(message, null, category, number);
    }

    public String getPrefix() {
        return "TSK";
    }

    public String getMessage() {
        return this.message;
    }

    public String getDisplayMessage() {
        return this.displayMessage;
    }

    public Category getCategory() {
        return this.category;
    }

    public int getNumber() {
        return this.number;
    }

    public boolean equals(OXException e) {
        return OXExceptionFactory.getInstance().equals((OXExceptionCode)this, e);
    }

    public OXException create() {
        return this.specials(OXExceptionFactory.getInstance().create((OXExceptionCode)this, new Object[0]));
    }

    public OXException create(Object ... args) {
        return this.specials(OXExceptionFactory.getInstance().create((OXExceptionCode)this, (Throwable)null, args));
    }

    public OXException create(Throwable cause, Object ... args) {
        return this.specials(OXExceptionFactory.getInstance().create((OXExceptionCode)this, cause, args));
    }

    private OXException specials(OXException exc) {
        switch (this) {
            case TASK_NOT_FOUND: {
                exc.setGeneric(OXException.Generic.NOT_FOUND);
                break;
            }
            case NO_PERMISSION: 
            case NO_WRITE_PERMISSION: {
                exc.setGeneric(OXException.Generic.NO_PERMISSION);
                break;
            }
            case MODIFIED: {
                exc.setGeneric(OXException.Generic.CONFLICT);
                break;
            }
        }
        return exc;
    }
}

