/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.settings.impl;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.settings.IValueHandler;
import com.openexchange.groupware.settings.PreferencesItemService;
import com.openexchange.groupware.settings.Setting;
import com.openexchange.groupware.settings.SettingExceptionCodes;
import com.openexchange.groupware.settings.SharedNode;
import com.openexchange.groupware.settings.impl.AbstractSetting;
import com.openexchange.groupware.settings.impl.TreeSetting;
import com.openexchange.groupware.settings.impl.ValueSetting;
import com.openexchange.groupware.settings.tree.AvailableModules;
import com.openexchange.groupware.settings.tree.AvailableTimeZones;
import com.openexchange.groupware.settings.tree.BetaFeatures;
import com.openexchange.groupware.settings.tree.CalendarNotification;
import com.openexchange.groupware.settings.tree.ContactID;
import com.openexchange.groupware.settings.tree.ContextID;
import com.openexchange.groupware.settings.tree.CookieLifetime;
import com.openexchange.groupware.settings.tree.CurrentTime;
import com.openexchange.groupware.settings.tree.FastGUI;
import com.openexchange.groupware.settings.tree.GUI;
import com.openexchange.groupware.settings.tree.Identifier;
import com.openexchange.groupware.settings.tree.Language;
import com.openexchange.groupware.settings.tree.LocationError;
import com.openexchange.groupware.settings.tree.LocationLogout;
import com.openexchange.groupware.settings.tree.Login;
import com.openexchange.groupware.settings.tree.MaxUploadIdleTimeout;
import com.openexchange.groupware.settings.tree.MinimumSearchCharacters;
import com.openexchange.groupware.settings.tree.ReloadTimes;
import com.openexchange.groupware.settings.tree.ServerVersion;
import com.openexchange.groupware.settings.tree.TaskNotification;
import com.openexchange.groupware.settings.tree.TimeZone;
import com.openexchange.groupware.settings.tree.UiWebPath;
import com.openexchange.groupware.settings.tree.ValidateContactEmail;
import com.openexchange.groupware.settings.tree.folder.Calendar;
import com.openexchange.groupware.settings.tree.folder.Contacts;
import com.openexchange.groupware.settings.tree.folder.EASFolder;
import com.openexchange.groupware.settings.tree.folder.Infostore;
import com.openexchange.groupware.settings.tree.folder.Tasks;
import com.openexchange.groupware.settings.tree.mail.AddressesSP3;
import com.openexchange.groupware.settings.tree.mail.AppendMailTextSP3;
import com.openexchange.groupware.settings.tree.mail.ColorquotedSP3;
import com.openexchange.groupware.settings.tree.mail.DefaultAddressSP3;
import com.openexchange.groupware.settings.tree.mail.DeleteMailSP3;
import com.openexchange.groupware.settings.tree.mail.EmoticonsSP3;
import com.openexchange.groupware.settings.tree.mail.ForwardMessageSP3;
import com.openexchange.groupware.settings.tree.mail.InlineAttachmentsSP3;
import com.openexchange.groupware.settings.tree.mail.LineWrapSP3;
import com.openexchange.groupware.settings.tree.mail.SendAddressSP3;
import com.openexchange.groupware.settings.tree.mail.SpamButtonSP3;
import com.openexchange.groupware.settings.tree.mail.VCardSP3;
import com.openexchange.groupware.settings.tree.mail.folder.DraftsSP3;
import com.openexchange.groupware.settings.tree.mail.folder.InboxSP3;
import com.openexchange.groupware.settings.tree.mail.folder.SentSP3;
import com.openexchange.groupware.settings.tree.mail.folder.SpamSP3;
import com.openexchange.groupware.settings.tree.mail.folder.TrashSP3;
import com.openexchange.groupware.settings.tree.modules.calendar.CalendarConflict;
import com.openexchange.groupware.settings.tree.modules.calendar.CalendarFreeBusy;
import com.openexchange.groupware.settings.tree.modules.calendar.CalendarTeamView;
import com.openexchange.groupware.settings.tree.modules.calendar.DefaultStatusPrivate;
import com.openexchange.groupware.settings.tree.modules.calendar.DefaultStatusPublic;
import com.openexchange.groupware.settings.tree.modules.calendar.NotifyAcceptedDeclinedAsCreator;
import com.openexchange.groupware.settings.tree.modules.calendar.NotifyNewModifiedDeleted;
import com.openexchange.groupware.settings.tree.modules.contacts.AllFoldersForAutoComplete;
import com.openexchange.groupware.settings.tree.modules.contacts.CharacterSearch;
import com.openexchange.groupware.settings.tree.modules.contacts.MailAddressAutoSearch;
import com.openexchange.groupware.settings.tree.modules.contacts.Module;
import com.openexchange.groupware.settings.tree.modules.contacts.SingleFolderSearch;
import com.openexchange.groupware.settings.tree.modules.folder.PublicFolders;
import com.openexchange.groupware.settings.tree.modules.folder.SharedFolders;
import com.openexchange.groupware.settings.tree.modules.interfaces.ICal;
import com.openexchange.groupware.settings.tree.modules.interfaces.SyncML;
import com.openexchange.groupware.settings.tree.modules.interfaces.VCard;
import com.openexchange.groupware.settings.tree.modules.mail.Addresses;
import com.openexchange.groupware.settings.tree.modules.mail.AllowHTMLImages;
import com.openexchange.groupware.settings.tree.modules.mail.AppendMailText;
import com.openexchange.groupware.settings.tree.modules.mail.Colorquoted;
import com.openexchange.groupware.settings.tree.modules.mail.DefaultAddress;
import com.openexchange.groupware.settings.tree.modules.mail.DefaultSeparator;
import com.openexchange.groupware.settings.tree.modules.mail.DeleteMail;
import com.openexchange.groupware.settings.tree.modules.mail.Emoticons;
import com.openexchange.groupware.settings.tree.modules.mail.ForwardMessage;
import com.openexchange.groupware.settings.tree.modules.mail.InlineAttachments;
import com.openexchange.groupware.settings.tree.modules.mail.LineWrap;
import com.openexchange.groupware.settings.tree.modules.mail.MailProtocols;
import com.openexchange.groupware.settings.tree.modules.mail.PhishingHeaders;
import com.openexchange.groupware.settings.tree.modules.mail.ReplyAllCc;
import com.openexchange.groupware.settings.tree.modules.mail.SendAddress;
import com.openexchange.groupware.settings.tree.modules.mail.Separators;
import com.openexchange.groupware.settings.tree.modules.mail.SpamButton;
import com.openexchange.groupware.settings.tree.modules.mail.UnifiedInboxEnablement;
import com.openexchange.groupware.settings.tree.modules.mail.UnifiedInboxIdentifier;
import com.openexchange.groupware.settings.tree.modules.mail.folder.Drafts;
import com.openexchange.groupware.settings.tree.modules.mail.folder.Inbox;
import com.openexchange.groupware.settings.tree.modules.mail.folder.Sent;
import com.openexchange.groupware.settings.tree.modules.mail.folder.Spam;
import com.openexchange.groupware.settings.tree.modules.mail.folder.Trash;
import com.openexchange.groupware.settings.tree.modules.olox20.Active;
import com.openexchange.groupware.settings.tree.modules.passwordchange.MaxLength;
import com.openexchange.groupware.settings.tree.modules.passwordchange.MinLength;
import com.openexchange.groupware.settings.tree.modules.passwordchange.Regexp;
import com.openexchange.groupware.settings.tree.modules.passwordchange.ShowStrength;
import com.openexchange.groupware.settings.tree.modules.passwordchange.Special;
import com.openexchange.groupware.settings.tree.modules.personaldata.InternalUserEditEnabled;
import com.openexchange.groupware.settings.tree.modules.tasks.DelegateTasks;
import com.openexchange.groupware.settings.tree.modules.tasks.NotifyAcceptedDeclinedAsParticipant;
import com.openexchange.groupware.settings.tree.participants.AutoSearch;
import com.openexchange.groupware.settings.tree.participants.MaximumNumberParticipants;
import com.openexchange.groupware.settings.tree.participants.ShowDialog;
import com.openexchange.groupware.settings.tree.participants.ShowWithoutEmail;
import com.openexchange.java.StringAllocator;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfigTree {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigTree.class);
    private static final ConfigTree SINGLETON = new ConfigTree();
    private TreeSetting tree;
    private final Set<Integer> dbIdentifier = new HashSet<Integer>();
    private static final Pattern SPLIT = Pattern.compile("/");

    private ConfigTree() {
    }

    public static ConfigTree getInstance() {
        return SINGLETON;
    }

    public Setting optSettingByPath(String path) {
        String[] pathParts = SPLIT.split(path, 0);
        return new ValueSetting(ConfigTree.optSettingByPath(this.tree, pathParts));
    }

    public static Setting optSettingByPath(Setting actual, String[] path) {
        Setting retval = actual;
        if (path.length != 0) {
            Setting child;
            String[] remainingPath = new String[path.length - 1];
            System.arraycopy(path, 1, remainingPath, 0, path.length - 1);
            Setting setting = child = 0 == path[0].length() ? actual : actual.getElement(path[0]);
            if (null == child) {
                return null;
            }
            retval = ConfigTree.optSettingByPath(child, remainingPath);
        }
        return retval;
    }

    public Setting getSettingByPath(String path) throws OXException {
        String[] pathParts = SPLIT.split(path, 0);
        return new ValueSetting(ConfigTree.getSettingByPath(this.tree, pathParts));
    }

    public static Setting getSettingByPath(Setting actual, String[] path) throws OXException {
        Setting retval = actual;
        if (path.length != 0) {
            Setting child;
            String[] remainingPath = new String[path.length - 1];
            System.arraycopy(path, 1, remainingPath, 0, path.length - 1);
            Setting setting = child = 0 == path[0].length() ? actual : actual.getElement(path[0]);
            if (null == child) {
                StringBuilder sb = new StringBuilder(path[0]);
                for (Setting parent = actual; null != parent; parent = parent.getParent()) {
                    sb.insert(0, '/');
                    sb.insert(0, parent.getName());
                }
                throw SettingExceptionCodes.UNKNOWN_PATH.create(sb.toString());
            }
            retval = ConfigTree.getSettingByPath(child, remainingPath);
        }
        return retval;
    }

    private static <T extends AbstractSetting<? extends T>> T getSettingByPath(T actual, String[] path) throws OXException {
        T retval = actual;
        if (path.length != 0) {
            T child;
            String[] remainingPath = new String[path.length - 1];
            System.arraycopy(path, 1, remainingPath, 0, path.length - 1);
            if (0 == path[0].length()) {
                child = actual;
            } else {
                Setting setting = child = null == actual ? null : actual.getElement(path[0]);
            }
            if (null == child) {
                StringBuilder sb = new StringBuilder(path[0]);
                for (Object parent = actual; null != parent; parent = parent.getParent()) {
                    sb.insert(0, '/');
                    sb.insert(0, parent.getName());
                }
                throw SettingExceptionCodes.UNKNOWN_PATH.create(sb.toString());
            }
            retval = ConfigTree.getSettingByPath(child, remainingPath);
        }
        return retval;
    }

    public Collection<Setting> getSettings() {
        LinkedList<Setting> settings = new LinkedList<Setting>();
        ConfigTree.gatherSettings(this.tree, settings);
        return settings;
    }

    private static <T extends AbstractSetting<? extends T>> void gatherSettings(T current, List<Setting> settings) {
        if (current.isLeaf()) {
            settings.add(current);
        } else {
            for (AbstractSetting child : current.getElements()) {
                ConfigTree.gatherSettings(child, settings);
            }
        }
    }

    public void addPreferencesItem(PreferencesItemService item) throws OXException {
        this.addSharedValue(null, item.getPath(), item.getSharedValue());
    }

    private void addSharedValue(TreeSetting actual, String[] path, IValueHandler shared) throws OXException {
        if (null == actual) {
            this.addSharedValue(this.tree, path, shared);
        } else if (1 == path.length) {
            if (-1 != shared.getId()) {
                Integer tmp = shared.getId();
                if (this.dbIdentifier.contains(tmp)) {
                    throw SettingExceptionCodes.DUPLICATE_ID.create(tmp);
                }
                this.dbIdentifier.add(tmp);
            }
            ConfigTree.addElementWithoutOverwriting(actual, new TreeSetting(path[0], shared.getId(), shared));
        } else {
            TreeSetting sub = (TreeSetting)actual.getElement(path[0]);
            if (null == actual.getElement(path[0])) {
                SharedNode node = new SharedNode(path[0]);
                TreeSetting toAdd = new TreeSetting(path[0], node.getId(), node);
                ConfigTree.addElementWithoutOverwriting(actual, toAdd);
                sub = toAdd;
            }
            String[] subPath = new String[path.length - 1];
            System.arraycopy(path, 1, subPath, 0, subPath.length);
            this.addSharedValue(sub, subPath, shared);
        }
    }

    private static void addElementWithoutOverwriting(TreeSetting actual, TreeSetting subSetting) throws OXException {
        if (actual.getElement(subSetting.getName()) != null) {
            throw SettingExceptionCodes.DUPLICATE_PATH.create(actual.getPath() + "/" + subSetting.getName());
        }
        actual.addElement(subSetting);
        subSetting.setParent(actual);
    }

    public void removePreferencesItem(PreferencesItemService item) {
        block3: {
            try {
                this.removeSharedValue(ConfigTree.getSettingByPath(this.tree, item.getPath()));
            }
            catch (OXException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.warn("", (Throwable)e);
                }
                String message = e.getMessage();
                if (ConfigTree.toLowerCase(message).indexOf("/io.ox/") >= 0) break block3;
                LOG.warn(message);
            }
        }
    }

    private void removeSharedValue(TreeSetting setting) throws OXException {
        TreeSetting parent = (TreeSetting)setting.getParent();
        parent.removeElement(setting);
        if (-1 != setting.getId()) {
            this.dbIdentifier.remove(setting.getId());
        }
        if (parent.isLeaf() && parent != this.tree) {
            this.removeSharedValue(parent);
        }
    }

    private static Class<? extends PreferencesItemService>[] getClasses() {
        return new Class[]{AvailableModules.class, AvailableTimeZones.class, BetaFeatures.class, CalendarNotification.class, ContactID.class, ContextID.class, Login.class, CookieLifetime.class, CurrentTime.class, FastGUI.class, Calendar.class, Contacts.class, Infostore.class, Tasks.class, EASFolder.class, GUI.class, Identifier.class, Language.class, AppendMailTextSP3.class, AddressesSP3.class, ColorquotedSP3.class, DefaultAddressSP3.class, DeleteMailSP3.class, EmoticonsSP3.class, DraftsSP3.class, InboxSP3.class, SentSP3.class, SpamSP3.class, TrashSP3.class, ForwardMessageSP3.class, InlineAttachmentsSP3.class, LineWrapSP3.class, SendAddressSP3.class, SpamButtonSP3.class, VCardSP3.class, MaxUploadIdleTimeout.class, MinimumSearchCharacters.class, com.openexchange.groupware.settings.tree.modules.calendar.GUI.class, com.openexchange.groupware.settings.tree.modules.calendar.Module.class, CalendarConflict.class, CalendarFreeBusy.class, CalendarTeamView.class, NotifyAcceptedDeclinedAsCreator.class, com.openexchange.groupware.settings.tree.modules.calendar.NotifyAcceptedDeclinedAsParticipant.class, NotifyNewModifiedDeleted.class, DefaultStatusPrivate.class, DefaultStatusPublic.class, AllFoldersForAutoComplete.class, com.openexchange.groupware.settings.tree.modules.contacts.GUI.class, MailAddressAutoSearch.class, Module.class, SingleFolderSearch.class, CharacterSearch.class, com.openexchange.groupware.settings.tree.modules.extras.Module.class, com.openexchange.groupware.settings.tree.modules.folder.GUI.class, PublicFolders.class, SharedFolders.class, com.openexchange.groupware.settings.tree.modules.infostore.GUI.class, com.openexchange.groupware.settings.tree.modules.infostore.Module.class, ICal.class, SyncML.class, VCard.class, Addresses.class, AllowHTMLImages.class, AppendMailText.class, Colorquoted.class, DefaultAddress.class, DefaultSeparator.class, DeleteMail.class, UnifiedInboxEnablement.class, UnifiedInboxIdentifier.class, Emoticons.class, Drafts.class, Inbox.class, Sent.class, Spam.class, Trash.class, ForwardMessage.class, com.openexchange.groupware.settings.tree.modules.mail.GUI.class, InlineAttachments.class, LineWrap.class, com.openexchange.groupware.settings.tree.modules.mail.Module.class, PhishingHeaders.class, MailProtocols.class, ReplyAllCc.class, SendAddress.class, Separators.class, SpamButton.class, com.openexchange.groupware.settings.tree.modules.mail.VCard.class, com.openexchange.groupware.settings.tree.modules.mailaccount.Module.class, Active.class, com.openexchange.groupware.settings.tree.modules.olox20.Module.class, com.openexchange.groupware.settings.tree.modules.passwordchange.Module.class, MaxLength.class, MinLength.class, Regexp.class, ShowStrength.class, Special.class, com.openexchange.groupware.settings.tree.modules.personaldata.Module.class, InternalUserEditEnabled.class, com.openexchange.groupware.settings.tree.modules.portal.GUI.class, com.openexchange.groupware.settings.tree.modules.portal.Module.class, com.openexchange.groupware.settings.tree.modules.tasks.GUI.class, com.openexchange.groupware.settings.tree.modules.tasks.Module.class, DelegateTasks.class, com.openexchange.groupware.settings.tree.modules.tasks.NotifyAcceptedDeclinedAsCreator.class, NotifyAcceptedDeclinedAsParticipant.class, com.openexchange.groupware.settings.tree.modules.tasks.NotifyNewModifiedDeleted.class, AutoSearch.class, MaximumNumberParticipants.class, ShowDialog.class, ShowWithoutEmail.class, ReloadTimes.class, ServerVersion.class, UiWebPath.class, TaskNotification.class, TimeZone.class, LocationLogout.class, LocationError.class, ValidateContactEmail.class};
    }

    void init() throws OXException {
        if (null != this.tree) {
            LOG.error("Duplicate initialization of configuration tree.");
            return;
        }
        this.tree = new TreeSetting("", -1, new SharedNode(""));
        try {
            Class<? extends PreferencesItemService>[] clazzes = ConfigTree.getClasses();
            PreferencesItemService[] items = new PreferencesItemService[clazzes.length];
            for (int i = 0; i < clazzes.length; ++i) {
                items[i] = clazzes[i].newInstance();
            }
            for (PreferencesItemService item : items) {
                this.addPreferencesItem(item);
            }
        }
        catch (InstantiationException e) {
            throw SettingExceptionCodes.INIT.create(e, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw SettingExceptionCodes.INIT.create(e, new Object[0]);
        }
    }

    void stop() {
        if (null == this.tree) {
            LOG.error("Duplicate shutdown of configuration tree.");
            return;
        }
        try {
            Class<? extends PreferencesItemService>[] clazzes = ConfigTree.getClasses();
            PreferencesItemService[] items = new PreferencesItemService[clazzes.length];
            for (int i = 0; i < clazzes.length; ++i) {
                items[i] = clazzes[i].newInstance();
            }
            for (PreferencesItemService item : items) {
                this.removePreferencesItem(item);
            }
        }
        catch (InstantiationException e) {
            OXException se = SettingExceptionCodes.INIT.create(e, new Object[0]);
            LOG.error("", (Throwable)se);
        }
        catch (IllegalAccessException e) {
            OXException se = SettingExceptionCodes.INIT.create(e, new Object[0]);
            LOG.error("", (Throwable)se);
        }
        this.tree = null;
    }

    private static String toLowerCase(CharSequence chars) {
        if (null == chars) {
            return null;
        }
        int length = chars.length();
        StringAllocator builder = new StringAllocator(length);
        for (int i = 0; i < length; ++i) {
            char c = chars.charAt(i);
            builder.append(c >= 'A' && c <= 'Z' ? (char)(c ^ 0x20) : c);
        }
        return builder.toString();
    }
}

