/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.ldap;

import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserAttribute;
import com.openexchange.i18n.LocaleTools;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.mail.internet.idn.IDNA;

public class UserImpl
implements User,
Cloneable {
    private static final long serialVersionUID = 2265710814522924009L;
    private String givenName;
    private String surname;
    private int id;
    private int contactId;
    private String mail;
    private String[] aliases;
    private Map<String, UserAttribute> attributes;
    private String mailDomain;
    private String imapServer;
    private String imapLogin;
    private String smtpServer;
    private String timeZone;
    private String preferredLanguage;
    private Locale locale;
    private String displayName;
    private String userPassword = null;
    private String passwordMech = "{CRYPT}";
    private boolean mailEnabled;
    private int shadowLastChange = -1;
    private int[] groups;
    private String loginInfo;

    public UserImpl() {
    }

    public UserImpl(User user) {
        this.givenName = user.getGivenName();
        this.surname = user.getSurname();
        this.id = user.getId();
        this.contactId = user.getContactId();
        this.mail = user.getMail();
        this.mailDomain = user.getMailDomain();
        this.imapServer = user.getImapServer();
        this.imapLogin = user.getImapLogin();
        this.smtpServer = user.getSmtpServer();
        this.timeZone = user.getTimeZone();
        this.preferredLanguage = user.getPreferredLanguage();
        this.displayName = user.getDisplayName();
        this.mailEnabled = user.isMailEnabled();
        this.passwordMech = user.getPasswordMech();
        this.shadowLastChange = user.getShadowLastChange();
        this.groups = (int[])user.getGroups().clone();
    }

    @Override
    public String getUserPassword() {
        return this.userPassword;
    }

    public void setId(int id) {
        this.id = id;
    }

    @Override
    public int getId() {
        return this.id;
    }

    void setUserPassword(String userPassword) {
        this.userPassword = userPassword;
    }

    @Override
    public boolean isMailEnabled() {
        return this.mailEnabled;
    }

    void setMailEnabled(boolean mailEnabled) {
        this.mailEnabled = mailEnabled;
    }

    @Override
    public int getShadowLastChange() {
        return this.shadowLastChange;
    }

    void setShadowLastChange(int shadowLastChange) {
        this.shadowLastChange = shadowLastChange;
    }

    void setPasswordMech(String passwordMech) {
        this.passwordMech = passwordMech;
    }

    public void setImapServer(String imapServer) {
        this.imapServer = imapServer == null ? null : IDNA.toUnicode((String)imapServer);
    }

    @Override
    public String getImapServer() {
        return this.imapServer;
    }

    public void setSmtpServer(String smtpServer) {
        this.smtpServer = smtpServer == null ? null : IDNA.toUnicode((String)smtpServer);
    }

    @Override
    public String getSmtpServer() {
        return this.smtpServer;
    }

    void setMailDomain(String mailDomain) {
        this.mailDomain = mailDomain == null ? null : IDNA.toUnicode((String)mailDomain);
    }

    @Override
    public String getMailDomain() {
        return this.mailDomain;
    }

    void setGivenName(String givenName) {
        this.givenName = givenName;
    }

    @Override
    public String getGivenName() {
        return this.givenName;
    }

    void setSurname(String sureName) {
        this.surname = sureName;
    }

    @Override
    public String getSurname() {
        return this.surname;
    }

    void setMail(String mail) {
        this.mail = mail == null ? mail : IDNA.toIDN((String)mail);
    }

    @Override
    public String getMail() {
        return this.mail;
    }

    void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    @Override
    public String getTimeZone() {
        return this.timeZone;
    }

    public void setPreferredLanguage(String preferredLanguage) {
        this.preferredLanguage = preferredLanguage;
        this.locale = LocaleTools.getSaneLocale((Locale)LocaleTools.getLocale((String)preferredLanguage));
    }

    @Override
    public String getPreferredLanguage() {
        return this.preferredLanguage;
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public int[] getGroups() {
        return (int[])this.groups.clone();
    }

    void setGroups(int[] groups) {
        this.groups = groups;
    }

    @Override
    public int getContactId() {
        return this.contactId;
    }

    public void setContactId(int contactId) {
        this.contactId = contactId;
    }

    public Object clone() throws CloneNotSupportedException {
        UserImpl retval = (UserImpl)super.clone();
        retval.groups = (int[])this.groups.clone();
        return retval;
    }

    public String toString() {
        return this.getClass().getName() + ' ' + this.id;
    }

    @Override
    public String getImapLogin() {
        return this.imapLogin;
    }

    public void setImapLogin(String imapLogin) {
        this.imapLogin = imapLogin == null ? imapLogin : IDNA.toIDN((String)imapLogin);
    }

    @Override
    public String[] getAliases() {
        return this.aliases;
    }

    public void setAliases(String[] aliases) {
        if (null == aliases) {
            this.aliases = null;
            return;
        }
        this.aliases = new String[aliases.length];
        String[] thisAliases = this.aliases;
        for (int i = 0; i < aliases.length; ++i) {
            thisAliases[i] = IDNA.toIDN((String)aliases[i]);
        }
    }

    @Override
    public Map<String, Set<String>> getAttributes() {
        if (null == this.attributes) {
            return null;
        }
        HashMap<String, Set<String>> retval = new HashMap<String, Set<String>>();
        for (Map.Entry<String, UserAttribute> entry : this.attributes.entrySet()) {
            retval.put(entry.getKey(), entry.getValue().getStringValues());
        }
        return Collections.unmodifiableMap(retval);
    }

    Map<String, UserAttribute> getAttributesInternal() {
        return Collections.unmodifiableMap(this.attributes);
    }

    public void setAttributes(Map<String, Set<String>> attributes) {
        this.attributes = UserImpl.toInternal(attributes);
    }

    public static Map<String, UserAttribute> toInternal(Map<String, Set<String>> attributes) {
        HashMap<String, UserAttribute> retval = new HashMap<String, UserAttribute>();
        for (Map.Entry<String, Set<String>> entry : attributes.entrySet()) {
            retval.put(entry.getKey(), new UserAttribute(entry.getKey(), entry.getValue()));
        }
        return retval;
    }

    void setAttributesInternal(Map<String, UserAttribute> attributes) {
        this.attributes = attributes;
    }

    @Override
    public String getPasswordMech() {
        return this.passwordMech;
    }

    @Override
    public String getLoginInfo() {
        return this.loginInfo;
    }

    void setLoginInfo(String loginInfo) {
        this.loginInfo = loginInfo;
    }
}

