/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.infostore.webdav;

import com.openexchange.event.impl.FolderEventInterface;
import com.openexchange.exception.OXException;
import com.openexchange.file.storage.FileStorageEventHelper;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.impl.FolderLockManager;
import com.openexchange.groupware.infostore.webdav.EntityLockManager;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.session.Session;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.session.ServerSessionAdapter;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LockCleaner
implements FolderEventInterface,
EventHandler {
    private static final Logger LOG = LoggerFactory.getLogger(LockCleaner.class);
    private final EntityLockManager infoLockManager;
    private final FolderLockManager folderLockManager;

    public LockCleaner(FolderLockManager folderLockManager, EntityLockManager infoLockManager) {
        this.folderLockManager = folderLockManager;
        this.infoLockManager = infoLockManager;
    }

    @Override
    public void folderDeleted(FolderObject folderObj, Session session) {
        try {
            ServerSession sessionObj = ServerSessionAdapter.valueOf(session);
            this.folderLockManager.removeAll(folderObj.getObjectID(), sessionObj.getContext(), UserStorage.getInstance().getUser(sessionObj.getUserId(), sessionObj.getContext()));
        }
        catch (OXException e) {
            LOG.error("Couldn't remove folder locks from folder {} in context {}. Run the consistency tool.", (Object)folderObj.getObjectID(), (Object)session.getContextId());
        }
    }

    @Override
    public void folderCreated(FolderObject folderObj, Session sessionObj) {
    }

    @Override
    public void folderModified(FolderObject folderObj, Session sessionObj) {
    }

    public void handleEvent(final Event event) {
        if (FileStorageEventHelper.isInfostoreEvent((Event)event) && FileStorageEventHelper.isDeleteEvent((Event)event) && null == FileStorageEventHelper.extractVersions((Event)event)) {
            try {
                int id = Integer.parseInt(FileStorageEventHelper.extractObjectId((Event)event));
                ServerSession session = ServerSessionAdapter.valueOf(FileStorageEventHelper.extractSession((Event)event));
                this.infoLockManager.removeAll(id, session.getContext(), UserStorage.getInstance().getUser(session.getUserId(), session.getContext()));
            }
            catch (OXException e) {
                LOG.error("Couldn't remove locks from infoitem. Run the consistency tool.", (Throwable)e);
            }
            catch (NumberFormatException e) {
                LOG.debug("", (Throwable)e);
            }
            LOG.debug("{}", new Object(){

                public String toString() {
                    return FileStorageEventHelper.createDebugMessage((String)"DeleteEvent", (Event)event);
                }
            });
        }
    }
}

