/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.infostore.database.impl;

import com.openexchange.database.tx.AbstractDBAction;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.infostore.DocumentMetadata;
import com.openexchange.groupware.infostore.database.impl.AbstractDocumentListAction;
import com.openexchange.groupware.infostore.database.impl.InfostoreQueryCatalog;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class DeleteVersionAction
extends AbstractDocumentListAction {
    private int batchSize = 1000;

    protected void undoAction() throws OXException {
        if (this.getDocuments().isEmpty()) {
            return;
        }
        List<DocumentMetadata> documents = this.getDocuments();
        List<DocumentMetadata>[] slices = this.getSlices(this.batchSize, documents);
        ArrayList<AbstractDBAction.UpdateBlock> updates = new ArrayList<AbstractDBAction.UpdateBlock>();
        for (final DocumentMetadata doc : this.getDocuments()) {
            updates.add(new AbstractDBAction.Update(this.getQueryCatalog().getVersionInsert()){

                @Override
                public void fillStatement() throws SQLException {
                    DeleteVersionAction.this.fillStmt(this.stmt, DeleteVersionAction.this.getQueryCatalog().getWritableVersionFields(), doc, DeleteVersionAction.this.getContext().getContextId());
                }
            });
        }
        for (int j = 0; j < slices.length; ++j) {
            updates.add(new AbstractDBAction.Update(this.getQueryCatalog().getVersionDelete(InfostoreQueryCatalog.Table.DEL_INFOSTORE_DOCUMENT, slices[j])){

                @Override
                public void fillStatement() throws SQLException {
                    this.stmt.setInt(1, DeleteVersionAction.this.getContext().getContextId());
                }
            });
        }
        this.doUpdates(updates);
    }

    public void perform() throws OXException {
        List<DocumentMetadata> documents = this.getDocuments();
        if (null == documents || documents.isEmpty()) {
            return;
        }
        final Integer contextID = this.getContext().getContextId();
        List<DocumentMetadata>[] slices = this.getSlices(this.batchSize, documents);
        ArrayList<AbstractDBAction.UpdateBlock> updates = new ArrayList<AbstractDBAction.UpdateBlock>(slices.length * 2);
        for (int i = 0; i < slices.length; ++i) {
            final List<DocumentMetadata> slice = slices[i];
            updates.add(new AbstractDBAction.Update(this.getQueryCatalog().getReplace(InfostoreQueryCatalog.Table.DEL_INFOSTORE_DOCUMENT, slice.size())){

                @Override
                public void fillStatement() throws SQLException {
                    int parameterIndex = 1;
                    for (DocumentMetadata document : slice) {
                        parameterIndex = DeleteVersionAction.this.fillStmt(parameterIndex, this.stmt, DeleteVersionAction.this.getQueryCatalog().getWritableDelVersionFields(), document, contextID);
                    }
                }
            });
            updates.add(new AbstractDBAction.Update(this.getQueryCatalog().getVersionDelete(InfostoreQueryCatalog.Table.INFOSTORE_DOCUMENT, slice)){

                @Override
                public void fillStatement() throws SQLException {
                    this.stmt.setInt(1, contextID);
                }
            });
        }
        this.doUpdates(updates);
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    @Override
    protected Object[] getAdditionals(DocumentMetadata doc) {
        return null;
    }
}

