/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.contact.datahandler;

import com.openexchange.ajax.writer.ContactWriter;
import com.openexchange.conversion.Data;
import com.openexchange.conversion.DataArguments;
import com.openexchange.conversion.DataExceptionCodes;
import com.openexchange.conversion.DataHandler;
import com.openexchange.conversion.DataProperties;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contact.helpers.ContactField;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.java.Streams;
import com.openexchange.session.Session;
import com.openexchange.tools.stream.UnsynchronizedByteArrayInputStream;
import com.openexchange.tools.versit.VersitDefinition;
import com.openexchange.tools.versit.VersitObject;
import com.openexchange.tools.versit.converter.ConverterException;
import com.openexchange.tools.versit.converter.OXContainerConverter;
import com.openexchange.tools.versit.filetokenizer.VCardFileToken;
import com.openexchange.tools.versit.filetokenizer.VCardTokenizer;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.TimeZone;
import org.apache.commons.codec.binary.Base64;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ContactJSONDataHandler
implements DataHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ContactJSONDataHandler.class);
    private static final String[] ARGS = new String[0];
    private static final Class<?>[] TYPES = new Class[]{InputStream.class};
    private static final ContactField[] CONTACT_FIELDS_FOLDER_ID = new ContactField[]{ContactField.FOLDER_ID};

    public String[] getRequiredArguments() {
        return ARGS;
    }

    public Class<?>[] getTypes() {
        return TYPES;
    }

    public Object processData(Data<?> data, DataArguments dataArguments, Session session) throws OXException {
        Context ctx = ContextStorage.getStorageContext(session);
        OXContainerConverter converter = new OXContainerConverter(session, ctx);
        InputStream inputStream = (InputStream)data.getData();
        try {
            DataProperties dataProperties = data.getDataProperties();
            VCardTokenizer tokenizer = new VCardTokenizer(inputStream);
            List<VCardFileToken> chunks = tokenizer.split();
            if (chunks.isEmpty()) {
                LOG.error("VCard tokenizer returned zero results");
                JSONArray jSONArray = new JSONArray();
                return jSONArray;
            }
            JSONArray jsonArray = new JSONArray();
            ContactWriter writer = new ContactWriter(TimeZone.getTimeZone(UserStorage.getInstance().getUser(session.getUserId(), ctx).getTimeZone()));
            for (VCardFileToken chunk : chunks) {
                String contactId;
                VersitDefinition def = chunk.getVersitDefinition();
                if (def == null) {
                    LOG.error("Could not recognize format of the following VCard data:\n{}", (Object)Arrays.toString(chunk.getContent()));
                    continue;
                }
                VersitDefinition.Reader versitReader = def.getReader((InputStream)new UnsynchronizedByteArrayInputStream(chunk.getContent()), dataProperties.get("com.openexchange.conversion.charset"));
                VersitObject versitObject = def.parse(versitReader);
                converter.setAddDisplayName4DList(true);
                Contact contact = converter.convertContact(versitObject);
                String folderId = dataProperties.get("com.openexchange.conversion.folderId");
                if (null != folderId) {
                    try {
                        contact.setParentFolderID(Integer.parseInt(folderId));
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
                if (null != (contactId = dataProperties.get("com.openexchange.conversion.id"))) {
                    try {
                        contact.setObjectID(Integer.parseInt(contactId));
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
                JSONObject jsonContact = new JSONObject(32);
                writer.writeContact(contact, jsonContact, session);
                byte[] image = contact.getImage1();
                if (null != image) {
                    jsonContact.put(ContactField.IMAGE1.getAjaxName(), (Object)Base64.encodeBase64String((byte[])image));
                    String mimeType = contact.getImageContentType();
                    if (null == mimeType) {
                        mimeType = "image/jpeg";
                    }
                    jsonContact.put(ContactField.IMAGE1_CONTENT_TYPE.getAjaxName(), (Object)mimeType);
                }
                jsonArray.put((Object)jsonContact);
            }
            JSONArray jSONArray = jsonArray;
            return jSONArray;
        }
        catch (ConverterException e) {
            throw DataExceptionCodes.ERROR.create((Throwable)e, new Object[]{e.getMessage()});
        }
        catch (JSONException e) {
            throw DataExceptionCodes.ERROR.create((Throwable)e, new Object[]{e.getMessage()});
        }
        catch (IOException e) {
            throw DataExceptionCodes.ERROR.create((Throwable)e, new Object[]{e.getMessage()});
        }
        finally {
            converter.close();
            Streams.close((Closeable)inputStream);
        }
    }
}

