/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.attach.impl;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.attach.AttachmentEvent;
import com.openexchange.groupware.attach.AttachmentExceptionCodes;
import com.openexchange.groupware.attach.AttachmentListener;
import com.openexchange.java.Autoboxing;
import com.openexchange.tools.service.ServicePriorityConflictException;
import com.openexchange.tools.service.SpecificServiceChooser;

public class OverridableAttachmentListener
implements AttachmentListener {
    private final SpecificServiceChooser<AttachmentListener> chooser;

    public OverridableAttachmentListener(SpecificServiceChooser<AttachmentListener> chooser) {
        this.chooser = chooser;
    }

    @Override
    public long attached(AttachmentEvent e) throws Exception {
        return this.getDelegate(e).attached(e);
    }

    @Override
    public long detached(AttachmentEvent e) throws Exception {
        return this.getDelegate(e).detached(e);
    }

    private AttachmentListener getDelegate(AttachmentEvent e) throws OXException {
        int contextId = e.getContext().getContextId();
        int folderId = e.getFolderId();
        try {
            return this.chooser.choose(contextId, folderId);
        }
        catch (ServicePriorityConflictException e1) {
            throw AttachmentExceptionCodes.SERVICE_CONFLICT.create(Autoboxing.I((int)contextId), Autoboxing.I((int)folderId));
        }
    }
}

