/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.virtual;

import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.Schema;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTask;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VirtualTreeCreateTableTask
implements UpdateTask {
    @Override
    public int addedWithVersion() {
        return 72;
    }

    @Override
    public int getPriority() {
        return UpdateTask.UpdateTaskPriority.HIGHEST.priority;
    }

    private static final String getTable1() {
        return "CREATE TABLE virtualTree (cid INT4 unsigned NOT NULL, tree INT4 unsigned NOT NULL, user INT4 unsigned NOT NULL, folderId VARCHAR(192) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL, parentId VARCHAR(192) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL, name VARCHAR(256) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL, lastModified BIGINT(64) DEFAULT NULL, modifiedBy INT4 unsigned DEFAULT NULL, shadow VARCHAR(192) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL, PRIMARY KEY (cid, tree, user, folderId), INDEX (cid, tree, user, parentId), INDEX (cid, tree, user, shadow), FOREIGN KEY (cid, user) REFERENCES user (cid, id), FOREIGN KEY (cid, modifiedBy) REFERENCES user (cid, id)) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;";
    }

    private static final String getDelTable1() {
        return "CREATE TABLE virtualBackupTree (cid INT4 unsigned NOT NULL, tree INT4 unsigned NOT NULL, user INT4 unsigned NOT NULL, folderId VARCHAR(192) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL, parentId VARCHAR(192) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL, name VARCHAR(256) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL, lastModified BIGINT(64) DEFAULT NULL, modifiedBy INT4 unsigned DEFAULT NULL, shadow VARCHAR(192) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL, PRIMARY KEY (cid, tree, user, folderId), INDEX (cid, tree, user, parentId), INDEX (cid, tree, user, shadow), FOREIGN KEY (cid, user) REFERENCES user (cid, id), FOREIGN KEY (cid, modifiedBy) REFERENCES user (cid, id)) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;";
    }

    private static final String getTable2() {
        return "CREATE TABLE virtualPermission (cid INT4 unsigned NOT NULL, tree INT4 unsigned NOT NULL, user INT4 unsigned NOT NULL, folderId VARCHAR(192) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL, entity INT4 unsigned NOT NULL, fp tinyint(3) unsigned NOT NULL, orp tinyint(3) unsigned NOT NULL, owp tinyint(3) unsigned NOT NULL, odp tinyint(3) unsigned NOT NULL, adminFlag tinyint(3) unsigned NOT NULL, groupFlag tinyint(3) unsigned NOT NULL, system tinyint(3) unsigned NOT NULL default '0', PRIMARY KEY (cid, tree, user, folderId, entity), FOREIGN KEY (cid, tree, user, folderId) REFERENCES virtualTree (cid, tree, user, folderId) ) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;";
    }

    private static final String getDelTable2() {
        return "CREATE TABLE virtualBackupPermission (cid INT4 unsigned NOT NULL, tree INT4 unsigned NOT NULL, user INT4 unsigned NOT NULL, folderId VARCHAR(192) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL, entity INT4 unsigned NOT NULL, fp tinyint(3) unsigned NOT NULL, orp tinyint(3) unsigned NOT NULL, owp tinyint(3) unsigned NOT NULL, odp tinyint(3) unsigned NOT NULL, adminFlag tinyint(3) unsigned NOT NULL, groupFlag tinyint(3) unsigned NOT NULL, system tinyint(3) unsigned NOT NULL default '0', PRIMARY KEY (cid, tree, user, folderId, entity), FOREIGN KEY (cid, tree, user, folderId) REFERENCES virtualBackupTree (cid, tree, user, folderId) ) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;";
    }

    private static final String getTable3() {
        return "CREATE TABLE virtualSubscription (cid INT4 unsigned NOT NULL, tree INT4 unsigned NOT NULL, user INT4 unsigned NOT NULL, folderId VARCHAR(192) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL, subscribed tinyint(3) unsigned NOT NULL, PRIMARY KEY (cid, tree, user, folderId), FOREIGN KEY (cid, tree, user, folderId) REFERENCES virtualTree (cid, tree, user, folderId) ) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;";
    }

    private static final String getDelTable3() {
        return "CREATE TABLE virtualBackupSubscription (cid INT4 unsigned NOT NULL, tree INT4 unsigned NOT NULL, user INT4 unsigned NOT NULL, folderId VARCHAR(192) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL, subscribed tinyint(3) unsigned NOT NULL, PRIMARY KEY (cid, tree, user, folderId), FOREIGN KEY (cid, tree, user, folderId) REFERENCES virtualBackupTree (cid, tree, user, folderId) ) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;";
    }

    @Override
    public void perform(Schema schema, int contextId) throws OXException {
        this.createTable("virtualTree", VirtualTreeCreateTableTask.getTable1(), contextId);
        this.createTable("virtualPermission", VirtualTreeCreateTableTask.getTable2(), contextId);
        this.createTable("virtualSubscription", VirtualTreeCreateTableTask.getTable3(), contextId);
        this.createTable("virtualBackupTree", VirtualTreeCreateTableTask.getDelTable1(), contextId);
        this.createTable("virtualBackupPermission", VirtualTreeCreateTableTask.getDelTable2(), contextId);
        this.createTable("virtualBackupSubscription", VirtualTreeCreateTableTask.getDelTable3(), contextId);
        Logger LOG = LoggerFactory.getLogger(VirtualTreeCreateTableTask.class);
        LOG.info("UpdateTask 'VirtualTreeCreateTableTask' successfully performed!");
    }

    private void createTable(String tablename, String sqlCreate, int contextId) throws OXException {
        Connection writeCon = Database.get(contextId, true);
        PreparedStatement stmt = null;
        try {
            if (VirtualTreeCreateTableTask.tableExists(tablename, writeCon.getMetaData())) {
                return;
            }
            stmt = writeCon.prepareStatement(sqlCreate);
            stmt.executeUpdate();
            DBUtils.closeSQLStuff(null, stmt);
        }
        catch (SQLException e) {
            throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        finally {
            DBUtils.closeSQLStuff(null, stmt);
            Database.back(contextId, true, writeCon);
        }
        Database.back(contextId, true, writeCon);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean tableExists(String tableName, DatabaseMetaData dbmd) throws SQLException {
        boolean bl;
        ResultSet resultSet = null;
        try {
            resultSet = dbmd.getTables(null, null, tableName, new String[]{"TABLE"});
            bl = resultSet.next();
        }
        catch (Throwable throwable) {
            DBUtils.closeSQLStuff(resultSet, null);
            throw throwable;
        }
        DBUtils.closeSQLStuff(resultSet, null);
        return bl;
    }
}

